/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro3RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO3
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "vdsl_const.h"
#include "cmv.h"

//#ifdef MTK_VECTORING_SUPPORT
#include "ROPVECTOR1Handler.h"
//#endif

/*^^^
*------------------------------------------------------------------------
*
*  Name : ROPSynchro3RxF_VDSL2
*
*  Prototype:  void ROPSynchro3RxF_VDSL2(void)
*
*   This is the state function for detecting O-P-SYNCHRO3 symbols.
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Return:
*      None
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_RX_INIT          (0)
#define R_O_P_SYNCHRO_RX_DETECT        (1)
#define EXTRA_3SECONS (3)


void ROPSynchro3RxF_VDSL2(void)
{
   int32 l_Synchro3TimeoutCnt = gl_SynchroTimeoutCnt;
   uint16 us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_3;

   //XDSLRTFW-2351: No Sync with Vinax 1.3 - GVT
   if((gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform < VINAX_REV_2_M_PLATFORM))
   {
      l_Synchro3TimeoutCnt += (EXTRA_3SECONS * TIMEOUT_CNT_1_SECONDS);
   }

   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO_RX_DETECT;

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //XDSLRTFW-2257 (Start)
         {
            // Long reach mode Rx - US0 only
            // The CO is indicating US0 only before our logic had detected it!
            if ((gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone <= (US0_ISDNDOUBLE_POTSQUAD_MAX_TONE +1)) &&
                (!(gus_UseUS0OnlyCntrl & (TX_US0_ONLY_INDICATION | TX_US0_ONLY_INDICATION_GHS))))
            {
               gus_UseUS0OnlyCntrl |= TX_US0_ONLY_INDICATION_CO;
            }
            else if((gs_HighestAllowedTxTone > 1900) &&
                    (gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone < FIRST_BIN_US2))
            {
               gus_UseUS0OnlyCntrl |= TX_US0US1_ONLY_INDICATION_CO;
            }
         }
         //XDSLRTFW-2257 (End)

         if (gft_DSVectoringEnabled == TRUE)
         {
            //go to the next RX state to receive O-P Vector 1 1 Signal
            gs_RxNextState = VDSL2_R_O_P_VECTOR1_1_RX;

            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timout after OP-SYNCHRO3
            // Note:
            //       1) It is not possible to set the value directly if the new
            //          one is lower than the previous one. The timeout check would
            //          directly kick-in in RxForeGround. Since the Vectoring timeout is bigger
            //          it could directly be set. But to be independent of any change the correct
            //          procedure is also used here!
            //       2) guc_SwitchGlobalTimeout must be initialized to zero
            guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;
         }
         else // for non Vectoring training
         {
            //go to the next RX state to receive O-P-Train-Random
            gs_RxNextState = VDSL2_R_O_P_TRAINING1_COMMON_RX;
         }

         gpF_RxStateFunc = ROPTrain1RxF_VDSL2; // both VDSL2_R_O_P_VECTOR1_1_RX and VDSL2_R_O_P_TRAINING1_COMMON_RX
         // reside in same ROPTrain1RxF_VDSL2 function
      }
      else
      {
         //Perform timeout check
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 1)
         {
            CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHRO1, E_CODE_RX_SYNCHRO3_DETECT_FAIL);
         }
         else
         {
            int32 l_CurrentSymCnt;

            //Compute the current symbol count passed from the start of the discovery phase
            l_CurrentSymCnt = gl_TotalTxSymbolCount - gl_DiscoveryPhaseSymCnt_start;

            //XDSLRTFW-2351: No Sync with Vinax 1.3 - GVT
            CheckTimeout(l_CurrentSymCnt, l_Synchro3TimeoutCnt, E_CODE_RX_SYNCHRO3_DETECT_FAIL);
         }
      }

      break;

   } //switch
}

//#ifdef MTK_VECTORING_SUPPORT

// all states are defined in ROPVECTOR1Handler.h
void ROPSynchroV2_VDSL2(void)
{
   switch (gs_VectorHandlerState)
   {

   case R_O_P_SYNCHRO_V2_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_VectorHandlerState = R_O_P_SYNCHRO_V2_RX_DETECT;

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO_V2_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         gs_VectorHandlerState = R_O_P_SYNCHRO_V2_DONE;   // use defination instead of value

      }
      else
      {
         //Perform timeout check : yet to implement
         ;  // CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHRO1, E_CODE_RX_SYNCHRO3_DETECT_FAIL);
      }
      break;
   } //switch
}
//#endif
