/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro4RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO4
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchro4RxF_VDSL2
 *
 *  Prototype:  void ROPSynchro3RxF_VDSL2(void)
 *
 *   This is the state function for detecting O-P-SYNCHRO3 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_RX_INIT         (0)
#define R_O_P_SYNCHRO_RX_DETECT         (1)

void ROPSynchro4RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_4;
   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO_RX_INIT:

      //Decide the next state and save the information
      //in gs_RxNextState_ToBe and gpF_RxStateFunc_ToBe
      if(gl_RxSymbolCount == 0)
      {
         gs_RxNextState_ToBe = VDSL2_R_O_P_PILOT2_RX;
         NextRxTrainingState();
      }

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO_RX_DETECT;

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Set the bit to indicate that the RX side has received R-P-Synchro4
         gus_VdslStatusFlag |= BITMAP_RX_SYNCHRO_VDSL2;

         //go to the next RX state
         gs_RxNextState = gs_RxNextState_ToBe;
         gpF_RxStateFunc = gpF_RxStateFunc_ToBe;

         //Disable PLL during R_O_P_ECT
         if(gft_EctPllDisable == 1)
         {
            if(gs_RxNextState == VDSL2_R_O_P_ECT_RX)
            {
               gft_EnablePLL = FALSE;
            }
         }
      }
      else
      {
         //Perform timeout check
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 1)
         {
            CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHRO1, E_CODE_RX_SYNCHRO4_DETECT_FAIL);
         }
         else
         {
            int32 l_CurrentSymCnt;

            //Compute the current symbol count passed from the start of the train phase
            l_CurrentSymCnt = gl_TotalTxSymbolCount - gl_TrainPhaseSymCnt_start;
            CheckTimeout(l_CurrentSymCnt, gl_SynchroTimeoutCnt, E_CODE_RX_SYNCHRO4_DETECT_FAIL);
         }
      }


      //If the next state is a periodic state,
      //turn off the CE upon transition to Periodic state
      if((gs_SynchSymbolDetectCnt >= 10+gs_HandleRxCE_Periodic2StateStart_StartSym_Offset) && (gs_RxNextStatePeriodicFlag))
      {
         HandleRxCE_PeriodicStateStart();
      }

      break;

   } //switch
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : NextRxTrainingState
 *
 *  Prototype:  void NextRxTrainingState(void)
 *
 *   This function is a generic function called by several state machine function.
 *  It is used to decide which of the next RX state to transfer to based
 *  on the specified length of each state (when the length is empty, it will go to the
 *  next state).
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_RxNextState -- (I/O) the next RX state to transfer to
 *      gl_RxTeqLength -- (I) RX TEQ state length
 *      gl_RxQuietLength  -- (I) RX QUIET2 state length
 *      gl_RxEctLength  -- (I) RX ECT state length
 *      gl_RxPeriodicLength -- (I) RX Periodic state length
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void NextRxTrainingState(void)
{
   //Transfer to the next RX state
   switch(gs_RxNextState_ToBe)
   {

   case VDSL2_R_O_P_PILOT2_RX:

      if(gl_TxTeqLength > 0)
      {
         gpF_RxStateFunc_ToBe = (PtrToFunc)ROPPilot2RxF_VDSL2;
         break;
      }
      else
      {
         gs_RxNextState_ToBe = VDSL2_R_O_P_ECT_RX;
      }
      /* no break */

   case VDSL2_R_O_P_ECT_RX:

      if(gl_RxEctLength>0)
      {
         gpF_RxStateFunc_ToBe = (PtrToFunc)ROPEctRxF_VDSL2;
         break;
      }
      else
      {
         gs_RxNextState_ToBe = VDSL2_R_O_P_TEQ_RX;
      }
      /* no break */

   case VDSL2_R_O_P_TEQ_RX:

      if(gl_RxTeqLength > 0)
      {
         gpF_RxStateFunc_ToBe = (PtrToFunc)ROPTeqRxF_VDSL2;
         break;
      }
      else
      {
         gs_RxNextState_ToBe = VDSL2_R_O_P_PILOT3_RX;
      }
      /* no break */

   case VDSL2_R_O_P_PILOT3_RX:
      if(gl_TxEctLength > 0)
      {
         gpF_RxStateFunc_ToBe = (PtrToFunc)ROPPilot3RxF_VDSL2;
         break;
      }
      else
      {
         gs_RxNextState_ToBe = VDSL2_R_O_P_PERIODIC2_RX;
      }
      /* no break */

   case VDSL2_R_O_P_PERIODIC2_RX:

      if(gl_RxPeriodicLength > 0)
      {
         gpF_RxStateFunc_ToBe = (PtrToFunc)ROPPeriodic2RxF_VDSL2;
         break;
      }
      else
      {
         gs_RxNextState_ToBe = VDSL2_R_O_TA_UPDATE_RX;
      }
      /* no break */

   case VDSL2_R_O_TA_UPDATE_RX:

      gpF_RxStateFunc_ToBe = (PtrToFunc)ROTaUpdateRxF_VDSL2;
      break;
   } //switch

   if((gs_RxNextState_ToBe == VDSL2_R_O_P_TEQ_RX) ||
         (gs_RxNextState_ToBe == VDSL2_R_O_P_PERIODIC2_RX))
   {
      gs_RxNextStatePeriodicFlag = 1;
   }
   else
   {
      gs_RxNextStatePeriodicFlag = 0;
   }
}

