/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro5RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO5
*-------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "vdsl_const.h"
#include "cmv.h"

#define SYNC_SYMBOL_DETECT_THRESH_CPE     (14)

int16 gs_pllShowLimit;
/*^^^
*------------------------------------------------------------------------
*
*  Name : ROPSynchro5RxF_VDSL2
*
*  Prototype:  void ROPSynchro5RxF_VDSL2(void)
*
*   This is the state function for detecting O-P-SYNCHRO5 symbols.
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Return:
*      None
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO5_RX_INIT            (0)
#define R_O_P_SYNCHRO5_RX_DETECT          (1)

void ROPSynchro5RxF_VDSL2(void)
{

   int16 s_snr;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_5;
   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO5_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO5_RX_DETECT;

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO5_RX_DETECT:

      //Decode the O-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Improve Pll performance in impulse noise by tightening limit on phase error.
         // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
         s_snr = gpsa_MeasuredSnrBuf[gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx];

         if(s_snr > 52*256)
         {
            gs_pllShowLimit = (int16)PLL_QUARTER_PI_RADIANS/64;
         }
         else if(s_snr > 46*256)
         {
            gs_pllShowLimit = (int16)PLL_QUARTER_PI_RADIANS/32;
         }
         else if(s_snr > 40*256)
         {
            gs_pllShowLimit = (int16)PLL_QUARTER_PI_RADIANS/16;
         }
         else if(s_snr > 34*256)
         {
            gs_pllShowLimit = (int16)PLL_QUARTER_PI_RADIANS/8;
         }
         else if(s_snr > 28*256)
         {
            gs_pllShowLimit = (int16)PLL_QUARTER_PI_RADIANS/4;
         }
         else
         {
            gs_pllShowLimit = (int16)PLL_QUARTER_PI_RADIANS/2;
         }


         if (gs_ForcePllShowLimit != -1) {
            gs_pllShowLimit = gs_ForcePllShowLimit;  //XDSLRTFW-2302
         }

         // switch PLL coefficients for lower steady-state noise
         // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
         ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, gs_pllShowLimit);
         ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, gs_pllShowLimit);
         ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, gs_pllShowLimit);

         //go to the next RX state
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
         {
            if (gft_DSVectoringEnabled == TRUE)
            {
               gs_RxNextState = VDSL2_R_O_P_VECTOR2_RX;

               // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
               // Switch global state timout after OP-SYNCHRO5
               // Note:
               //       1) It is not possible to set the value directly if the new
               //          one is lower than the previous one. The timeout check would
               //          directly kick-in in RxForeGround. Since the Vectoring timeout is bigger
               //          it could directly be set. But to be independent of any change the correct
               //          procedure is also used here!
               //       2) guc_SwitchGlobalTimeout must be initialized to zero
               guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;
            }
            else
            {
               gs_RxNextState = VDSL2_R_O_MSG1_RX;
            }

            gpF_RxStateFunc = (PtrToFunc)ROMsg1RxF_VDSL2;    // both Rx state VDSL2_R_O_P_VECTOR2_RX   & VDSL2_R_O_MSG1_RX reside in the same
            // function ROMsg1RxF_VDSL2

            //go to the next TX state to send R-P-Synchro5
            gs_TxNextState = VDSL2_R_P_SYNCHRO5_TX;
            gpF_TxStateFunc = (PtrToFunc)RPSynchro5TxF_VDSL2;
         }
         else
         {
            //XDSLRTFW-1621 DeltInVectoring (Start)
            if (gft_DSVectoringEnabled == TRUE)
            {
               gs_RxNextState = VDSL2_R_O_P_VECTOR2_RX;

               // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
               // Switch global state timout after OP-SYNCHRO5
               // Note:
               //       1) It is not possible to set the value directly if the new
               //          one is lower than the previous one. The timeout check would
               //          directly kick-in in RxForeGround. Since the Vectoring timeout is bigger
               //          it could directly be set. But to be independent of any change the correct
               //          procedure is also used here!
               //       2) guc_SwitchGlobalTimeout must be initialized to zero
               guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;

               gpF_RxStateFunc = (PtrToFunc)ROMsg1RxF_VDSL2;    // both Rx state VDSL2_R_O_P_VECTOR2_RX  & VDSL2_R_O_MSG1_RX
               //reside in the same function ROMsg1RxF_VDSL2
               //XDSLRTFW-1621 DeltInVectoring (End)
            }
            else
            {
               //for the diag non-vect mode, R-MSG1 is not sent
               //Go to the next RX state to perform the training in Medley phase
               gs_RxNextState = VDSL2_R_O_P_MEDLEY_RX_BRIDGE;
               gpF_RxStateFunc = (PtrToFunc)ROPMedleyRxF_VDSL2_Bridge;
            }
            //In diagnostic mode, always set gs_RxNumBytesPerSymbol to 1
            gs_RxNumBytesPerSymbol = 1;
         }
      }
      else
      {
         //Perform timeout check
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 1)
         {
            CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHRO1, E_CODE_RX_SYNCHRO5_DETECT_FAIL);
         }
         else
         {
            int32 l_CurrentSymCnt;

            //Compute the current symbol count passed from the start of the train phase
            l_CurrentSymCnt = gl_TotalTxSymbolCount - gl_TrainPhaseSymCnt_start;
            CheckTimeout(l_CurrentSymCnt, gl_SynchroTimeoutCnt, E_CODE_RX_SYNCHRO5_DETECT_FAIL);
         }
      }

      //Load the TC task to disable the PRBS reset
      if((gft_DSVectoringEnabled == FALSE) && (gs_SynchSymbolDetectCnt == SYNC_SYMBOL_DETECT_THRESH_CPE))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SwitchToRxMedleyPRBS);

#ifdef ENABLE_VR9_HW_ERR_CNT
         //Log the core error counts during the train phase
         //and reset the current counts for logging the core error counts during Medley
         if(gft_EnableCoreErrorCheck)
         {
            memcpy(gsa_StrymonOverflowCnt_train, gsa_StrymonOverflowCnt, (sizeof(int16)*17));
            memset(gsa_StrymonOverflowCnt, 0, (sizeof(int16)*17));

            memcpy(gusa_FTOverflowCnt_train, gusa_FTOverflowCnt, (sizeof(int16)*2));
            memset(gusa_FTOverflowCnt, 0, (sizeof(int16)*2));

            memcpy(gsa_TxQTErrorCnt_train, gsa_TxQTErrorCnt, (sizeof(int16)*4));
            memset(gsa_TxQTErrorCnt, 0, (sizeof(int16)*4));

            memcpy(gsa_RxQTErrorCnt_train, gsa_RxQTErrorCnt, (sizeof(int16)*4));
            memset(gsa_RxQTErrorCnt, 0, (sizeof(int16)*4));
         }
#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

      }

      break;

   } //switch
}
