/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro6RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO6
*-------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// FramingGenLP1.c
//
// History
//
// 29/09/2014 Palaksha: Workaround for "XDSLRTFW-2032 No connect at 700mts in 30A profile."
//             Involves disabling the fix for jira XDSLRTFW-1628 for 30 a profile
//                    Grep for "XDSLRTFW-2032"
//
// ************************************************************************************************************



#include <string.h>
#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "zph_ini.h"
#include "showtime.h"
#include "show_iof.h"
#include "IRI_Iof.h"
#include "cri_iof.h"
#include "ghs.h"
#include "vdsl_const.h"
#include "cmv.h"
#include "ShowtimeERBHandler.h"
#include "CustomerTasks.h"

extern FlagT gft_TxStrymonOverflow;
extern uint16 gus_TxStrymonOverflowCnt_Medley;
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchro6RxF_VDSL2
 *
 *  Prototype:  void ROPSynchro6RxF_VDSL2(void)
 *
 *   This is the state function for detecting O-P-SYNCHRO6 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_RX_INIT          (0)
#define R_O_P_SYNCHRO_RX_DETECT        (1)

void ROPSynchro6RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_6;
   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO_RX_DETECT;

      if (!(gul_dbgSocMsgControl & DISABLE_PRBS_RESET_FOR_SYNCHRO6))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxResetPRBS);
      }

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO_RX_DETECT:

      //For synchro 6 signal, the scramber shall be used in reset mode
      //(for some reason, calling this function one time does not bring
      // the PRBS go back to reset mode)
      if (!(gul_dbgSocMsgControl & DISABLE_PRBS_RESET_FOR_SYNCHRO6))
      {
         if(gs_SynchSymbolDetectCnt < 14)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxResetPRBS);
         }
      }

      //Decode the O-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {

#ifdef ENABLE_VR9_HW_ERR_CNT
         //Due to the time slot assignment where RX-PMS is in the time slot before RX-QT,
         //we need to delay enabling the RX-PMS by one symbol so they will process
         //the RX path in correct sequence
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxPms);

         //Log the core error counts during the medley phase
         //and reset the current counts for logging the core error counts during showtime
         if(gft_EnableCoreErrorCheck)
         {
            gft_TxStrymonOverflow = FALSE;
            memcpy(gsa_StrymonOverflowCnt_medley, gsa_StrymonOverflowCnt, (sizeof(int16)*17));
            memset(gsa_StrymonOverflowCnt, 0, (sizeof(int16)*17));

            memcpy(gusa_FTOverflowCnt_medley, gusa_FTOverflowCnt, (sizeof(int16)*2));
            memset(gusa_FTOverflowCnt, 0, (sizeof(int16)*2));

            memcpy(gsa_TxQTErrorCnt_medley, gsa_TxQTErrorCnt, (sizeof(int16)*4));
            memset(gsa_TxQTErrorCnt, 0, (sizeof(int16)*4));

            memcpy(gsa_RxQTErrorCnt_medley, gsa_RxQTErrorCnt, (sizeof(int16)*4));
            memset(gsa_RxQTErrorCnt, 0, (sizeof(int16)*4));
            // XDSLRTFW-1628 (START)
            if (gsa_StrymonOverflowCnt_medley[0] || gsa_StrymonOverflowCnt_medley[3] || gsa_StrymonOverflowCnt_medley[9]
                  || gsa_StrymonOverflowCnt_medley[11] || gsa_StrymonOverflowCnt_medley[14] || gsa_StrymonOverflowCnt_medley[16])
            {
               gft_TxStrymonOverflow = TRUE;
               gus_TxStrymonOverflowCnt_Medley++;
            }
            // XDSLRTFW-1628 (END)
         }
#endif //#ifdef ENABLE_VR9_HW_ERR_CNT


#ifdef LOG_PILOT_CONSTELLATION
         if(gft_EnablePilotLog == 1)
         {
            //Start the pilot tone log
            gft_StartPilotLog = 1;
            gs_PilotLogSymCnt = 0;
            gs_PilotLogCnt = 0;
         }
#endif //#ifdef LOG_PILOT_CONSTELLATION

#ifdef ILV_DBG_BUFFER
         gpsa_IlvDbgBuffer = (int16 *)(void *)glp_IlvDbgBufferStart;
#endif // #ifdef ILV_DBG_BUFFER

         // XDSLRTFW-1958 (Start)
         if ((guc_InitSuccessFailCode == INIT_CONFIG_ERROR) || (guc_InitSuccessFailCode == INIT_CONFIG_NOT_FEASIBLE))
            EnterFailStates(gul_StoreExceptionCode);
         // XDSLRTFW-1958 (End)
         // Transition to RX showtime state
         gs_RxNextState = R_O_SHOWTIME_RX;
         gpF_RxStateFunc = (PtrToFunc)ShowtimeRxF_QT_VDSL2;

         //DSM_Vectoring_Debug:
         //if ( gs_PauseControl == 0x27)
         //Pause(gs_PauseControl);

         // Assign 1st RX time-critical
         gt_TaskArray[RX_QT_DONE].TimeCriticalTask = ShowtimeRxTC_QT_VDSL2;

         // Assign 2nd RX time-critical and non-time critical tasks used only
         // during showtime. .
         gt_TaskArray[RX_FC_DONE].TimeCriticalTask = ShowtimeRxTC_FC_VDSL2;
         gt_TaskArray[RX_FC_DONE].NonTimeCriticalTask = ShowtimeRxF_FC_VDSL2;

         if (gft_DSVectoringEnabled == TRUE)
         {
            //Synchronize Last RPSynchro6 Frame with Tx Sync Position
            // at the 241th Txfrmcnt we should prepare 1st SEGUE of synchro
            // to make sure the first Showtime Data frame coincides with TxFrmCnt =0
            // BUG: it seems the correct condition is 256 - 16
            if(gs_TxFrmCnt > (TX_DATA_SYMBOLS_PER_SUPERFRAME-15))
               //BUG: it seems the correct formula is 512 - 15 - gs_TxFrmCnt
            {
               gs_dbgDelayRPSynchro6 = TX_DATA_SYMBOLS_PER_SUPERFRAME<<1 - gs_TxFrmCnt -14;
            }
            else
               // BUG: it seems the correct formula is 256-16-gs_TxFrmCnt
            {
               gs_dbgDelayRPSynchro6 = TX_DATA_SYMBOLS_PER_SUPERFRAME - 15 - gs_TxFrmCnt;
            }
         }

         //go to the next TX state to send R-P-SYNCHRO6
         gs_TxNextState = VDSL2_R_P_SYNCHRO6_TX;
         gpF_TxStateFunc = (PtrToFunc)RPSynchro6TxF_VDSL2;

         if ( (gft_TxStrymonOverflow) && (gs_frame_rate_is_8khz == 0) ) // except 30a profile XDSLRTFW-2032
         {
            EnterFailStates(E_CODE_AFE_NOT_READY);   // XDSLRTFW-1628
         }
      }
      else
      {
         if(gs_SynchSymbolDetectCnt == 14)
         {
            // States in showtime
            // EOC_ERB_TRANSMISSION_STATE
            //    0: ST_ERBS_OFF                      : ERB are turned off
            //    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
            //    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
            guc_EOC_ERB_TRANSMISSION_STATE = ST_ERBS_OFF;

            gt_ShowtimeErbParams.uc_Dummy1                                             = 0x23;     // just as a marker
            gt_ShowtimeErbParams.us_EOC_ErrorFB_CMD_count                              = 0;
            gt_ShowtimeErbParams.us_EOC_ErrorFB_StartMsg_WithParameterChange_count     = 0;
            gt_ShowtimeErbParams.us_EOC_ErrorFB_StartMsg_WithoutParameterChange_count  = 0;
            gt_ShowtimeErbParams.us_EOC_ErrorFB_StopMsg_count                          = 0;
            gt_ShowtimeErbParams.us_EOC_ErrorFB_Parameter_Mismatch_count               = 0;
            gt_ShowtimeErbParams.us_Delay_ERB_Processing_count          = 0;
            gt_ShowtimeErbParams.us_Delay_ERBStartMsg_Processing_count  = 0;
            gt_ShowtimeErbParams.us_Delay_ERBEndMsg_Processing_count    = 0;
            gt_ShowtimeErbParams.us_First_SSC                           = 65535;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, StartRxDataPath_VDSL2);
#ifdef PPE_ENGINE
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, DFE_PPE_RxDataStatus_EnterShow);
#endif //PPE_ENGINE

         }

         //Perform timeout check
         if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 1)
         {
            CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHRO1, E_CODE_RX_SYNCHRO6_DETECT_FAIL);
         }
         else
         {
            int32 l_CurrentSymCnt;

            //Compute the current symbol count passed from the start of the medley phase
            l_CurrentSymCnt = gl_TotalTxSymbolCount - gl_AnalysisPhaseSymCnt_start;
            CheckTimeout(l_CurrentSymCnt, gl_SynchroTimeoutCnt, E_CODE_RX_SYNCHRO6_DETECT_FAIL);
         }
      }

      break;
   } //switch
}

