/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro6RxF_VDSL2Diag.c
*
*   This file contains RT function to receive O-P-SYNCHRO6 in the diagnostic mode.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "ROTrainingRxF.h"
#include "SynchDetect.h"
#include "vdsl_xception.h"
#include "show_iof.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchro6RxF_VDSL2Diag
 *
 *  Prototype:  void ROPSynchro6RxF_VDSL2Diag(void)
 *
 *   This is the state function for detecting O-P-SYNCHRO6 symbols used
 *  in the diagnostic mode.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_RX_INIT         (0)
#define R_O_P_SYNCHRO_RX_CODESWAP      (1)
#define R_O_P_SYNCHRO_RX_CODESWAP_WAIT   (2)
#define R_O_P_SYNCHRO_RX_DETECT         (3)

void ROPSynchro6RxF_VDSL2Diag(void)
{

   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //For the synchro6, the PRBS runs in the reset mode
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxResetPRBS);

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO_RX_CODESWAP;

      break;

      //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
      //Swap in the next page which contains all the remaining functions
      //used in the diagnostic mode
   case R_O_P_SYNCHRO_RX_CODESWAP:

      //For some reason, it seems we have to call this function twice
      //to make the PRBS go back to the reset mode
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableRxResetPRBS);

      // Request next swap page and go to substate to wait
      FreeSwapHandle(&guc_PrimPageHandle);
      guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ANAL_4_V2_PM_SWAPPAGE);

      gs_RxSubStateCnt = 0;
      gs_RxSubState = R_O_P_SYNCHRO_RX_CODESWAP_WAIT;

      break;

   case R_O_P_SYNCHRO_RX_CODESWAP_WAIT:

      if(guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         gft_CodeSwapDoneFlag = TRUE;

         //go to the next RX sub state to detect Synchro
         gs_RxSubState = R_O_P_SYNCHRO_RX_DETECT;
      }
      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Transfer to the next RX state
         gs_RxNextState = VDSL2_R_O_P_TRAIN3_RX;
         gpF_RxStateFunc = (PtrToFunc)ROMsgLdRxF_VDSL2;

         //Enable the demodulation of SOC message for diag mode
         gs_RxNumSocBitPerByte = 8;
         gft_RxSocMsgDemodFlag = ENABLE_LD_DEMOD_SOC_MSG;
      }
      else
      {
         //timeout check
         if(gl_RxSymbolCount > (gl_MedleyStateLength_Diag+10000))
         {
            EnterFailStates(E_CODE_RX_SYNCHRO6_DETECT_FAIL);
         }

      }

      break;

   } //switch

   /* =============================================== */
   /* state machine to handle code swap requests      */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ANAL_4_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ANAL_4_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ANAL_4_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ANAL_4_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ANAL_4_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   }

}
