/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchro7RxF_VDSL2Diag.c
*
*   This file contains CO function to receive R-P-SYNCHRO6 in the diagnostic mode.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "ROTrainingRxF.h"
#include "SynchDetect.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchro7RxF_VDSL2Diag
 *
 *  Prototype:  void ROPSynchro7RxF_VDSL2Diag(void)
 *
 *   This is the state function for detecting R-P-SYNCHRO7 symbols used
 *  in the diagnostic mode.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_RX_INIT         (0)
#define R_O_P_SYNCHRO_RX_DETECT         (1)

void ROPSynchro7RxF_VDSL2Diag(void)
{

   switch (gs_RxSubState)
   {

   case R_O_P_SYNCHRO_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_RxSubState = R_O_P_SYNCHRO_RX_DETECT;

      break;

      // demodulate and delineate HDLC msg.
   case R_O_P_SYNCHRO_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Transfer to the next RX state
         gs_RxNextState = VDSL2_R_O_DIAG_DONE_RX;
         gpF_RxStateFunc = (PtrToFunc)DiagDoneStateFunc;
      }
      else
      {
         //timeout check
         if(gl_RxSymbolCount > TIMEOUT_CNT_RX_P_SYNCHRO7_DIAG)
         {
            EnterFailStates(E_CODE_RX_SYNCHRO7_DETECT_FAIL);
         }
      }

      break;

   } //switch
}
