/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPSynchroVector1RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-SYNCHRO1
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "SynchDetect.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "IRI_IOf.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "cmv.h"
#include "vdsl_const.h"
extern int16 gs_MsgReceiveOPSYNCHROV1Flag;


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPSynchroVector1RxF_VDSL2_Handler
 *
 *  Prototype:  void ROPSynchroVector1RxF_VDSL2(void)
 *
 *   This is the state function for detecting O-P-SYNCHROV1 symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#include "ROPSynchroVector1RxF_VDSL2_Handler.h"


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_P_SYNCHRO_V1_RX_INIT         (0)
#define R_O_P_SYNCHRO_V1_RX_DETECT      (1)
#define R_O_P_SYNCHRO_V1_DONE         (2)

//#ifdef MTK_VECTORING_SUPPORT

void ROPSynchroVector1RxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_V1;
   switch (gs_VectorHandlerState)
   {

   case R_O_P_SYNCHRO_V1_RX_INIT:

      //Set the symbol detection count to 0
      gs_SynchSymbolDetectCnt = 0;

      //go to next substate
      gs_VectorHandlerState = R_O_P_SYNCHRO_V1_RX_DETECT;

      // set the DeRotateMedleyPilot flag to use
      // decision directed method for determining pilot phase
      gft_DeRotateMedleyPilot = 1;

      break;

   case R_O_P_SYNCHRO_V1_RX_DETECT:

      //Decode the R-P-Synchro signal
      if(DetectSynch(gpsa_RxToneBuf, gs_RxNumChannelsForMsgDecode) == TRUE)
      {
         //Indicate to the TX side that synchroV1 is received
         gs_MsgReceiveOPSYNCHROV1Flag = TRUE;
         gs_VectorHandlerState = R_O_P_SYNCHRO_V1_DONE;
      }
//      else
//      {

      //Perform timeout check
//         CheckTimeout(gl_RxSymbolCount, TIMEOUT_CNT_RX_O_P_SYNCHROV1, E_CODE_RX_SYNCHROV1_DETECT_FAIL);

//      }


      break;
   } //switch

}
//#endif //#ifdef MTK_VECTORING_SUPPORT
