/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPTrain1RxF_VDSL2.c
*
*   This file contains CPE function to receive O-P-TRAINING-RANDOM
*-------------------------------------------------------------------------
*/

//*****************************************************************************
// ROPTrain1RxF_VDSL2.c
//
// History
// 12/04/2013 Fuss: Solve link problems in vectoring on long loops
//            XDSLRTFW-793 RP-Synch not detected / Tone cluster not detected (due to "fast LOS" / Pilot-tone scaling)
//            Grep for  "XDSLRTFW-793: RP-Synch not detected / Tone cluster not detected"
// 28/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//            XDSLRTFW-458:Loop Reach is limited with different ECI  DPBO shapes.
//            This is because link failures at different phases.
//            a) 2nd pilot tone selection failure, because of conditions imposed
//               on pilot selection like limit for Pilot tone selection:
//               ADD_OFFSET_FROM_BANDEDGE i.e. set the start tone index away
//               from the band edge by minimum of predefined value and 1/4 of
//               band size and minimum SNR required 15 dB This fix is controlled
//               by CMV INFO 232 0 bit0(mask 0x0001)
//                  bit0 value - 0 (default)
//                             - 1 (for ECIBT testing)
//            b) Timing Advance correction applied from O-Update message. If
//               total timing advance value is going above 300 then observed
//               OPTrain1 SNR is completely noisy (because of Echo) hence not
//               able to detect proper band for OPSYNCHRO4 detection.
//
//            Work around is to limit the Maximum value of Timing Advance from
//            CPE such that Echo effect will not be seen in DS band.
//
//            This fix is controlled by CMV INFO 232 0 bit1(mask 0x0002)
//               bit1 value - 0 (default)
//                          -1 (for ECIBT testing)
//            c) Use special hybrid setting (this hybrid will reduce the US0
//               echo, and enhancs the US1&US2 echos) So,use  only if US0 is
//               selected.
//
//               This fix is controlled by CMV INFO 232 0 bit2(mask 0x0004)
//                  bit1 value - 0 (default)
//                             -1 (for ECIBT testing)
//            d) Restore number of frames for average of PSD calcultion (which
//               will be used to select the pilot tone of ChDisc) to 8.
//
//               This fix is controlled by CMV INFO 232 0 bit4(mask 0x0010)
//                  bit4 value - 0 (default)
//                             -1 (for ECIBT testing)
//               Grep for  "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 19/09/2013 Abu: Change Slow and fast PLL settings to default VDSL2 values
//            Grep for XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate
// 19/09/2013 Fuss: Addded if-case to skip fct. ResetPllRefTone()
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
// 28/01/2014 Fuss: Added fix to reach 2800m noise free and added debug code
//            Grep XDSLRTFW-1506: No sync in vectoring mode on loops >1600m (US0 only).
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
// 11/03/2015 Krause: Fix for no links on long loops (with noise) due to loss of sync in O-PERIODIC-2
//            Grep for XDSLRTFW-2190/XDSLRTFW-2270: PERF_DS_LONGLOOPS_SYNC_LOSS_IN_O_P_PERIODIC
//*****************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "DSLEngin.h"
#include "PGAHandler.h"
#include "FrameAlignmentHandler.h"
#include "FdqHandler.h"
#include "PsdHandler.h"
#include "SnrHandler.h"
#include "TxPSDControl.h"
#include "IRI_Iof.h"
#include "SharedFuncs.h"
#include "vdsl_xception.h"
#include "cmv.h"
#include "mul.h"
#include "IRI_sync.h"
#include "vdsl_const.h"
#include "V_STR_IOf.h"
#include "GetTonePsd.h"

//#ifdef MTK_VECTORING_SUPPORT
#include "ROPVECTOR1Handler.h"
#include "DetectDSSync_Vector_Handler.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "ToneReorder.h"
 #ifdef VRX518_BRINGUP_DEBUG
 #include "profile.h"
 #endif
#include "CRI_Iof.h"

//#define TTR_PAUSE_DEBUG
#undef TTR_PAUSE_DEBUG


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPTrain1RxF_VDSL2
 *
 *  Prototype:  void ROPTrain1RxF_VDSL2(void)
 *
 *   This function contains five Rx states.
 *      i. VDSL2_R_O_P_VECTOR1_1_RX         (181)    :(G993.5 state)
 *     ii. VDSL2_R_O_P_TRAINING1_COMMON_RX  (140)    :(common for both G993.2 and G993.5)
 *    iii. VDSL2_R_O_P_TRAINING_V1_RX       (182)    :(G993.5 state)
 *     iv. VDSL2_R_O_P_SYNCRO_V2_RX         (183)    :(G993.5 state)
 *      v. VDSL2_R_O_P_TRAIN1_RX            (78)     :(common for both G993.2 and G993.5)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_RxSubState -- (I/O) substate number
 *      gs_RxNextState -- (O) the next TX state
 *      gpF_TxStateFunc -- (O) pointer to the next TX state function
 *      guc_TxMsgCode -- (O) TX message code of the next message
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */

// sub state definations for VDSL2_R_O_P_VECTOR1_1_RX (O-P Vector1-1/G993.5)
#define R_O_P_VECTOR1_1_RX_INIT                                    (0)
#define R_O_P_VECTOR1_1_RX_SIGNAL                                  (1)
#define R_O_P_VECTOR1_1_RX_DONE                                    (2)

// sub state definations for VDSL2_R_O_P_TRAINING1_COMMON_RX (initial part of O-P Training V1/G993.5 or O-P Training1/G993.2)
#define R_O_P_TRAINING1_COMMON_RX_INIT                             (0)
#define R_O_P_TRAINING1_COMMON_RX_RECONFIG_BANDPLAN                (1)
#define R_O_P_TRAINING1_COMMON_RX_PGA_NO_ECHO                      (2)
#define R_O_P_TRAINING1_COMMON_RX_PLL_RELOCK_1                     (3)
#define R_O_P_TRAINING1_COMMON_RX_FRAME_ALIGNMENT                  (4)
#define R_O_P_TRAINING1_COMMON_RX_FRAMEALIGNMENT_RESET             (5)

// sub state definations for VDSL2_R_O_P_TRAINING_V1_RX (O-P Training V1/G993.5)
#define R_O_P_TRAINING_V1_RX_FDQ                                   (0)
#define R_O_P_TRAINING_V1_RX_NO_ECHO_SNR                           (1)
#define R_O_P_TRAINING_V1_RX_ALGHD_2_CS_PAGE_LOAD                  (2)
#define R_O_P_TRAINING_V1_RX_VERIFY_SYNC_SYMBOL_POSITION           (3)
#define R_O_P_TRAINING_V1_RX_PREPARE_TX                            (4)

// sub state definations for VDSL2_R_O_P_SYNCRO_V2_RX (O-P Synchro V2/G993.5)
#define R_O_P_SYNCRO_V2_RX_DETECT                                  (0)

// sub state definations for VDSL2_R_O_P_TRAIN1_RX (O-P Training1)
#define R_O_P_TRAIN_RX_RESET_PGA                                   (0)
#define R_O_P_TRAIN_RX_PGA_ECHO                                    (1)
#define R_O_P_TRAIN_RX_PLL_RELOCK_2                                (2)
#define R_O_P_TRAIN_RX_TRAIN_FDQ                                   (3)
#define R_O_P_TRAIN_RX_MEASURE_PSD                                 (4)
#define R_O_P_TRAIN_RX_STREAM_PSD                                  (5)
#define R_O_P_TRAIN_RX_CALCULATE_SNR                               (6)
#define R_O_P_TRAIN_RX_DONE                                        (7)


//#define QLN_VALUE_MINUS_100DBM_HZ    154   // -100dBm/Hz is 154 {-23-(154/2) = -100}
//#define QLN_VALUE_MINUS_90DBM_HZ     134   //  -90dBm/Hz is 134 {-23-(134/2) =  -90}
//#define QLN_VALUE_MINUS_88DBM_HZ     130   //  -90dBm/Hz is 134 {-23-(130/2) =  -88}
//
// Local function declaration
static void BgReconfigTrain(void);
static void InitROPTraining(void);


void ROPTrain1RxF_VDSL2(void)
{
   int16 i;

   // VDSL2_R_O_P_VECTOR1_1_RX state start
   if (gs_RxState == VDSL2_R_O_P_VECTOR1_1_RX)
   {
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[3]=VDSL2_R_O_P_VECTOR1_1;
      switch (gs_RxSubState)
      {
      case R_O_P_VECTOR1_1_RX_INIT:

         //Configure HW
         if(gl_RxSymbolCount == 0)
         {
            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timout from VECTORING_STATE_TIMEOUT_LEN back
            // to normal STATE_TIMEOUT_LEN.
            // Note: This code is only active for Vectoring!
            if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_RX)
            {
               gl_RxStateTimeOutCount = VECTORING_STATE_TIMEOUT_LEN;
               guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_RX);
            }
            //Configure HW to change CE, CP, FFT length etc.
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, InitROPTraining);

            // Set RTV selection to FFT output
            gs_RtvSelect = FFT_OUTPUT;

            //Indicate the TX side is not sending signal
            gs_TxRxMessaging = PGA_RETRAIN_IDLE;

            // Load the background task to reconfigure the band/states based on the messages exchanged
            // in discovery phase
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReconfigTrain);

            // turn off PLL
            gft_EnablePLL  = FALSE;

            // XDSLRTFW-1506 (Start_End)
            // XDSLRTFW-3382 (Start_End)
            // The fix from Jira XDSLRTFW-1506 must be disabled for VRx518 HW until correct concept is available!
            // Note: The FW is restoring the PGA from ChannelDiscovery -> gs_PGA_set_NoEcho
            //       But at this point the special QLN hybrid is used, i.e. 8-12dB more gain and
            //       the is ACE off.
            //       Therefore this setting can lead for short loops to clipping at the ADC.
            //       Main problem:
            //          - ACE gain and QLN hybrid gain difference to actual used hybrid is not considered
            //          - AFED_BgSingleStagePGASetting is not considering the possible 1.5Vp at PREFI in-put to 0.6Vp at PREFI in-output.
            //XDSLRTFW-3613 Start
            if (gus_DebugControlVRX518 & PGA_OF_CHDISC_FOR_TRANSTRAIN_EN)
            {
               int16 s_HybGainDiff;
               //The fix from Jira XDSLRTFW-1506 is corrected for VRx518 HW!
               //Set the PGA used for OP-Vector11 detection to the PGA value used in ChannelDiscovery no Echo phase.
               //But at this point NEW HYB IS SELECTED is used and ChannelDiscovery no Echo phase PGA was with spl QLN/HLOG Hyb settings
               //We have to take the difference of Hyb gains of special QLN hybrid and the SELECTED Hyb and adjust accordingly
               //Add Hyb gain diff = QLN/HLOG Hyb Gain - SELECTED Hyb gain
               //Add Hyb gain diff between ChannelDiscovery Hyb and Present Hyb = QLN Hyb Gain - gs_HybridGain(SELECTED Hyb)
               s_HybGainDiff = gusa_HybridSettingV2_QlnHlog_VRX518[VRX518_HYBGAIN_IDX]-gs_HybridGain;
               guc_PgaState = TRAINING_IN_PROGRESS;
               AFED_ReUsePgaPrefiGains(s_HybGainDiff);
            }
            else
            {
               guc_PgaState = TRAINING_DONE;
            }
            //XDSLRTFW-3613 End
         }

         //INTEROP_IK
         // wait for backgrount task to complete and
         // delay to insure that the training signal has settled
         // XDSLRTFW-1506 (Start_End)
         if((gs_RxBkgdProcessFlag == TRAINING_DONE) && (guc_PgaState == TRAINING_DONE) &&
               ((gft_DSVectoringEnabled == TRUE) || (gl_RxSymbolCount >= gs_dbgROPTrain1Delay)))
         {
            //swap R_O_P_vector1 code
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE);

            // Set RTV selection to HW_ACCUM_POW
            gs_RtvSelect = FFT_OUTPUT ;
            gs_VectorHandlerState = R_O_P_VECTOR1_INIT;
            gs_RxSubState = R_O_P_VECTOR1_1_RX_SIGNAL;
         }
         break;

      case R_O_P_VECTOR1_1_RX_SIGNAL:

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            if (gs_VectorHandlerState != R_O_P_VECTOR_1_X_DETECTED)
            {
               ROPVector1Handler();
            }
            else
            {
               // done with O_P_VECTOR1, continue with rest of the processing for ROTrain,
               // swap ALGHD1 page
               FreeSwapHandle(&guc_PrimPageHandle);
               guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
               gs_RxSubState = R_O_P_VECTOR1_1_RX_DONE;
            }
         }
         break;

      case R_O_P_VECTOR1_1_RX_DONE:

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            // delay to insure that the training signal has settled
            // included this condition to incorporate the training signal to skip transition.
//               gs_dbgROPTrain1Delay--;
//               if(gs_dbgROPTrain1Delay < 1)
            {
               // Next Rx state
               // Note: During state change sub state and sub state cnt will initialize to zero
               //       in RxForeGround()!
//                  gs_RxSubStateCnt = 0;
//                  gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_INIT;
               gs_RxNextState = VDSL2_R_O_P_TRAINING1_COMMON_RX;
            }
         }
         break;
      } // end switch
   } // end if of VDSL2_R_O_P_VECTOR1_1_RX state
   else if (gs_RxState == VDSL2_R_O_P_TRAINING1_COMMON_RX)  // VDSL2_R_O_P_TRAINING1_COMMON_RX state start
   {
      if((gl_RxSymbolCount == 0) && (gft_DSVectoringEnabled == TRUE))
      {
         gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_RECONFIG_BANDPLAN;
      }

      switch (gs_RxSubState)
      {
      case R_O_P_TRAINING1_COMMON_RX_INIT:
         //Configure HW
         if(gl_RxSymbolCount == 0)
         {
            //Configure HW to change CE, CP, FFT length etc.
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, InitROPTraining);

            // Set RTV selection to FFT output
            gs_RtvSelect = FFT_OUTPUT;

            //Indicate the TX side is not sending signal
            gs_TxRxMessaging = PGA_RETRAIN_IDLE;

            // Load the background task to reconfigure the band/states based on the messages exchanged
            // in discovery phase
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReconfigTrain);

            // turn off PLL
            gft_EnablePLL  = FALSE;
         }

         //INTEROP_IK
         // wait for backgrount task to complete and
         // delay to insure that the training signal has settled
         if((gs_RxBkgdProcessFlag == TRAINING_DONE) &&(gl_RxSymbolCount >= gs_dbgROPTrain1Delay))
         {
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_RECONFIG_BANDPLAN;
         }
         break;


      case R_O_P_TRAINING1_COMMON_RX_RECONFIG_BANDPLAN:

         if(gs_RxSubStateCnt == 0)
         {
            // read TX and RX timer
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, GetTxRxCounters);
         }
         else if(gs_RxSubStateCnt == 1)
         {
            SavePreTimeAdvanceInfo();
            gs_TimingAdvanceTrailIndex++;

            // Set RX tone offset to the start tone from which the HW should do the processing, i.e. RTV buffer 0.
            gs_RxToneOffset = gsa_RxBandLeftChannel[0];
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);
         }
         else
         {
            //Go to substate to train the PGA (without echo)
            gs_PgaHandlerState = PGA_INIT;
            gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_PGA_NO_ECHO;
            if (gft_EnablePsdMeasurementInPgaHandler == TRUE)
            {
               gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC = TRUE;
            }
         }

         gs_RxSubStateCnt++;
         break;


      case R_O_P_TRAINING1_COMMON_RX_PGA_NO_ECHO:

         //Train PGA when echo is off (CPE sends quiet signal
         if (gs_PgaHandlerState != PGA_DONE)
         {
            PGAHandler();
         }
         else
         {
            // Save PGA settings
            gs_PGA_set_NoEcho_Train = gs_PGA_set;
            gs_RxVarGainDB_NoEcho_Train = gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB;

            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_PLL_RELOCK_1;
         }
         break;

      case R_O_P_TRAINING1_COMMON_RX_PLL_RELOCK_1:
         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         gs_RxSubStateCnt++;

         if (gs_RxSubStateCnt == 1)
         {
            if (!(gsa_Optn2_AlgControl[1] & OPTN_UseForcedPilot) &&
                !(gt_PilotConfig.s_PilotToneControl & DISABLE_MULTI_PILOT_SELECT))
            {
               // switch to currently best pilot tone according to pilot tone metric
               int32 l_tempBest = PT_ARRAY_IDX_0;
               if (gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_1].l_Metric > gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].l_Metric)
               {
                  l_tempBest= PT_ARRAY_IDX_1;
               }
               // XDSLRTFW-3470, XDSLRTFW-2723: Exclude the usage of the DS3 band pilot tone if ShowPllToneSwitch is disabled,
               // since we communicated only DS1 and DS2 PT in R-MSG1 and we have to decide for one of those two to be used
               if(gft_EnableShowPllToneSwitch) // XDSLRTFW-3610 Start/End correction to fix rate degradation
               {
                  if (gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_2].l_Metric > gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_1].l_Metric)
                  {
                     l_tempBest= PT_ARRAY_IDX_2;
                  }
               }
               gt_PilotConfig.te_BestPTArrayIdx = l_tempBest;
               gt_PilotConfig.te_UsedPTArrayIdx = l_tempBest;
            }
            // configure HW to grab a new pilot tone
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxPilotToneIndex);
         }
         else if (gs_RxSubStateCnt == 3)
         {
            // Set new Pll Reference for all 3 supported pilot tones after PGA
            ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3);

            // Set PLL loop filter parameters to Fast converge.
            ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);

            // turn on PLL
            gft_EnablePLL  = TRUE;
            DSH_SendStream(DSH_PILOT_TONE_ARRAY,sizeof(gt_PilotConfig),&gt_PilotConfig.s_NumPilotTones);
         }
         // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start)
         else if ((gs_NumFramesSlowPLLStabilization_TrainV1 != -1) && (gs_RxSubStateCnt == gs_NumFramesFastPLLStabilization_TrainV1)) // Wait for PLL to stabilize
         {
            // Ignore Slow PLL adaptation in case gs_NumFramesSlowPLLStabilization_TrainV1 = -1
            // At Non Vectoring cases, gs_NumFramesSlowPLLStabilization_TrainV1 initializes to -1

            // switch PLL coefficients for Slow adaptation to adapt lower steady-state noise
            ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
         }
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
         else if (gs_RxSubStateCnt > (gs_NumFramesFastPLLStabilization_TrainV1+gs_NumFramesSlowPLLStabilization_TrainV1)) // Wait for PLL to stabilize
         {
            // In case of gs_NumFramesSlowPLLStabilization_TrainV1 = -1, FW will skip ResetPLL for Slow adaptation
            // and code will come to this section when "gs_RxSubStateCnt = gs_NumFramesFastPLLStabilization_TrainV1"
            // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (End)

            // proceed to frame alignment
            if (gus_VdslCntlFlag & BITMAP_ENABLE_2ND_FA_TRAIN1_VDSL2)
            {
               gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_FRAME_ALIGNMENT;
               gs_AlgHandlerState = FRAMEALIGNMENT_SELECT_TONES;
            }
            // skip 2nd frame alignment if bit-field is not set
            else
            {
#ifdef LOG_FA_DEBUG_INFO
               // save frame alignment debug info
               gs_CumulativeAlignmentOffset_Train = 0;
#endif // LOG_FA_DEBUG_INFO

               if(gs_dbgRPTrain1Delay >= gl_RxSymbolCount)
               {
                  gs_dbgRPTrain1Delay -= gl_RxSymbolCount;
               }

               // Next Rx state
               // Note: During state change sub state and sub state cnt will initialize to zero
               //       in RxForeGround()!
//                  gs_RxSubStateCnt = 0;
//                  gs_RxSubState = R_O_P_TRAIN_RX_RESET_PGA;
               gs_RxNextState = VDSL2_R_O_P_TRAIN1_RX;
            }
         }
         break;


      case R_O_P_TRAINING1_COMMON_RX_FRAME_ALIGNMENT:
         //Compute and perform frame alignment
         if (gs_AlgHandlerState != FRAMEALIGNMENT_DONE)
         {
            FrameAlignmentHandler();
         }
         else
         {
            if ( (gsa_FrameAlignOffsets[gs_FrameAlignIteration-1] > gs_MaxFAOffset_at_convergence)      ||
                  (gsa_FrameAlignOffsets[gs_FrameAlignIteration-1] < (-gs_MaxFAOffset_at_convergence))  ||
                  (gsa_FrameAlignOffsets[gs_FrameAlignIteration-2] > gs_MaxFAOffset_at_convergence)     ||
                  (gsa_FrameAlignOffsets[gs_FrameAlignIteration-2] < (-gs_MaxFAOffset_at_convergence))  ||
                  (gsa_FrameAlignOffsets[gs_FrameAlignIteration-3] > gs_MaxFAOffset_at_convergence)     ||
                  (gsa_FrameAlignOffsets[gs_FrameAlignIteration-3] < (-gs_MaxFAOffset_at_convergence))      )
            {
               // If the cumulative FA adjustment applied in FrameAlignmentHandler() exeeded gs_RxNumTones>>5,
               // apply another adjustment which limits the composite adjustment to
               // gs_RxNumTones>>5. This limit is 128 samples, for 4096 tones.  Downstream distortion has been
               // seen to cause FA to be way off intermittently.
               if (gs_CumulativeAlignmentOffset>(gs_RxNumTones>>5))
               {
                  gs_AlignmentOffset =  (gs_RxNumTones>>5) - gs_CumulativeAlignmentOffset;
                  gs_CumulativeAlignmentOffset = (gs_RxNumTones>>5);
               }
               else if (gs_CumulativeAlignmentOffset<-(gs_RxNumTones>>5))
               {
                  gs_AlignmentOffset = -(gs_RxNumTones>>5) - gs_CumulativeAlignmentOffset;
                  gs_CumulativeAlignmentOffset = -(gs_RxNumTones>>5);
               }
               else
               {
                  gs_AlignmentOffset = 0;
               }
            }
            else
            {
               gs_AlignmentOffset = 0;
            }

#ifdef LOG_FA_DEBUG_INFO
            // save frame alignment debug info
            gs_ToneSelect_FA_Train = gs_SelectBandStart;
            gs_NumCluster_FA_Train = gs_NumFrameAlignClusters;
            gs_CumulativeAlignmentOffset_Train = gs_CumulativeAlignmentOffset;
            gs_FrameAlignIteration_Train = gs_FrameAlignIteration;
            {
               int16 s_CopyLength;

               s_CopyLength = gs_FrameAlignIteration;
               if (s_CopyLength > MAX_NUM_FRAME_ALIGN_ITERATIONS)
               {
                  s_CopyLength = MAX_NUM_FRAME_ALIGN_ITERATIONS;
               }
               memcpy(gsa_FrameAlignOffsets_Train, gsa_FrameAlignOffsets, sizeof(int16)*s_CopyLength);
               memcpy(gsa_FA_debug_buf_Train, gsa_FA_debug_buf, sizeof(int16)*6*s_CopyLength);
            }
#endif // LOG_FA_DEBUG_INFO

            //Transfer the TX to the state to send R-P-Training
            gs_RxFrameAlignRemain = 0;

            AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
            gft_EnablePLL = 0; // Turn off PLL
            gs_RxSubState = R_O_P_TRAINING1_COMMON_RX_FRAMEALIGNMENT_RESET;
         }
         break;


      case R_O_P_TRAINING1_COMMON_RX_FRAMEALIGNMENT_RESET:
         //For the 6.2 HW, it is not allowed to make a strymon frame less than FFT size
         //so it may take more than one frame to do frame adjustment if gs_AlignmentOffset is greater than
         //CE Length. Note the variable gs_RxFrameAlignRemain stores the remaining adjustment
         //after each call to AdjustAlignment()
         if(gs_RxFrameAlignRemain != 0)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
            break;
         }

         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetRxAlign);

         if (gft_DSVectoringEnabled == TRUE)
         {
            // turn on PLL ( is it needed?)
            gft_EnablePLL  = TRUE;

            gs_AlgHandlerState = FDQ_TRAIN_INIT;

            // Next Rx state (Vectoring)
            // Note: During state change sub state and sub state cnt will initialize to zero
            //       in RxForeGround()!
//               gs_RxSubState = R_O_P_TRAINING_V1_RX_FDQ;
            gs_RxNextState = VDSL2_R_O_P_TRAINING_V1_RX;
         }
         else
         {
            if(gs_dbgRPTrain1Delay >= gl_RxSymbolCount)
            {
               gs_dbgRPTrain1Delay -= gl_RxSymbolCount;
            }

            // Next Rx state
            // Note: During state change sub state and sub state cnt will initialize to zero
            //       in RxForeGround()!
//               gs_RxSubStateCnt = 0;
//               gs_RxSubState = R_O_P_TRAIN_RX_RESET_PGA;
            gs_RxNextState = VDSL2_R_O_P_TRAIN1_RX;
         }
         break;

      } // End switch

   } // end if   of VDSL2_R_O_P_TRAINING_COMMON_INIT state
   else if (gs_RxState == VDSL2_R_O_P_TRAINING_V1_RX) // VDSL2_R_O_P_TRAINING_V1_RX state start
   {
      gsa_IndirectStat0[3]=VDSL2_R_O_P_TRAINING_V1;
      switch (gs_RxSubState)
      {
      case R_O_P_TRAINING_V1_RX_FDQ:

         if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
         {
            FdqHandler();
         }
         else
         {
            // Set RTV selection to FFT output (?)
            gs_RtvSelect = FFT_OUTPUT;

            gs_AlgHandlerState = SNR_INIT;
            gs_RxSubState = R_O_P_TRAINING_V1_RX_NO_ECHO_SNR;
         }
         break;

      case R_O_P_TRAINING_V1_RX_NO_ECHO_SNR:

         if (gs_AlgHandlerState != SNR_CALC_DONE)
         {
            SnrHandler();
         }
         else
         {
            //Call the following function to select the tones for message decoding
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxMsgDecodeTones);

            gs_RxSubState = R_O_P_TRAINING_V1_RX_ALGHD_2_CS_PAGE_LOAD;

            // save pilot tone index and other debug info
            // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
            gs_PilotToneIdx_Train = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx;
            for (i=0; i<gt_PilotConfig.s_NumPilotTones; i++)
            {
               memcpy(&gsa_SnrOfPilotTone_Train[i], &gpsa_MeasuredSnrBuf[gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx-2], sizeof(int16)*5);
            }
         }
         break;

      case R_O_P_TRAINING_V1_RX_ALGHD_2_CS_PAGE_LOAD:
         if (gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            //swap R_O_P_vector1 code
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE);

            gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB_INIT;
            gs_RxSubState = R_O_P_TRAINING_V1_RX_VERIFY_SYNC_SYMBOL_POSITION;
         }
         break;

      case R_O_P_TRAINING_V1_RX_VERIFY_SYNC_SYMBOL_POSITION:

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            if (gs_VectorHandlerState != VECTOR_DECODESYNCH_DONE)
            {
               DetectDSSync_Vector_Handler();
            }
            else
            {
               // swap ALGHD1 page
               FreeSwapHandle(&guc_PrimPageHandle);
               guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);

               gs_RxSubState = R_O_P_TRAINING_V1_RX_PREPARE_TX;
            }
         }
         break;

      case R_O_P_TRAINING_V1_RX_PREPARE_TX:

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            // make TX transition to VDSL2_R_P_VECTOR1_1_TX state
            gs_TxNextState = VDSL2_R_P_VECTOR1_1_TX;        // Start R_P_Vector1-1 Tx state

            gpF_TxStateFunc = (PtrToFunc)RPTrain1TxF_VDSL2;

            gft_EnablePLL  = TRUE;

            gs_VectorHandlerState = R_O_P_SYNCHRO_V2_RX_INIT;

            // Next Rx state
            // Note: During state change sub state and sub state cnt will initialize to zero
            //       in RxForeGround()!
//               gs_RxSubState = R_O_P_SYNCRO_V2_RX_DETECT;
            gs_RxNextState = VDSL2_R_O_P_SYNCRO_V2_RX;
         }
         break;

      } // end switch
   } //end if of VDSL2_R_O_P_TRAINING_V1_RX state

   if (gs_RxState == VDSL2_R_O_P_SYNCRO_V2_RX)       // VDSL2_R_O_P_SYNCRO_V2_RX start
   {
      // We are using this switch funchtion below only to make this state function code similar to other state function code
      gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_V2;
      switch (gs_RxSubState)
      {
      case R_O_P_SYNCRO_V2_RX_DETECT:

         if (gs_VectorHandlerState != R_O_P_SYNCHRO_V2_DONE)   // use defination instead of value
         {
            ROPSynchroV2_VDSL2();
         }
         else
         {
            // this flag is used in the transmit state machine to start RPTraining 1
            gs_MsgReceiveOPSYNCHROV1Flag = TRUE;

            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timout after OP-SYNCHROV2
            // Note:
            //       1) It is not possible to set the value here directly since
            //          it is lower than the previous one. So the timeout check
            //          in RxForeGround would directly kick in.
            //       2) guc_SwitchGlobalTimeout must be initialized to zero
            guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;

            // Next Rx state (train PGA (with echo))
            // Note: During state change sub state and sub state cnt will initialize to zero
            //       in RxForeGround()!
//               gs_RxSubStateCnt = 0;
//               gs_RxSubState = R_O_P_TRAIN_RX_RESET_PGA;
            gs_RxNextState = VDSL2_R_O_P_TRAIN1_RX;
         }
         break;

      } // end swithc
   } // end if of R_O_P_SYNCRO_V2_RX_DETECT state

   if ( gs_RxState == VDSL2_R_O_P_TRAIN1_RX)        //VDSL2_R_O_P_TRAIN1_RX state start
   {
      gsa_IndirectStat0[3]=VDSL2_R_O_P_TRAINING1;
      switch (gs_RxSubState)
      {
      case R_O_P_TRAIN_RX_RESET_PGA:
         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timout from VECTORING_STATE_TIMEOUT_LEN back
         // to normal STATE_TIMEOUT_LEN.
         // Note: This code is only active for Vectoring!
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_RX)
         {
            gl_RxStateTimeOutCount = STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_RX);
         }

         // XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
         if(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_TrainingV1)
         {
            // initialize vars for FDQ train
            gs_AlgHandlerState = FDQ_TRAIN_INIT;
            gs_RxSubState = R_O_P_TRAIN_RX_TRAIN_FDQ;
         }
         else
         {
            if (gs_RxSubStateCnt == 0)
            {
               // Signal to TX side to start timing advance correction according to O-Update value.
               guc_TxRxCommunicator |= TX_TIMING_ADVANCE_TRAIN1_START;

               // turn off PLL
               gft_EnablePLL  = FALSE;

            }
            else
            {
               if ((guc_TxRxCommunicator & TX_TIMING_ADVANCE_TRAIN1_COMPLETED) &&
                   ((gl_RxSymbolCount >= gs_dbgRPTrain1Delay) || (gft_DSVectoringEnabled == TRUE)))
               {
                  if (gft_DSVectoringEnabled == FALSE)
                  {
                     // make TX transition to R_P_TRAIN1 state
                     gs_TxNextState = VDSL2_R_P_TRAIN1_TX;
                     gpF_TxStateFunc = (PtrToFunc)RPTrain1TxF_VDSL2;
                  }

                  // train the PGA (with echo)
                  gs_PgaHandlerState = PGA_INIT;

                  if (gft_EnablePsdMeasurementInPgaHandler == TRUE)
                  {
                     gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC = TRUE;
                  }

                  //XDSLRTFW-3064 Start
                  //Detetct Noise limited case by looking at QLN values US1/US2 band and if DS1 or DS1 and DS2 band are present
                  {
                     //XDSLRTFW-3064 Start
                     //Detetct Noise limited case by looking at QLN values US1/US2 band and if DS1 or DS1 and DS2 band are present
                     if((gus_DebugControlVRX518 & US_NOISE_DETECTION_EN) && (!(gs_Pga_XtakNoiseScaleCtrl & (~0x03))))
                     {
                        if (gs_Pga_XtakNoiseScaleCtrl & 0x02)
                        {
                           //US0 and DS1
                           gs_Pga_XtakNoiseScale = 2;                          // 2dB(Already Prefi Marigin is 2dB)+6dB in 8.8 format
                        }
                        else if (gs_Pga_XtakNoiseScaleCtrl & 0x01)
                        {
                           //US0/US1 and DS1/DS2 case
                           gs_Pga_XtakNoiseScale = 1;                          // 2dB(Already Prefi Marigin is 2dB)+3dB in 8.8 format
                        }
                     }
                  }

                  gs_RxSubState = R_O_P_TRAIN_RX_PGA_ECHO;
                  // XDSLRTFW-3897(Start)
                  // Debug code:
                  // Smaller the Fc of PGA and PREFI for mid and long reach (US0 only) loops
                  // XDSLRTFW-3197 Start_End
                  // XDSLRTFW-3190 Start_End
                  // Note: 2348 is equal to 10.125MHz, i.e. no DS3 and only DS2 and DS1!
                  //       The code is located here and not before the Hybrid- or PgaHandler, because
                  //       the gains would be adapted to the fct.. But with this approach an additional margin will be available.
                  //       Goal is to get the system first stable!
                  // Setting bit 0x2000 of gt_Reconf_Hybrid_Coeff.s_control will enable this setting
                  if(gt_Reconf_Hybrid_Coeff.s_control & DO_FC_TUNING_BEFORE_FINAL_PGA_TRAINING)
                  {
                     if (gus_DebugControlVRX518 & PGA_PREFI_FC_REDUCTION_EN)
                     {
                        // if US2 is disabled
                        if (gsa_RxBandRightChannel[gs_NumOfRxBands-1] < LAST_BIN_DS2)
                        {
                           int16 s_ShiftValue;
                           s_ShiftValue = 1;
                           // if US1 and US2 are disabled
                           if ((gsa_RxBandRightChannel[gs_NumOfRxBands-1] < LAST_BIN_DS1) &&
                               (!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK)))
                           {
                              s_ShiftValue = 2;
                           }
                           gla_fc_pga_lp_kHz[  gus_AFE_RxMode] = (gla_fc_pga_lp_kHz[  gus_AFE_RxMode] >> s_ShiftValue);
                           gla_fc_prefi_lp_kHz[gus_AFE_RxMode] = (gla_fc_prefi_lp_kHz[gus_AFE_RxMode] >> s_ShiftValue);
                        }
                     }
                  }
                  // XDSLRTFW-3897(End)
               }
            }
         } // end if(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_TrainingV1)
         gs_RxSubStateCnt++;

         break;

      case R_O_P_TRAIN_RX_PGA_ECHO:

         // wait til TX sends the R_P_TRAIN1
         if (gs_TxRxMessaging != PGA_RETRAIN_XMITTING)
         {
            break;
         }

         //Train PGA when echo is on (CPE sends R-P-Training1 signal)
         if (gs_PgaHandlerState != PGA_DONE)
         {
            PGAHandler();
         }
         else
         {
            // XDSLRTFW-2190/XDSLRTFW-2270: PERF_DS_LONGLOOPS_SYNC_LOSS_IN_O_P_PERIODIC (StartEnd)
            // this is an initial WORKAROUND which needs to be replaced by a proper O-P_PERIODIC1 fix
            // XDSLRTFW-3856 - Removed the fix for XDSLRTFW-2190/XDSLRTFW-2270, i.e. commented the code out!
            //                 Now the PLL slow stabilization is always used. This shows an positive effect on upstream performance
            //                 at least against BDCM.
            //                 The variable "gs_NumFramesSlowPLLStabilization_Train1" is initialized to "PLL_STABILIZATION_LEN_300".
            //                 Therefore the disabling in fct. PostGhsConfigVDSL2() must also be removed to get a common code
            //                 for all loop length.
            //                 Reason why it was not done from scratch, is not clear anymore. But there was once a no link problem
            //                 due to a train time issue, which is not available any more due to the bigger RTV and faster SNR/PSD
            //                 measurement.
//            if (gt_Kl0ElectricalLength.s_kl0_estimate > (KL0_1500M_PE04))  // = 391 to be replaced with code-cleanup (XDSLRTFW-2262)
//            {
//               gs_NumFramesSlowPLLStabilization_Train1 = 300;   // set to 300 frames ~ 80ms
//            }
            // XDSLRTFW-3897(Start)
            // Smaller the Fc of PGA and PREFI for mid and long reach (US0 only) loops
            // XDSLRTFW-3197 Start_End
            // XDSLRTFW-3190 Start_End
            // Note: 2348 is equal to 10.125MHz, i.e. no DS3 and only DS2 and DS1!
            //       The code is located here and not before the Hybrid- or PgaHandler, because
            //       the gains would be adapted to the fct.. But with this approach an additional margin will be available.
            //       Goal is to get the system first stable!
            guc_PgaState = TRAINING_DONE;
            if ((gt_Reconf_Hybrid_Coeff.s_control & DO_FC_TUNING_BEFORE_FINAL_PGA_TRAINING) == 0x0000) // Default code : bit 0x2000 is NOT set by default
            {
               if (gus_DebugControlVRX518 & PGA_PREFI_FC_REDUCTION_EN)
               {
                  if (gsa_RxBandRightChannel[gs_NumOfRxBands-1] < LAST_BIN_DS2)
                  {
                     int16 s_ShiftValue;
                     s_ShiftValue = 1;
                     if ((gsa_RxBandRightChannel[gs_NumOfRxBands-1] < LAST_BIN_DS1) &&
                         (!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK)))
                     {
                        s_ShiftValue = 2;
                     }
                     gla_fc_pga_lp_kHz[gus_AFE_RxMode]   = (gla_fc_pga_lp_kHz[gus_AFE_RxMode] >> s_ShiftValue);
                     gla_fc_prefi_lp_kHz[gus_AFE_RxMode] = (gla_fc_prefi_lp_kHz[gus_AFE_RxMode] >> s_ShiftValue);

                     // Set this flag to false so we can program all AGCs (AGC1, AGC2)
                     gft_EnableDoublePGATrain = FALSE;
                     gft_EnaPrefiAceOffOneStagePga = FALSE;//XDSLRTFW-3613 Making false because Don't want to overwrite ACE settings here
   //                  gs_PGA_required = gs_PGA_set;
                     guc_PgaState = TRAINING_IN_PROGRESS;
                     AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_SetPga);
                  }
               }
            }
            // XDSLRTFW-3897(End)
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_O_P_TRAIN_RX_PLL_RELOCK_2;
         }
         break;

      case R_O_P_TRAIN_RX_PLL_RELOCK_2:

         if (guc_PgaState == TRAINING_DONE)
         {
            gs_RxSubStateCnt++;

            // XDSLRTFW-793: RP-Synch not detected / Tone cluster not detected (start_end) -> == 10
            // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start)
            if (gs_RxSubStateCnt == 10)
            // XDSLRTFW-793: RP-Synch not detected / Tone cluster not detected (end)
            {
               // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
               // Set new Pll Reference for all 3 supported pilot tones after PGA
               ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );

               // Set PLL loop filter parameters to Fast converge.
               if (gs_NumFramesFastPLLStabilization_Train1 != -1)
               {
                  // Set PLL loop filter parameters to Fast converge.
                  ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
                  ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
                  ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
               }
               else
               {
                  //Set PLL loop filter parameters to Slow converge.
                  ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
                  ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
                  ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
               }

               // turn on PLL
               gft_EnablePLL  = TRUE;
            }
            else if ((gs_NumFramesSlowPLLStabilization_Train1 != -1) && (gs_RxSubStateCnt == gs_NumFramesFastPLLStabilization_Train1)) // Wait for PLL to stabilize
            {
               // Ignore Slow PLL adaptation in case gs_NumFramesSlowPLLStabilization_Train1 = -1
               // At Non Vectoring cases, gs_NumFramesSlowPLLStabilization_Train1 initializes to -1

               // switch PLL coefficients for Slow adaptation to adapt lower steady-state noise
               ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
               ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
               ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            }
            // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
            else if (gs_RxSubStateCnt > (gs_NumFramesFastPLLStabilization_Train1+gs_NumFramesSlowPLLStabilization_Train1)) // Wait for PLL to stabilize
            {

               // In case of gs_NumFramesSlowPLLStabilization_TrainV1 = -1, FW will skip ResetPLL for Slow adaptation
               // and code will come to this section when "gs_RxSubStateCnt = gs_NumFramesFastPLLStabilization_TrainV1"
               // initialize vars for FDQ train
               gs_AlgHandlerState = FDQ_TRAIN_INIT;
               gs_RxSubState = R_O_P_TRAIN_RX_TRAIN_FDQ;
            }
         }
         // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (End)
         break;

      case R_O_P_TRAIN_RX_TRAIN_FDQ:

         //Train FDQ
         if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
         {
            FdqHandler();
         }
         else
         {
#ifdef SAVE_REVERB_FDQ
            // save Reverb FDQ coefficients
            ReadFdqMant(gsa_ReverbFdqMantissa, 0, gs_RxNumTones);
            ReadFdqExp(guca_ReverbFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_REVERB_FDQ
#if defined(VRX518_BRINGUP_DEBUG)
            // After FDQ Handler in ROPTrain1
            if (gs_PauseControl == 0x202)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif // TTR_PAUSE_DEBUG

            if (gus_VdslCntlFlag & BITMAP_ENABLE_PSD_TRAIN1_VDSL2)
            {
               // measure PSDs again after PGA is retrained.
               gpsa_MeasuredSnrBuf = gsa_CommonMemoryBlock0;   // use gsa_CommonMemoryBlock0 to store PSD
               gs_AlgHandlerState = PSD_INIT;
               gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;

               gs_RxSubState = R_O_P_TRAIN_RX_MEASURE_PSD;
            }
            else
            {
               // measure SNR
               gpsa_MeasuredSnrBuf = gsa_SnrBuf;
               gs_AlgHandlerState = SNR_INIT;
               gs_RxSubState = R_O_P_TRAIN_RX_CALCULATE_SNR;
            }
         }
         break;

      case R_O_P_TRAIN_RX_MEASURE_PSD:

         //Compute the RX PSD
         if (gs_AlgHandlerState != PSD_CALC_DONE)
         {
            PsdHandler();
         }
         else
         {
            // Tracee debug info
            {
               gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgStreamRxEchoPsd);
               gs_RxSubState =R_O_P_TRAIN_RX_STREAM_PSD;
            }
         }
         break;

      case R_O_P_TRAIN_RX_STREAM_PSD:
         if (gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            // Initialize vars for SNR calculation
            gpsa_MeasuredSnrBuf = gsa_SnrBuf;
            gs_AlgHandlerState = SNR_INIT;
            gs_RxSubState = R_O_P_TRAIN_RX_CALCULATE_SNR;
         }
         break;

      case R_O_P_TRAIN_RX_CALCULATE_SNR:
         if (gs_AlgHandlerState != SNR_CALC_DONE)
         {
            SnrHandler();
         }
         else
         {
            DSH_SendStream(DSH_TRTR_SNR,gs_RxNumTones*sizeof(int16),(void*)gpsa_MeasuredSnrBuf);

#if defined(VRX518_BRINGUP_DEBUG)
            //At the end of SNR Handler in ROPTrain1
            if (gs_PauseControl == 0x203)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif // TTR_PAUSE_DEBUG

            //Call the following function to select the tones for message decoding
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxMsgDecodeTones);
            gs_RxSubState = R_O_P_TRAIN_RX_DONE;

            // save pilot tone index and other debug info
            // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
            gs_PilotToneIdx_Train = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx;
            for (i=0; i<gt_PilotConfig.s_NumPilotTones; i++)
            {
               memcpy(&gsa_SnrOfPilotTone_Train[i], &gpsa_MeasuredSnrBuf[gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx-2], sizeof(int16)*5);
            }
         }
         break;


      case R_O_P_TRAIN_RX_DONE:

         if (gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            // save tone selection
            gs_ToneSelect_Msg_Train = gs_SelectBandStart;
            gs_NumCluster_Msg_Train = gs_NumOfToneClustersForMsgDecode;

            // check the result and enter fail state if no band was found
            if (gs_SelectBandStart == -1)
            {
               EnterFailStates(E_CODE_ZERO_TONE_CLUSTERS_R_O_P_TRAIN1);
            }
            else
            {
               //Change the number RX tones (need to do this for Medley PRBS generator)
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRxNumTone);

               // save actual R-P-TRAINING 1 time
               guc_RtAct_RPTrainLength = (uint8)(gl_RxSymbolCount >> 6);

               // go to the next TX state to load TRAIN_2_V2 swap page
               gs_TxNextState = VDSL2_R_P_TRAIN1_TX_BRIDGE;
               gpF_TxStateFunc = (PtrToFunc)RPTrain1TxF_VDSL2_Bridge;

               // go to the next RX state to load TRAIN_2_V2 swap page
               gs_RxNextState = VDSL2_R_O_P_TRAIN1_RX_BRIDGE;
               gpF_RxStateFunc = (PtrToFunc)ROPTrain1RxF_VDSL2_Bridge;
            }
         }
      } //switch
   } // end if of VDSL2_R_O_P_TRAIN1_RX state
   //#ifdef MTK_VECTORING_SUPPORT

   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */

   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_2_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_2_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   case CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_1_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   }
   //#endif
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : CalcRtTrainingStateLengths
*
*  Prototype:  void CalcRtTrainingStateLengths(void)
*
*   This function computes the various RT training state lengths based on
*  those specified by the message O-PRM and R-PRM.
*  All the TX state lengths are in symbols, where symbol length is 2N.
*  All the RX state lengths are in symbols, where symbol lenght is 2N+Lce
*  (Since the RX side does not perform any training in the currently implementation
*  so we do not need to turn off the cyclic extension).
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Return:
*      None
*
*  Global Variables Used:
*      gs_m -- (I) value m in equation Lce = m*N/32
*      gl_TxTeqLength  -- (O) TX TEQ state length
*      gl_TxQuiet3Length -- (O) TX QUIET 3 state length
*      gl_TxEctLength  -- (O) TX ECT state length
*
*      gl_RxEctLength  -- (O) RX ECT state length
*      gl_RxTeqLength -- (O) RX TEQ state length
*      gl_RxPeriodicLength -- (O) RX Periodic state length
*
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
void CalcRtTrainingStateLengths(void)
{
   int16 s_TxNumSymbols, s_RxNumSymbols;
   int16 s_duration_VTU_O_TEQ;
   int16 s_duration_VTU_R_TEQ;
   int16 s_duration_VTU_O_EC;
   int16 s_duration_VTU_R_EC;
   int16 s_duration_Periodic;

   //It can be proved that for every 64 symbols of size (2N+CELength),
   //there are (m+64) symbols of size 2N
   if (gul_dbgMiscControl & DISABLE_TX_PERIODIC_TRANSITION)
   {
      s_TxNumSymbols = 64;
   }
   else
   {
      s_TxNumSymbols = gs_m + 64;
   }

   if (gul_dbgMiscControl & DISABLE_RX_PERIODIC_TRANSITION)
   {
      s_RxNumSymbols = 64;
   }
   else
   {
      s_RxNumSymbols = gs_m + 64;
   }


   //======================================================================
   //Compute the durations of each training phase in unit of 64 symbols with CE
   //======================================================================

   //Duration of VTU-O-TEQ training
   if(guc_RtReq_CoTeqLength > gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_TEQTraining)
   {
      s_duration_VTU_O_TEQ = guc_RtReq_CoTeqLength;
   }
   else
   {
      s_duration_VTU_O_TEQ = gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_TEQTraining;
   }

   //Duration of VTU-R-TEQ training
   if(guc_RtReq_TeqLength > gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUR_TEQTraining)
   {
      s_duration_VTU_R_TEQ = guc_RtReq_TeqLength;
   }
   else
   {
      s_duration_VTU_R_TEQ = gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUR_TEQTraining;
   }

   //Duration of VTU-O-EC training
   s_duration_VTU_O_EC = gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_ECTraining;

   //Duration of VTU-R-EC training
   s_duration_VTU_R_EC = guc_RtReq_EcLength;

   //Duration of Periodic state
   if(guc_RtReq_PeriodicLength > gt_DecMsg_O_Prm_VDSL2.uc_DurationPeriodicSignal)
   {
      s_duration_Periodic = guc_RtReq_PeriodicLength;
   }
   else
   {
      s_duration_Periodic = gt_DecMsg_O_Prm_VDSL2.uc_DurationPeriodicSignal;
   }

   //======================================================================
   //Compute TX/RX state lengths in number of symbols (either with CE or without)
   //======================================================================

   //gl_TxTeqLength      = s_duration_VTU_O_TEQ * s_NumSymbols;
   MULS16(gl_TxTeqLength, s_duration_VTU_O_TEQ, s_TxNumSymbols);

   //gl_RxPilot2Length   = s_duration_VTU_O_TEQ * 64;
   gl_RxPilot2Length   = s_duration_VTU_O_TEQ << 6;

   //gl_TxQuiet3Length   = (s_duration_VTU_O_EC + s_duration_VTU_R_TEQ) * 64;
   gl_TxQuiet3Length   = (s_duration_VTU_O_EC + s_duration_VTU_R_TEQ) << 6;

   //gl_RxEctLength      = s_duration_VTU_O_EC * 64;
   gl_RxEctLength      = s_duration_VTU_O_EC << 6;

   //gl_RxTeqLength      = s_duration_VTU_R_TEQ * s_NumSymbols;
   MULS16(gl_RxTeqLength, s_duration_VTU_R_TEQ, s_RxNumSymbols);

   //gl_TxEctLength      = s_duration_VTU_R_EC * 64;
   gl_TxEctLength      = s_duration_VTU_R_EC << 6;

   //gl_RxPilot3Length   = s_duration_VTU_R_EC * 64;
   gl_RxPilot3Length   = s_duration_VTU_R_EC << 6;

   //gl_TxPeriodicLength = s_duration_Periodic * s_NumSymbols;
   MULS16(gl_TxPeriodicLength, s_duration_Periodic, s_TxNumSymbols);

   //gl_RxPeriodicLength = s_duration_Periodic * s_NumSymbols;
   MULS16(gl_RxPeriodicLength, s_duration_Periodic, s_RxNumSymbols);
}

void BgReconfigTrain(void)
{
   // Compute the various state lengths of the training phase
   CalcRtTrainingStateLengths();


   //Reconfigure the RX band plan
   ReconfigBandPlan();

   // Generate Per Tone PSD wrt MaxNomPsd
   {
      signed int i,j;

      for (j=0; j<gs_NumOfRxBands; j++)
      {
         for (i=gsa_RxBandLeftChannel[j]; i<=gsa_RxBandRightChannel[j]; i++)
         {
            gsa_PsdPerTone[i] = GetTonePsd(i, (PSDDescriptorTable_t*)(void *)&gt_DsREFPSDDescriptorTable, gs_RxNumTones) - gt_PwrConfigParam.s_Dn_MaxNomPSD;//XDSLRTFW-3838
         }
      }
   }

  // Note: The medley set, as communicated by the CO in O-PRM, has a number of DS tones strictly larger than 6000 tones.
  //       Only then the BDCM constrains should be set!
  if (gul_35bLiteConfig & EN_BDCM_DS_TONES_GT_6000)
  {
     // Set BDCM constrains
     gft_EnableRxIlvTrt = FALSE;                                  // Note: Variable gets be checked and used in Medley, i.e. fct. "MedleyTrainRxF(void)"
     gs_RxToneOrderType = NO_TONE_ORDER;                          // Note: Variable gets be checked and used in fct. "ToneOrdering() and FormTRT()"
     gt_ModemConfig.s_DsMinConstSize = RX_MIN_BITS_PER_TONE_2;    // Note: Variable gets be checked and used in fct. "InitBitloading()"
  }

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

void InitROPTraining(void)
{
   //Reinitialize CE, CP, CS and beta length for training phase
   InsertRxCE();

   //Note: moved this reconfiguration to the end of this
   //state (by then all PGA and PSD calculation is done),
   //otherwise we may not process the full bandwidth
   //Reconfigure the RX number tones
   //ConfigRxNumTone();
}

#undef TTR_PAUSE_DEBUG
