/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), Lantiq Deutschland GmbH. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Lantiq Deutschland GmbH DMT Technology. Proprietary and Confidential.
*
*   Lilienthalstrasse 15, 85579 Neubiberg, Germany
*   phone:    +49 (89) 89899 - 0
*
*
*   ROPVECTOR1Handler.c
*
*   This file contains RT's R_O_P_VECTOR1 state machine (G993.5).
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// ROPVECTOR1Handler.c
//
// History
//
// 12/04/2013 Fuss: Still development status. Grep pattern makes no sense!
//            XDSLRTFW-791: OP-Vect1: transition to OP-CD-V1 fails (IVE exception: 0x7D4)
//            XDSLRTFW-792: OP-Vect1_1: transition to OP-training-V1 fails (IVE exception: 0x7D4)
// 19/09/2013 Fuss: Global timeout clean-up for vectoring
//            Grep for XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts
// 28/01/2014 Fuss: Added fix to reach 2800m noise free and added debug code
//            Grep XDSLRTFW-1506: No sync in vectoring mode on loops >1600m (US0 only).
// ************************************************************************************************************


#include <string.h>
#include "common.h"
#include "gdata.h"
#include "fifo.h"

#include "SharedFuncs.h"
#include "vdsl_state.h"
#include "vdsl_xception.h"
#include "IRI_Iof.h"
#include "V_STR_IOf.h"
#include "ROPVECTOR1Handler.h"
#include "DDSnrFdqHandler.h"
#include "ComplexVectorMult.h"
#include "show_iof.h"
#include "vdsl_state.h"
#include "LL_Iof.h"
//#include "qt_memmap.h"
#include "acc40.h"
#include "IRI_sync.h"
#include "cmv.h"


#define DMT_SPUPERFRAME_OPVEC_DBG      257
#define ADDITIONAL_VAR_OPVEC_DBG         6

/*
*-------------------------------------------------------------------------------
*
*    Prototype: void ROPVector1Handler(void)
*
*   This function implements R_O_P_VECTOR1_RX state machine. This function only detects
*   the next vectoring state based on the accumulated power complete DMT symbol. This does not
*   do any Sync Symbol synchronization.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ROPVector1Handler(void)
{
   int16 i;

   switch (gs_VectorHandlerState)
   {
   case R_O_P_VECTOR1_INIT:

      memset(gla_EnergyArr, 0, (RX_DATA_SYMBOLS_PER_SUPERFRAME+1)*sizeof(uint32));//since 4 bytes = 1 dword
      gl_MaxEnergy = 0;
      gl_MaxEnergyPrev = 0;
      gl_NoiseEnergyAverage = 0;
      gl_EnergyExit = 0;
      gus_NoSyncSymbolEnergyCnt = 0;
      gs_OPVector1_SyncSymCnt = 0;

      // Initalize Dbg variables
      gs_IlvDbgBufferWriteIdx = 0;


      // XDSLRTFW-1506 (Start_End)
//         gs_LeftChannel = 0;
//         gs_AlgNumTonesToProcess = 4096; // since band plan is not known, setup to do vector power for all tones
      gs_LeftChannel = gsa_RxBandLeftChannel[0];
      gs_AlgNumTonesToProcess = (gsa_RxBandRightChannel[0] - gsa_RxBandLeftChannel[0])+1;
      if (gs_RxState == VDSL2_R_O_P_VECTOR1_RX)
      {
         if(gft_ExecuteShadowing == FALSE)
         {
            gs_AlgNumTonesToProcess = (gs_AlgNumTonesToProcess >> 1);
         }
      }
      // Account total # of tones in a frame, i.e. for fct. ReadVectorPower().
      {
         int16 s_NumTxTones;

         // determine k of 2^k
         guc_VectorPowerRightShifts = 0;
         s_NumTxTones = 1;
         while ((gs_AlgNumTonesToProcess > s_NumTxTones) && (guc_VectorPowerRightShifts < 15))
         {
            s_NumTxTones = (s_NumTxTones << 1);
            guc_VectorPowerRightShifts++;
         }
      }

      // setup QT for vector power accumulation
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, TriggerVectorPower);
      gs_VectorHandlerState = R_O_P_VECTOR1_READ_POWER;
      break;

   case R_O_P_VECTOR1_READ_POWER:

      gs_RxVecFrmCnt = 0; // initial value
      gl_Pa = 0;

      //Clear the vector accumulation register
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR,0);
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR,0);

      // Read VectorPower
      // O-P_Vector 1 signal carries energy on sync frames, hence detect sync frame based
      // on the highest power in the frame
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadVectorPower);
      gs_VectorHandlerState = R_O_P_VECTOR1_COMPUTE_POWER;
      break;

   case R_O_P_VECTOR1_COMPUTE_POWER:
      {
         // Read vector power
         // XDSLRTFW-2467 (Start)
         // Whenever FW detects at initial O-P Vector1 detection logic in ROPVector1Detector() function
         // that the accumulated O-PVector signal power (within defined band) is below 8 bit value, FW amplifying
         // this signal by 4 bit (16 times) for better detection.
         if (guc_RxPwrIndicator & LOW_OP_VECTOR_POWER)
         {
            gl_Pa = gl_Pa <<4;
         }
         // Special note : there is a special reason to multiply gl_pa by 16!
         // In the detection logic of detecting next state after any O-P Vector states (example O-P Channel Discovery V1 )
         // where CO transmits energy on every symbol, whenever everage energy over 4 symbols
         // is within (1/16)*100 = 6.25% of the maximum energy of one symbol, CPE detects it as
         // end of O-P Vector phase and FW goes to it's next state.
         // In case of very low power on O-P vector phase this mentioned detection logic does not work! That's why FW needs
         // this extra logic to increase the accumulated power by 16 on long loop. On short loop this specal work around is not
         // needed due to high accumulated power.
         // XDSLRTFW-2467 (End)
         gla_EnergyArr[gs_RxVecFrmCnt] = gl_Pa;

         // Find the symbol (frame) with highest energy during one superframe.
         // This should normaly be the sync symbol!
         if (gl_Pa > gl_MaxEnergy)
         {
            gl_MaxEnergy = gl_Pa;
            gsa_Indx_RxSyncFrm[(gs_OPVector1_SyncSymCnt & 1)]  = gs_RxVecFrmCnt;
#ifdef ILV_DBG_BUFFER
            // debug start - code to trace signal loss parameter
            if(gs_IlvDgbBufferContentSelector & ILVDBG_OP_VECT1_DETECT_DBG)
            {
               gpsa_IlvDbgBuffer = &gsa_TrnVectoringBuffer[(DMT_SPUPERFRAME_OPVEC_DBG + ADDITIONAL_VAR_OPVEC_DBG)*2];
               *gpsa_IlvDbgBuffer++ = (int16)(0xCCCC);
               *gpsa_IlvDbgBuffer++ = (int16)(0xCCCC);
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Im ;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[1].s_PilotTone_Re;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[1].s_PilotTone_Im;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Re;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Im;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Re;
               *gpsa_IlvDbgBuffer++ = gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Im;
               *gpsa_IlvDbgBuffer++ = gs_PhaseError;
               *gpsa_IlvDbgBuffer++ = gs_RxVecFrmCnt;
               gs_IlvDbgBufferWriteIdx = (12*sizeof(int16));
            }
#endif // ILV_DBG_BUFFER
         }

         // This if-condition makes sure that CPE does not make any decision based on not captured data.
         // Detection of the end of OP-Vector1 / 1-1 and start of OP-Channel-Discovery-V1 /
         // OP-Training-V1.
         if (gs_OPVector1_SyncSymCnt > 0)
         {
            int32 l_EnergyFourAdjFrm, l_diff;
            int16 s_adjacent_indices[4];

            s_adjacent_indices[0] = gs_RxVecFrmCnt - 4;
            s_adjacent_indices[1] = gs_RxVecFrmCnt - 3;
            s_adjacent_indices[2] = gs_RxVecFrmCnt - 2;
            s_adjacent_indices[3] = gs_RxVecFrmCnt - 1;

            // Now perform modulo operation on these indices
            for (i = 0; i<4; i++)
            {
               if (s_adjacent_indices[i]<0)
               {
                  s_adjacent_indices[i] = (RX_DATA_SYMBOLS_PER_SUPERFRAME+1) +  s_adjacent_indices[i];
               }
            }

            // Take average of the power in adjacent indices
            //**** This accumulation does not consider overflow!! ****//
            l_EnergyFourAdjFrm = (gla_EnergyArr[s_adjacent_indices[0]] + gla_EnergyArr[s_adjacent_indices[1]] +
                                  gla_EnergyArr[s_adjacent_indices[2]] + gla_EnergyArr[s_adjacent_indices[3]]) >> 2;
            gl_EnergyFourAdjFrm = l_EnergyFourAdjFrm;

            // Detection logic for O-P Channel Discovery V1 where CO transmits energy on every symbol
            // (in O-P Vector 1 CO transmits energy only on sync symbol). Whenever everage energy over 4 symbol
            // is within (1/16)*100 = 6.25% of the maximum energy of one symbol, CPE detects it as
            // O-P Channel Discovery V1, i.e. around 0.28 dB variation.
            //
            //     -------   upper bound 17/16
            //     -------   power value 16/16 = 1
            //     -------   lower bound 15/16
            //
            // Todo: 6.25% threshold need to be justified, Please look XDSLRTFW-2467
            {
               unsigned int us_ExitDecision;
               int32 l_TempEnergy;

               us_ExitDecision = 0;
               for (i = 0; i<4; i++)
               {
                  l_TempEnergy = gla_EnergyArr[s_adjacent_indices[i]];
                  if (l_EnergyFourAdjFrm > l_TempEnergy)
                  {
                     l_diff = l_EnergyFourAdjFrm - l_TempEnergy;
                  }
                  else
                  {
                     l_diff = l_TempEnergy - l_EnergyFourAdjFrm;
                  }

                  if (l_diff < (l_EnergyFourAdjFrm>>4))
                  {
                     us_ExitDecision++;
                  }
               }

               // To distinguish true signal from noise a reference signal power must be used!
               // But this reference power is not allowed to be build by storing the max DS sync symbol power,
               // because in case of peak during the DS sync symbol the signals (OP-Channel-Discovery-V1 or
               // OP-Training-V1 cannot be detected. This would lead to E_CODE_RX_STATE_TIMEOUT.
               if((us_ExitDecision == 4) &&
                     ((gl_NoiseEnergyAverage << 1) < l_EnergyFourAdjFrm) &&
                     (l_EnergyFourAdjFrm >= (gl_EnergyExit - (gl_EnergyExit>>4))))
               {
                  // next go to end of OP vector1 state
                  gs_VectorHandlerState = R_O_P_VECTOR1_DONE;

                  if(guc_VecDebugSwitchEnable & VEC_DEBUG_TRACE_OPVEC_TRANSIT)
                  {
                     if (gs_IlvDbgBufferWriteIdx <= (RX_MAX_NUM_TONES - ((DMT_SPUPERFRAME_OPVEC_DBG + ADDITIONAL_VAR_OPVEC_DBG)*2)))
                     {
                        memcpy(&gsa_TrnVectoringBuffer[0], &gla_EnergyArr[0], (DMT_SPUPERFRAME_OPVEC_DBG*sizeof(int32)));
                        gpsa_OPVectorDbgBuffer32 = (int32 *)(void *)&gsa_TrnVectoringBuffer[DMT_SPUPERFRAME_OPVEC_DBG*2];
                        *gpsa_OPVectorDbgBuffer32++ = gl_NoiseEnergyAverage;
                        *gpsa_OPVectorDbgBuffer32++ = gl_MaxEnergy;
                        *gpsa_OPVectorDbgBuffer32++ = gl_EnergyExit;
                        *gpsa_OPVectorDbgBuffer32++ = gl_EnergyFourAdjFrm;
                        *gpsa_OPVectorDbgBuffer32++ = gus_NoSyncSymbolEnergyCnt;
                        *gpsa_OPVectorDbgBuffer32++ = ((gsa_Indx_RxSyncFrm[(gs_OPVector1_SyncSymCnt & 1)] << 16) | gs_RxVecFrmCnt);

                        gs_IlvDbgBufferWriteIdx += (int16)((DMT_SPUPERFRAME_OPVEC_DBG + ADDITIONAL_VAR_OPVEC_DBG) * sizeof(int32));
                     }
                     DSH_SendStream(OP_VECT1_DETECT_DBG, gs_IlvDbgBufferWriteIdx, &gsa_TrnVectoringBuffer[0]);

                     gs_IlvDbgBufferWriteIdx = 0;
                  }
                  break;
               }
            }
         }
      }

      // clear accumulated value and trigger next power read
      gl_Pa = 0;
      // Clear the vector accumulation register
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR,0);
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR,0);

      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadVectorPower);
      // Incrementing frame counter at every symbol
      gs_RxVecFrmCnt++;


      // Tasks to be done once per superframe
      if (gs_RxVecFrmCnt > RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         // Noise calculation, i.e. average over 32 symbols.
         // The noise symbols with a distance of 96 symbols from the sync symbol are used.
         {
            int16 s_SyncSymbolFrm;
            uint16 us_GuardBits;
            int32 l_NoisPwrAcc, l_NoisePowThr;

            us_GuardBits = 5;
            l_NoisPwrAcc = 0;

            // Set start index into array
            s_SyncSymbolFrm = gsa_Indx_RxSyncFrm[(gs_OPVector1_SyncSymCnt & 1)];
            s_SyncSymbolFrm += 96;

            // Calculate the average noise
            for(i = 0; i < 32; i++)
            {
               if (s_SyncSymbolFrm > RX_DATA_SYMBOLS_PER_SUPERFRAME)
               {
                  s_SyncSymbolFrm -= (RX_DATA_SYMBOLS_PER_SUPERFRAME+1);
               }
               l_NoisPwrAcc += ((gla_EnergyArr[s_SyncSymbolFrm++] + (1 << (us_GuardBits - 1))) >> us_GuardBits);
            }

            gl_NoiseEnergyAverage = l_NoisPwrAcc;

            // Set sync symbol detection threshold to be 3 dB above the average background noise power.
            // 2^1 -> 10*log10(2) = 3 dB above background noise.
            l_NoisePowThr = (l_NoisPwrAcc << 1);
            if (l_NoisePowThr < 32)
            {
               l_NoisePowThr = 32;
            }

            if(gl_MaxEnergy < l_NoisePowThr)
            {
               gus_NoSyncSymbolEnergyCnt++;
            }
            else
            {
               // Counter counts down by 2 each time silence is not detected
               if(gus_NoSyncSymbolEnergyCnt >= 2)
               {
                  gus_NoSyncSymbolEnergyCnt -= 2;
               }
               else
               {
                  gus_NoSyncSymbolEnergyCnt = 0;
               }
            }


            // debug start - code to trace signal loss parameter
            if(guc_VecDebugSwitchEnable & VEC_DEBUG_TRACE_OPVEC_TRANSIT)
            {
               if (gs_IlvDbgBufferWriteIdx <= (RX_MAX_NUM_TONES - ((DMT_SPUPERFRAME_OPVEC_DBG * 2)+(ADDITIONAL_VAR_OPVEC_DBG*2))))
               {
                  memcpy(&gsa_TrnVectoringBuffer[0], &gla_EnergyArr[0], (DMT_SPUPERFRAME_OPVEC_DBG*sizeof(int32)));
                  gpsa_OPVectorDbgBuffer32 = (int32 *)(void *)&gsa_TrnVectoringBuffer[DMT_SPUPERFRAME_OPVEC_DBG*2];
                  *gpsa_OPVectorDbgBuffer32++ = gl_NoiseEnergyAverage;
                  *gpsa_OPVectorDbgBuffer32++ = gl_MaxEnergy;
                  *gpsa_OPVectorDbgBuffer32++ = gl_EnergyExit;
                  *gpsa_OPVectorDbgBuffer32++ = gl_EnergyFourAdjFrm;
                  *gpsa_OPVectorDbgBuffer32++ = gus_NoSyncSymbolEnergyCnt;
                  *gpsa_OPVectorDbgBuffer32++ = ((gsa_Indx_RxSyncFrm[(gs_OPVector1_SyncSymCnt & 1)] << 16) | gs_RxVecFrmCnt);

                  gs_IlvDbgBufferWriteIdx += (int16)((DMT_SPUPERFRAME_OPVEC_DBG * sizeof(int32))+ ADDITIONAL_VAR_OPVEC_DBG * sizeof(int32));
               }
               DSH_SendStream(OP_VECT1_DETECT_DBG, gs_IlvDbgBufferWriteIdx, &gsa_TrnVectoringBuffer[0]);

               gs_IlvDbgBufferWriteIdx = 0;
            }
         }

         // Note: Frame alignment and RxFrmCnt adjustment is needed during O-PVector1 and O-PVector1-1 state.
         //       This is needed to do the real and exact frame alignment afterwards. The exact frame alignment
         //       is using the tones 8,9 and 10. For Vectoring tone 9 is used to modulate the index in
         //       the upstream pilot sequence and to indicate the downstream sync symbol time position. These
         //       modulated 28 symbols cannot be used for during the exact frame alignment, i.e.
         //       256 and 0 to 26.
         //       For O-PVector1-1 the alignment is not available anymore due to the peridoc state before, which
         //       is running with a different symbol rate.
         if (gs_OPVector1_SyncSymCnt > 0)
         {
            int16 s_FinalSyncIdx, s_Temp;

            // Select gl_EnergyExit
            {
               int32 l_diff;

               if (gl_MaxEnergyPrev > gl_MaxEnergy)
               {
                  l_diff = gl_MaxEnergyPrev - gl_MaxEnergy;
               }
               else
               {
                  l_diff = gl_MaxEnergy - gl_MaxEnergyPrev;
               }

               if (l_diff < (gl_MaxEnergyPrev>>4))
               {
                  gl_EnergyExit = ((gl_MaxEnergy+gl_MaxEnergyPrev) >> 1);
               }
            }

            if ((gs_RxState == VDSL2_R_O_P_VECTOR1_RX) ||
                  (!(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_VEC_RESYNC_CALC)))
            {
               // Adjustment of the gs_RxFrmCnt because it is needed for the
               // frame alignment that tone9 can be used. This tone gets modulated
               // with the pilot sequence marker 10.3.3.5, G.993.5.
               //
               // Example:
               // - superframe consists out of 26 symbols, i.e. sync symbol at symbol 25
               // - For the function an own symbol count (gs_RxVecFrmCnt) is used, which is
               //   running parallel to the real symbol counter gs_RxFrmCnt. But gs_RxFrmCnt
               //   is not aligned to the superframe and therefore to the sync symbol.
               //   The free running real symbol counter has to be adjust to the sync symbol
               //   as show below.
               //
               //                     18 power peak for sync symbol energy
               //                             |
               // gs_RxVecFrmCnt:   |0| .... |18|19|20|21|22|23|24|25|0|1| .... |25| ....
               //                              |<------------------->|
               //                                   adjust value
               //
               // free. gs_RxFrmCnt:  ... | 5| 6| 7| ...
               // adj. gs_RxFrmCnt:      ... |25| 0| 1| 2| 3| 4| 5| 6| ...
               //
               //
               s_Temp = gsa_Indx_RxSyncFrm[1];
               if(gs_OPVector1_SyncSymCnt & 1)
               {
                  s_Temp = gsa_Indx_RxSyncFrm[0];
               }

               s_FinalSyncIdx = (RX_DATA_SYMBOLS_PER_SUPERFRAME - s_Temp);
               if (s_FinalSyncIdx == 0)
               {
                  gs_RxFrmCnt = RX_DATA_SYMBOLS_PER_SUPERFRAME;
               }
               else
               {
                  gs_RxFrmCnt = (s_FinalSyncIdx-1);
               }
            }
         } // gs_OPVector1_SyncSymCnt > 0
         else
         {
            // Initialization of the exit energy variable, i.e. set to max energy of first superframe.
            gl_EnergyExit = gl_MaxEnergy;
         }

         // Next substate
         gs_VectorHandlerState = R_O_P_VECTOR1_COMPUTE_POWER;
         if ((gs_RxState == VDSL2_R_O_P_VECTOR1_RX) && (!(guc_VecDebugSwitchEnable & VEC_DEBUG_DISABLE_OPVEC_FA)))
         {
            gs_VectorHandlerState = R_O_P_VECTOR1_FRMALGN_INIT;
         }

         // Count the number of superframes
         gs_OPVector1_SyncSymCnt++;
         // Reset/update variables for the next superframe
         gl_MaxEnergyPrev = gl_MaxEnergy;
         gl_MaxEnergy = 0;
         gs_RxVecFrmCnt = 0;
      } // if(gs_RxVecFrmCnt > RX_DATA_SYMBOLS_PER_SUPERFRAME)

      // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
      if (gs_RxState == VDSL2_R_O_P_VECTOR1_1_RX)
      {
         if (gl_RxSymbolCount > (int32)(O_P_VECTOR1_MAX_LENGTH + (O_P_VECTOR1_MIN_LENGTH << 1)))
         {
            EnterFailStates(E_CODE_RX_STATE_TIMEOUT);
         }
      }

      // XDSLRTFW-1506 (Start_End)
      if((gus_NoSyncSymbolEnergyCnt == 4) && gft_ExecuteShadowing &&
            (gs_RxState == VDSL2_R_O_P_VECTOR1_RX))
      {
         gft_ExecuteShadowing = FALSE;
         gs_VectorHandlerState = R_O_P_VECTOR1_INIT;
      }

      // Against Ikanos CPE got below coded exception  due to some random power glitch in long gap (Silent)
      // between Ghs to O-P Vector1 transition Ikanos. This silent behavior of Ikanos is not standard compliant.
      // To avoid this issue agaisnt Ikanos we don't consider this exception for them. This fix is a workaround.
      // When Ikanos make proper standard compliant solution, we will remove this vendorID specific check.
      if((gul_fe_G994VendorID != IKNS_VENDOR_ID)  && (gus_NoSyncSymbolEnergyCnt == 8))
      {
         if(!(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_OPVEC1_LOSS))
         {
            EnterFailStates(E_CODE_RX_OPVECTOR_SIGNAL_LOSS);
         }
      }
      break;


   case R_O_P_VECTOR1_FRMALGN_INIT:
      {
         int16 gs_Indx_RxSyncFrmHelp;
         int32 l_Energy_1, l_Energy_2, l_total, l_shft, l_sc, l_higher, l_lower;
         int16 s_adjacent_indices[4];

         // Note: gs_OPVector1_SyncSymCnt is always greater 1, when the state
         //       gets entered.
         gs_Indx_RxSyncFrmHelp = gsa_Indx_RxSyncFrm[((gs_OPVector1_SyncSymCnt-1) & 1)];

         // do frame alignment based on energy in frame
         // compare energy in frame n-1 and n+1
         s_adjacent_indices[0] = gs_Indx_RxSyncFrmHelp - 1;
         s_adjacent_indices[1] = gs_Indx_RxSyncFrmHelp + 1;

         // perform modulo here
         for (i = 0; i<2; i++)
         {
            if (s_adjacent_indices[i] < 0)
            {
               s_adjacent_indices[i] += (RX_DATA_SYMBOLS_PER_SUPERFRAME+1);
            }
            if (s_adjacent_indices[i] > RX_DATA_SYMBOLS_PER_SUPERFRAME)
            {
               s_adjacent_indices[i] -= (RX_DATA_SYMBOLS_PER_SUPERFRAME+1);
            }
         }

         l_Energy_1 = gla_EnergyArr[s_adjacent_indices[0]];
         l_Energy_2 = gla_EnergyArr[s_adjacent_indices[1]];
         //l_temp is higher of the two values
         l_higher = (l_Energy_1 >= l_Energy_2) ? l_Energy_1:l_Energy_2;
         l_lower = (l_Energy_1 < l_Energy_2) ? l_Energy_1:l_Energy_2;
         // compare thetwo values
         // basedon the comparison between thetwo, adjust the frame size to do alignment

         //Assume RxFFT length = 8192 (Non-35B VDSL) or RxFFT length 16384 (35B), so Total energy should correspond to 8192 (=2^13) or 16384 (=2^14) samples of data
         l_total = l_higher + gla_EnergyArr[gs_Indx_RxSyncFrmHelp] - l_lower;

         // l_shift is Energy per Sample
         if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
             (gs_RxLog2FftLength > DS_LOG2_FFT_LENGTH_8192))
         {
            l_shft= l_total >> DS_LOG2_FFT_LENGTH_16384;
         }
         else
         {
            l_shft= l_total >> DS_LOG2_FFT_LENGTH_8192;
         }

         // determine 2^k = l_shft
         l_sc = 0;

         // we find out the scale of the energy per Time Domain Sample
         // This scaling is used to approximate a division operation
         while (l_shft > 0)
         {
            l_shft = l_shft>>1;
            l_sc++;
         }

         gs_AlignmentOffset = (l_higher - l_lower) >> l_sc;
         if (l_Energy_2 > l_Energy_1)
         {
            gs_AlignmentOffset = - gs_AlignmentOffset;
         }

#ifdef ILV_DBG_BUFFER
         if(gs_IlvDgbBufferContentSelector & ILVDBG_OP_VECT1_ALIGNMENT_DBG)
         {
            DSH_SendEvent(DSH_EVT_OP_VECT1_ALIGNMENT_DBG,sizeof(int16),(void *)gs_AlignmentOffset);
         }
#endif

         gs_VectorHandlerState = R_O_P_VECTOR1_FRMALGN;

         break;
      }

   case R_O_P_VECTOR1_FRMALGN:

      if (gs_AlignmentOffset >  gt_FrameAlignConfig.s_MaxAlignmentOffset)
      {
         gs_AlignmentOffset =  gt_FrameAlignConfig.s_MaxAlignmentOffset;
      }
      else if (gs_AlignmentOffset < -gt_FrameAlignConfig.s_MaxAlignmentOffset)
      {
         gs_AlignmentOffset = -gt_FrameAlignConfig.s_MaxAlignmentOffset;
      }

      // initialize remaining frame alignment to zero
      gs_RxFrameAlignRemain = 0;

      AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
      gs_VectorHandlerState = R_O_P_VECTOR1_FRAMEALIGNMENT_RESET;

      break;

   case R_O_P_VECTOR1_FRAMEALIGNMENT_RESET:
      //For the 6.2 HW, it is not allowed to make a strymon frame less than FFT size
      //so it may take more than one frame to do frame adjustment if gs_AlignmentOffset is greater than
      //CE Length. Note the variable gs_RxFrameAlignRemain stores the remaining adjustment
      //after each call to AdjustAlignment()
      if(gs_RxFrameAlignRemain != 0)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
         break;
      }

      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetRxAlign);
      gs_VectorHandlerState = R_O_P_VECTOR1_READ_POWER;

      break;

   case R_O_P_VECTOR1_DONE:
      // Restore QT MISC and QT_RNG0 Register to their original value
      gft_ExecuteShadowing = TRUE;
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, DeTriggerVectorPower);

      gs_VectorHandlerState = R_O_P_VECTOR_1_X_DETECTED;
      break;

   } //switch
}

/*
*-------------------------------------------------------------------------------
*
*    Prototype: void ROPVector1Detector(void)
*
*    This function detects O-P Vector 1 Signal based on Sync Symbol power over
*   non synsymbol power. During this state CPE RX path does not have any frame
*   boundary alignment and it does not do any frame alignment either.
*
*    Input Arguments:
*
*    Output Arguments:
*
*    Returns:
*
*    Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ROPVector1Detector(void)
{
   int32 l_EnergyFourAdjFrm, l_diff;
   int16 s_adjacent_indices[4];
   int16 i;

   switch (gs_VectorHandlerState)
   {
   case R_O_P_VECTOR1_INIT:

      memset(gla_EnergyArr, 0, (RX_DATA_SYMBOLS_PER_SUPERFRAME+1)*sizeof(uint32));//since 4 bytes = 1 dword
      gl_MaxEnergy = 0;
      gs_OPVector1_SyncSymCnt = 0;
      // XDSLRTFW-1506 (Start_End)
//        gs_LeftChannel = 0;
//        gs_AlgNumTonesToProcess = 4096; // since band plan is not known, setup to do vector power for all tones

      gs_LeftChannel = gsa_RxBandLeftChannel[0];
      gs_AlgNumTonesToProcess = (gsa_RxBandRightChannel[0] - gsa_RxBandLeftChannel[0])+1;

      // Account total # of tones in a frame, i.e. for fct. ReadVectorPower().
      {
         int16 s_NumTxTones;

         // determine k of 2^k
         guc_VectorPowerRightShifts = 0;
         s_NumTxTones = 1;
         while ((gs_AlgNumTonesToProcess > s_NumTxTones) && (guc_VectorPowerRightShifts < 15))
         {
            s_NumTxTones = (s_NumTxTones << 1);
            guc_VectorPowerRightShifts++;
         }
      }

      // setup QT for vector power accumulation
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, TriggerVectorPower);
      gs_VectorHandlerState = R_O_P_VECTOR1_READ_POWER;
      break;

   case R_O_P_VECTOR1_READ_POWER:

      // initial values
      gs_RxVecFrmCnt = -1;       // Note: gs_RxVecFrmCnt++ is done always at the end of the fct.,i.e. after the switch-case!
      gl_Pa = 0;

      //Clear the vector accumulation register
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR,0);
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR,0);

      // Read VectorPower
      // O-P_Vector 1 signal carries energy on sync frames, hence detect sync frame based
      // on the highest power in the frame
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadVectorPower);
      gs_VectorHandlerState = R_O_P_VECTOR1_COMPUTE_POWER;
      break;

   case R_O_P_VECTOR1_COMPUTE_POWER:

      // Read vector power for next 257 consecutive frames
      gla_EnergyArr[gs_RxVecFrmCnt] = gl_Pa;

      //Clear the vector accumulation register
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR,0);
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR,0);

      // decide the sync frame, frame with highest energy
      if (gl_Pa > gl_MaxEnergy)
      {
         gl_MaxEnergy = gl_Pa;
         gsa_Indx_RxSyncFrm[0] = gs_RxVecFrmCnt;
      }

      // clear accumulated value and trigger next power read
      gl_Pa = 0;
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadVectorPower);

      if (gs_RxVecFrmCnt >= RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         gs_OPVector1_SyncSymCnt++;

         s_adjacent_indices[0] = gsa_Indx_RxSyncFrm[0] - 3;
         s_adjacent_indices[1] = gsa_Indx_RxSyncFrm[0] - 2;
         s_adjacent_indices[2] = gsa_Indx_RxSyncFrm[0] + 2;
         s_adjacent_indices[3] = gsa_Indx_RxSyncFrm[0] + 3;

         // Now perform modulo operation on these indices
         for (i = 0; i<4; i++)
         {
            if (s_adjacent_indices[i]<0)
            {
               s_adjacent_indices[i] += (RX_DATA_SYMBOLS_PER_SUPERFRAME+1);
            }
            else if (s_adjacent_indices[i] > RX_DATA_SYMBOLS_PER_SUPERFRAME)
            {
               s_adjacent_indices[i] -= (RX_DATA_SYMBOLS_PER_SUPERFRAME+1);
            }
         }

         //take average of the power in adjacent indices
         //**** This accumulation does not consider overflow!! ****//
         l_EnergyFourAdjFrm = (gla_EnergyArr[s_adjacent_indices[0]] + gla_EnergyArr[s_adjacent_indices[1]]
                               + gla_EnergyArr[s_adjacent_indices[2]] + gla_EnergyArr[s_adjacent_indices[3]]) >>2;

         // detection logic for O-P Channel Discovery V1 where CO transmits energy on every Symbol ( in O-P Vector 1
         // CO transmits enery only on sync symbol). Whenever everage energy over 4 symbol is within 1/16*100 = 6.25% of
         // the maximum energy of one symbol, CPE detects it as O-P Channel Discovery V1
         if (gl_MaxEnergy > l_EnergyFourAdjFrm)
         {
            l_diff = gl_MaxEnergy - l_EnergyFourAdjFrm;
         }
         else
         {
            l_diff = l_EnergyFourAdjFrm -gl_MaxEnergy;
         }

         if (l_diff >  l_EnergyFourAdjFrm>>1)    // this 50% threshold need to be justified
         {
            // next go to end of OP vector1 state
            gs_VectorHandlerState = R_O_P_VECTOR1_DONE;

         }
         else
         {
            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            if (gs_RxState == VDSL2_R_O_P_VECTOR1_1_RX)
            {
//                  if (gl_RxSymbolCount > ((int32)(O_P_VECTOR1_MAX_LENGTH<<1)))
               if (gl_RxSymbolCount > (int32)(O_P_VECTOR1_MAX_LENGTH + (O_P_VECTOR1_MIN_LENGTH << 1)))
               {
                  // write unique value to Exception Code for OP Vector1 timeout
                  EnterFailStates(E_CODE_RX_STATE_TIMEOUT);
               }
            }
         }
      }
      break;

   case R_O_P_VECTOR1_DONE:
      // Restore QT MISC and QT_RNG0 Register to their original value
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, DeTriggerVectorPower);

      //XDSLRTFW-2467 (Start)
      //Whenever FW detects that the accumulated O-PVector signal power (within defined band) is below 8 bit value,
      //then it initiates guc_RxPwrIndicator value to LOW_OP_VECTOR_POWER, with this flag later on OPvector accumulated power will be
      //amplified (multiplied) by 16

      if (gl_MaxEnergy < 256) // gl_MaxEnergy value is less than 8 bit value
      {
         guc_RxPwrIndicator = LOW_OP_VECTOR_POWER;
      }
      //XDSLRTFW-2467 (End)
      gs_VectorHandlerState = R_O_P_VECTOR_1_X_DETECTED;
      break;
   } //end switch

   gs_RxVecFrmCnt++;                                        // increment this counter at every frame
   if (gs_RxVecFrmCnt > RX_DATA_SYMBOLS_PER_SUPERFRAME)
   {
      gs_RxVecFrmCnt = 0;
   }
}

//#endif //#ifdef MTK_VECTORING_SUPPORT
