/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPmdAckRxF_VDSL2.c
*
*   This file contains the RX state function to receive the R-PMD Ack message
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "SharedFuncs.h"
#include "InitShowTimeTx.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPmdAckRxF_VDSL2
 *
 *  Prototype:  void ROPmdAckRxF_VDSL2(void)
 *
 *   This is the state function for receiving R-PMD Ack symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_PMD_ACK_RX_INIT                  (0)
#define R_O_PMD_ACK_RX_WAIT_FOR_CODESWAP      (1)
#define   R_O_PMD_ACK_RX_SEG                  (2)

void ROPmdAckRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_O_PMD;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_RxSubState)
   {

   case R_O_PMD_ACK_RX_INIT:

      // Check if Tx Showtime initialization done. If so
      // swap in the Show 1 page
      if (guc_TxShowInitState == TX_SHOW_INIT_DONE)
      {
         // Request next swap page and go to substate to wait
         FreeSwapHandle(&guc_PrimPageHandle);
         guc_RxSwapActivity = CODESWAP_LOAD(VDSL_SHOW_1_V2_PM_SWAPPAGE);

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_O_PMD_ACK_RX_WAIT_FOR_CODESWAP;
      }

      break;

   case R_O_PMD_ACK_RX_WAIT_FOR_CODESWAP:

      if (PollForCodeSwapDone(VDSL_SHOW_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         // Tx Show init done and Show 1 page loaded in,
         // Now can send R-PMD message
         gft_OKToSendBGFlag = 1;

         // Start processing the Ack messages for the transmitted R-PMD message
         gs_RxSubState = R_O_PMD_ACK_RX_SEG;

         //This state only receives ACK_SEG message, but
         //it is handled in TxRxMsgHandler.c
         guc_NumberOfPossibleRxMsgs = 0;

         //Initialize to the first substate in RxHDLCMsgHandler()
         gs_RxHDLCMsgState = 0;

      }

      break;

   case R_O_PMD_ACK_RX_SEG:

      //Decode the HDLC message
      RxHDLCMsgHandler();

      //If the TX finish sending the last segment, go to the next state
      if(gft_OKToSendBGFlag == 2)
      {
         gs_RxNextState = VDSL2_R_O_P_SYNCHRO6_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPSynchro6RxF_VDSL2;
      }


   } //switch

   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_SHOW_1_V2_PM_SWAPPAGE):

      if ((guc_PrimPageHandle = RequestSwap(VDSL_SHOW_1_V2_PM_SWAPPAGE))!= INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }

      break;

   }

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }
}
