/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROPmdRxF_VDSL2.c
*
*   This file contains the RX state function to receive the O-PMD message
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "SharedFuncs.h"
#include "InitShowTimeTx.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPmdRxF_VDSL2
 *
 *  Prototype:  void ROPmdRxF_VDSL2(void)
 *
 *   This is the state function for receiving O-PMD symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_PMD_RX_INIT               (0)
#define R_O_PMD_RX_DEMODULATE_MSG      (1)
#define   R_O_PMD_RX_WAIT_FOR_CODESWAP   (2)

void ROPmdRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_O_PMD;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_RxSubState)
   {


      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_PMD_RX_INIT:

      //Set the message code (expected message)
      guc_NumberOfPossibleRxMsgs = 2;
      guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_PMD;
      guca_PossibleRxMsgCodes[1] = (uint8)SOC_MSG_REPEAT_REQUEST;

      //Initialize to the first substate in RxHDLCMsgHandler()
      gs_RxHDLCMsgState = 0;

      //Init. a timer
      gul_RxTimer = 0;

      //go to next substate
      gs_RxSubState = R_O_PMD_RX_DEMODULATE_MSG;

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_PMD_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {

#if defined(VRX518_BRINGUP_DEBUG)
            // Pause to dump the O-PMD SOC message.
            if (gs_PauseControl == 0x704)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif // VRX518_BRINGUP_DEBUG

            //If SOC_MSG_REPEAT_REQUEST is received, instruct the TX side to retransmit this message
            if(guc_RxMsgCode == SOC_MSG_REPEAT_REQUEST)
            {
               gs_TxNextState = VDSL2_R_PMS_TX;
               gpF_TxStateFunc = (PtrToFunc)RMedleyMsgTxF_VDSL2;

               if(gs_TxNextState == gs_TxState)
               {
                  gs_TxState = SAME_STATE;
               }

               //set the RX to go to the first substate to receive R-Update again
               gs_RxSubState = R_O_PMD_RX_INIT;
            }
            else //if(guc_RxMsgCode == VDSL2_SOC_MSG_O_PMD)
            {
               gft_OKToSendBGFlag = 0;

               // O-PMD message received. Bring in Anal5 page and then do
               // Tx showtime initialization
               gft_StartTxShowinit = 0;

               // Request next swap page and go to substate to wait
               FreeSwapHandle(&guc_PrimPageHandle);
               guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ANAL_5_V2_PM_SWAPPAGE);

               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_O_PMD_RX_WAIT_FOR_CODESWAP;
            }
         }
         else //If the message received incorrect
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_O_PMD_FAIL);
         }
      }

      //Check if the RX timeout
      MedleyMsgCheckRxTimer();

      break;

      /* =============================================== */
      /* wait for codeswap */
      /* =============================================== */
   case R_O_PMD_RX_WAIT_FOR_CODESWAP:

      if (PollForCodeSwapDone(VDSL_ANAL_5_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         // Kick off the Tx showtime initialization when Anal 5 V2 page
         // is swapped in
         gft_StartTxShowinit = TRUE;

         // Received O-PMD message, and Anal5 page swapped in,
         // Start sending R-PMD now from Anal 5 page
         gs_TxNextState = VDSL2_R_PMD_TX;
         gpF_TxStateFunc = (PtrToFunc)RMedleyMsg2TxF_VDSL2;

         gs_RxNextState = VDSL2_R_O_PMD_ACK_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPmdAckRxF_VDSL2;

         //reset the counts for the next message
         gs_NumRxRepeatRequest = 0;
         gs_NumTxRepeatRequest = 0;

      }
      break;

   } //switch

   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ANAL_5_V2_PM_SWAPPAGE):

      if ((guc_PrimPageHandle = RequestSwap(VDSL_ANAL_5_V2_PM_SWAPPAGE))!= INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }

      break;

   }

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }
}
