/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ORPrmRxF_VDSL2.c
*
*   This file contains function to receive O-PRM, or REPEAT_REQUEST message
*
*-------------------------------------------------------------------------
*/

#include "vdsl_compiler.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "ModulateSocMessages.h"
#include "codeswap.h"
#include "vdsl_xception.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROPrmRxF_VDSL2
 *
 *   This function receives O-PRM, or REPEAT_REQUEST message
 *
 *  Prototype:  void ROPrmRxF_VDSL2(void)
 *
 *
 *  Input Arguments:
 *      NONE
 *
 *  Output Arguments:
 *      NONE
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      gs_RxSubState -- (I/O) substate number
 *      guc_NumberOfPossibleRxMsgs -- (I/O) the number of possible expected messages
 *      guca_PossibleRxMsgCodes[] -- (I/O) the message codes of the expected messages
 *      gs_MsgReceiveFlag -- (O) flag to indicate if the message decoding is ok or not
 *      gs_RxHDLCMsgState -- (I/O) state used in RxHDLCMsgHandler()
 *      guc_RxMsgCode -- (O) the RX message code
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_PRM_RX_MSG_INIT            (0)
#define R_O_PRM_RX_DEMODULATE_MSG      (1)

void ROPrmRxF_VDSL2(void)
{
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_CHANNEL_DISCOVERY2;
   gsa_IndirectStat0[2]=VDSL2_R_O_PRM;
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)

   switch (gs_RxSubState)
   {

      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_PRM_RX_MSG_INIT:

      //Set the message code (expected message) to O-PRM
      guc_NumberOfPossibleRxMsgs = 2;

      if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
      {
         guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_PRM;
      }
      else
      {
         guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_PRM_LD;
      }

      guca_PossibleRxMsgCodes[1] = (uint8)SOC_MSG_REPEAT_REQUEST;

      //Initialize to the first substate in RxHDLCMsgHandler()
      gs_RxHDLCMsgState = 0;

      //Init. timer to an invalid value.  TX function will reset it
      gul_RxTimer = 0xFFFFFFFF;

      //go to next substate
      gs_RxSubState = R_O_PRM_RX_DEMODULATE_MSG;

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_PRM_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {
#if defined(VRX518_BRINGUP_DEBUG)
         // Pause to dump the O-PRM SOC message.
         if (gs_PauseControl == 0x702)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // VRX518_BRINGUP_DEBUG

            //If SOC_MSG_REPEAT_REQUEST is received, instruct the TX side to retransmit this message
            if(guc_RxMsgCode == SOC_MSG_REPEAT_REQUEST)
            {
               //go to the next TX to resend R-UPDATE
               gs_TxNextState = VDSL2_R_UPDATE_TX;
               gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
               gft_TxStateInitFlag = TRUE;

               if(gs_TxNextState == gs_TxState)
               {
                  gs_TxState = SAME_STATE;
               }

               //set the RX to go to the first substate to receive R-Update again
               gs_RxSubState = R_O_PRM_RX_MSG_INIT;

            }
            //If VDSL2_SOC_MSG_O_PRM or VDSL2_SOC_MSG_O_PRM_LD is received,
            else if(guc_RxMsgCode == guca_PossibleRxMsgCodes[0])
            {
               //go to the next TX state to send R-PRM
               gs_TxNextState = VDSL2_R_PRM_TX;
               gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
               gft_TxStateInitFlag = TRUE;

               //go to the next RX state to receive O-ACK
               gs_RxNextState = VDSL2_R_O_ACK_RX;
               gpF_RxStateFunc = (PtrToFunc)ROAckRxF_VDSL2;

               //reset the counts for the next message
               gs_NumRxRepeatRequest = 0;
               gs_NumTxRepeatRequest = 0;
            }
         }
         else //If the message received incorrectly
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_O_PRM_FAIL);
         }

      }

      if((gul_RxTimer != 0xFFFFFFFF) && (gul_RxTimer >= TIMEOUT_CNT_TWO_SECONDS))
      {
         //Check timeout
         if(gs_NumTxRepeatRequest < NUM_TX_REPEAT_REQUEST)
         {
            gs_NumTxRepeatRequest++;

            //go to the next TX state to send REPEAT_REQUEST
            gs_TxNextState = VDSL2_R_REPEAT_REQUEST_TX;
            gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
            gft_TxStateInitFlag = TRUE;

            if(gs_TxNextState == gs_TxState)
            {
               gs_TxState = SAME_STATE;
            }
         }
         else
         {
            //go to fail state
            CheckTimeout(gul_RxTimer, TIMEOUT_CNT_TWO_SECONDS, E_CODE_RX_STATE_TIMEOUT);
         }
      }
      break;
   } //switch

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }
}
