/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROSignatureRxF_VDSL2.c
*
*   This file contains RT's R_O_SIGNATURE_RX state machine (VDSL2).
*
*-------------------------------------------------------------------------
*/
//*****************************************************************************
// ROSignatureRxF_VDSL2.c
//
// History
//
//   XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH
//       1. Select the Number of Tx Bands which would be used based on LATN DS1
//       2. Re-configure TX Path for transmitting the new TX Bands
//       3. If Only US0 used, select 8x Hybrid Coeffs
//       4. Check if Less Number of RX Bands can be used for Hybrid Training, Based on Last Bin Used
//       Controlled with CMV 232 1 Bit 0x0001
//
// 19/09/2013 Abu: Change Slow and fast PLL settings to default VDSL2 values
//            Grep for XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate
// 09/10/2013 Fuss: Fix for OP-SYNCHROV1 can sometimes not be detected.
//            Grep for XDSLRTFW-1293: Bugfix_DS_VDSL2_ALL_SYNCHROV1
// 28/01/2014 Fuss: Added fix to reach 2800m noise free and added debug code
//            Grep XDSLRTFW-1506: No sync in vectoring mode on loops >1600m (US0 only).
// 13/03/2014 Kannan: Restricted bandplan reconfiguration for VINAX_Rev_1.4 &
//            VINAX_Rev_1 CO's, since this option is not supported by these
//            CO's.
//            Grep for "XDSLRTFW-1639"
// 11/08/2014 Fuss: Hybrid setting Clean-up and US0 only handling for vectoring, i.e. switching from 17a/12a to 8a hybrids
//            Grep for XDSLRTFW-1488
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
// 11/03/2015 Krause: Fix for no links on long loops (with noise) due to loss of sync in O-PERIODIC-2
//            Grep for XDSLRTFW-2190/XDSLRTFW-2270: PERF_DS_LONGLOOPS_SYNC_LOSS_IN_O_P_PERIODIC1
//
// 14/09/2017 Hanyu: Merged IOP fixes against EVLT-F/CNXT in A8D profile
//   1. IOP adjustment to reduce estimated KL0 from loop length ~2800ft to ~3800ft to connect to showtime.
//   2. Switched to US0 band if KL0 is greater than 25.8dB (~3700ft) to fix the no sync issue.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft
//
//   3. Added 0.6dB to final KL0 to reduce UPBO and boost US power by ~0.5dB to get comparable US data rate with BRCM CPE.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 14/09/2017 Hanyu: Merged IOP fixes against EVLT-F/CNXT in A8D profile
//   1. Changed US0 PSD level and MASK for CNXT CO if CO or CPE decides to force US0-only on 4kft or longer loops to improve US data rate.
//   2. Used original estimated KL0 value for CPE to determine US0-only.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 28/07/2018 Stefan: Added two new hybrid coefs for 8MHz and 17MHz modes for OTE setup
//            Increase the number of tested hybrid settings from 7 to 9 for BRCM-based DSLAMs
//            Due to missing testing time this fix is enabled only for BRCM
//            The default settings were not matching due to an impedance mismatch of their linesimulator
//            XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
//
//*****************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "PGAHandler.h"
#include "HybridTrainingHandler.h"
#include "PsdHandler.h"
#include "Psd_b.h"
#include "FdqHandler.h"
#include "SnrHandler.h"
#include "SharedFuncs.h"
#include "vdsl_xception.h"
#include "IRI_Iof.h"
#include "ROTrainingRxF.h"
#include "BitSynchHandler_VDSL2.h"
#include "ByteSynchHandler_VDSL2.h"
#include "SelectPilot.h"
#include "ghs.h"
#include "SniffTrain.h"
#include "SelectRxBandLimit.h"
#include "V_STR_IIR_IOf.h"
#include "V_STR_IOf.h"
#include "BgCalcProposedCeiling.h"
#include "vdsl_const.h"

//#ifdef MTK_VECTORING_SUPPORT
#include "ROPSynchroVector1RxF_VDSL2_Handler.h"
#include "DetectDSSync_Vector_Handler.h"
//#endif //#ifdef MTK_VECTORING_SUPPORT
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#ifdef VRX518_BRINGUP_DEBUG
#include "profile.h"
#endif
extern void CheckEchoLevel(int16 *psa_PsdBuf);
extern void CheckQuieteLineNoiseLevel_UpstreamBand(void);

//#define O_SINATURE_PAUSE_DEBUG

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgIdentifyTonesForKL0_VDSL2(void)
*
*   This function identifies tones with sufficient SNR for kl0 estimation.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void BgIdentifyTonesForKL0_VDSL2(void)
{
   unsigned int i;

   // XDSLRTFW-3751
   // Note: Memory copy is not done in ReconfigBandPlan(void) to save MIPS. Reason is that
   //       ReconfigBandPlan() is called multiple time and this must not be set all the time!
   memcpy(guca_RxSupportedToneSet_temp, guca_RxSupportedToneSet, sizeof(RxToneFlags));

   // Use only RX tones with sufficient SNR, during the kl0 estimation.
   for (i=gsa_RxBandLeftChannel[0]; i<=gsa_RxBandRightChannel[gs_NumOfRxBands-1]; i++)
   {
      if (gpsa_MeasuredSnrBuf[i] < gs_SnrThreshForSATN)
      {
         CLEARTONEFLAG(guca_RxSupportedToneSet_temp, i);
      }
   }

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ROSignatureRxF_VDSL2(void)
*
*   This function implements R_O_SIGNATURE_RX state machine.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#define R_O_SIGNATURE_RX_IDLE                                   (-1)
#define R_O_SIGNATURE_RX_MSG_INIT                               (0)
#define R_O_SIGNATURE_RX_BIT_SYNCH                              (1)   //for diag mode
#define R_O_SIGNATURE_RX_BYTE_SYNCH                             (2)   //for diag mode
#define R_O_SIGNATURE_RX_DEMODULATE_MSG                         (3)
#define R_O_SIGNATURE_RX_WAIT_FOR_RECONFIG_BANDPLAN_FDQ_FOR_KL0 (4)
#define R_O_SIGNATURE_RX_GET_SNR_FOR_KL0                        (5)
#define R_O_SIGNATURE_RX_SUPPORTED_SET_FOR_KL0                  (6)
#define R_O_SIGNATURE_RX_CALC_PSD_FOR_KL0                       (7)
#define R_O_SIGNATURE_RX_BGPSDANALYSIS                          (8)
#define R_O_SIGNATURE_RX_RECONFIG_FOR_US0                       (9)
#define R_O_SIGNATURE_RX_CONFIG_TX_IIR                          (10)
#define R_O_SIGNATURE_RX_WAIT_FOR_BGPSDANALYSIS                 (11)
#define R_O_SIGNATURE_RX_TRAIN_FDQ_FOR_SYNCHRO_V1               (12)  //DSM_Vectoring
#define R_O_SIGNATURE_RX_SELECT_TONE_FOR_SYNCHRO_V1_DETECTION   (13)  //DSM_Vectoring
#define R_O_SIGNATURE_RX_CODESWAP_ALGHD_2                       (14)  //DSM_Vectoring
#define R_O_SIGNATURE_RX_DEMODULATE_DS_SYNCSYMB_INIT1           (15)  //DSM_Vectoring
#define R_O_SIGNATURE_RX_O_P_SYNCHRO_V1                         (16)  //DSM_Vectoring
#define R_O_SIGNATURE_RX_SET_PGA_AND_TRIG_TX_RMSG1              (17)
#define R_O_SIGNATURE_RX_WAIT_FOR_TX                            (18)
#define R_O_SIGNATURE_RX_TRAIN_PGA                              (19)
#define R_O_SIGNATURE_RX_PLL_RELOCK                             (20)
#define R_O_SIGNATURE_RX_TRAIN_FDQ                              (21)
#define R_O_SIGNATURE_RX_PSD                                    (22)
#define R_O_SIGNATURE_RX_PROP_CEILING                           (23)
#define R_O_SIGNATURE_RX_INIT_CALCULATE_SNR                     (24)
#define R_O_SIGNATURE_RX_CALCULATE_SNR                          (25)
#define R_O_SIGNATURE_RX_SELECT_MSG_TONE                        (26)
#define R_O_SIGNATURE_RX_SELECT_MSG_TONE_DONE                   (27)  //DSM_Vectoring  -- Not USED
#define R_O_SIGNATURE_RX_VECTOR_DEMODULATE_DS_SYNCSYMB_INIT2    (28)  //DSM_Vectoring  -- Not USED
#define R_O_SIGNATURE_RX_WAIT_FOR_CODESWAP_ALGHD_1              (29)  //DSM_Vectoring  -- Not USED
#define R_O_SIGNATURE_RX_SELECT_PILOT                           (30)
#define R_O_SIGNATURE_RX_WAIT_SELECT_PILOT                      (31)
#define R_O_SIGNATURE_RX_BAND_FOR_HYBRID_SELECT                 (32)

#define R_O_SIGNATURE_RX_DONE                                   (33)

#define QLN_VALUE_MINUS_100DBM_HZ    154   // -100dBm/Hz is 154 {-23-(154/2) = -100}
#define QLN_VALUE_MINUS_90DBM_HZ     134   //  -90dBm/Hz is 134 {-23-(134/2) =  -90}
#define QLN_VALUE_MINUS_88DBM_HZ     130   //  -90dBm/Hz is 134 {-23-(130/2) =  -88}


void ROSignatureRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[2]=VDSL2_R_O_SIGNATURE;
   if (gft_DSVectoringEnabled == TRUE )
   {
      gsa_IndirectStat0[3]=VDSL2_R_O_P_CHANNEL_DISCOVERY_V1;
   }
   else
   {
      gsa_IndirectStat0[3]=VDSL2_R_O_P_CHANNEL_DISCOVERY1;
   }
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   signed int i;

   switch (gs_RxSubState)
   {
      //------------------------------------------------------------------
      // Initialization
      //------------------------------------------------------------------
   case R_O_SIGNATURE_RX_MSG_INIT:

      //Set the message code (expected message) to O-SIGNATURE
      guc_NumberOfPossibleRxMsgs = 1;
      guca_PossibleRxMsgCodes[0] = (uint8)SOC_MSG_O_SIGNATURE;

      gs_RxHDLCMsgState = 0;
      gs_MsgReceiveFlag = FALSE;
      gs_TxRxMessaging = PGA_RETRAIN_IDLE;

      //go to next substate
      if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
      {
         //Go to the substate to search for bit boundary
         gs_AlgHandlerState = BIT_SYNCH_START;
         gs_RxSubState = R_O_SIGNATURE_RX_BIT_SYNCH;
      }
      else
      {
         // log start of O-Signature message decode ready
         gpt_DebugTiming->l_RxROSignature_MsgReady = gl_TotalTxSymbolCount;
         gs_RxSubState = R_O_SIGNATURE_RX_DEMODULATE_MSG;
      }

      break;

      //------------------------------------------------------------------
      // Loop Diagnostic Mode: Bit level synchronization.
      //------------------------------------------------------------------
   case R_O_SIGNATURE_RX_BIT_SYNCH:

      //Achieve the bit-level synchronization
      if(gs_AlgHandlerState != BIT_SYNCH_DONE)
      {
         BitSynchHandler();
      }
      else
      {
         //Go to the substate to search for byte boundary
         gs_AlgHandlerState = BYTE_SYNCH_INIT;
         gs_RxSubState = R_O_SIGNATURE_RX_BYTE_SYNCH;
      }

      break;


   case R_O_SIGNATURE_RX_BYTE_SYNCH:

      //This substate is only used for the diagnostic mode
      //It search for byte boundary (note each byte is sent in 40 symbols)
      if(gs_AlgHandlerState != BYTE_SYNCH_DONE)
      {
         ByteSynchHandler();
      }
      else
      {
         // log start of R-MSG1 message decode ready
         gpt_DebugTiming->l_RxROSignature_MsgReady = gl_TotalTxSymbolCount;
         gs_RxSubState = R_O_SIGNATURE_RX_DEMODULATE_MSG;
      }

      break;

      //--------------------------------------
      // Demodulate O-SIGNATURE.
      //--------------------------------------
   case R_O_SIGNATURE_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {
            // log end of O-SIGNATURE message decode
            gpt_DebugTiming->l_RxROSignature_MsgEnd = gl_TotalTxSymbolCount;

            // O_SIGNATURE correctly decoded, it's now safe to change
            // the bandplan according to O-Signature message.
            // In VDSL2 mode, swap in page to configure bandplan and
            // analyze PSD.
            //Do not run DemodSocMsgForDiagMode() in RxStateFunc()
            //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
            gft_RxSocMsgDemodFlag = DISABLE_LD_DEMOD_SOC_MSG;

#if defined(O_SINATURE_PAUSE_DEBUG)
         //At the end of SNR Handler in MedleyTraining
         if (gs_PauseControl == 0x101)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // O_SINATURE_PAUSE_DEBUG

            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReconfigBandPlan);

            gs_AlgHandlerState = FDQ_TRAIN_INIT;
            gs_RxSubState = R_O_SIGNATURE_RX_WAIT_FOR_RECONFIG_BANDPLAN_FDQ_FOR_KL0;
         }
         else
         {
            //message received is wrong, restart decoding
            gs_RxHDLCMsgState = 0;
         }
      }
      break;


   case R_O_SIGNATURE_RX_WAIT_FOR_RECONFIG_BANDPLAN_FDQ_FOR_KL0:

      //--------------------------------------
      // Caclulate FDQ for KL0
      //--------------------------------------
      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
         {
            FdqHandler();
         }
         else
         {
#ifdef SAVE_REVERB_FDQ
            // save Reverb FDQ coefficients
            ReadFdqMant(gsa_ReverbFdqMantissa, 0, gs_RxNumTones);
            ReadFdqExp(guca_ReverbFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_REVERB_FDQ

            gpsa_MeasuredSnrBuf = gsa_SnrBuf;
            gs_AlgHandlerState = SNR_INIT;
            gs_RxSubState = R_O_SIGNATURE_RX_GET_SNR_FOR_KL0;
         }
      } //if(gs_RxBkgdProcessFlag == TRAINING_DONE)

      break;


      //------------------------------------------------------------------
      // Caclulate SNR.  Select tones for KL0 estimation.
      //------------------------------------------------------------------
   case R_O_SIGNATURE_RX_GET_SNR_FOR_KL0:

      if (gs_AlgHandlerState != SNR_CALC_DONE)
      {
         SnrHandler();
      }
      else
      {
#ifdef O_SINATURE_PAUSE_DEBUG
         //At the end of SNR Handler in MedleyTraining
         if (gs_PauseControl == 0x102)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // O_SINATURE_PAUSE_DEBUG

         // XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (Start_End)
         // Only needed for for SNR-based hyb algo!
         // Note: Already other algo's expects that variable "gs_HighestAllowedRxTone" is set, e.g.  XDSLRTFW-3064 - "gus_DebugControlVRX518 & US_NOISE_DETECTION_EN".
         //       Therefore the if-case should be commented out to not run into problems later!
         // Note: This first estimate is done with the QLN/HLOG hybrid (-12.39dB) and without ECHO. Therefore this estimate is
         //         - for short loops to high (missing ECHO) and
         //         - for mid/long loops to low (to high hybrid attenuation).
         if((guc_HybridAlgoCtrl == HYB_ALGO_SNR_BASED) ||
            (gs_PgaTrainingDbg & TEST_HP2_CONFIG_USE_SNR_HYB_FOR_US0))
         {
            // Identify the Band Limits for Hybrid Training
            // This would reduce the Cycles a lot for Hybrid training
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxBandLimit);
         }

         gs_RxSubState = R_O_SIGNATURE_RX_BAND_FOR_HYBRID_SELECT;
      }
      break;


      //-------------------------------------------
      // Wait for Selection Band for Hybrid Selection
      //-------------------------------------------
//   XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (Start)
   case R_O_SIGNATURE_RX_BAND_FOR_HYBRID_SELECT:

      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // Identify tones to use for kl0 estimation, based on SNR.
         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgIdentifyTonesForKL0_VDSL2);
         gs_RxSubState = R_O_SIGNATURE_RX_SUPPORTED_SET_FOR_KL0;
      }
      break;
//   XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (End)


      //-------------------------------------------
      // Wait for KL0 tone selection to complete
      //-------------------------------------------
   case R_O_SIGNATURE_RX_SUPPORTED_SET_FOR_KL0:

      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // Initialize vars for PSD calculation
         gs_AlgHandlerState = PSD_INIT;
         gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
         gpsa_MeasuredSnrBuf = gsa_SnrBuf; // use gsa_SnrBuf to store PSD

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_O_SIGNATURE_RX_CALC_PSD_FOR_KL0;
      }
      break;


      //----------------------------------------------------
      // Measure PSD.
      // Analyze PSD to calculate LATN, SATN, HLOG, KL0.
      //----------------------------------------------------
   case R_O_SIGNATURE_RX_CALC_PSD_FOR_KL0:

      if (gs_AlgHandlerState != PSD_CALC_DONE)
      {
         PsdHandler();
      }
      else
      {
         if(TESTArray[TEST_StoreSramControl] & TEST_SAVE_DISC_EchoOff_PSD_ENABLE)
         {
            if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) != SWAP_DONE)
            {
               break;
            }

            gta_BAR15LookUpTable[OFF_CHIP_DISC_PSD_ECHOOFF][OFF_CHIP_SOURCE_INDEX] = (int32)gpsa_MeasuredSnrBuf;   // update source address
            gta_BAR15LookUpTable[OFF_CHIP_DISC_PSD_ECHOOFF][OFF_CHIP_DEST_INDEX] = (int32)&gsa_DiscPsdBuf_EchoOff[gs_RxNumTones*guc_ch_id];    // destination;
            gta_BAR15LookUpTable[OFF_CHIP_DISC_PSD_ECHOOFF][OFF_CHIP_LENGTH_INDEX] = ((gs_RxNumTones + 1)/2)*4;    // size in bytes; make sure length is multiple of 4-bytes

            // Free handle for PSD offchip request
            FreeSwapHandle(&guc_OffChipRequestHandle);
            guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DISC_PSD_ECHOOFF);
         }

         gs_RxSubState = R_O_SIGNATURE_RX_BGPSDANALYSIS;
      }
      break;


   case R_O_SIGNATURE_RX_BGPSDANALYSIS:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         // perform PSD analysis in background
         guc_PsdCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgPsdAnalysis);

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_O_SIGNATURE_RX_WAIT_FOR_BGPSDANALYSIS;
      }
      break;

      //-------------------------------------------
      // Wait for PSD analysis to complete
      //-------------------------------------------
   case R_O_SIGNATURE_RX_WAIT_FOR_BGPSDANALYSIS:

      if (guc_PsdCalcState == TRAINING_DONE)
      {
         DSH_SendStream(DSH_HLOG,sizeof(int16)*512,(void*)gsa_RxHlog);

         // Fix for failure in kl0 estimation - START
         // Note: gft_UPBO_is_enabled is initialized to FALSE at link start and is set to TRUE by UnpackOSignatureMsg_VDSL2 if UPBO is enabled
         if (gft_UPBO_is_enabled && (gt_Kl0ElectricalLength.s_kl0_estimate >= gs_kl0_estimate_threshold))
         {
            if (gft_disable_autorestart_on_kl0_thresh_fail)
            {
               gs_MONI_AutoRestart = 0;
            }
            gs_E_CODE_KL0_THRESHOLD_FAIL_count++;
            EnterFailStates(E_CODE_KL0_THRESHOLD_FAIL);
            break;
         }

         //Initialize variables
         gs_RxBkgdProcessFlag = TRAINING_DONE;
         // XDSLRTFW-477 Enhance_ALL_ALL_TX_BAND_SWITCH (Start_End)
         gs_PrevFirstToneLastBand = 4096;

         // XDSLRTFW-3761 (Start_End)
         if (!(gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING))
         {
            int16 s_latn_pb;

            s_latn_pb = ((int16)gla_latn_pb[0]);
            // XDSLRTFW-3707
            // Low US DR with AELEM mode 3 / ELE_DS1 is low compared to DS2 and DS3 (start)
            // We have reduced the RxPathGain by 1.16 dB which directly impacts Rx QLN, Rx HLOG LATN and SATN.
            // This reduces the Rx QLN and HLOG by 1.16 dB and increases SATN and LATN value by 1.16 dB.
            // Since DS band 1 LATN value is used for loop length estimation, +1.16dB correction is needed wherever
            // LATN is used to maintain the consistency of the FW behavior.
            s_latn_pb = (s_latn_pb - gs_QlnHlogCorrection);
            if (s_latn_pb < 0)
            {
               s_latn_pb = 0;
            }
            gus_SwitchingCriterionVal = (uint16)s_latn_pb;

         }

         //XDSLRTFW-1429
         //Enable Common DS Performance Improvement for Vectoring and Non Vectoring
         //State M/C and also handling non-US0 cases
         //We presently do with LATN thresholds as earlier and we search for the
         //band switch criteria
         {
            uint16 s_NumBands;
            uint16 us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;

            //XDSLRTFW-1639 (start_end)
            //Bandplan reconfiguration is restricted for Vinax Rev1.4 (Platform ID 10)
            //and Vinax Rev 1.0 (Platform ID 9), since this option is not supported by these CO's.
            s_NumBands = gs_NumOfTxBands;
            // XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft (START_END)
            if( ((s_NumBands > 1) && (gft_EVLT_IOPtuning == 0) &&
                 (!((gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform < VINAX_REV_2_M_PLATFORM)))) ||
                 (gt_DbgAllowedToneInfo.s_HighestAllowedTxTone > 0) )
            {
               // XDSLRTFW-3741 Start_End
               {
                  int16 s_HighestAllowedTxTone;
                  uint16 us_SwitchingCriterionVal;

                  us_SwitchingCriterionVal = gus_SwitchingCriterionVal;
                  s_HighestAllowedTxTone = 4096;

                  // XDSLRTFW-3750(Start_End)
                  // Low US rate on DM200 on NBN field line.
                  // The rate is low because the link reaches showtime in US-only mode.
                  // CPE switches to US0 only mode, because its LATN calculation and HLOG measurement shows a wrong
                  // to high value, which is equal to a long loop, where normally on US1/2 no bits can be loaded anymore.
                  // HLOG seems to have a constant offset of ~20dB. The reason for the offset in HLOG is not understood.
                  // It may be a loose connector plug.
                  // Solution:
                  //   Use gs_HighestAllowedRxTone index information, which is known already before TX switching logic kicks in.
                  //
                  // - LAST_BIN_DS1 equal to  3.75 MHZ, i.e (3.75*1000/4.3125) = 869.5652
                  // - LAST_BIN_DS2 equal to 10.125MHz, i.e.(num2str(10.125*1000/4.3125) = 2347.8261
                  if(      (us_SwitchingCriterionVal > (gusa_SwitchingThreshTxBands[SWITCH_TO_1BAND_IDX0])) &&
                           (gs_HighestAllowedRxTone <= LAST_BIN_DS1))
                  {
                     s_HighestAllowedTxTone =  800; // FIRST_BIN_US1 = 696; i.e. 3.0MHz
                  }
                  else if( (us_SwitchingCriterionVal > (gusa_SwitchingThreshTxBands[SWITCH_TO_2BAND_IDX1])) &&
                           (gs_HighestAllowedRxTone <= LAST_BIN_DS2))
                  {
                     s_HighestAllowedTxTone = 1900; // FIRST_BIN_US2 = 1635; i.e. 7.05MHz
                  }

                  // Debug code to check the FW switching, i.e. disable or change and to force the highest Tx tone.
                  if (gt_DbgAllowedToneInfo.s_HighestAllowedTxTone > 0)
                  {
                     s_HighestAllowedTxTone = gt_DbgAllowedToneInfo.s_HighestAllowedTxTone;
                  }
                  gs_HighestAllowedTxTone = s_HighestAllowedTxTone;
                  LimitBandPlanToHighestTone(&gsa_TxBandLeftChannel[0], &gsa_TxBandRightChannel[0], &gs_NumOfTxBands, s_HighestAllowedTxTone);

                  // Note: The 'OR' if-case part is needed to get the correct value for "gs_TxNumTonesUsed".
                  //       E.g. Lower highest Tone of US2-band will not change the "gs_NumOfTxBands" and "gs_PrevFirstToneLastBand",
                  //            but "gs_TxNumTonesUsed". Therefore the code must always be executed for the debug case.
                  if ((gs_NumOfTxBands != s_NumBands) || (gt_DbgAllowedToneInfo.s_HighestAllowedTxTone > 0))
                  {
                     // Note: The if-case is needed for "(gt_DbgAllowedToneInfo.s_HighestAllowedTxTone > 0)". Therefore
                     //       it can be removed, when the debug functionality gets removed.
                     if (gs_NumOfTxBands != s_NumBands)
                     {
                        gs_ChangeTxBand = gs_NumOfTxBands;
                        // Take the first tone of deactivated band!
                        gs_PrevFirstToneLastBand = gsa_TxBandLeftChannelOSignature[gs_NumOfTxBands];
                     }

                     // Re-Configuring BandPlan
                     gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
                     AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReconfigBandPlan);
                  }
               }
            }

            //XDSLRTFW-1429
            //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft (START)
            else if( (gs_NumOfTxBands > 1) && (gft_EVLT_IOPtuning) &&
                     (gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_8D_MASK | CNFG_V2_PROFILE_8A_MASK)) )
            {
               // Force to US0-only band at loops greater than ~3700ft (or KL0 > 25.8dB) to coneect to showtime
               if( (gt_Kl0ElectricalLength.s_kl0_estimate > 258) &&
                   (gsa_TxBandRightChannel[0] <= US0_POTS_MAX_TONE) ) //US0_POTS_MAX_TONE = 32; Check for Double Upstream
               {
                gs_NumOfTxBands = 1;
                gs_PrevFirstToneLastBand =  gsa_TxBandLeftChannel[gs_NumOfTxBands];
               }
            }
            //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft (END)
         }

         //XDSLRTFW-3300 (Start)
         //Common for vectoring and non vectoring to limit max bits based on LATN
         //LATN with QM 35B Loop Reach
         //0m   ==> 0.1
         //50m  ==> 1.1
         //100m ==> 2.6
         //150m ==> 4.0
         //200m ==> 5.5 to 5.8
         //Note: Restrict to 14Bits for the Loops < 150m
         {
            uint16 us_SwitchingThresh;

            us_SwitchingThresh = LATN_FOR_LIMIT_DS_MAX_BITS_HRT_5_0;
            if(gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING)
            {
               us_SwitchingThresh = KL0_150M_PE04;
            }

            if ((gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE) &&
               (TESTArray[TEST_Control4] & TEST_Control4_HRT_5_0_CapMaxDsBits14_35b_Bit9_Mask) &&
               (gus_SwitchingCriterionVal < us_SwitchingThresh))
            {
               gt_ModemConfig.s_DsMaxConstSize = DS_MAX_BITS_FOR_HRT_5_0;
            }
         }
         //XDSLRTFW-3300 (End)

         gs_RxSubState = R_O_SIGNATURE_RX_RECONFIG_FOR_US0;
      }
      break;

      //-------------------------------------------
      // Reconfiguration for Tx band switch (e.g. US0 only), i.e.
      // - Tx PSD difference
      // - Tx LineDriver mode etc. (InitAnalogRegs_Tx)
      // - Rx Hybrid tables
      //-------------------------------------------
   case R_O_SIGNATURE_RX_RECONFIG_FOR_US0:

      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // Note: gus_UseUS0OnlyCntrl is used for profiles with and without US0 band.
         //       Therefore a differentiation for the value "gus_UseUS0OnlyCntrl = 1" is needed.
         //       It could mean US1 or US0 band and for US1 the US0 TxIIR coeffi, PSDCeiling etc is
         //       not allowed to be used.
         //       -> gus_UseUS0OnlyCntrl |= TX_US0_ONLY_INDICATION is the indication for US0 only band


         // XDSLRTFW-1325 : Boost US1 and US2 PSD by 0.5dB
         // XDSLRTFW-1200 : BUG_DS_ALL_ALL_QUAD_SUPPORT
         // XDSLRTFW-2819 : ChooseUsCeiling() is checking "(gs_NumOfTxBands > 1)". Therefore setting variables "gs_DeltaUsPsdCeilValue_ChDis"
         //                 and "gs_DeltaUsPsdCeilValue_TrTrain" for US0 only case has no effect at all!
         if((((gs_NumOfTxBands == 1) && (gsa_TxBandRightChannel[0] <= (US0_ISDNDOUBLE_POTSQUAD_MAX_TONE +1))) ||
               (gus_UseUS0OnlyCntrl & TX_US0_ONLY_INDICATION_GHS)) && (!(TESTArray[TEST_JIRA2257_CONFIG] & TEST_JIRA2257_SKIP_TX_BAND_SWITCH)))
         {
            // Note: The part "TX_NUM_BAND_MASK" of gus_UseUS0OnlyCntrl must be set here again. Reason is that gs_ChangeTxBand
            //       gets only be set when the number of bands is greater than 1. Avinax is doing a double
            //       train and is directly coming with US0 in the O-Signature. Therefore it must be set explicitly,
            //       so that a improvements get be triggered, like PsdCeiling, POTS_17M_Filter_LP, etc..
            gus_UseUS0OnlyCntrl |= 0x0001;               // When we are here then gs_NumOfTxBands = 1

            // Note: Two modes are available:
            //       1)  US0 only by GHS with PofiPoco = ADSL
            //                 => gus_UseUS0OnlyCntrl = (TX_US0_ONLY_INDICATION_GHS|
            //                                      TX_US0_ONLY_CONF_PSD_CEIL | TX_US0_ONLY_CONF_IIR|
            //                                      TX_US0_ONLY_CONF_POFIPOCO_LD | TX_US0_ONLY_CONF_RX_HYB);
            //       2)  US0 only FW LATN with PofiPoco = ADSL
            //                 => gus_UseUS0OnlyCntrl = (TX_US0_ONLY_INDICATION|
            //                                      TX_US0_ONLY_CONF_PSD_CEIL|TX_US0_ONLY_CONF_IIR|
            //                                      TX_US0_ONLY_CONF_RX_HYB);
            if (!(gus_UseUS0OnlyCntrl & TX_US0_ONLY_INDICATION_GHS))
            {
               gus_UseUS0OnlyCntrl |= (TX_US0_ONLY_INDICATION);
            }
            // XDSLRTFW-3627
            // Common code, because the concept was changed for VRx518, i.e. no configuration after handshake anymore
            // that is taking care about these info's.
            gus_UseUS0OnlyCntrl |= (TX_US0_ONLY_CONF_PSD_CEIL | TX_US0_ONLY_CONF_IIR |
                                    TX_US0_ONLY_CONF_POFIPOCO_LD | TX_US0_ONLY_CONF_RX_HYB);


            // XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (Start)
            // XDSLRTFW-1488 (Start)
            // Make sure this part is done only for USO!

            // In all Profile Modes with Long loops having US0 only
            // the 8X Hybrid Coeff and AFE TX Config gets selected!
            //-----------------------------------------------------
            // AFE TX Config

            //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (START)
            if ( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK) &&
                     (gft_EVLT_IOPtuning) )// Only for CNXT CO in A8
            {
               // Fine-tune US0 PSD level and shape to improve US data rate
               gt_PwrConfigParam.s_Up_MaxNomPSD = 450; //380;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[1].us_IndexOfTone = 2;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[1].s_PSDLevelOfTone = 0;
               gt_RefUsPSDDescriptorTable.ut_PSDRecord[1].s_PSDLevelOfTone = 0;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[2].us_IndexOfTone = 6;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[2].s_PSDLevelOfTone = 0;
               gt_RefUsPSDDescriptorTable.ut_PSDRecord[2].s_PSDLevelOfTone = 0;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[3].us_IndexOfTone = 35;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[3].s_PSDLevelOfTone = 0;
               gt_RefUsPSDDescriptorTable.ut_PSDRecord[3].s_PSDLevelOfTone = 0;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[4].us_IndexOfTone = 36;
               gt_MaxUsPSDDescriptorTable.ut_PSDRecord[4].s_PSDLevelOfTone = 0;
               gt_RefUsPSDDescriptorTable.ut_PSDRecord[4].s_PSDLevelOfTone = 0;
            }
            //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (END)

            // Note: US0 indicated in Handshake, i.e. Rx Hyb setting is already done!
            //       The configuration must not be done again.
            if(gus_UseUS0OnlyCntrl & TX_US0_ONLY_CONF_RX_HYB)            // XDSLRTFW-3627
            {
               // US0 Hybrid Coeff RX
               // Frequency range:
               // -  0 /  25kHz upto 276kHz or 552kHz -> POTS hybrid coefficients
               // -      120kHz upto 276kHz           -> ISDN hybrid coefficients

               {
                  // Presently moved the Memory to different place in Interleave Mem
                  gpus_HybridsForProfileSelected = &gusa_HybridsForProfileSelected[0][0];

                  if ((gsa_TxBandLeftChannel[0] <= US0_POTS_ISDN_DETECT_TONE) &&
                      (!(gs_PgaTrainingDbg & TEST_HP2_CONFIG_US0_HYB_TBL)))
                  {
                     TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_A_NUM_HYBS_US0;
                     memcpy(gpus_HybridsForProfileSelected,
                            &gusa_HybridSettingV2_US0_A_VRX518[0][0],
                            sizeof(uint16)*VRX_ANX_A_NUM_HYBS_US0*VRX_HYB_NUM_SETTINGS);
                  }
                  else
                  {
                     // if (gt_ProfileAct.us_AnxBUS0PsdSelected & CNFG_V2_ANXB_US0_120_276_MASK)
                     TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_BJ_NUM_HYBS_US0;
                     memcpy(gpus_HybridsForProfileSelected,
                            &gusa_HybridSettingV2_US0_VRX518[0][0],
                            sizeof(uint16)*VRX_ANX_BJ_NUM_HYBS_US0*VRX_HYB_NUM_SETTINGS);
                  }

                  // If no of hybrids were forced, choose the forced one.
                  if ((guc_ForceNumHybrid > 0) && (guc_ForceNumHybrid < TESTArray[TEST_MaxNumHybrSettings]))
                  {
                     TESTArray[TEST_MaxNumHybrSettings] = guc_ForceNumHybrid;
                  }
               }
            }


            if (gs_PgaTrainingDbg & TEST_HP2_CONFIG_USE_SNR_HYB_FOR_US0)
            {
               guc_HybridAlgoCtrl = HYB_ALGO_SNR_BASED;
            }
            // XDSLRTFW-1200 : BUG_DS_ALL_ALL_QUAD_SUPPORT
            // XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (End)
            // XDSLRTFW-1488 (END)
         }
         else
         {
            // The variable "gs_PgaTrainingDbg" gets be initialized for long reach mode (i.e. US0 only) by default.
            // Therefore it must be reset for short and medium loops!
            // Only if the bit "TEST_HP2_CONFIG_CMV_CONFIG_ALWAYS" is set, the config stays valid
            // for every loop length.
            if(!(gs_PgaTrainingDbg & TEST_HP2_CONFIG_CMV_CONFIG_ALWAYS))
            {
               gs_PgaTrainingDbg &= TEST_HP2_CONFIG_DC_TO_ZERO;
            }

            gus_UseUS0OnlyCntrl = (gs_ChangeTxBand & TX_NUM_BAND_MASK);
            if (TESTArray[TEST_JIRA2257_CONFIG] & TEST_JIRA2257_SKIP_TX_BAND_SWITCH)
            {
               gus_UseUS0OnlyCntrl = 0;
            }

            // Switch hybrids
            {
               uint16 us_SwitchingCriterionVal;

               us_SwitchingCriterionVal = gus_SwitchingCriterionVal;
               // Defines for variable "gus_UseUS0OnlyCntrl"
               // #define TX_NUM_BAND_MASK                        0x00FF
               // #define US0_BITFIELDS                           0xFF00

               // gus_UseUS0OnlyCntrl contains at this point:
               // - the desired number of Transmit bands (gs_ChangeTxBand)
               // - US0 bits are NOT set
               if (gus_UseUS0OnlyCntrl)
               {
                  // XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
                  // For switch from 17a to the 8x settings if the loop attenuation > 25dB (corresponds to > 1000 m ETSI#1) (US1 only used)
                  // From: Schreiber, Frank
                  // Sent: Wednesday, December 14, 2016 1:20 PM
                  // Note: Tests with BDCM and PE04 DSL-8234 Loopsimulator shows that the correct value is 22dB ~950m
                  // use 9 hybrid settings only for BRCM COs
                  //Before enabling this fix also for non-BRCM devices we need to show that there is no timing issue
                  if ((gul_fe_G994VendorID == BRCM_VENDOR_ID) || ((gt_Reconf_Hybrid_Coeff.s_control & ENABLE_ALL_HYB_FOR_NON_BRCM)==ENABLE_ALL_HYB_FOR_NON_BRCM))
                     TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_8M;
                  else
                     TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_8M_NONBRCM;
                  memcpy(gpus_HybridsForProfileSelected, &gusa_HybridSettingV2_8M_VRX518[0][0], sizeof(uint16)*VRX_ANX_ABJ_NUM_HYBS_8M*VRX_HYB_NUM_SETTINGS);
               }
               else if ((us_SwitchingCriterionVal < (gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_X_HYB])) &&
                   (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK))
               {
                  // For zero loop detection a loop attenuation < 0.5 dB at 1 MHz should be used.
                  // From: Schreiber, Frank
                  // Sent: Wednesday, December 14, 2016 1:20 PM
                  TESTArray[TEST_MaxNumHybrSettings] = 1;
                  memcpy(gpus_HybridsForProfileSelected, &gusa_SpecialHybSetting[0], sizeof(uint16)*1*VRX_HYB_NUM_SETTINGS);

                  // Disable long PLL time for short loops
//                  gs_NumFramesSlowPLLStabilization_ChDisc1 = PLL_STABILIZATION_LEN_DIS;
               }
               else if (us_SwitchingCriterionVal >= (gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_US0_HYB]))
               {
                  // For switch from 8x to the U0 settings if the loop attenuation > 33dB (corresponds to > 1400 m ETSI#1) (US1 only used)
                  // Frequency range:
                  // -  0 /  25kHz upto 276kHz or 552kHz -> POTS hybrid coefficients
                  // -      120kHz upto 276kHz          -> ISDN hybrid coefficients
                  {
                     // Presently moved the Memory to different place in Interleave Mem
                     gpus_HybridsForProfileSelected = &gusa_HybridsForProfileSelected[0][0];

                     if (gsa_TxBandLeftChannel[0] <= US0_POTS_ISDN_DETECT_TONE)
                     {
                        TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_A_NUM_HYBS_US0;
                        memcpy(gpus_HybridsForProfileSelected,
                               &gusa_HybridSettingV2_US0_A_VRX518[0][0],
                               sizeof(uint16)*VRX_ANX_A_NUM_HYBS_US0*VRX_HYB_NUM_SETTINGS);
                     }
                     else
                     {
                        TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_BJ_NUM_HYBS_US0;
                        memcpy(gpus_HybridsForProfileSelected,
                               &gusa_HybridSettingV2_US0_VRX518[0][0],
                               sizeof(uint16)*VRX_ANX_BJ_NUM_HYBS_US0*VRX_HYB_NUM_SETTINGS);
                     }
                  }
               }
               else if (us_SwitchingCriterionVal >= (gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_8_HYB]))
               {
                  // For switch from 17a to the 8x settings if the loop attenuation > 25dB (corresponds to > 1000 m ETSI#1) (US1 only used)
                  // From: Schreiber, Frank
                  // Sent: Wednesday, December 14, 2016 1:20 PM
                  // Note: Tests with BDCM and PE04 DSL-8234 Loopsimulator shows that the correct value is 22dB ~950m
                  TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_8M;
                  memcpy(gpus_HybridsForProfileSelected, &gusa_HybridSettingV2_8M_VRX518[0][0],
                         sizeof(uint16)*VRX_ANX_ABJ_NUM_HYBS_8M*VRX_HYB_NUM_SETTINGS);

               }
               else if((us_SwitchingCriterionVal >= (gusa_SwitchingThreshRxHyb[SWITCH_TO_PROFILE_17_HYB])) &&
                       (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK))
               {
                  // XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
                  // For switch from 35b to the 17a settings if the loop attenuation > 15 dB at 1 MHz (corresponds to ~600m ETSI#1 loop).
                  // From: Schreiber, Frank
                  // Sent: Wednesday, December 14, 2016 1:20 PM
                  // use 9 hybrid settings only for BRCM COs
                  //Before enabling this fix also for non-BRCM devices we need to show that there is no timing issue
                  if ((gul_fe_G994VendorID == BRCM_VENDOR_ID) || ((gt_Reconf_Hybrid_Coeff.s_control & ENABLE_ALL_HYB_FOR_NON_BRCM)==ENABLE_ALL_HYB_FOR_NON_BRCM))
                  {
                     TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_17M;
                  }
                  else
                  {
                     TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_17M_NONBRCM;
                  }
                  memcpy(gpus_HybridsForProfileSelected, &gusa_HybridSettingV2_17M_VRX518[0][0],
                         sizeof(uint16)*VRX_ANX_ABJ_NUM_HYBS_17M*VRX_HYB_NUM_SETTINGS);
               }
//               else
//               {
//                  // Disable long PLL time for short loops
//                  gs_NumFramesSlowPLLStabilization_ChDisc1 = PLL_STABILIZATION_LEN_DIS;
//               }
            }
         }

         guc_TxRxCommunicator |= TX_IIRFILTER_RECONF_START;
         gs_RxSubState = R_O_SIGNATURE_RX_CONFIG_TX_IIR;
      }
      break;

      //-------------------------------------------
      // Config Transmitter IIR filter
      //-------------------------------------------
   case R_O_SIGNATURE_RX_CONFIG_TX_IIR:

      if(guc_TxRxCommunicator & TX_IIRFILTER_RECONF_COMPLETED)
      {
         if(gft_DSVectoringEnabled == TRUE)
         {
            //Next State for Vectoring
            gs_AlgHandlerState = FDQ_TRAIN_INIT;
            gs_RxSubState = R_O_SIGNATURE_RX_TRAIN_FDQ_FOR_SYNCHRO_V1;
         }
         else
         {
            gs_RxSubState = R_O_SIGNATURE_RX_SET_PGA_AND_TRIG_TX_RMSG1;
         }
      }
      break;


   case R_O_SIGNATURE_RX_TRAIN_FDQ_FOR_SYNCHRO_V1:
      if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
      {
         FdqHandler();
      }
      else
      {

#ifdef SAVE_REVERB_FDQ
         // save Reverb FDQ coefficients
         ReadFdqMant(gsa_ReverbFdqMantissa, 0, gs_RxNumTones);
         ReadFdqExp(guca_ReverbFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_REVERB_FDQ
         gs_RxSubState = R_O_SIGNATURE_RX_SELECT_TONE_FOR_SYNCHRO_V1_DETECTION;
      }
      break;

   case R_O_SIGNATURE_RX_SELECT_TONE_FOR_SYNCHRO_V1_DETECTION:
      // XDSLRTFW-1293: Bugfix_DS_VDSL2_ALL_SYNCHROV1 (start)
      // Set the RX tone offset for capturing tones in RTV buffer
      // gs_RxToneOffset was initially populated in SelectRxMsgDecodeTones() function and modified #
      // by later states so that gs_RxToneOffset variable need to be reinitialized.
      // This re-initialization is possible because all other variables populated by
      // SelectRxMsgDecodeTones() function are not changed.
      // !!In case of any detection issue, here SelectRxMsgDecodeTones function along with SnrHandler() need to be called here!!
      gs_RxToneOffset = (gs_SelectBandStart+9)/10;
      gs_RxToneOffset *= 10;
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

      gs_RxSubState = R_O_SIGNATURE_RX_CODESWAP_ALGHD_2;

      // send a request to Tx to TimingAdvanceHandler to align Tx/Rx frame boundaries.
      guc_TxRxCommunicator |= TX_TIMING_ADVANCE_START;
      break;

   case R_O_SIGNATURE_RX_CODESWAP_ALGHD_2:

      if (guc_TxRxCommunicator & TX_TIMING_ADVANCE_COMPLETED)
      {
         // load coad swap page for DetectDSSync_Vector_Handler
         FreeSwapHandle(&guc_PrimPageHandle);
         guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE);

         gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB_INIT;
         gs_RxSubState = R_O_SIGNATURE_RX_DEMODULATE_DS_SYNCSYMB_INIT1;
      }
      break;

   case R_O_SIGNATURE_RX_DEMODULATE_DS_SYNCSYMB_INIT1:

      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         if (gs_VectorHandlerState != VECTOR_DECODESYNCH_DONE)
         {
            DetectDSSync_Vector_Handler();
         }
         else
         {
            // swap ALGHD1 page
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);

            // send signal to Tx State machine to start R_P_Vector 1
            guc_TxRxCommunicator |= TX_RPVECTOR1_START;

            gs_VectorHandlerState = 0;
            gs_RxSubState = R_O_SIGNATURE_RX_O_P_SYNCHRO_V1;
         }
      }
      break;

   case R_O_SIGNATURE_RX_O_P_SYNCHRO_V1:
      gsa_IndirectStat0[3]=VDSL2_R_O_P_SYNCHRO_V1;
      if (!(guc_VecDebugSwitchEnable & VEC_DEBUG_STOP_TX_RPVEC1))
      {
         /*
            After decoding O-SIGNATURE MESSAGE, transmit R-P_vector1 and move Rx to look for O-P_SYNCHRO V1
            As soon as O-SYNCHRO V1 is received stop transmitting R-P-Vector1 and move to transmitting R-IDLE
         */
         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            if (gs_VectorHandlerState != R_O_P_SYNCHRO_V1_DONE)
            {
               ROPSynchroVector1RxF_VDSL2();
            }
            else
            {
               // transmit message 1
               gs_RxSubState = R_O_SIGNATURE_RX_SET_PGA_AND_TRIG_TX_RMSG1;

               // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
               // Switch global state timout after OP-SYNCHROV1
               // Note:
               //       1) It is not possible to set the value here directly since
               //          it is lower than the previous one. So the timeout check
               //          in RxForeGround would directly kick in.
               //       2) guc_SwitchGlobalTimeout must be initialized to zero
               guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;
            }
         }
      }
      break;

   case R_O_SIGNATURE_RX_SET_PGA_AND_TRIG_TX_RMSG1:

      // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
      // Switch global state timout from VECTORING_STATE_TIMEOUT_LEN back
      // to normal STATE_TIMEOUT_LEN.
      // Note: This code is only active for Vectoring!
      if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_RX)
      {
// This would be the right place, but since there is no state change it doesn't work!
         gl_RxSymbolCount = 1;
         gl_RxStateTimeOutCount = STATE_TIMEOUT_LEN;
         guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_RX);
      }

      // signal to TX side to start transmitting RMsg1.
      guc_TxRxCommunicator |= TX_RMSG1_START;

      // reset PGA to GHS PGA for echo dominated loop
      // to avoid clipping during PGA measurement
      guc_PgaState = TRAINING_DONE;
#ifdef VR9_BRINGUP_DBG  //Debug code
      if(gft_BypassPGATrain == TRUE) //This flag is always ZERO in normal case, For Debugging purpose this may be non-zero
      {
         if(gs_PGA_set > 0)
         {
            // turn off PLL
            gft_EnablePLL  = FALSE;
            gs_PGA_required = gs_PGA_init_In_Train;

            guc_PgaState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting);
         }
      }
#endif //#ifdef VR9_BRINGUP_DBG

      gs_RxSubState = R_O_SIGNATURE_RX_WAIT_FOR_TX;

      break;

      //------------------------------------------------------------
      // Trigger and Wait for Transmit signal (i.e. echo) to start
      //------------------------------------------------------------

   case R_O_SIGNATURE_RX_WAIT_FOR_TX:

      if ((guc_PgaState == TRAINING_DONE) && (gs_TxRxMessaging == PGA_RETRAIN_XMITTING))
      {
         // train the PGA or Hybrid/PGA (with echo)
         // (NOTE: Hybrid Training includes PGA Training)
         if (gft_HybridTrainingEnable == 1)
         {
            gs_HybrTrHandlerState = HYBRID_TRAINING_INIT;
         }
         else
         {
            gs_PgaHandlerState = PGA_INIT;
         }

         // Enable the RX AFE HPF (i.e., do not bypass it)
         gft_BypassRxAFE_HPF = FALSE;
         // turn off PLL
         gft_EnablePLL  = FALSE;

         // Here the final PGA train of ChannelDiscovery will happen.
         // ACE should not be changed earlier, because HLOG/QLN TF assumes ACE=OFF.
         //
         // For 8x profiles:
         // - The PgaHandler() is not indicating clipping due to less receive Signal, i.e. missing US2 and DS3 band.
         // - Therefore no stepping down of ACE as for 17a/12x and 17a DPBO will occur.
         // - As proposed by Villach let the ACE mode on highest level.
         {
            int16 s_PrefiAceMode;
            uint16 us_SwitchingCriterionVal;

            s_PrefiAceMode = ACE_OFF;
            us_SwitchingCriterionVal = gus_SwitchingCriterionVal;
            if (us_SwitchingCriterionVal > gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX5_OFF])
            {
               // (     > 1400m PE04 DSL8234)
               s_PrefiAceMode = ACE_OFF;
            }
            else if (us_SwitchingCriterionVal > gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX4_7DOT5PF])
            {
               // ( 975m - 1400m PE04 DSL8234)
               s_PrefiAceMode = ACE_7p5F;
               if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK)         // XDSLRTFW-3268
               {
                  s_PrefiAceMode = ACE_52p5F;
               }
            }
            else if (us_SwitchingCriterionVal > gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX3_15PF_LR])
            {
               // ( 600m -  975m PE04 DSL8234)
               s_PrefiAceMode = ACE_15pF;
               if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK)         // XDSLRTFW-3268
               {
                  s_PrefiAceMode = ACE_52p5F;
               }
            }
            else if (us_SwitchingCriterionVal > gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX2_52DOT5PF])
            {
               // ( 150m - 600m PE04 DLS8234)
               s_PrefiAceMode = ACE_52p5F;
            }
            else if (us_SwitchingCriterionVal > gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX1_30PF])
            {
               // (  75m - 150m PE04 DLS8234)
               s_PrefiAceMode = ACE_30pF;
            }
            else if (us_SwitchingCriterionVal > gusa_SwitchingThreshAceMode[SWITCH_ACE_MODE_IDX0_15PF])
            {
               // (  25m - 75m PE04 DLS8234)
               s_PrefiAceMode = ACE_15pF;
            }
            else
            {
               s_PrefiAceMode = ACE_7p5F;
            }


            //XDSLRTFW-3064 Start
            //Detetct Noise limited case by looking at QLN values US1/US2 band and if DS1 or DS1 and DS2 band are present
            {
//               gula_DebugVarsPalak[10] = 0x00001210;
               if(gus_DebugControlVRX518 & US_NOISE_DETECTION_EN)
               {
                  int16 s_HighestAllowedRxTone;

                  CheckQuieteLineNoiseLevel_UpstreamBand();

                  s_HighestAllowedRxTone = gs_HighestAllowedRxTone;
                  gula_DebugVarsPalak[10] = (((int16)0x1410) | (s_HighestAllowedRxTone <<16));

                  // US1 band Noise level -> guca_QlnLevelUS[1]
                  // US2 band Noise level -> guca_QlnLevelUS[2]
                  // Note: The check must be "<", because a higher noise level has a smaller value
                  //       E.g. -100dBm/Hz is 154 (= Sum(n(k)))
                  //             -90dBm/Hz is 134 (= Sum(n(k)))
                  //       It shall be represented as an 8-bit unsigned integer n(k), where k = 0 to 511.
                  //       The value of QLN(k * G * delf_f) shall be defined as
                  //       QLN(k * G * delta_f) = -23 - (n(k)/2) dBm/Hz.
                  if ( (s_HighestAllowedRxTone < LAST_BIN_DS1) && (guca_QlnLevelUS[1] < (uint8) QLN_VALUE_MINUS_100DBM_HZ) )
                  {
                     //US0 and DS1
                     gs_Pga_XtakNoiseScaleCtrl |= 2;       //2dB(Already Prefi Marigin is 2dB)+6dB in 8.8 format
                     s_PrefiAceMode = ACE_OFF;
//                     gs_PGA_margin_AGC2 += 0x0600;  //2dB(Already Prefi Marigin is 2dB)+6dB in 8.8 format
                  }
                  else if ( (s_HighestAllowedRxTone < LAST_BIN_DS2) && ( (guca_QlnLevelUS[2] < (uint8) QLN_VALUE_MINUS_100DBM_HZ) || (guca_QlnLevelUS[1] < (uint8) QLN_VALUE_MINUS_88DBM_HZ)) ) //XDSLRTFW-3310
                  {
                     //US0/US1 and DS1/DS2 case
                     gs_Pga_XtakNoiseScaleCtrl |= 1;       //2dB(Already Prefi Marigin is 2dB)+3dB in 8.8 format
                     s_PrefiAceMode = ACE_15pF;
//                     gs_PGA_margin_AGC2 += 0x0400;  //2dB(Already Prefi Marigin is 2dB)+4dB in 8.8 format
                     gula_DebugVarsPalak[10] |= 0x00000100;              // 0x00001510
                  }
               }
            }

            gs_PrefiAceMode_Selected = s_PrefiAceMode;
            // Force ACE to a specific mode, i.e. code for debugging!
            s_PrefiAceMode = (TESTArray[TEST_DS_ACE] & ACE_MODE_MASK);
            if (s_PrefiAceMode != ACE_MODE_MASK)
            {
               gs_PrefiAceMode_Selected = s_PrefiAceMode;
            }
         }
         // For PGA and PREFI Lp corner frequency the same value should be used.
         // PGA and PREFI Lp corner frequency ~=  twice the highest possible frequency
         memcpy(gla_fc_pga_lp_kHz, gla_fc_pga_lp_kHz_HybridPga, sizeof(gla_fc_pga_lp_kHz));
         memcpy(gla_fc_prefi_lp_kHz, gla_fc_prefi_lp_kHz_HybridPga, sizeof(gla_fc_pga_lp_kHz));

// This code was not available before and is a placeholder for PgaHandler() debug/analysis!
//         if (gus_DebugControlVRX518 & PGA_PREFI_FC_REDUCTION_EN)
//         {
//            if (gs_HighestAllowedRxTone < LAST_BIN_DS2)
//            {
//               int16 s_ShiftValue;
//
//               s_ShiftValue = 1;
//               if ((gs_HighestAllowedRxTone < LAST_BIN_DS1) &&
//                   (!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK)))
//               {
//                  s_ShiftValue = 2;
//               }
//               gla_fc_pga_lp_kHz[gus_AFE_RxMode]   = (gla_fc_pga_lp_kHz[gus_AFE_RxMode] >> s_ShiftValue);
//               gla_fc_prefi_lp_kHz[gus_AFE_RxMode] = (gla_fc_prefi_lp_kHz[gus_AFE_RxMode] >> s_ShiftValue);
//            }
//         }


         gs_RxSubState = R_O_SIGNATURE_RX_TRAIN_PGA;
      }
      break;

      //-------------------------------------------------------------
      // Train PGA and Hybrid in presence of Channel Discovery Echo
      //-------------------------------------------------------------

   case R_O_SIGNATURE_RX_TRAIN_PGA:

      // Run Hybrid or PGA Training, dependent on HybridTrainingEnable flag
      if ((gft_HybridTrainingEnable == 1) && (gs_HybrTrHandlerState != HYBRID_TRAINING_DONE))
      {
         HybridTrainingHandler();
      }
      else if ((gft_HybridTrainingEnable == 0) && (gs_PgaHandlerState != PGA_DONE))
      {
         PGAHandler();
      }
      else
      {
         // Save PGA settings
         gs_PGA_set_ChDisc = gs_PGA_set;
         gs_RxVarGainDB_ChDisc = gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB;
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_O_SIGNATURE_RX_PLL_RELOCK;

         // XDSLRTFW-2190/XDSLRTFW-2270: PERF_DS_LONGLOOPS_SYNC_LOSS_IN_O_P_PERIODIC1 (StartEnd)
         // this is an initial WORKAROUND which needs to be replaced by a proper O-P_PERIODIC1 fix
         if (gt_Kl0ElectricalLength.s_kl0_estimate > (KL0_1500M_PE04))  // = 391 to be replaced with code-cleanup (XDSLRTFW-2262)
         {
            gs_NumFramesSlowPLLStabilization_ChDisc1 = 300;   // set to 300 frames ~ 80ms
         }
      }
      break;


      //-------------------------------------------------------------
      // Relock PLL
      //-------------------------------------------------------------
   case R_O_SIGNATURE_RX_PLL_RELOCK:

      gs_RxSubStateCnt++;
      // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start)
      // XDSLRTFW-793: RP-Synch not detected / Tone cluster not detected (start)
      // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
      if (gs_RxSubStateCnt == 10)
      {
         // Set new Pll Reference for all 3 supported pilot tones after PGA
         ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );

         if (gs_NumFramesFastPLLStabilization_ChDisc1 != -1)
         {
            // Set PLL loop filter parameters to Fast converge.
            ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
         }
         else
         {
            // Set PLL loop filter parameters to Slow converge
            ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
         }

         // Turn on PLL
         gft_EnablePLL = TRUE;
      }
      else if((gs_NumFramesSlowPLLStabilization_ChDisc1 != -1) && (gs_RxSubStateCnt == gs_NumFramesFastPLLStabilization_ChDisc1)) // Wait for PLL to stabilize
      {
         // Ignore Slow PLL adaptation in case gs_NumFramesSlowPLLStabilization_ChDisc = -1
         // At Non Vectoring cases, gs_NumFramesSlowPLLStabilization_ChDisc initializes to -1

         // switch PLL coefficients for Slow adaptation to adapt lower steady-state noise
         ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
         ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
         ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
      }
      // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
      else if (gs_RxSubStateCnt > (gs_NumFramesFastPLLStabilization_ChDisc1 + gs_NumFramesSlowPLLStabilization_ChDisc1) ) // Wait for PLL to stabilize
      {
         // In case of gs_NumFramesSlowPLLStabilization_ChDiscV1 = -1, FW will skip ResetPLL for Slow adaptation
         // and code will come to this section when "gs_RxSubStateCnt = gs_NumFramesFastPLLStabilization_ChDisc1V1"

         gs_AlgHandlerState = FDQ_TRAIN_INIT;
// Note: This line is not needed! The control "gs_FDQTrainTypeCntrlFlag" sould be set only once, which is done
//       in ConfigTaskLayerForPostGhs().
//         gs_FDQTrainTypeCntrlFlag = FDQ_TRAIN_TYPE_DEFAULT;
         gs_RxSubState = R_O_SIGNATURE_RX_TRAIN_FDQ;

         // XDSLRTFW-1111
         if (gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_DS_MASK))
         {
            // save original AlgLog2NumFramesToAccum
            gs_FdqAlgLog2NumFramesToAccum_Saved = gt_FdqConfig.s_AlgLog2NumFramesToAccum;
            gs_SnrAlgLog2NumFramesToAccum_Saved = gt_SnrConfig.s_AlgLog2NumFramesToAccum;

            // Enable removing of Tone9 marker symbols for vectroing during FDQ/SNR measurement.
            gs_MedleyFrameSynchEnableFlag |= (EN_CHDIS_SKIP_TONE9_MARKER_SYM_SNR|EN_CHDIS_SKIP_TONE9_MARKER_SYM_FDQ);
//            if (gs_MedleyFrameSynchEnableFlag & 0x1000)
            {
               gt_FdqConfig.s_AlgLog2NumFramesToAccum -= 1;
            }
//            if (gs_MedleyFrameSynchEnableFlag & 0x2000)
            {
               gt_SnrConfig.s_AlgLog2NumFramesToAccum -= 1;
            }
         }

#if defined(O_SINATURE_PAUSE_DEBUG)
         if (gs_PauseControl == 0x103)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // O_SINATURE_PAUSE_DEBUG
      }
      // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (End)
      break;


      //-------------------------------------------------------------
      // Calculate FDQ
      //-------------------------------------------------------------
   case R_O_SIGNATURE_RX_TRAIN_FDQ:

      if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
      {
         FdqHandler();
      }
      else
      {
#ifdef SAVE_REVERB_FDQ
         // save Reverb FDQ coefficients
         ReadFdqMant(gsa_ReverbFdqMantissa, 0, gs_RxNumTones);
         ReadFdqExp(guca_ReverbFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_REVERB_FDQ

#if defined(O_SINATURE_PAUSE_DEBUG)
         if (gs_PauseControl == 0x104)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // O_SINATURE_PAUSE_DEBUG

         // Initialize vars for SNR calculation
         gpsa_MeasuredSnrBuf = gsa_SnrBuf;
         gs_AlgHandlerState = SNR_INIT;

         // Transition to next substate
         gs_RxSubState = R_O_SIGNATURE_RX_CALCULATE_SNR;
      }
      break;

      //-------------------
      // Calculate SNR
      //-------------------
   case R_O_SIGNATURE_RX_CALCULATE_SNR:
      if (gs_AlgHandlerState != SNR_CALC_DONE)
      {
         SnrHandler();
      }
      else
      {
         // XDSLRTFW-1111
         if (gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_DS_MASK))
         {
            // Disable removing of Tone9 marker symbols for vectroing during FDQ/SNR measurement.
            gs_MedleyFrameSynchEnableFlag &= (~(EN_CHDIS_SKIP_TONE9_MARKER_SYM_SNR|EN_CHDIS_SKIP_TONE9_MARKER_SYM_FDQ));

            gt_FdqConfig.s_AlgLog2NumFramesToAccum = gs_FdqAlgLog2NumFramesToAccum_Saved;
            gt_SnrConfig.s_AlgLog2NumFramesToAccum = gs_SnrAlgLog2NumFramesToAccum_Saved;
         }

#if defined(O_SINATURE_PAUSE_DEBUG)
         // At the end of SNR Handler
         if (gs_PauseControl == 0x105)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // O_SINATURE_PAUSE_DEBUG


         if(TESTArray[TEST_StoreSramControl] & TEST_SAVE_DISC_SNR_ENABLE)
         {
            if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) != SWAP_DONE)
            {
               break;
            }
            gta_BAR15LookUpTable[OFF_CHIP_DISC_SNR][OFF_CHIP_SOURCE_INDEX] = (int32)gpsa_MeasuredSnrBuf;   // update source address
            gta_BAR15LookUpTable[OFF_CHIP_DISC_SNR][OFF_CHIP_DEST_INDEX] = (int32)&gsa_ReverbSnrBuf[gs_RxNumTones*guc_ch_id];    // destination;
            gta_BAR15LookUpTable[OFF_CHIP_DISC_SNR][OFF_CHIP_LENGTH_INDEX] = ((gs_RxNumTones + 1)/2)*4;    // size in bytes; make sure length is multiple of 4-bytes

            // Free handle for PSD offchip request
            FreeSwapHandle(&guc_OffChipRequestHandle);
            guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DISC_SNR);

         }

         DSH_SendStream(DSH_CD_SNR,gs_RxNumTones*sizeof(int16),(void*)gpsa_MeasuredSnrBuf);

         // Initialize vars for PSD calculation
         gpsa_MeasuredSnrBuf = gsa_CommonMemoryBlock0;   // use gsa_CommonMemoryBlock0 to store PSD
         gs_AlgHandlerState = PSD_INIT;
         gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;

         // Transition to next substate
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_O_SIGNATURE_RX_PSD;
      }
      break;


      //-------------------------------------------------------------
      // Calculate PSD
      // - This is needed to calculate the Proposed DS Ceiling.
      //-------------------------------------------------------------
   case R_O_SIGNATURE_RX_PSD:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
      if (gs_AlgHandlerState != PSD_CALC_DONE)
      {
         PsdHandler();
      }
      else
      {
         if(TESTArray[TEST_StoreSramControl] & TEST_SAVE_DISC_EchoOn_PSD_ENABLE)
         {
            if(PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) != SWAP_DONE)
            {
               break;
            }

            gta_BAR15LookUpTable[OFF_CHIP_DISC_PSD_ECHOON][OFF_CHIP_SOURCE_INDEX] = (int32)gpsa_MeasuredSnrBuf;   // update source address
            gta_BAR15LookUpTable[OFF_CHIP_DISC_PSD_ECHOON][OFF_CHIP_DEST_INDEX] = (int32)&gsa_DiscPsdBuf_EchoOn[gs_RxNumTones*guc_ch_id];    // destination;
            gta_BAR15LookUpTable[OFF_CHIP_DISC_PSD_ECHOON][OFF_CHIP_LENGTH_INDEX] = ((gs_RxNumTones + 1)/2)*4;    // size in bytes; make sure length is multiple of 4-bytes

            // Free handle for PSD offchip request
            FreeSwapHandle(&guc_OffChipRequestHandle);
            guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DISC_PSD_ECHOON);
         }

         //Compute the PSD level difference between US0 band and DS1 band
         //to decide the echo level
         if((gft_EnableUS0PsdCut) && (gft_US0BandUsed))
         {
            CheckEchoLevel(gpsa_MeasuredSnrBuf);
         }

         gs_RxSubState = R_O_SIGNATURE_RX_INIT_CALCULATE_SNR;
#if defined(O_SINATURE_PAUSE_DEBUG)
         if (gs_PauseControl == 0x106)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // O_SINATURE_PAUSE_DEBUG
      }
      }
      break;

      //-------------------------------------------------------------
      // Calculate RxBandLimit
      // - Use SNR measurement for calculation.
      //-------------------------------------------------------------
   case R_O_SIGNATURE_RX_INIT_CALCULATE_SNR:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         gpsa_MeasuredSnrBuf = gsa_SnrBuf;
         // Note: This is needed to detect Synchro1. SnrHandler() and FdqHanlder() are setting "SFDQ_OUTPUT" as output.
         //       Only the PsdHandler() is setting "FFT_OUTPUT" as output?
         gs_RtvSelect = SFDQ_OUTPUT;

         // select RX band limit based on SNR
         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxBandLimit);

         gs_RxSubState = R_O_SIGNATURE_RX_PROP_CEILING;
      }
      break;

      //-------------------------------------------------------------
      // Calculate ProposedCeiling
      // - Use PSD measurement for calculation.
      //-------------------------------------------------------------
   case R_O_SIGNATURE_RX_PROP_CEILING:
      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // Compute optimal proposed ceiling settings in background
         // Note: In the fct. the variable "gft_EnableProposedCeiling" is checked.
         //       It is done in this way to have for enable/disable the same FG/BG behaviour.
         //       In case of disabled the fct. gets diretly be returned with:
         //           gt_PwrConfigParam.s_Dn_ProposedPsdCeiling = 0x1000;
         //           guc_PgaState = TRAINING_DONE;
         gpsa_MeasuredSnrBuf = gsa_CommonMemoryBlock0;   // use gsa_CommonMemoryBlock0 to store PSD

         guc_PgaState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCalcProposedCeiling);

         // Tracee debug info
         {
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgStreamRxEchoPsd);
         }

         gs_RxSubState = R_O_SIGNATURE_RX_SELECT_MSG_TONE;

      }
      break;


      //----------------------------------
      // Message Tone(s) Selection
      //----------------------------------
   case R_O_SIGNATURE_RX_SELECT_MSG_TONE:

      if ((guc_PgaState == TRAINING_DONE) && (gs_RxBkgdProcessFlag == TRAINING_DONE))
      {

#if defined(PROPOSED_CEILING_DS_DEBUG)
         if (gs_PauseControl == 0x107)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // PROPOSED_CEILING_DS_DEBUG

         // Call the following function to select the tones for message decoding
         gpsa_MeasuredSnrBuf = gsa_SnrBuf;
         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxMsgDecodeTones);

         // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
         if (gt_PilotConfig.s_PilotToneControl & DISABLE_MULTI_PILOT_SELECT)
         {
            gs_RxSubState = R_O_SIGNATURE_RX_DONE;
         }
         else
         {
            gs_RxSubState = R_O_SIGNATURE_RX_SELECT_PILOT;
         }
      }
      break;


      //----------------------------------
      // Pilot Tone(s) Selection
      //----------------------------------
   case R_O_SIGNATURE_RX_SELECT_PILOT:

      // wait for the message decode tone selection
      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectMultiPilot);

         gs_RxSubState = R_O_SIGNATURE_RX_WAIT_SELECT_PILOT;
      }
      break;

   case R_O_SIGNATURE_RX_WAIT_SELECT_PILOT:

      // wait for the new pilot tone selection
      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
          // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         if (gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx == 0)
         {
            EnterFailStates(E_CODE_PILOT_TONE_SELECTION_FAIL);
         }
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

         gs_RxSubState = R_O_SIGNATURE_RX_DONE;
      }
      break;

      //---------------------------------------------------------------
      // Complete O-Signature processing and continue to next state
      //----------------------------------------------------------------
   case R_O_SIGNATURE_RX_DONE:

      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // save tone selection
         gs_ToneSelect_Msg_ChDisc = gs_SelectBandStart;
         gs_NumCluster_Msg_ChDisc = gs_NumOfToneClustersForMsgDecode;

         // save pilot tone index and other debug info
         // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
         gs_PilotToneIdx_ChDisc = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx;
         for (i=0; i<gt_PilotConfig.s_NumPilotTones; i++)
         {
            memcpy(&gsa_SnrOfPilotTone_ChDisc[i], &gpsa_MeasuredSnrBuf[gt_PilotConfig.ta_PilotTones[i].s_PilotToneIdx-2], sizeof(int16)*5);
         }

         // check the result and enter fail state if no band was found
         if (gs_SelectBandStart == -1)
         {
            EnterFailStates(E_CODE_ZERO_TONE_CLUSTERS_R_O_SIGNATURE);
         }
         else
         {
            //Signal to TX side that processing O-Signature is done
            gs_TxRxMessaging = PGA_RETRAIN_FDQDONE;

            // go to the bridge state, and load TRAIN_1_V2 swap page
            gs_RxNextState = VDSL2_R_O_SIGNATURE_RX_BRIDGE;
            gpF_RxStateFunc = (PtrToFunc)ROSignatureRxF_VDSL2_Bridge;
         }
      }
      break;

   } //switch

   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_2_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_2_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   case CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_1_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   }
}


void CheckEchoLevel(int16 *psa_PsdBuf)
{
   int32 l_Us0Psd, l_Ds1Psd;
   int16 i;


   //Compute the power level of US0 near right band edge
   l_Us0Psd = 0;
   for(i=gsa_TxBandRightChannel[0]-3; i <= gsa_TxBandRightChannel[0]; i++)
   {
      l_Us0Psd += psa_PsdBuf[i];
   }
   l_Us0Psd >>= 2;

   //Compute the power level of DS1 near left band edge
   l_Ds1Psd = 0;
   for(i=gsa_RxBandLeftChannel[0]; i < (gsa_RxBandLeftChannel[0]+4); i++)
   {
      l_Ds1Psd += psa_PsdBuf[i];
   }
   l_Ds1Psd >>= 2;

   //Compute the PSD difference
   gs_Us0Ds1PsdDiff = (int16)(l_Us0Psd - l_Ds1Psd);

} //void CheckEchoLevel(int16 *psa_PsdBuf)

//XDSLRTFW-3064 Start
void CheckQuieteLineNoiseLevel_UpstreamBand(void)
{
   int16 s_Band;
   int16 s_Start, s_End, s_toneIndex, s_NumOfValues;
   int16 s_sum;

   for( s_Band=0; s_Band<gs_NumOfTxBandsOSignature;s_Band++)
   {
      s_NumOfValues=0;
      s_sum = 0;
      //XDSLRTFW-3801 Start
      //Before calling of function CheckQuieteLineNoiseLevel_UpstreamBand, the vaues of guca_QlnLevelUS were
      //guca_QlnLevelUS[Band_0] = 0xFF; //Means -150.5 dBm/Hz
      //guca_QlnLevelUS[Band_1] = 0xFF; //Means -150.5 dBm/Hz
      //guca_QlnLevelUS[Band_2] = 0xFF; //Means -150.5 dBm/Hz
      //guca_QlnLevelUS[Band_3] = 0xFF; //Means -150.5 dBm/Hz
      //which means lowest possible values of QLN.
      //The bug here was:
      //gs_NumOfTxBandsOSignature=3;
      //gsa_TxBandLeftChannel[0] = 28 gsa_TxBandRightChannel[0] = 60
      //gsa_TxBandLeftChannel[1] = 871 gsa_TxBandRightChannel[1] = 1205
      //gsa_TxBandLeftChannel[2] = 0 gsa_TxBandRightChannel[2] = 0
      //guca_QlnLevelUS value for US band 0 is calculated properly say = 0xCF (-126dBm/Hz)
      //guca_QlnLevelUS value for US band 1 is calculated properly say = 0xD2 (-128dBm/Hz)
      //But for guca_QlnLevelUS value for US band 2 is calculated = 0x5C (-69 dBm/Hz) which is quite high.
      //This high value is because of gsa_TxBandLeftChannel[2]=0, gsa_TxBandRightChannel[2]=0 which Mean QLN value
      //0th bin is quite high(guca_QLN[0] =0x5B)
      //The fix will be to use
      //gs_NumOfTxBandsOSignature along with arrays gsa_TxBandLeftChannelOSignature and gsa_TxBandRightChannelOSignature

      s_Start = gsa_TxBandLeftChannelOSignature[s_Band];
      s_End = gsa_TxBandRightChannelOSignature[s_Band];
      //XDSLRTFW-3801 End

      //Take the averege of QLN values at US2 band frequencies
      for( s_toneIndex= s_Start; s_toneIndex<=s_End;  s_toneIndex += 8)
      {
         s_sum += (int16) guca_QLN_tmp[s_toneIndex >> 3];
         s_NumOfValues++;
      }
      //Averege of QLN values in US2 band
      guca_QlnLevelUS[s_Band] = (uint8) (s_sum / s_NumOfValues); //avg
   }

}
// XDSLRTFW-3064 End


