/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROTaUpdateRxF_VDSL2.c
*
*   This CO file contains the RX state function to receive the O_TA_UPDATE message
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// gdata.c
//
// History
//
// 19/09/2013 Fuss: Addded if-case to skip fct. ResetPllRefTone()
//            Grep for XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation
// 28/01/2014 Fuss: Added fix to reach 2800m noise free
//            XDSLRTFW-1506: No sync in vectoring mode on loops >1600m (US0 only).
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//            Grep for XDSLRTFW-1901
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "SharedFuncs.h"
#include "ghs.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "IRI_Iof.h"
//#ifdef MTK_VECTORING_SUPPORT
#include "DetectDSSync_Vector_Handler.h"
#include "cmv_Data.h"
//#endif
#include "FdqHandler.h"
#include "SnrHandler.h"
#include "IRI_Iof.h"

uint8 guc_SkipSnrTrainingEnd = 1;
uint8 guc_NumFramesToAccumTrainingEnd = LOG2_NUM_FDQ_TRAINING_SYMBOLS;


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROTaUpdateRxF_VDSL2
 *
 *  Prototype:  void ROTaUpdateRxF_VDSL2(void)
 *
 *   This is the state function for receiving O_TA_UPDATE symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_TA_UPDATE_RX_SELECT                       (0)
#define R_O_TA_UPDATE_RX_PLL_RELOCK                   (1)
#define R_O_TA_UPDATE_RX_INIT                         (2)
#define R_O_TA_UPDATE_RX_DEMODULATE_MSG               (3)
#define R_O_TA_UPDATE_RX_EXIT                         (4)
//#ifdef MTK_VECTORING_SUPPORT
#define R_O_TA_UPDATE_RX_CODESWAP_ALGHD_2             (5)
#define R_O_TA_UPDATE_RX_DEMODULATE_DS_SYNCSYMB_INIT1 (6)
//#endif


#define R_O_TA_UPDATE_RX_MSG_FDQ                      (7)
#define R_O_TA_UPDATE_RX_MSG_SNR                      (8)


void ROTaUpdateRxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_TRAINING2;
   gsa_IndirectStat0[2]=VDSL2_R_O_TA_UPDATE;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_RxSubState)
   {

   case R_O_TA_UPDATE_RX_SELECT:

      if (gl_RxSymbolCount == 0)
      {
         //Enable the demodulation of SOC message for diag mode
         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            gft_RxSocMsgDemodFlag = ENABLE_LD_DEMOD_SOC_MSG;

            //At this time, we missed demodulate the first symbol of this state
            //so we have to set the counter properly for the second symbol
            //(note for the HDLC flag, the first symbol should carry bit 0)
            gs_RxNumSocBitPerByte = 0;
            guc_RxSocByte = 0;
            gs_SegueSymCntPerBit = 0;
            gs_SymCntPerBit = 1;

            //If all the five symbols (per bit) have been received, set the count for decoding next bit
            if(gs_SymCntPerBit == gus_NumSymbolsPerBit)
            {
               //Update the number of bits received for the current byte
               gs_RxNumSocBitPerByte++;
               gs_SymCntPerBit = 0;
            }
         } //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)

         // indicate RX side is out of PERIODIC2 state
         gs_TxRxMessaging = 10;
      }
      // wait enough to avoid glitch from periodic to non-periodic transition
      else if (gl_RxSymbolCount == 80)
      {
         gs_RxSubState = R_O_TA_UPDATE_RX_PLL_RELOCK;
         gs_RxSubStateCnt = 0;
      }

      break;

   case R_O_TA_UPDATE_RX_PLL_RELOCK:

      if (gs_RxSubStateCnt == 0)
      {
         // RESET REFERENCE IN PERIODIC
         //if(gs_PeriodicPllDisable == 1)
         {
            if(gft_EnablePLL == FALSE)
            {
               gft_EnablePLL = TRUE;
               // XDSLRTFW-1181: BugFix_DS_VDSL2_All_VecDSRateRunToRunVariation (Start/End)
               // XDSLRTFW-1506 (Start_ End)
               if(!(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_SKIP_PLL_O_TA_Update))
               {
                  // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
                  // Set new Pll Reference for all 3 supported pilot tones.
                  ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );
               }
               else
               {
                  // indicate RX side is ready to decode O_TA_UPDATE
                  gs_TxRxMessaging = 11;
                  gs_RxSubState = R_O_TA_UPDATE_RX_INIT;
               }
            }
         }
      }

      if (gs_RxSubStateCnt == gs_NumFramesPLLRelock)
      {
         // indicate RX side is ready to decode O_TA_UPDATE
         gs_TxRxMessaging = 11;
         gs_RxSubState = R_O_TA_UPDATE_RX_INIT;
      }

      gs_RxSubStateCnt++;
      break;


      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_TA_UPDATE_RX_INIT:

      //Set the message code (expected message)
      guc_NumberOfPossibleRxMsgs = 2;
      guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_TA_UPDATE;
      guca_PossibleRxMsgCodes[1] = (uint8)SOC_MSG_REPEAT_REQUEST;

      //Initialize to the first substate in RxHDLCMsgHandler()
      gs_RxHDLCMsgState = 0;

      //Init. a timer
      gul_RxTimer = 0;

      //go to next substate
      gs_RxSubState = R_O_TA_UPDATE_RX_DEMODULATE_MSG;

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_TA_UPDATE_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {
            //If SOC_MSG_REPEAT_REQUEST is received, instruct the TX side to retransmit this message
            if(guc_RxMsgCode == SOC_MSG_REPEAT_REQUEST)
            {
               gs_TxNextState = VDSL2_R_TA_UPDATE_TX;
               gpF_TxStateFunc = (PtrToFunc)RPTrain2TxF_VDSL2;
               gft_TxStateInitFlag = TRUE;

               if(gs_TxNextState == gs_TxState)
               {
                  gs_TxState = SAME_STATE;
               }

               //set the RX to go to the first substate to receive R-Update again
               gs_RxSubState = R_O_TA_UPDATE_RX_INIT;
            }
            else //if(guc_RxMsgCode ==VDSL2_SOC_MSG_O_TA_UPDATE)
            {
               gs_RxSubStateCnt = 0;
               //#ifdef MTK_VECTORING_SUPPORT
               if (gft_DSVectoringEnabled == TRUE)
               {
                  gs_RxSubState =  R_O_TA_UPDATE_RX_CODESWAP_ALGHD_2;
               }
               else
               {
                  gs_RxSubState = R_O_TA_UPDATE_RX_EXIT;
                  if (gs_MedleyFrameSynchEnableFlag & EN_TTRAINING_FDQ_END)
                  {
                     // Train FDQ
                     gs_AlgHandlerState = FDQ_TRAIN_INIT;
                     gt_FdqConfig.s_AlgLog2NumFramesToAccum = guc_NumFramesToAccumTrainingEnd;
                     gs_FDQTrainTypeCntrlFlag = FDQ_TRAIN_TYPE_MEDLEY_ONEPASS;

                     gs_RxSubState = R_O_TA_UPDATE_RX_MSG_FDQ;
                  }
               }
               //#endif
            }
         }
         else //If the message received incorrect
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_O_TA_UPDATE_FAIL);
         }
      }

      if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
      {
         if((gul_RxTimer != 0xFFFFFFFF) && (gul_RxTimer >= TIMEOUT_CNT_TWO_SECONDS))
         {
            //Send the repeat request if desired
            if(gs_NumTxRepeatRequest < NUM_TX_REPEAT_REQUEST)
            {
               gs_NumTxRepeatRequest++;

               //go to the next TX state to send REPEAT_REQUEST
               gs_TxNextState = VDSL2_R_REPEAT_REQUEST_TX;
               gpF_TxStateFunc = (PtrToFunc)RPTrain2TxF_VDSL2;
               gft_TxStateInitFlag = TRUE;

               // In the case of gs_TxNextState = gs_TxState, we need to do the following reset here
               gl_TxSymbolCount = 0;
               gs_TxSubState = 0;
               gs_TxSubStateCnt = 0;
            }
            else //Check timeout
            {
               //go to fail state
               CheckTimeout(gul_RxTimer, TIMEOUT_CNT_TWO_SECONDS, E_CODE_RX_STATE_TIMEOUT);
            }
         }
      }
      break;

//#ifdef MTK_VECTORING_SUPPORT
   case R_O_TA_UPDATE_RX_CODESWAP_ALGHD_2:
      /* =============================================== */
      /* wait for codeswap */
      /* =============================================== */
      // load coad swap page for DetectDSSync_Vector_Handler
      FreeSwapHandle(&guc_PrimPageHandle);
      guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE);

      gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB_INIT;
      if (TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_VEC_RESYNC_CALC)
      {
         gs_VectorHandlerState = VECTOR_DECODESYNCH_DONE;
      }
      gs_RxSubState = R_O_TA_UPDATE_RX_DEMODULATE_DS_SYNCSYMB_INIT1;
      break;

   case R_O_TA_UPDATE_RX_DEMODULATE_DS_SYNCSYMB_INIT1:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         if (gs_VectorHandlerState != VECTOR_DECODESYNCH_DONE)
         {
            DetectDSSync_Vector_Handler();   // Synchronize Tx/Rx frame counter during O-P training 2
         }
         else
         {
            if (TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_VEC_RESYNC_CALC)
            {
               VectoringReSyncFrameCntCalc();
            }
            // swap ALGHD1 page
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);

            gs_VectorHandlerState = 0;

            gs_RxSubState = R_O_TA_UPDATE_RX_EXIT;
            if (gs_MedleyFrameSynchEnableFlag & EN_TTRAINING_FDQ_END)
            {
               // Train FDQ
               gs_AlgHandlerState = FDQ_TRAIN_INIT;
               gt_FdqConfig.s_AlgLog2NumFramesToAccum = guc_NumFramesToAccumTrainingEnd;

               gs_FDQTrainTypeCntrlFlag = FDQ_TRAIN_TYPE_MEDLEY_ONEPASS;
               gs_RxSubState = R_O_TA_UPDATE_RX_MSG_FDQ;
            }
         }
      }
      break;
//#endif


   case R_O_TA_UPDATE_RX_MSG_FDQ:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
#if defined(ANXQ_35BLITE_PAUSE_DEBUG) || defined(VRX518_BRINGUP_DEBUG)
         // Before FDQ Handler in ROTaUpdate
         if (gs_PauseControl == 0x301)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // ANXQ_35BLITE_PAUSE_DEBUG

         if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
         {
            FdqHandler();
         }
         else
         {
            //go to substate to compute SNR
            gt_SnrConfig.s_AlgLog2NumFramesToAccum = guc_NumFramesToAccumTrainingEnd;
            gpsa_MeasuredSnrBuf = gsa_SnrBuf;
            gs_AlgHandlerState = SNR_INIT;
            if (guc_SkipSnrTrainingEnd)
            {
               gs_AlgHandlerState = SNR_CALC_DONE;
            }

            gs_RxSubState = R_O_TA_UPDATE_RX_MSG_SNR;
            gs_RxSubStateCnt = 0;
         }
      }
      break;

   case R_O_TA_UPDATE_RX_MSG_SNR:
      if (gs_AlgHandlerState != SNR_CALC_DONE)
      {
         SnrHandler();
      }
      else
      {
#if defined (ANXQ_35BLITE_PAUSE_DEBUG) || defined(VRX518_BRINGUP_DEBUG)
         // At the end of SNR Handler in ROTaUpdate
         if (gs_PauseControl == 0x303)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // ANXQ_35BLITE_PAUSE_DEBUG

         //Set the RX tone offset for capturing tones in RTV buffer
         gs_RxToneOffset = (gs_SelectBandStart+9)/10;
         gs_RxToneOffset *= 10;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         gs_RxSubState = R_O_TA_UPDATE_RX_EXIT;
      }
      break;


   case R_O_TA_UPDATE_RX_EXIT:
      if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
      {
         //go to the next TX state to send R-ACK
         gs_TxNextState = VDSL2_R_ACK_TX;
         gpF_TxStateFunc = (PtrToFunc)RPTrain2TxF_VDSL2;

         //go to the next RX state to receive O-P-Synchro5
         gs_RxNextState = VDSL2_R_O_P_SYNCHRO5_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPSynchro5RxF_VDSL2;

         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            //Disable the message demodulate in RxStateFunc()
            gft_RxSocMsgDemodFlag = DISABLE_LD_DEMOD_SOC_MSG;
         }

         //reset the counts for the next message
         gs_NumRxRepeatRequest = 0;
         gs_NumTxRepeatRequest = 0;
      }
      break;

   } //switch

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }

//#ifdef MTK_VECTORING_SUPPORT
   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_2_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_2_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   case CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_1_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   } // end code swap switch
//#endif //ifdef MTK_VECTORING_SUPPORT
}
