/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROTpsRxF_VDSL2.c
*
*   This file contains the RX state function to receive the O-TPS message
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "SharedFuncs.h"
#include "vdsl_const.h"
#include "cmv.h"
#include "ppe_memmap.h"
#include "LL_IOf.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROTpsRxF_VDSL2
 *
 *  Prototype:  void ROTpsRxF_VDSL2(void)
 *
 *   This is the state function for receiving O-TPS symbols.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_TPS_RX_INIT               (0)
#define R_O_TPS_RX_DEMODULATE_MSG      (1)

void ROTpsRxF_VDSL2(void)
{
   uint32 ul_data, ul_addr;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_MEDLEY;
   gsa_IndirectStat0[2]=VDSL2_R_O_TPS;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_RxSubState)
   {


      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_TPS_RX_INIT:

      //Set the message code (expected message)
      guc_NumberOfPossibleRxMsgs = 2;
      guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_TPS;
      guca_PossibleRxMsgCodes[1] = (uint8)SOC_MSG_REPEAT_REQUEST;

      //Initialize to the first substate in RxHDLCMsgHandler()
      gs_RxHDLCMsgState = 0;

      //Init. a timer
      gul_RxTimer = 0;

      //go to next substate
      gs_RxSubState = R_O_TPS_RX_DEMODULATE_MSG;

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_TPS_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {

            //If SOC_MSG_REPEAT_REQUEST is received, instruct the TX side to retransmit this message
            if(guc_RxMsgCode == SOC_MSG_REPEAT_REQUEST)
            {
               gs_TxNextState = VDSL2_R_MSG2_TX;
               gpF_TxStateFunc = (PtrToFunc)RMedleyMsgTxF_VDSL2;

               if(gs_TxNextState == gs_TxState)
               {
                  gs_TxState = SAME_STATE;
               }

               //set the RX to go to the first substate to receive R-Update again
               gs_RxSubState = R_O_TPS_RX_INIT;

            }
            else //if(guc_RxMsgCode == VDSL2_SOC_MSG_O_TPS)
            {
               //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 (Start)
               //Check for TC Mode Mismatch and fail
               // Also Update the Final TC Mode Supported By Dslam
               if(gus_TcModeUsed_PPE == 0)
               {
                  gus_TcModeUsed_PPE = 0x1; // By Default PTM
               }

               // ACK_TC_StatusGet
               // Reports the used TC-Mode.
               // Supported settings:
               //    0x0 UNKNOWN_TC TC mode is unknown.
               //    0x1 EFM_TC EFM TC
               //    0x2 ATM_TC ATM TC
               gus_DSL_TC_Status = (uint16)gta_DsBearerChanAct[BC0].s_TypeEnabled; // CMD_TC_StatusGet / DSL_TC_STATUS / DSL 14

               // XDSLRTFW-1924 (Start)
               ul_addr = DREG_MISCRAM4_ADDR;
               // The loaded TC driver information is stored in DREG4 register.
               // Bit 0 --> ATM TC driver loaded
               // Bit 1 --> PTM TC driver loaded
               // For more information, refer "PPE DSL Notifications" document
               ReadPpeReg(ul_addr, &ul_data);
               if (ul_data==0)                     // PPA prior to 3.2
               {
                  gus_curr_TC_mode_value = (uint32)gus_TcModeUsed_PPE;
                  if (gus_curr_TC_mode_value == TPS_TC_TYPE_ATM)     // changing the numerical value due to mismatch between the standard and ppe in ppa 3.2
                  {
                     gus_curr_TC_mode_value = DREG_MISCRAM4_ATM;
                  }
                  else if (gus_curr_TC_mode_value == TPS_TC_TYPE_PTM)    // changing the numerical value due to mismatch between the standard and ppe in ppa 3.2
                  {
                     gus_curr_TC_mode_value = DREG_MISCRAM4_PTM;
                  }
               }
               else
               {
                  gus_curr_TC_mode_value= ul_data & (MASK_BIT0 | MASK_BIT1);     // If PPA 3.2 is used, then use the value in the register for TC Mode
               }
               // XDSLRTFW-1924 (End)

               // Bit 0 of "DREG_MISCRAM6_ADDR" is used by the PPE FW to inform the DSL FW that, Framer request can be turned on.
               // The DSL FW needs to check both TC MODE loaded and the status of the below register. Only if the required TC driver
               // is loaded and the Bit 0 (FRAMER_REQUEST_ENABLED) in the register is set, DSL FW should proceed further otherwise, we need to drop the link.
               // Bit definition of 0X7DC6 (DREG_MISCRAM6_ADDR):
               //  Bit 0      --> Framer Request Enable (Set by the PPE driver and cleared by DSL FW)
               //  Bit 1      --> Dynamic Frequency supported (Set by the PPE driver and cleared by DSL FW)
               ul_addr = DREG_MISCRAM6_ADDR;
               ReadPpeReg(ul_addr, &ul_data);

               if (((gus_curr_TC_mode_value == DREG_MISCRAM4_ATM) && (gus_DSL_TC_Status == TPS_TC_TYPE_ATM)) ||   // ATM
                   ((gus_curr_TC_mode_value == DREG_MISCRAM4_PTM) && (gus_DSL_TC_Status == TPS_TC_TYPE_PTM)) &&   // PTM
                   ((ul_data & 0x1) == 1))
               {
                  gs_TxNextState = VDSL2_R_TPS_ACK_TX;
                  gpF_TxStateFunc = (PtrToFunc)RMedleyMsgTxF_VDSL2;

                  gs_RxNextState = VDSL2_R_O_PMS_RX;
                  gpF_RxStateFunc = (PtrToFunc)ROPmsRxF_VDSL2;

                  //reset the counts for the next message
                  gs_NumRxRepeatRequest = 0;
                  gs_NumTxRepeatRequest = 0;

                  // XDSLRTFW-3711 (Start)
                  // If the BIT 1 of 0x7DCE is set, we can say that PPE frequency scaling feature is
                  // supported by the PPE driver.
                  // The configured PPE frequency can be read from the register 0x7DCE.
                  // Please refer MCAT 3.1 for the values for the values of INFO 244.
                  // Bit defintion of DREG register 0x7DCE (DREG_MISCRAM14_ADDR):
                  //       Value (Bit1 - Bit0)                 PPE Frequency
                  //             0                                576 MHz
                  //             1                                494 MHz
                  //             2                                432 MHz
                  //             3                                288 MHz
                  if (ul_data & MASK_BIT1)
                  {
                     ul_addr = DREG_MISCRAM14_ADDR;
                     ReadPpeReg(ul_addr, &ul_data);

                     gus_PPEClock_Configured = (ul_data & PPE_CLOCK_FREQ_MASK) + 1;
                  }
                  else
                  {
                     // If the BIT 1 of 0x7DCE is not set, we can say that PPE frequency scaling feature
                     // is not supported the PPE driver (old driver).
                     // The configured PPE frequency is always 576 MHz.
                     gus_PPEClock_Configured = PPE_CLOCK_576MHz;
                  }
                  // XDSLRTFW-3711 (End)
               }
               else
               {
                  // DSL FW should clear below location to 0 to notify the PPE FW about the Framer Request stop.
                  ul_data = ul_data & 0xFFFE;
                  WriteCoreReg(DREG_MISCRAM6_ADDR,ul_data);
                  EnterFailStates(E_CODE_PPE_MISS_MATCH);
               }
               //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 (End)
            }
         }
         else //If the message received incorrect
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_O_TPS_FAIL);
         }
      }

      //Check if the RX timeout
      MedleyMsgCheckRxTimer();

      break;
   }

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }

}

