/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROTrainingRxF_VDSL2.c
*
*   This file contains RT's R_O_TRAIN_RX state machine (VDSL2).
*
*-------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// ROTrainingRxF_VDSL2.c
//
// History
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
// 19/09/2013 Abu: Change Slow and fast PLL settings to default VDSL2 values
//                 Grep for XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate
// 19/09/2013 Fuss: Global timeout clean-up for vectoring
//                  Grep for XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts
// 28/01/2014 Fuss: Added fix to reach 2800m noise free and added debug code
//                  Grep for XDSLRTFW-1506: No sync in vectoring mode on loops >1600m (US0 only).
// 08/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//                   Grep for XDSLRTFW-1901
// 10/03/2015 Fuss: Added fix for ChannelDiscovery - FDQ is also done on upstream tones
//                  Grep for XDSLRTFW-2240
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "PGAHandler.h"
#include "PsdHandler.h"
#include "FrameAlignmentHandler.h"
#include "FdqHandler.h"
#include "SnrHandler.h"
#include "SelectPilot.h"
#include "ROTrainingRxF.h"
#include "BgComputeQln.h"
#include "SharedFuncs.h"
#include "vdsl_state.h"
#include "vdsl_xception.h"
#include "IRI_Iof.h"
#include "V_STR_IOf.h"
#include "ROPVECTOR1Handler.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "AFED_Functions.h"
#ifdef VRX518_BRINGUP_DEBUG
#include "profile.h"
#endif
#include "Psd_b.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ROTrainRxF_VDSL2(void)
*
*   This function contains three Rx states
*      i. R_O_P_QUITE1_RX            (169)  : contains O-P Quite 1 related code
*     ii. VDSL2_R_O_P_VECTOR1_RX     (180)  : contains O-P Vector1 related code
*    iii. R_O_TRAIN_RX               (20)   : contains non echo related (partial) O-P Channel discovery V1 ( for vectoring) or
*                                             O-P Channel discovery 1 ( for non vectoring)code
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

// Sub state definations for R_O_P_QUITE1_RX ( O-P Quite 1 state)
#define R_O_P_QUITE1_RX_INIT                          (0)
#define R_O_P_QUITE1_RX_SET_PGA_QLN_PSD_MAX_PGA       (1)
#define R_O_P_QUITE1_RX_MEASURE_QLN_PSD_MAX_PGA       (2)
#define R_O_P_QUITE1_RX_SET_PGA_QLN_PSD_MIN_PGA       (3)
#define R_O_P_QUITE1_RX_MEASURE_QLN_PSD_MIN_PGA       (4)
#define R_O_P_QUITE1_RX_SET_GHS_PGA                   (5)
#define R_O_P_QUITE1_RX_COMPUTE_QLN                   (6)
#define R_O_P_QUITE1_RX_EXIT_O_P_QUITE1               (7)

// Sub state definations for VDSL2_R_O_P_VECTOR1_RX ( O-P Vector 1 State)
#define R_O_P_VECTOR1_RX_ENTRY_DETECTION              (0)
#define R_O_P_VECTOR1_RX_EXIT_DETECTION               (1)

// Sub state definations for R_O_TRAIN_RX  ( O-P Channel Discovery (V)1 state)
#define R_O_TRAIN_RX_PGA_INIT                         (0)
#define R_O_TRAIN_RX_CALCULATE_ECHO_OFF_PGA           (1)
#define R_O_TRAIN_RX_MEASURE_PSD_BASED_SNR            (2)
#define R_O_TRAIN_RX_WAIT_SELECT_PILOT                (3)
#define R_O_TRAIN_RX_SEARCH_GOOD_SYMBOL               (4)
#define R_O_TRAIN_RX_INITIAL_PLL                      (5)
#define R_O_TRAIN_RX_FRAME_ALIGNMENT                  (6)
#define R_O_TRAIN_RX_TRAIN_FDQ                        (7)
#define R_O_TRAIN_RX_MEASURE_ECHO_OFF_PSD             (8)
#define R_O_TRAIN_RX_CALCULATE_ECHO_OFF_SNR           (9)

#define R_O_TRAIN_RX_DONE                             (-1)

void ROTrainRxF_VDSL2(void)
{
   signed int i;

   // R_O_P_QUITE1_RX state start
   if(gs_RxState == R_O_P_QUITE1_RX)
   {

//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[3]=VDSL2_R_O_P_QUIET1;
      switch (gs_RxSubState)
      {
      case R_O_P_QUITE1_RX_INIT:

         if (gl_RxSymbolCount == 0)
         {

            //Map the CMV to the off chip SREM buffer
            if(TESTArray[TEST_StoreSramControl] & TEST_SAVE_DISC_EchoOn_PSD_ENABLE)
            {
               INFOMap[INFO_PsdBuf] = &gsa_DiscPsdBuf_EchoOn[0];
            }

            // Reduce algorithm training lengths for channel discovery phase to reduce training time
            gt_FdqConfig.s_AlgLog2NumFramesToAccum -= 1;       // LOG2_NUM_FDQ_TRAINING_SYMBOLS-1;     // currently 8-1=7
            gt_SnrConfig.s_AlgLog2NumFramesToAccum -= 1;       // LOG2_NUM_SNR_TRAINING_SYMBOLS-1;     // currently 8-1=7
            gt_PsdConfig.s_AlgLog2NumFramesToAccum -= 1;       // LOG2_NUM_PSD_TRAINING_SYMBOLS-1;     // currently 8-1=7

            // log start of Channel Discovery phase
            gpt_DebugTiming->l_RxROTrain_Start = gl_TotalTxSymbolCount;

#ifdef ENABLE_VR9_HW_ERR_CNT
            //Log the core error counts during the train phase
            //and reset the current counts for logging the core error counts during Medley
            if(gft_EnableCoreErrorCheck)
            {
               if(gft_IncludeGhsInTrain == FALSE)
               {
                  memset(gsa_StrymonOverflowCnt, 0, (sizeof(int16)*17));
                  memset(gusa_FTOverflowCnt, 0, (sizeof(int16)*2));
                  memset(gsa_TxQTErrorCnt, 0, (sizeof(int16)*4));
                  memset(gsa_RxQTErrorCnt, 0, (sizeof(int16)*4));
               }
            }
#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

         } //if (gl_RxSymbolCount == 0)

         // Wait for TX side to be in R_MSG1_TX before
         // requesting TRAIN 1B swap page. Otherwise, TRAIN 1B
         // could overwrite HS page if for some reason the TX side
         // hasn't transitioned into R_MSG1_TX.
         if (gs_TxState == R_P_QUITE1_TX)
         {
            FreeSwapHandle(&guc_PrimPageHandle);
            guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);

            // Enable GetRxTones in RxProcessTones fcn
            gft_EnableGetRxTones = TRUE;

            // Configure HW
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, InitTrainRxF);

            // Set RTV selection to FFT output
            gs_RtvSelect = FFT_OUTPUT;

            // prepare for PGAHandler call
            gs_PgaHandlerState = PGA_INIT;

            //Set the RX AFE HPF to bypass mode if desired
            gft_BypassRxAFE_HPF = gft_EnableBypassRxAFE_HPF;  //FALSE

            // force RxVarGain to unity for QLN measurement
            gft_UnityRxVarGain = 1;

            gs_RxSubState = R_O_P_QUITE1_RX_SET_PGA_QLN_PSD_MAX_PGA;

#ifdef DEBUG_VRX518_AFE  //0x5103
            if(gs_PauseControl == 0x5103)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif
         }

         break;

      case R_O_P_QUITE1_RX_SET_PGA_QLN_PSD_MAX_PGA:

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            // Set PGA as high as possible for QLN computation to reduce quantization effects
            // Run PGA handler instead of using MAX_PGA to avoid clipping in the presence of cross-talk
            if (gs_PgaHandlerState != PGA_DONE)
            {
               PGAHandler();
            }
            else
            {
               // save PGA setting for QLN computation
               gs_PGA_set_Qln = gs_PGA_set;
               gs_RxVarGainDB_Qln = gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB;
               gs_HybridGain_Qln = gs_HybridGain;
               // restore normal RxVarGain computation
               gft_UnityRxVarGain = 0;

               // Prepare for PSD calculation for QLN measurement with MAX-PGA, i.e.
               // PGA as high as possible to reduce quantization effect
               // - "gsa_SnrBuf" is used to store QLN-PSD
               gs_AlgHandlerState = PSD_INIT;
               gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
               // save original AlgLog2NumFramesToAccum
               gs_PsdAlgLog2NumFramesToAccum_Saved = gt_PsdConfig.s_AlgLog2NumFramesToAccum;
               // set the number of symbols used to compute QLN
               // -   4 symbols for regular mode and
               // - 256 symbols for diag. mode
               gt_PsdConfig.s_AlgLog2NumFramesToAccum = gs_Log2NumSymbolsToMeasureQln;
               gpsa_MeasuredSnrBuf = gsa_SnrBuf;

               gs_RxSubState = R_O_P_QUITE1_RX_MEASURE_QLN_PSD_MAX_PGA;

#ifdef DEBUG_VRX518_AFE  //0x5106
               if(gs_PauseControl == 0x5106)
               {
                  gft_PauseOff = 0;
                  Pause(gs_PauseControl);
               }
#endif
            }
         }
         break;

      case R_O_P_QUITE1_RX_MEASURE_QLN_PSD_MAX_PGA:

         if (gs_AlgHandlerState != PSD_CALC_DONE)
         {
            PsdHandler();
         }
         else
         {
            if (gft_EnableProposedCeilingOpt)
            {
               // Set to min pga while computing Qln noise to best see ADC noise.
               // Rx var gain is 0 dB
               gs_PGA_required = MIN_PGA;

               guc_PgaState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting); //Since PGA1 and PGA2 no special handling required here

               gs_RxSubState = R_O_P_QUITE1_RX_SET_PGA_QLN_PSD_MIN_PGA;
            }
            else
            {
               gs_RxSubState = R_O_P_QUITE1_RX_SET_GHS_PGA;
            }
         }
         break;

      case R_O_P_QUITE1_RX_SET_PGA_QLN_PSD_MIN_PGA:

         if (guc_PgaState == TRAINING_DONE)
         {
            // Prepare for PSD calculation for ADC noise estimation with "MIN_PGA"
            // - "gsa_CommonMemoryBlock0" buffer is used to store PSD
            //   Note: After measurment the buffer has to be set back to "gsa_SnrBuf".
            gs_AlgHandlerState = PSD_INIT;
            gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
            gpsa_MeasuredSnrBuf = gsa_CommonMemoryBlock0;

            gs_RxSubState = R_O_P_QUITE1_RX_MEASURE_QLN_PSD_MIN_PGA;
         }
         break;

      case R_O_P_QUITE1_RX_MEASURE_QLN_PSD_MIN_PGA:

         if (gs_AlgHandlerState != PSD_CALC_DONE)
         {
            PsdHandler();
         }
         else
         {
            // Change the pointer back to the SNR buffer
            gpsa_MeasuredSnrBuf = gsa_SnrBuf;
            gs_RxSubState = R_O_P_QUITE1_RX_SET_GHS_PGA;
         }
         break;

      case R_O_P_QUITE1_RX_SET_GHS_PGA:

         // log end of QLN measurement
         gpt_DebugTiming->l_RxROTrain_QlnMeasEnd = gl_TotalTxSymbolCount;

         FreeSwapHandle(&guc_PrimPageHandle);
         guc_RxSwapActivity = CODESWAP_LOAD(VDSL_TRAIN_MAIN_PM_SWAPPAGE);

         // Check if Qln PSD computation occured within QUIET length
         if (gl_RxSymbolCount >= gs_MinOPQuiet1StateLength)
         {
            EnterFailStates(E_CODE_QUIET_PSD_COMPUTE_FAIL);
         }
         else
         {
            // restore original AlgLog2NumFramesToAccum
            gt_PsdConfig.s_AlgLog2NumFramesToAccum = gs_PsdAlgLog2NumFramesToAccum_Saved;

            // Set PGA
            // This code is needed for vectoring!
            // Note: At this place the PGA/Prefi Gain is equal to
            //       - PSD_MIN_PGA Qln (if (gft_EnableProposedCeilingOpt)) or
            //       - PSD_Max_PGA Qln.
            //       That means to very high values or very low values!
            if((gft_DSVectoringEnabled == TRUE) || (gft_BypassPGATrain == TRUE))
            {
               //XDSLRTFW-3613 Start
               int16 s_HybGainDiff;

               //The fix from Jira XDSLRTFW-1506 is corrected for VRx518 HW!
               //Set the PGA used for OP-Vector1 detection to the PGA value used in GHS.
               //But at this point the special QLN hybrid is used and GHS PGA was derived with some Hyb settings
               //We have to take the difference of Hyb gains of GHS and special QLN hybrid and adjust accordingly
               //Add Hyb gain diff = GHS Hyb Gain - QLN Hyb gain
               s_HybGainDiff = gusa_HybridSettingV2_Handshake_VRX518[VRX518_HYBGAIN_IDX] - gusa_HybridSettingV2_QlnHlog_VRX518[VRX518_HYBGAIN_IDX];
               guc_PgaState = TRAINING_IN_PROGRESS;
               AFED_ReUsePgaPrefiGains(s_HybGainDiff);
               //XDSLRTFW-3613 End
            }
            gs_RxSubState = R_O_P_QUITE1_RX_COMPUTE_QLN;
         }
         break;

      case R_O_P_QUITE1_RX_COMPUTE_QLN: // wait for swap to complete

         if (guc_PgaState == TRAINING_DONE)
         {

#ifdef DEBUG_VRX518_AFE  //0x5104
            if(gs_PauseControl == 0x5104)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif

            // Compute Qln in the correct format
            // Note: QLN should be done always for all tones!
            // Output:
            //  - guca_QLN[512] dBm/Hz
            //  - guca_QLN_tmp[1024] dBm/Hz used for QuieteLineNoiseLevel in Upstream Bands
            //  - if "gft_EnableProposedCeilingOpt = TRUE"
            //       gpsa_MedleyTempFDQCoeffs = gpsa_DILVB_SharedMemory is -> gula_PackedSRCCoeffs used for ADC noise PSD.
            //  - if "gft_EnableRxPathCorrection = TRUE"
            //       gsa_ELE_Tmp[8192] used for RxPath compensation vector, i.e. per tone
            //       gsa_CommonMemoryBlock used for QLN compensated with RxPath vector
            guc_QlnCalcState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgComputeQln);

            //Store the near-end (NE) QLN measurement time
            gt_ChannelMeasurement_NE.us_QlnMT = (1<<gs_Log2NumSymbolsToMeasureQln);

            // XDSLRTFW-3344 (Start)
            if (gft_Swap_HLog_QLN_Offchip == TRUE)
            {
               DMAtoSDRAM_PerTone(QLN_PERTONE);
            }
            // XDSLRTFW-3344 (End)
            {
               //go to next substate
               gs_RxSubState = R_O_P_QUITE1_RX_EXIT_O_P_QUITE1;
            }
         }
         break;

      case R_O_P_QUITE1_RX_EXIT_O_P_QUITE1:
         // Do not attempt to detect signal tone set since we do not
         // have intelligence in DetectSignalHandler() to perform
         // this w/o knowing the DS band info. Instead wait for max
         // O-P-QUIET length before proceeding

         // Wait for the Qln computation to finish
         if (guc_QlnCalcState == TRAINING_DONE)
         {
            if(gft_DSVectoringEnabled == TRUE)
            {
               if (gl_RxSymbolCount >= gs_MaxOPQuiet1StateLength)
               {
                  // log start of O-SIGNATURE idle detection
                  gpt_DebugTiming->l_RxROTrain_IdleStart = gl_TotalTxSymbolCount;

                  //swap R_O_P_vector1 code
                  FreeSwapHandle(&guc_PrimPageHandle);
                  guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE);

                  // Set RTV selection to HW_ACCUM_POW
                  gs_RtvSelect = FFT_OUTPUT ;
                  gs_VectorHandlerState = R_O_P_VECTOR1_INIT;

                  //   go to O-P Vector 1 State
                  gs_RxNextState = VDSL2_R_O_P_VECTOR1_RX;
                  // During state change sub state will initialize to zero and the code
                  // will go to R_O_P_VECTOR1_RX_ENTRY_DETECTION sub state
//                gs_RxSubState = R_O_P_VECTOR1_RX_ENTRY_DETECTION;
               }
            }
            else
            {
               // Wait for an additional gs_DetectDelay symbols just to assure that CO is
               // indeed out of QUIET and has started transmitting O-Signature
               if (gl_RxSymbolCount >= (gs_MaxOPQuiet1StateLength+gs_DetectDelay))
               {
                  // log start of O-SIGNATURE idle detection
                  gpt_DebugTiming->l_RxROTrain_IdleStart = gl_TotalTxSymbolCount;

                  // go to O-P Channel Discovery 1 State
                  gs_RxNextState = R_O_TRAIN_RX;
                  // During state change sub state will initialize to zero and the code
                  // will go to R_O_TRAIN_RX_PGA_INIT sub state to train PGA
//                gs_RxSubState = R_O_TRAIN_RX_PGA_INIT;
               }
            }

#ifdef DEBUG_VRX518_AFE  //0x5107
            if(gs_PauseControl == 0x5107)
            {
               gft_PauseOff = 0;
               Pause(gs_PauseControl);
            }
#endif
         }
         break;
      } // end switch for R_O_P_QUITE1_RX
   } // end of R_O_P_QUITE1_RX state
   else if(gs_RxState == VDSL2_R_O_P_VECTOR1_RX) // // VDSL2_R_O_P_VECTOR1_RX Rx state start
   {
      switch (gs_RxSubState)
      {
      case R_O_P_VECTOR1_RX_ENTRY_DETECTION:

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            if (gl_RxSymbolCount >= (gs_MaxOPQuiet1StateLength))
            {
               if (gs_VectorHandlerState != R_O_P_VECTOR_1_X_DETECTED)
               {
                  ROPVector1Detector();
               }
               else
               {
                  // Set RTV selection to HW_ACCUM_POW
                  gs_RtvSelect = FFT_OUTPUT ;
                  gs_VectorHandlerState = R_O_P_VECTOR1_INIT;
                  gs_RxSubState = R_O_P_VECTOR1_RX_EXIT_DETECTION;
               }
            }
         }
         break;

      case R_O_P_VECTOR1_RX_EXIT_DETECTION:

         if (gl_RxSymbolCount >= (gs_MaxOPQuiet1StateLength))
         {
            if (gs_VectorHandlerState != R_O_P_VECTOR_1_X_DETECTED)
            {
               ROPVector1Handler();
            }
            else
            {
               // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
               // Switch global state timout after OP-Vector1
               // Note:
               //       1) It is not possible to set the value here directly since
               //          it is lower than the previous one. So the timeout check
               //          in RxForeGround would directly kick in.
               //       2) guc_SwitchGlobalTimeout must be initialized to zero
               guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_RX;

               //DSM_Vectoring_Debug:
//                  if(gs_PauseControl == 0x5B)
//                     Pause(gs_PauseControl);

               // done with O_P_VECTOR1, continue with rest of the processing for ROTrain,
               // swap ALGHD1 page
               FreeSwapHandle(&guc_PrimPageHandle);
               guc_RxSwapActivity = CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE);

               // go to O-P Channel Discovery V1 State ( this is similar to non vectoring O-P channel Discovery 1 state)
               gs_RxNextState = R_O_TRAIN_RX;
               // During state change sub state will initialize to zero and the code
               // will go to R_O_TRAIN_RX_PGA_INIT sub state to train PGA
//                gs_RxSubState = R_O_TRAIN_RX_PGA_INIT;
            }
         }
         break;
      }// end switch for VDSL2_R_O_P_VECTOR1_RX
   } // end of VDSL2_R_O_P_VECTOR1_RX Rx state
   else if(gs_RxState == R_O_TRAIN_RX)    // R_O_TRAIN_RX rx State start
   {
      switch (gs_RxSubState)
      {
         // Here OP Channel Discovery V1 (for vectoring) or OP Channel Discovery1 (for non vectoring) state starts
      case R_O_TRAIN_RX_PGA_INIT:

         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timout from OP_VECTOR1_STATE_TIMEOUT_LEN back
         // to normal VECTORING_STATE_TIMEOUT_LEN.
         // Note: This code is only active for Vectoring!
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_RX)
         {
            gl_RxStateTimeOutCount = VECTORING_STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_RX);
         }

         if (guc_RxSwapActivity == CODESWAP_DO_NOTHING)
         {
            // this is same as R-P_CHANNELDISCOVER V1 state
            //Go to substate to train the PGA
            // Set RTV selection to FFT_OUTPUT
            gs_RtvSelect = FFT_OUTPUT;

            gs_PgaHandlerState = PGA_INIT;

            gs_RxSubState = R_O_TRAIN_RX_CALCULATE_ECHO_OFF_PGA;
         }
         break;

      case R_O_TRAIN_RX_CALCULATE_ECHO_OFF_PGA:

         if (gs_PgaHandlerState != PGA_DONE)
         {
            PGAHandler();
         }
         else
         {
            // Save PGA settings

            gs_Stored_AGC1_Gain_Set = gs_AGC1_Gain_Set; //PGA gain     //XDSLRTFW-3613 Start
            gs_Stored_AGC2_Gain_Set = gs_AGC2_Gain_Set; // PREFI gain //XDSLRTFW-3613 End
            gs_RxVarGainDB_NoEcho = gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB;

            // Initialize vars for PSD-SNR
            // - "gsa_SnrBuf" is used to store PSD-SNR, i.e. PSD_SNR = Signal_PSD - Noise_PSD
            //   Note: This SNR compution is done in-place in the "gsa_SnrBuf".
            {
               gs_AlgHandlerState = PSD_INIT;
               gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_ADDMSRDBUFF_AND_INC;
//               gs_PsdAlgLog2NumFramesToAccum_Saved = gt_PsdConfig.s_AlgLog2NumFramesToAccum;
               // XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)
               // - 256 frame accumulation for better pilot1 estimation at long loops
//               gt_PsdConfig.s_AlgLog2NumFramesToAccum = 8;
               gpsa_MeasuredSnrBuf = gsa_SnrBuf;
            }

            // Prepare "gsa_SnrBuf" content for in-place PSD-SNR compution.
            // - Invert Qln PSD so that the in-place accumulation can be done, i.e.
            //   so that this value can be added to signal PSD to get SNR.
            // - scale Qln PSD to actual PGA with RX Signal only
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAdjustQlnForPga);

            gs_RxSubState = R_O_TRAIN_RX_MEASURE_PSD_BASED_SNR;
         }
         break;

      case R_O_TRAIN_RX_MEASURE_PSD_BASED_SNR:

         if(gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            if (gs_AlgHandlerState != PSD_CALC_DONE)
            {
               PsdHandler();
            }
            else
            {

#ifdef VRX518_BRINGUP_DEBUG
               if (gul_dbg_LogControl & CD_REV_SNR_ECHO_OFF_POST_PGA1)
               {
                  gul_dbg_LogControl_Status |= CD_REV_SNR_ECHO_OFF_POST_PGA1;
                  memcpy(gsa_StVectoringBuffer, gpsa_MeasuredSnrBuf, sizeof(int16)*RX_MAX_NUM_TONES);
               }
#endif
               // restore original AlgLog2NumFramesToAccum
//               gt_PsdConfig.s_AlgLog2NumFramesToAccum = gs_PsdAlgLog2NumFramesToAccum_Saved;

               //Select pilot tone
               gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectPilot);

               gs_RxSubState = R_O_TRAIN_RX_WAIT_SELECT_PILOT;
            }
         }
         break;

      case R_O_TRAIN_RX_WAIT_SELECT_PILOT:
         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         if(gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            if (gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx == 0)
            {
               EnterFailStates(E_CODE_PILOT_TONE_SELECTION_FAIL);
            }

            // Configure h/w to grab new pilot tone
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxPilotToneIndex);

            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_O_TRAIN_RX_INITIAL_PLL;
         }
         break;

      case R_O_TRAIN_RX_INITIAL_PLL:

         gs_RxSubStateCnt++;
         if (gs_RxSubStateCnt == 3) // Wait for SetRxPilotTone to take effect
         {
            // Set new Pll Reference for all 3 supported pilot tones.
            ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );

            // Set PLL loop filter parameters to Fast converge.
            ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_QUARTER_PI_RADIANS);
            /* Turn on PLL. */
            gft_EnablePLL  = TRUE;
            DSH_SendStream(DSH_PILOT_TONE_ARRAY,sizeof(gt_PilotConfig),&gt_PilotConfig.s_NumPilotTones);
         }
         // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (Start)
         else if((gs_NumFramesSlowPLLStabilization_ChDiscV1 != -1) && (gs_RxSubStateCnt == gs_NumFramesFastPLLStabilization_ChDiscV1)) // Wait for PLL to stabilize
         {
            // Ignore Slow PLL adaptation in case gs_NumFramesSlowPLLStabilization_ChDiscV1 = -1
            // At Non Vectoring cases, gs_NumFramesSlowPLLStabilization_ChDiscV1 initializes to -1

            // switch PLL coefficients for Slow adaptation to adapt lower steady-state noise
            ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
            ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS/gs_PhaseErrorThresholdConstant);
         }
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
         else if (gs_RxSubStateCnt > (gs_NumFramesFastPLLStabilization_ChDiscV1 + gs_NumFramesSlowPLLStabilization_ChDiscV1) ) // Wait for PLL to stabilize
         {
            // In case of gs_NumFramesSlowPLLStabilization_ChDiscV1 = -1, FW will skip ResetPLL for Slow adaptation
            // and code will come to this section when "gs_RxSubStateCnt = gs_NumFramesFastPLLStabilization_ChDiscV1"
            // XDSLRTFW-1182: Bugfix_US_VDSL2_ALL_LowUsRate (End)

            // proceed to frame alignment
            gs_AlgHandlerState = FRAMEALIGNMENT_SELECT_TONES;
            gs_RxSubState = R_O_TRAIN_RX_FRAME_ALIGNMENT;
         }

         break;

      case R_O_TRAIN_RX_FRAME_ALIGNMENT:

         if (gs_AlgHandlerState != FRAMEALIGNMENT_DONE)
         {
            FrameAlignmentHandler();
         }
         else
         {
#ifdef LOG_FA_DEBUG_INFO
            // save frame alignment debug info
            gs_ToneSelect_FA_ChDisc = gs_SelectBandStart;
            gs_NumCluster_FA_ChDisc = gs_NumFrameAlignClusters;
            gs_CumulativeAlignmentOffset_ChDisc = gs_CumulativeAlignmentOffset;
            gs_FrameAlignIteration_ChDisc = gs_FrameAlignIteration;
            {
               int16 s_CopyLength;

               s_CopyLength = gs_FrameAlignIteration;
               if (s_CopyLength > MAX_NUM_FRAME_ALIGN_ITERATIONS)
               {
                  s_CopyLength = MAX_NUM_FRAME_ALIGN_ITERATIONS;
               }
               memcpy(gsa_FrameAlignOffsets_ChDisc, gsa_FrameAlignOffsets, sizeof(int16)*s_CopyLength);
               memcpy(gsa_FA_debug_buf_ChDisc, gsa_FA_debug_buf, sizeof(int16)*6*s_CopyLength);
            }
#endif // LOG_FA_DEBUG_INFO

            // In absence of band plan until O_SIGNATURE is recieved, select Rx bandplan
            // using psd based snr to train fdqs. Instead of selecting a new band of tones
            // we use the band selected during frame alignment
            if (gs_dbgSnifferRxToneOffsetControl)
            {
               gs_RxToneOffset = gs_dbgSnifferRxToneOffsetControl;
            }

            // XDSLRTFW-2240 (Start_End)
            // Train FDQ and do the SNR calculation only for the band selected in the "FrameAlignmentHandler()".
            {
               int16 s_NumOfTonesInBand;
               int16 s_LeftChannel;
               int16 s_NumChannelsPerGroup;

               s_NumChannelsPerGroup = gs_NumChannelsPerGroup;
               if(gs_NumChannelsPerGroup > NUM_CHANNELS_PER_GROUP_512)
               {
                  s_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_512;
               }
               s_NumOfTonesInBand = s_NumChannelsPerGroup;
               s_LeftChannel = gs_RxToneOffset;

               // 1) Find band in which gs_RxToneOffset is located
               // 2) Check if 512 tone can be used upto the right band edge
               // 3) If not check if rest of tones are available upto the left band edge
               for(i=0; i < gs_NumOfRxBands; i++)
               {
                  if((gs_RxToneOffset >= gsa_RxBandLeftChannel[i]) &&
                     (gs_RxToneOffset < gsa_RxBandRightChannel[i]))
                  {
                     // right channel calculation
                     s_NumOfTonesInBand = gsa_RxBandRightChannel[i] - gs_RxToneOffset + 1;
                     if(s_NumOfTonesInBand > s_NumChannelsPerGroup)
                     {
                        s_NumOfTonesInBand = s_NumChannelsPerGroup;
                     }
                     // left channel calculation
                     // Note: This code could be removed to speed the training up.
                     if(s_NumOfTonesInBand < s_NumChannelsPerGroup)
                     {
                        s_LeftChannel = gs_RxToneOffset - (s_NumChannelsPerGroup - s_NumOfTonesInBand);
                        if (s_LeftChannel < gsa_RxBandLeftChannel[i])
                        {
                           s_LeftChannel = gsa_RxBandLeftChannel[i];
                        }
                     }
                  }
               }

               // 2) Set left and right band
               gsa_RxBandLeftChannel[0] = s_LeftChannel;
               gsa_RxBandRightChannel[0] = gs_RxToneOffset + s_NumOfTonesInBand - 1;

               // 3) Set number of band
               gs_NumOfTxBands = 0;
               gs_NumOfRxBands = 1;
            }

            // The stuff of "BgReconfigBandPlan" is also done in fct. ConfigTaskLayerForPostGhs(),
            // except the DsBlackoutBands, which are not needed at this point.
            // Pilot tone gets removed directly at the place where the pilot tone gets be set, i.e. void BgSelectPilot(void).
// Could be removed?
//            // The following check prevents memory corruption to happen in BgReconfigBandPlan
//            if (gsa_RxBandRightChannel[0] > gs_RxNumTones-1)
//            {
//               gsa_RxBandRightChannel[0] = gs_RxNumTones-1;
//            }

//            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
//            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReconfigBandPlan);

            //Initialize the states to perform FDQ training
            gs_AlgHandlerState = FDQ_TRAIN_INIT;
            gs_RxSubState = R_O_TRAIN_RX_TRAIN_FDQ;
         }
         break;

      case R_O_TRAIN_RX_TRAIN_FDQ:

//         if(gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            if (gs_AlgHandlerState != FDQ_TRAIN_DONE)
            {
               FdqHandler();
            }
            else
            {

#ifdef SAVE_REVERB_FDQ
               // save Reverb FDQ coefficients
               ReadFdqMant(gsa_ReverbFdqMantissa, 0, gs_RxNumTones);
               ReadFdqExp(guca_ReverbFdqExponent, 0, gs_RxNumTones);
#endif // SAVE_REVERB_FDQ

               if(gus_VdslCntlFlag & BITMAP_ENABLE_MEASURE_ROTRAIN_ECHOOFF_PSD)
               {
                  gs_AlgHandlerState = PSD_INIT;
                  gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
                  gpsa_MeasuredSnrBuf = gsa_SnrBuf; // use gsa_SnrBuf to store PSD
               }
               else
               {
                  gs_AlgHandlerState = PSD_CALC_DONE;
               }

               gs_RxSubState = R_O_TRAIN_RX_MEASURE_ECHO_OFF_PSD;
            }
         }
         break;

      case R_O_TRAIN_RX_MEASURE_ECHO_OFF_PSD:

         if (gs_AlgHandlerState != PSD_CALC_DONE)
         {
            PsdHandler();
         }
         else
         {
            gpsa_MeasuredSnrBuf = gsa_SnrBuf;
            gs_AlgHandlerState = SNR_INIT;

            gs_RxSubState = R_O_TRAIN_RX_CALCULATE_ECHO_OFF_SNR;

         }
         break;

      case R_O_TRAIN_RX_CALCULATE_ECHO_OFF_SNR:

         if (gs_AlgHandlerState != SNR_CALC_DONE)
         {
            SnrHandler();
         }
         else
         {
            //Call the following function to select the tones for message decoding
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSelectRxMsgDecodeTones);
            gs_RxSubState = R_O_TRAIN_RX_DONE;


#ifdef VRX518_BRINGUP_DEBUG

               if (gul_dbg_LogControl & CD_REV_SNR_ECHO_OFF)
               {
                  gul_dbg_LogControl_Status |= CD_REV_SNR_ECHO_OFF;
                  memcpy(gsa_StVectoringBuffer, gpsa_MeasuredSnrBuf, sizeof(int16)*RX_MAX_NUM_TONES);
               }
#endif
         }
         break;

      case R_O_TRAIN_RX_DONE:

         if(gs_RxBkgdProcessFlag == TRAINING_DONE)
         {
            // save tone selection
            gs_ToneSelect_Msg_NoEcho = gs_SelectBandStart;
            gs_NumCluster_Msg_NoEcho = gs_NumOfToneClustersForMsgDecode;

            // check the result and enter fail state if no band was found
            if (gs_SelectBandStart == -1)
            {
               EnterFailStates(E_CODE_ZERO_TONE_CLUSTERS_R_O_TRAIN);
            }
            else
            {
               //If the background process is done
               //Go to next RX state to decode the message
               gs_RxNextState = R_O_SIGNATURE_RX;
               gpF_RxStateFunc = (PtrToFunc)ROSignatureRxF_VDSL2;
            }
         }
         break;

      } //end switch for R_O_TRAIN_RX
   } // end of R_O_TRAIN_RX state

   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_TRAIN_MAIN_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap1(VDSL_TRAIN_MAIN_PM_SWAPPAGE, SWAP_TIMING_OFF)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_TRAIN_MAIN_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_TRAIN_MAIN_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_TRAIN_MAIN_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   case CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap1(VDSL_ALGHD_1_V2_PM_SWAPPAGE, SWAP_TIMING_OFF)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   case CODESWAP_LOAD(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap1(VDSL_ALGHD_2_V2_PM_SWAPPAGE, SWAP_TIMING_OFF )) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE);
      }
      break;
   case CODESWAP_CHECK(VDSL_ALGHD_2_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_2_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;
   }/* switch() */
}
