/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ROUpdateRxF_VDSL2.c
*
*   This file contains function to receive O-UPDATE message
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "ModulateSocMessages.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "vdsl_xception.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ROUpdateRxF_VDSL2
 *
 *   This function receives O-UPDATE message
 *
 *  Prototype:  void ROUpdateRxF_VDSL2(void)
 *
 *
 *  Input Arguments:
 *      NONE
 *
 *  Output Arguments:
 *      NONE
 *
 *   Return:
 *      NONE
 *
 *  Global Variables Used:
 *      gs_RxSubState -- (I/O) substate number
 *      guc_NumberOfPossibleRxMsgs -- (I/O) the number of possible expected messages
 *      guca_PossibleRxMsgCodes[] -- (I/O) the message codes of the expected messages
 *      gs_MsgReceiveFlag -- (O) flag to indicate if the message decoding is ok or not
 *      gs_RxHDLCMsgState -- (I/O) state used in RxHDLCMsgHandler()
 *      guc_RxMsgCode -- (O) the RX message code
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_O_UPDATE_RX_MSG_INIT            (0)
#define R_O_UPDATE_RX_DEMODULATE_MSG      (1)

void ROUpdateRxF_VDSL2(void)
{
   PT_ArrIdx_te UsedPilot = gt_PilotConfig.te_UsedPTArrayIdx;

   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   gsa_IndirectStat0[3]=VDSL2_R_O_P_CHANNEL_DISCOVERY2;
   gsa_IndirectStat0[2]=VDSL2_R_O_UPDATE;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
   switch (gs_RxSubState)
   {

      /* =============================================== */
      /* initialize RxMsgHandler */
      /* =============================================== */
   case R_O_UPDATE_RX_MSG_INIT:

      if (gl_RxSymbolCount == 1)
      {
         if (gs_PeriodicPllDisable == 1)
         {
            gft_EnablePLL = TRUE;
            // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
            // Set new Pll Reference for all 3 supported pilot tones.
            ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );
         }
      }
      // don't want to wait too long here
      else if (gl_RxSymbolCount == 2)
      {
         //Set the message code (expected message) to O-UPDATE
         guc_NumberOfPossibleRxMsgs = 1;
         guca_PossibleRxMsgCodes[0] = (uint8)VDSL2_SOC_MSG_O_UPDATE;

         //Set the RX timer
         gul_RxTimer = 0;

         //Initialize to the first substate in RxHDLCMsgHandler()
         gs_RxHDLCMsgState = 0;

         //go to next substate
         gs_RxSubState = R_O_UPDATE_RX_DEMODULATE_MSG;
      }

      break;

      /* =============================================== */
      /* process received messages */
      /* =============================================== */
   case R_O_UPDATE_RX_DEMODULATE_MSG: // demodulate and delineate HDLC msg.

      //Decode the HDLC message
      RxHDLCMsgHandler();

      if(gs_RxHDLCMsgState == RX_HDLC_MSG_DECODE_IDLE)
      {
         if(gs_MsgReceiveFlag == TRUE)
         {

#if defined(VRX518_BRINGUP_DEBUG)
         // Pause to dump the O-UPDATE SOC message.
         if (gs_PauseControl == 0x701)
         {
            gft_PauseOff = 0;
            Pause(gs_PauseControl);
         }
#endif // VRX518_BRINGUP_DEBUG

            //If O_UPDATE is received,
            if(guc_RxMsgCode == VDSL2_SOC_MSG_O_UPDATE)
            {
               //go to the next TX state to send R-UPDATE
               gs_TxNextState = VDSL2_R_UPDATE_TX;
               gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
               gft_TxStateInitFlag = TRUE;

               //go to the next RX state to receive O-PRM
               gs_RxNextState = VDSL2_R_O_PRM_RX;
               gpF_RxStateFunc = (PtrToFunc)ROPrmRxF_VDSL2;

               //reset the counts for the next message
               gs_NumRxRepeatRequest = 0;
               gs_NumTxRepeatRequest = 0;
            }
         }
         else
         {
            //Received message either has FCS error or interpretation error
            EnterFailStates(E_CODE_RX_O_UPDATE_FAIL);
         }
      }

      //Check for timeout
      if((gul_RxTimer != 0xFFFFFFFF) &&( gul_RxTimer >= TIMEOUT_CNT_TWO_SECONDS))
      {
         //Check timeout
         if(gs_NumTxRepeatRequest < NUM_TX_REPEAT_REQUEST)
         {
            //Count the number of repeat-request message sent for this message
            gs_NumTxRepeatRequest++;

            //go to the next TX state to send REPEAT_REQUEST
            gs_TxNextState = VDSL2_R_REPEAT_REQUEST_TX;
            gpF_TxStateFunc = (PtrToFunc)RPDiscovery2TxF_VDSL2;
            gft_TxStateInitFlag = TRUE;

            //go to the beginning of this substate
            gs_RxSubState = R_O_UPDATE_RX_MSG_INIT;

            // In the case of gs_TxNextState = gs_TxState, we need to do the following reset here
            gl_TxSymbolCount = 0;
            gs_TxSubState = 0;
            gs_TxSubStateCnt = 0;
         }
         else
         {
            //go to fail state
            CheckTimeout(gul_RxTimer, TIMEOUT_CNT_TWO_SECONDS, E_CODE_RX_STATE_TIMEOUT);
         }
      }
      break;
   } //switch

   //Update timer
   if(gul_RxTimer != 0xFFFFFFFF)
   {
      gul_RxTimer++;
   }

}

