/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPDiscovery2TxF_VDSL2.c
*
*   This file contains CO state function to send messages in R-P-Discovery2 state
*
*-------------------------------------------------------------------------
*/
//*****************************************************************************
// RPDiscovery2TxF_VDSL2.c
//
// History
//
// 23/03/2015 Fuss: VDSL2 - CPE bug in SOC message handling for O-REPEAT_REQUEST
//            Grep for XDSLRTFW-2284
//
// 14/09/2017 Hanyu: Merged IOP fixes against EVLT-F/CNXT in A8D profile
//   1. IOP adjustment to reduce estimated KL0 from loop length ~2800ft to ~3800ft to connect to showtime.
//   2. Switched to US0 band if KL0 is greater than 25.8dB (~3700ft) to fix the no sync issue.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft
//
//   3. Added 0.6dB to final KL0 to reduce UPBO and boost US power by ~0.5dB to get comparable US data rate with BRCM CPE.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 10/10/2018 Sriram Shastry: CenturyLink Training failure against EVLT-F/CNXT
//   Training failure is seen against EVLT-F CNXT DSLAM because first Supported US0 channel is 870 Incorrect FirstSupportedUS0Channel always Leeds to
//   selection of US0 oISDN filter.Corrected the bug for first Supported US0 Channel in case of oISDN profile.Added check for search firstSupportedUS0Channel
//   if oISDN profiles is used.
//   Grep for  XDSLRTFW-3978
//*****************************************************************************
#include <string.h>
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "ModulateSocMessages.h"
#include "DSLEngin.h"
#include "HDLC.h"
#include "vdsl_xception.h"
#include "TxPSDControl.h"
#include "RTrainingTxF.h"
#include "cmv.h"
#include "DshInterface.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPDiscovery2TxF_VDSL2
 *
 *  Prototype:  void RPDiscovery2TxF_VDSL2(void)
 *
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_TxSubState -- (I/O) TX substate number
 *      gl_TxSymbolCount -- TX state symbol count
 *      gs_FormMsgFlag -- (I/O) flag indicating if the TX message generation is done or not
 *      gs_TxHDLCMsgState -- (I/O) state number of HDLC state machine
 *      gs_UpdateTxMsgIdxFlag -- (I/O) flag indicating if the TX message index should be updated or not
 *      gs_NumRxRepeatRequest -- (I/O number of times when this message is sent
 *      gul_TxTimer -- (I/O) TX timer count
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_DISCOVERY2_TX_INIT                  (0)
#define R_P_DISCOVERY2_TX_MODULATE_ONE_BYTE     (1)
#define R_P_DISCOVERY2_TX_IDLE                  (2)

void RPDiscovery2TxF_VDSL2(void)
{
   uint8 uc_octet;
   uint16 us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;

   PtrToBkgdFunc ptrToFunction;

   switch (gs_TxSubState)
   {

   case R_P_DISCOVERY2_TX_INIT:

      if(gft_TxStateInitFlag == TRUE)
      {
         //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         gft_TxStateInitFlag = FALSE;

         gul_TxTimer = 0xFFFFFFFF;

         // Generate HDLC flag
         uc_octet = (uint8)HDLC_FLAG;
         ModulateHdlcOctets(&uc_octet, 1);

         //Update the number of the same message being sent
         gs_NumRxRepeatRequest++;

         if(gs_NumRxRepeatRequest == 1)
         {
            //Start a background process to initialize the TX message payload buffer
            //by the designated message
            switch(gs_TxState)
            {
            case VDSL2_R_UPDATE_TX:

               //Set gs_UpdateTxMsgIdxFlag to TRUE so the message
               //index, guc_TxHDLCMsgIndex, will be increased by one in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = TRUE;

               ptrToFunction = (PtrToBkgdFunc)FormRUpdateMsg_VDSL2;


               break;

            case VDSL2_R_PRM_TX:

               //XDSLRTFW-3924 (start)
               // US0 TxFilter loading based on O-UPDTE msg and TxLoaded Filter during CD phase.
               if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Tx_Filter_Auto_Reconfig)
               {
                  int16 s_TxIIRFilterSelect;
                  int16 s_FirstSupportedUS0Channel, s_LastSupportedUS0Channel;
                  s_TxIIRFilterSelect = IIR_FILTER_NO_CHANGE;
                  s_FirstSupportedUS0Channel = gsa_TxBandLeftChannel[0];
                  s_LastSupportedUS0Channel = gsa_TxBandRightChannel[0];
                  // A different TX filter depending on the TX band information must be selected!
                  if ( (gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_8xALL_MASK|CNFG_V2_PROFILE_12xALL_MASK|CNFG_V2_PROFILE_17A_MASK))
                        &&(gft_Debug35bHwConfig17aModeEnable == FALSE)
                        && (gs_TxIIRFilterSelect < OPTN_POTS_LP_Filter_Select)
                        && (gs_NumOfTxBands == 1)
                      )
                  {
                        if (s_FirstSupportedUS0Channel <= US0_POTS_ISDN_DETECT_TONE)
                        {
                           // POTS profile
                           if (s_LastSupportedUS0Channel <= US0_POTS_MAX_TONE)
                           {
                              s_TxIIRFilterSelect = OPTN_POTS_LP_Filter_Select;
                              gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = 80;
                           }
                           else if(s_LastSupportedUS0Channel <= US0_ISDN_POTSDOUBLE_MAX_TONE)
                           {
                              s_TxIIRFilterSelect = OPTN_POTS_DOUBLE_LP_Filter_Select;
                              gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = 320;
                           }
                           else if(s_LastSupportedUS0Channel <= US0_ISDNDOUBLE_POTSQUAD_MAX_TONE)
                           {  //XDSLRTFW-3496 Start
                              s_TxIIRFilterSelect = OPTN_POTS_QUAD_LP_Filter_Select;
                              gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = 552;
                           }
                        }
                        // Search for oISDN profiles used
                        else if(s_FirstSupportedUS0Channel < US0_ISDN_POTSDOUBLE_MAX_TONE)   // XDSLRTFW-3978(Start_End)
                        {
                           s_TxIIRFilterSelect = OPTN_ISDN_LP_Filter_Select;
                           gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = 320;
                        }
                        if (s_TxIIRFilterSelect != IIR_FILTER_NO_CHANGE)
                        {
                           gs_TxPathAfeDfeCustomSettings |= AFE_POFI_MODE_ADSL2_CPE;
                           //Update CMV and variable
                           gs_TxIIRFilterSelect = s_TxIIRFilterSelect;
                           gt_PSDCompData.us_TxIIRFilter = s_TxIIRFilterSelect; // input to "SetTransmitGains"
                           gsa_Optn4_FilterControl[OPTN_4_IDX5_FILTER_TTR] = (gsa_Optn4_FilterControl[OPTN_4_IDX5_FILTER_TTR] & (~OPTN_TX_MASK_Filter_Select));
                           gsa_Optn4_FilterControl[OPTN_4_IDX5_FILTER_TTR] |= s_TxIIRFilterSelect;

                           // Check whether Filter change required from CD to TR phases.
                           // Called during the "RPQuiet2TxF_VDSL2" begining of the TR phase
                           //AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadTxIIR);
                        }
                  }
               }
               //XDSLRTFW-3924 (end)

               // SetTransmitGains() computes the Tx PSD to be sent in O-PRM Message
               // Hence, we call SetTransmitGains() (but we do NOT load these gains)
               // before O-PRM message transmission. We load these gains later,
               // during the first symbol of training in O-P-TRAIN1

               // Setup TxPSDControl control structure used for Transmit Signal
               gt_TxPsdControl.s_MaxNomPsdIn = gt_PwrConfigParam.s_Up_MaxNomPSD;

               // Set MAXNOMATP
               gt_TxPsdControl.s_MaxAtp = gt_PwrConfigParam.s_Up_MaxNomAggrPwr;


               // Standard says, the CDPSDus should be 'limited to' min(PSDMASKus,MAXPSDus) and
               // that REFPSDus should limited to (min(PSDMASKus,MAXMASKus)-3.5dB)
               // Hence, we compute CDPSDus/REFPSDus by equating it to the limit
               if (gt_PwrConfigParam.s_Up_ProposedPsdCeiling == 0x1000)
               {
                  // special value indicates no limit under constraints of MaxNomPsd
                  //XDSLRTFW-610 IOP_US_ALL_VDMF_NoConnectUPBO (Start)
                  // With high DPBO Cases and also As per Standard we need to Ceil US0
                  // also with the Initial Ceil Exchanged - Min(all Ceiling) has to be
                  // Considered
                  //XDSLRTFW-1429 : Enable the DS Perf Improvement in general
                  //XDSLRTFW-1534 : In case of 8M profile @ 1200mts Non-UPBO case
                  // we see that NVLT-G, sends only one band to be used from training
                  // were we cannot switch to ADSL mode of operation and so gus_UseUS0OnlyCntrl is
                  // not set. But still we have to allow the full power on US0 only
                  gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_InitialPsdCeiling;
                  if((gus_UseUS0OnlyCntrl & TX_US0_ONLY_CONF_PSD_CEIL) ||
                        ((gs_NumOfTxBands == 1) && (gsa_TxBandRightChannel[0] <= (US0_ISDNDOUBLE_POTSQUAD_MAX_TONE +1))) )
                  {
                     gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_MaxNomPSD;
                  }

                  //XDSLRTFW-610 IOP_US_ALL_VDMF_NoConnectUPBO
                  if( (gt_CustomerIopBits.us_TELIASONERA_UPBO & TELIASONERA_UPBO_NOCONNECT) &&
                        (gt_UPBOPSDDescriptorTable.us_NumberOfBands > 0) )
                  {
                     gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_InitialPsdCeiling;
                  }
                  //XDSLRTFW-610 IOP_US_ALL_VDMF_NoConnectUPBO (End)
               }
               else if (gt_PwrConfigParam.s_Up_ProposedPsdCeiling > gt_PwrConfigParam.s_Up_InitialPsdCeiling)
               {
                  // proposed level is lower than the upstream PSD ceiling indicated in R-MSG1
                  // the VTU-R shall apply this new ceiling level.
                  gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_ProposedPsdCeiling;
               }
               else
               {
                  // Otherwise, the VTU-R may increase the ceiling of the upstream PSD mask up to this proposed ceiling level
                  // Standard says *may* and *upto* -- Hence, we increase it here under constraints of MaxNomPsd
                  //Use proposed Ceil here always
                  //gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_InitialPsdCeiling;
                  //Issue seen with all the cases @ loops 1050mts where Proposed Ceil is lower than
                  //initial PSD Ceil
                  //XDSLRTFW-1794
                  gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_ProposedPsdCeiling;
                  //XDSLRTFW-1794

                  if(gus_UseUS0OnlyCntrl & TX_US0_ONLY_CONF_PSD_CEIL)
                  {
                     if (gt_PwrConfigParam.s_Up_ProposedPsdCeiling > gt_PwrConfigParam.s_Up_MaxNomPSD)
                     {
                        gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_ProposedPsdCeiling;
                     }
                     else
                     {
                        gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_MaxNomPSD;
                     }
                  }
                  //XDSLRTFW-1722 : Use the Proposed PSD Ceiling if no TX Band Switching enabled
                  if((gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform < VINAX_REV_2_M_PLATFORM))
                  {
                     gt_TxPsdControl.s_PsdCeiling = gt_PwrConfigParam.s_Up_ProposedPsdCeiling;
                  }
               }

               //XDSLRTFW-554 BUG_US_ALL_ALL_PSDVIOLATION
               //The Limit now increased to -38dBm/Hz - With gs_MAX_US0_CEILING changed to 390
               if (gft_LimitUsCeiling)
               {
                  gt_TxPsdControl.s_PsdCeiling = MAX(gt_TxPsdControl.s_PsdCeiling, gs_MAX_US0_CEILING-10);
               }

               gt_TxPsdControl.pt_MaxPsdDescIn = (PSDDescriptorTable_t*)(void *)&gt_MaxUsPSDDescriptorTable;

               if (gt_UPBOPSDDescriptorTable.us_NumberOfBands)
               {
                  gt_TxPsdControl.pt_RefPsdDescIn = (UPBOPSDDescriptorTable_t*)&gt_UPBOPSDDescriptorTable;
                  // here we are after O-UPDATE
                  // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)

                  //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (START)
                  if (gft_EVLT_IOPtuning)
                      gt_TxPsdControl.s_kl0In = (gt_Kl0ElectricalLength.s_kl0_final + 6); // reduce UPBO and boost US power to improve US data rate on loops <= 3200ft
                  else
                  //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (END)
                  gt_TxPsdControl.s_kl0In = gt_Kl0ElectricalLength.s_kl0_final;
                  // if us_AeleMode = 1,2,3 we have to use O-UPDATE field 10 values
                  // those should already contain exactly what we need to use for UPBO
                  // values already capped upon O-UPDATE interpretation
                  gt_TxPsdControl.usa_Kl0EstimOPb[0] = gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[0];
                  gt_TxPsdControl.usa_Kl0EstimOPb[1] = gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[1];
                  gt_TxPsdControl.usa_Kl0EstimOPb[2] = gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[2];
                  gt_TxPsdControl.usa_Kl0EstimOPb[3] = gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[3];
                  if(gt_AELEM_UPBOInfo.us_AeleMode != 0)
                  {
                     int16 i;
                     // in us_AeleMode = 1,2,3 this parameter should not matter, but let's populate it
                     // The valid range of values is from 0 dB to 128 dB with a 0.1 dB step
                     gt_TxPsdControl.s_kl0In = 1280;
                     
                     for(i = 0; i< guc_ELEUsBands; i++)
                     {
                        if(gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[i] < (uint16)gt_TxPsdControl.s_kl0In)
                        {
                           gt_TxPsdControl.s_kl0In = gt_AELEM_UPBOInfo.usa_Kl0EstimOPb[i];
                        }
                     }
                  }
                  // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
               }
               else
               {
                  gt_TxPsdControl.pt_RefPsdDescIn = NULL;
               }

               gt_TxPsdControl.pt_ActPsdDescOut = (PSDDescriptorTable_t*)(void *)&gt_UsREFPSDDescriptorTable;

               // clear PreTxPath structure.  it will contain the log_Tssi breakpoints, if TSSI is enabled.
               memset(&gt_UsTSSIPSDDescriptorTable, 0, sizeof(UsTssiPSDDescriptorTable_t));

               // Enable tssi usage in InterpolatePSDValues()
               if((gft_disable_tx_tssi == FALSE) && (gft_US0BandUsed))
               {
                  // ANXQ_SUPPORT
                  // Why the index range was increased for "Table 12-31 - Log_tssi descriptor" is not clear!
                  // But as discussed with concept engineering nothing must be done for G.993.2 AnxQ.
                  // Note: The VTU-R shall provide non-zero tssi values for all out-of-band subcarriers
                  //       with indices from 1 to t_US0_stop+32, where t_US0_stop is the highest_index
                  //       subcarrier in US0. The out-of-band tssi values (virtual values, since no out-of-band
                  //       subcarriers are transmitted during channel discovery) shall only be used
                  //       during R-P-TEQ, as described in clause 12.3.4.3.2.4.
                  gs_interp_psd_with_tssi = 1;
               }

               // XDSLRTFW-3738 (Start End)
               // For non-vectoring we might loose US performance, if CO is limited by external noise. Therefore leave control on CO side except the US2
               // is available.
               // Behaviour of fix:
               // Note:      0dB - US0 ceiled to max PSD of USx bands (with x = 1 to (x = 1 to NumTxBands-1))
               //       -32768dB - US0 disabled (DISABLE_US0_CEILING)
               // |----------------------------------------------------------------------------|
               // |          |   Init           |      ChDis         |    TrTrain              |
               // |----------------------------------------------------------------------------|
               // |  Vec     |  x_ChDis    0dB  |    x_ChDis  0dB    |     x_TrTrain      0dB  |
               // |          |  x_TrTrain  0dB  |                    |old: x_TrTrain -32768dB  |
               // |----------------------------------------------------------------------------|
               // | Non-Vec  |  x_ChDis    0dB  |    x_ChDis  0dB    |      x_TrTrain      0dB |
               // |(US0+US1+ |  x_TrTrain  0dB  |                    | old: x_TrTrain -32768dB |
               // | US2/3)   |                  |                    |                         |
               // |----------------------------------------------------------------------------|
               // | Non-Vec  |  x_ChDis    0dB  |    x_ChDis  0dB    |     x_TrTrain -32768dB  |
               // |(US0+US1) |  x_TrTrain  0dB  |                    |                         |
               // |----------------------------------------------------------------------------|
               // !!!!! Note: Difference to old implementation is only for TrTrain: x_TrTrain = -32768dB !!!!!

               // Note: The if-case "gs_DeltaUsPsdCeilValue_TrTrain" is needed to use the variable also as debug variable, i.e. setting any value beside the default one.
               //       First bin US2 = FIRST_BIN_US2 = 1635, i.e. 7.05MHz
               if (((gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_DS_MASK)) == 0) &&
                   (gsa_TxBandLeftChannel[gs_NumOfTxBands-1] < FIRST_BIN_US2) &&
                   (gs_DeltaUsPsdCeilValue_TrTrain == 0))
               {
                  gs_DeltaUsPsdCeilValue_TrTrain = (int16)DISABLE_US0_CEILING;
               }
               // Write the transceiver training value in the global variable, so it gets applied in SetTransmitGains
               gs_DeltaUsPsdCeilValue = gs_DeltaUsPsdCeilValue_TrTrain;

               // Recompute the TX gains based on the final PSD information
               // Note: Call this *before* the FormRPrmMsg_VDSL2() Bkgrnd task
               // since we check for gs_FormMsgFlag to be DONE before proceeding
               // to next substate
               guc_SetTransmitGainsState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)SetTransmitGains);

               gs_UpdateTxMsgIdxFlag = TRUE;
               ptrToFunction = (PtrToBkgdFunc)FormRPrmMsg_VDSL2;

               // Send the structure of gt_TxPsdControl as debug stream (hopefully background function SetTransmitGains will be finished by then)
               // (size of DSH_MAX_PSD_DESC_IN = 386bytes considering MAX_NUM_PSD_POINTS] = 64)
               DSH_SendStream(DSH_TX_PSD_CONTROL,36,&gt_TxPsdControl);
               DSH_SendStream(DSH_MAX_PSD_DESC_IN,386,gt_TxPsdControl.pt_MaxPsdDescIn);
               DSH_SendStream(DSH_Max_PSD_DESC_OUT,386,gt_TxPsdControl.pt_ActPsdDescOut);
               break;

            case VDSL2_R_REPEAT_REQUEST_TX:

               //Set this flag to FALSE, so guc_TxHDLCMsgIndex will not be changed in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = FALSE;

               ptrToFunction = (PtrToBkgdFunc)FormORRepeatRqstMsg_VDSL2;
               break;

            default:
               ptrToFunction = 0;
               break;
            }

            gs_FormMsgFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo(ptrToFunction);

         }
         else
         {
            // XDSLRTFW-2284 (Start_End)
            memcpy(&gpuca_TxSocMsg[0], &guca_TxSocResend[0], 5);

            //If after two resending of this message, go to fail state
            if(gs_NumRxRepeatRequest > NUM_RESEND_O_UPDATE)
            {
               EnterFailStates(E_CODE_TX_DISCOVERY2_FAIL);
            }
            else
            {
               //Set gs_UpdateTxMsgIdxFlag to FALSE so the message
               //index will not be increased (since this is a repeated message)
               gs_UpdateTxMsgIdxFlag = FALSE;
               gs_FormMsgFlag = TRAINING_DONE;
            }
         }
      } //if((gl_TxSymbolCount == 0) || (gft_TxStateInitFlag == TRUE))

      //If the background process is finished
      if(gs_FormMsgFlag == TRAINING_DONE)
      {
         // XDSLRTFW-2284 (Start_End)
         if((gs_TxState == VDSL2_R_PRM_TX) || (gs_TxState == VDSL2_R_UPDATE_TX))
         {
            memcpy(&guca_TxSocResend[0], &gpuca_TxSocMsg[0], 5);
         }

         //Init. HDLC state machine state
         gs_TxHDLCMsgState = HDLC_TX_START_NEW_MSG;

         //go to the next substate
         gs_TxSubState = R_P_DISCOVERY2_TX_MODULATE_ONE_BYTE;
      }

      break;

   case R_P_DISCOVERY2_TX_MODULATE_ONE_BYTE: // Modulate 1 byte

      //Modulate a byte
      TxHDLCMsgHandler();

      //When the last byte of this message is sent
      if(gs_TxHDLCMsgState == HDLC_TX_CLOSING_FLAG_DONE)
      {
         //goto idle state
         gs_TxSubState = R_P_DISCOVERY2_TX_IDLE;

         //Set the TX timer
         gul_TxTimer = 0;
         gul_RxTimer = 0;
      }

      break;

   case R_P_DISCOVERY2_TX_IDLE:

      if((gs_TxState == VDSL2_R_PRM_TX) && (gs_RxState == VDSL2_R_O_P_SYNCHRO3_RX))
      {
         //go to the next TX state to send R-P-Synchro3
         gs_TxNextState = VDSL2_R_P_SYNCHRO3_TX;
         gpF_TxStateFunc = (PtrToFunc)RPSynchro3TxF_VDSL2;

         //disable repeat the HDLC flag
         //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         gft_SocRepeatFlag = FALSE;
      }

      if(gul_TxTimer != 0xFFFFFFFF)
      {
         gul_TxTimer++;
      }

      break;
   }

}


