/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPLineprobeTxF_VDSL2.c
*
*   This file contains RT function to transmit R-P-Lineprobe symbols
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "fifo.h"
#include "V_STR_IOf.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPLineprobeTxF_VDSL2
 *
 *   This function transmits R-P-Lineprobe symbols in VDSL2
 *
 *  Prototype:  void RPLineprobeTxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I) TX substate
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_LINEPROBE_TX_INIT         (0)
#define R_P_LINEPROBE_TX_WAIT         (1)

void RPLineprobeTxF_VDSL2(void)
{
   uint8 uc_octet;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_LINEPROBE;
   switch (gs_TxSubState)
   {

   case R_P_LINEPROBE_TX_INIT:

      if(gl_TxSymbolCount == 0)
      {
         //Generate HDLC flag
         uc_octet = (uint8)HDLC_FLAG   ;
         ModulateHdlcOctets(&uc_octet, 1);

         gs_TxSubState = R_P_LINEPROBE_TX_WAIT;
      }

   case R_P_LINEPROBE_TX_WAIT:

      //When all symbols are sent, go to the next state to send R-P-Periodic
      if(gl_TxSymbolCount == (VDSL2_R_P_LINEPROBE_TX_LENGTH-1))
      {
         //go to the next TX state O-P-Peridic state
         gs_TxNextState = VDSL2_R_P_PERIODIC1_TX;
         gpF_TxStateFunc = (PtrToFunc)RPPeriodic1TxF_VDSL2;
      }

      break;

   } //switch

}

