/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPMedleyTxF_VDSL2.c
*
*   This file contains RT state function to transmit R-P-MEDLEY symbol.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "vdsl_xception.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RPMedleyTxF_VDSL2(void)
*
*   This function, which is cascaded to RPMedleyTxF_VDSL2_Bridge() continues
*   transmiting R-P-MEDLEY symbol.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


void RPMedleyTxF_VDSL2(void)
{
   int32 l_TxSymbolCount;

   // In the diagnostic mode, this state should run for 80000 symbols
   if (gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   {
      // account for Medley bridge state length
      l_TxSymbolCount = gl_TxSymbolCount + gl_TxBridgeStateSymbolCount;

      //If the RX side finishes swaping in the page anal_4_v2
      if (gft_CodeSwapDoneFlag == TRUE)
      {
         if (l_TxSymbolCount == (gl_MedleyStateLength_Diag-1))
         {
            //go to the next state to transmit O-P-Synchro6
            gs_TxNextState = VDSL2_R_P_SYNCHRO6_TX;
            gpF_TxStateFunc = (PtrToFunc)RPSynchro6TxF_VDSL2Diag;

            //Disable the feature to repetively send HDLC idle flags
            gft_SocRepeatFlag = FALSE;
            gft_RunTxStateFuncFlag = FALSE;
         }
      }

      // timeout check
      if (l_TxSymbolCount > gl_MedleyStateLength_Diag)
      {
         EnterFailStates(E_CODE_TX_MEDLEY_FAIL);
      }

   } //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
}
