/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPMedleyTxF_VDSL2_Bridge.c
*
*   This file contains RT state function to transmit R-P-MEDLEY symbol.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "fifo.h"
#include "ModulateSocMessages.h"
#include "IRI_Iof.h"
#include "TimingAdvanceHandler.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RPMedleyTxF_VDSL2_Bridge(void)
*
*   This function starts transmitting R-P-MEDLEY symbols, and acts as a bridge
*   state to load the next swap page which contains Analysis states.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

#define R_P_MEDLEY_TX_INIT            (0)
#define R_P_MEDLEY_TX_SEND_FLAGS      (1)

void RPMedleyTxF_VDSL2_Bridge(void)
{
   uint8 uca_octet[2];

   //ACK message address and control byte is different
   switch (gs_TxSubState)
   {

   case R_P_MEDLEY_TX_INIT:

      if(gl_TxSymbolCount == 0)
      {
         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timout from VECTORING_STATE_TIMEOUT_LEN back
         // to normal STATE_TIMEOUT_LEN.
         // Note: This code is only active for Vectoring!
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_TX)
         {
            gl_TxStateTimeOutCount = STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_TX);
         }

         //In diagnostic mode, always set gs_TxNumBytesPerSymbol to 1
         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            // run TX foreground at every frame
            gft_RunTxStateFuncFlag = TRUE;

            gs_TxNumBytesPerSymbol = 1;

            //Enable the feature to repetively send HDLC idle flags
            gft_SocRepeatFlag = TRUE;
         }
         else
         {
            //Choose the desired number of bytes per DMT symbol in downstream
            //which is the smallest of two requested by CO and CPE
            gs_TxNumBytesPerSymbol = guc_ExchangePhaseTxNumBytesPerSymbol;
            if(gs_TxNumBytesPerSymbol > gt_DecMsg_O_TA_Update.uc_Bex_us_O)
            {
               gs_TxNumBytesPerSymbol = gt_DecMsg_O_TA_Update.uc_Bex_us_O;
            }

         }

         //Modulate 1 or 2 HDLC flags into one symbol
         //(Note: gs_TxNumBytesPerSymbol is set to be either 1 or 2)
         uca_octet[0] = (uint8)HDLC_FLAG;
         uca_octet[1] = (uint8)HDLC_FLAG;
         ModulateHdlcOctets(uca_octet, gs_TxNumBytesPerSymbol);

         //Start from the medley, the scramble state is reset once at the begining
         //and will not be reset for the remaining symbols in Medley state
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, SwitchToTxMedleyPRBS);


         //Previous release performs the second TA at the beginning of Medley,
         //which is not standard compilant.
         //To keep backward compatibility, we need to have this code
         //to interop with the previous releases

         //For CPE, set up to do the timing advance
         if((gs_EnableTaBugFix == FALSE) && (gt_DecMsg_O_TA_Update.s_TimeAdv != 0))
         {
            gs_TimingAdvance = gt_DecMsg_O_TA_Update.s_TimeAdv;
            gs_TimingAdvanceHandlerState = TIMING_ADVANCE_INIT;

            //Update the timing advance at U2 interface
            gs_TargetTimingAdvance += gs_TimingAdvance;
         }
         else
         {
            gs_TxSubState = R_P_MEDLEY_TX_SEND_FLAGS;
         }
      }


      if(gs_EnableTaBugFix == FALSE)
      {
         //Perform (but not calculate) timing advance for CPE
         //(In order to apply the TA at the first symbol of Medley
         // this function should not be moved to the next substate
         if (gs_TimingAdvanceHandlerState != TIMING_ADVANCE_DONE)
         {
            TimingAdvanceHandler();
         }
         else
         {
            gs_TxSubState = R_P_MEDLEY_TX_SEND_FLAGS;
         }
      }

      break;

   case R_P_MEDLEY_TX_SEND_FLAGS:

      if (gs_RxState == VDSL2_R_O_P_MEDLEY_RX)
      {
         // go to the next TX state to keep sending R-P-MEDLEY
         gs_TxNextState = VDSL2_R_P_MEDLEY_TX;
         gpF_TxStateFunc = (PtrToFunc)RPMedleyTxF_VDSL2;

         // save Medley bridge state length
         gl_TxBridgeStateSymbolCount = gl_TxSymbolCount + 1;
      }
      break;
   }
}
