/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPMultTrain2TxF_VDSL2.c
*
*   This file contains several RT state functions for transimiting the following
*   signal:
*   R-P-TEQ
*   R-P-QUITE3
*   R-P-ECT
*   R-P-Periodic2
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "IRI_Iof.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "V_STR_IOf.h"
#include "IRI_Iof.h"
#include "TxPSDControl.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPTeqTxF_VDSL2
 *
 *   This function transmits R-P-TEQ symbols in VDSL2
 *
 *  Prototype:  void OPTeqTxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I/O) TX substate
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *      gl_TxTeqLength -- (I) the length of TX TEQ state
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_TEQ_TX_INIT      (0)
#define R_P_TEQ_TX_ENABLE_TSSI   (11)
#define R_P_TEQ_TX_WAIT      (1)

void RPTeqTxF_VDSL2(void)
{
   int16 j, k;
   uint8 *puc_EGT;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_TEQ;
   switch(gs_TxSubState)
   {
   case R_P_TEQ_TX_INIT:

      //Disable the CE insertion if this is the first state where the CE insertion is turned off
      if(gl_TxSymbolCount >= 1)
      {
         HandleTxCE_PeriodicStateStart();
      }

      if(gl_TxSymbolCount == 0)
      {
         //All the tones should be modulated by value 11
         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }

      //If disabling the CE inserton is done
      if((gus_VdslStatusFlag & BITMAP_DISABLE_TX_CE_VDSL2) != 0)
      {
         gs_TxSubState = R_P_TEQ_TX_ENABLE_TSSI;
      }

      break;

   case R_P_TEQ_TX_ENABLE_TSSI:

      // Temporarily activate TSSI tones surrounding band 0 for tdq training state.
      // The fine gains have been written to HW earlier in InterpolatePSDValues().
      if (gft_US0BandUsed)
      {

         k = 0;
         puc_EGT = ghpuca_TxExtGains_Inactive + 1;
         for (j=1; j< gsa_TxBandLeftChannel[0]; j++)
         {

            //Save the original value of EGT
            guca_EGT_save[k++] = *puc_EGT;

            //Set TX bit to 1
            *puc_EGT |= 0x10;
            *puc_EGT++ &= ~0x06;
         }

         puc_EGT = ghpuca_TxExtGains_Inactive + gsa_TxBandRightChannel[0]+1;
         for (j=gsa_TxBandRightChannel[0]+1; j<= gsa_TxBandRightChannel[0]+32; j++)
         {

            //Save the original value of EGT
            guca_EGT_save[k++] = *puc_EGT;

            *puc_EGT |= 0x10;
            *puc_EGT++ &= ~0x06;
         }

         //Update gs_TxNumTonesUsed to include the TSST tone
         //This variable is used in SwitchTxPingPongTable()
         gs_TxNumTonesUsed += gsa_TxBandLeftChannel[0] - 1 + 32;

         // Load the ghpsa_TxFineGains_Inactive settings for tssi tones.
         Switch_TxFineGains_Tssi();

         AddFunctionToFifo(gp_TxLoadingFunctionFifo,SwitchTxPingPongTable);

      }


      gs_TxSubState = R_P_TEQ_TX_WAIT;

      break;

   case R_P_TEQ_TX_WAIT:

      if(gl_TxSymbolCount == (gl_TxTeqLength-1))
      {

         // Deactivate TSSI tones surrounding band 0. They aren't active
         // for other states.
         if (gft_US0BandUsed)
         {

            //restore the original EGT table values
            k = 0;
            puc_EGT = ghpuca_TxExtGains_Inactive + 1;
            for (j=1; j< gsa_TxBandLeftChannel[0]; j++)
            {
               //Restore the original value of EGT
               *puc_EGT++ = guca_EGT_save[k++];
            }

            puc_EGT = ghpuca_TxExtGains_Inactive + gsa_TxBandRightChannel[0]+1;
            for (j=gsa_TxBandRightChannel[0]+1; j<= gsa_TxBandRightChannel[0]+32; j++)
            {
               //Restore the original value of EGT
               *puc_EGT++ = guca_EGT_save[k++];
            }

            // Restore the previous ghpsa_TxFineGains_Inactive settings
            Switch_TxFineGains_Tssi();



            //Update gs_TxNumTonesUsed to exclude the TSST tones
            //This variable is used in SwitchTxPingPongTable()
            gs_TxNumTonesUsed -= gsa_TxBandLeftChannel[0] - 1 + 32;

            //Note: In 6.2, the TX and RX active table are independently controlled
            //so we need to change the TX table to avoid sending the tssi tones.
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,SwitchTxPingPongTable);

         }

         // Go on to quiet state, in which we will SwitchTxPingPongTable() to
         // enable the updated fine gains in HW.
         gs_TxNextState = VDSL2_R_P_QUIET3_TX;
         NextTxTrainingState();
      }
      break;
   } //switch

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPQuiet3TxF_VDSL2
 *
 *   This function transmits R-P-QUIET3 symbols in VDSL2
 *
 *  Prototype:  void RPQuiet3TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_TxSubState -- (I) TX substate
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_QUIET_TX_INIT      (0)
#define R_P_QUIET_TX_WAIT      (1)
#define R_P_QUIET_TX_EXIT      (2)

void RPQuiet3TxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_QUIET3;
   switch(gs_TxSubState)
   {
   case R_P_QUIET_TX_INIT:

      //Handle the CE change at the end of the periodic state
      if(gl_TxSymbolCount >= 1)
      {
         HandleTxCE_PeriodicStateEnd();
      }

      if(gl_TxSymbolCount == 1)
      {
         //SetVarGain to 0 for sending the quiet signal
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, ClearTxVarGain);
      }

      //If programming HW is done, go to the next substate
      if((!(gus_VdslStatusFlag & BITMAP_DISABLE_TX_CE_VDSL2)) && (gl_TxSymbolCount >= 1))
      {
         gs_TxSubState = R_P_QUIET_TX_WAIT;
      }

      break;

   case R_P_QUIET_TX_WAIT:

      if(gl_TxSymbolCount == gl_TxQuiet3Length-1)
      {
         //Transfer to the next TX state
         gs_TxNextState = VDSL2_R_P_ECT_TX;
         NextTxTrainingState();
      }
      break;

   } //switch
}



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPEctTxF_VDSL2
 *
 *   This function transmits R-P-ECT symbols in VDSL2
 *
 *  Prototype:  void RPEctTxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *      gl_TxEctLength -- (I) the length of TX ECT state
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_ECT_TX_INIT      (0)
#define R_P_ECT_TX_WAIT      (1)
#define R_P_ECT_TX_EXIT      (2)


void RPEctTxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_ECT;
   switch(gs_TxSubState)
   {
   case R_P_ECT_TX_INIT:

      //Disable the CE insertion if this is the first state where the CE insertion is turned off
      if(gl_TxSymbolCount >= 1)
      {
         HandleTxCE_PeriodicStateEnd();
      }

      //Since we do not train the EC, just send silence
      if(gl_TxSymbolCount == 1)
      {
         //SetVarGain to 0 for sending the quiet signal
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, ClearTxVarGain);
      }

      //If programming HW is done, go to the next substate
      if((!(gus_VdslStatusFlag & BITMAP_DISABLE_TX_CE_VDSL2)) && (gl_TxSymbolCount >= 1))
      {
         gs_TxSubState = R_P_ECT_TX_WAIT;
      }

      break;

   case R_P_ECT_TX_WAIT:

      //This state is of fixed length
      if(gl_TxSymbolCount == gl_TxEctLength-1)
      {
         //Go to the next TX state
         gs_TxNextState = VDSL2_R_P_PERIODIC2_TX;
         NextTxTrainingState();
      }
      break;

   } //switch
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPPeriodic2TxF_VDSL2
 *
 *   This function transmits R-P-Period2 symbols in VDSL2
 *
 *  Prototype:  void RPPeriodic2TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I/O) TX substate
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *      gl_TxTeqLength -- (I) the length of TX TEQ state
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_PERIODIC_TX_INIT      (0)
#define R_P_PERIODIC_TX_WAIT      (1)

void RPPeriodic2TxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_PERIODIC2;
   switch(gs_TxSubState)
   {
   case R_P_PERIODIC_TX_INIT:

      //Disable the CE insertion if this is the first state where the CE insertion is turned off
      if(gl_TxSymbolCount >= 1)
      {
         HandleTxCE_PeriodicStateStart();
      }

      if(gl_TxSymbolCount == 0)
      {
         //Value of 11 should be modulated on each DS tone
         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }
      else if(gl_TxSymbolCount == 1)
      {
         //Restore the TX gain in case it has set to 0 previously
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);
      }

      //If disabling the CE inserton is done, go to the next state
      if(((gus_VdslStatusFlag &BITMAP_DISABLE_TX_CE_VDSL2) != 0) && (gl_TxSymbolCount >= 1))
      {
         gs_TxSubState = R_P_PERIODIC_TX_WAIT;
      }

      break;

   case R_P_PERIODIC_TX_WAIT:

      if(gl_TxSymbolCount == (gl_TxPeriodicLength-1))
      {
         //reset the counts for the next message
         gs_NumRxRepeatRequest = 0;
         gs_NumTxRepeatRequest = 0;

         gs_TxNextState = VDSL2_R_P_TRAIN2_TX;
         gpF_TxStateFunc = (PtrToFunc)RPTrain2TxF_VDSL2;
         gft_TxStateInitFlag = TRUE;
      }
      break;
   } //switch
}

