/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPPeriodic1TxF_VDSL2.c
*
*   This file contains RT function to transmit the R-P-Periodic1 symbols
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "ghs.h"
#include "IRI_Iof.h"
#include "V_STR_IOf.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "mul.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPPeriodic1TxF_VDSL2
 *
 *   This function transmits R-P-Periodic symbols
 *
 *  Prototype:  void RPPeriodic1TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_TxSubState -- (I/O) TX substate
 *      gs_TxNextState -- (O) Next TX state
 *      gus_OperationModeStatus_VDSL2 -- (I) indicating if lineprobe state is sent or not
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_PERIODIC_TX_INIT            (0)
#define R_P_PERIODIC_TX_WAIT            (1)

void RPPeriodic1TxF_VDSL2(void)
{
   uint8 uc_octet;
   int32 l_temp;
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_PERIODIC1;
   switch(gs_TxSubState)
   {
   case R_P_PERIODIC_TX_INIT:

      //Perform the TX CE change at the start of the periodic state
      if(gl_TxSymbolCount >= 1)
      {
         HandleTxCE_PeriodicStateStart();
      }

      if(gl_TxSymbolCount == 0)
      {
         //Value of 11 should be modulated on each DS tone
         if (gul_dbgSocMsgControl & FORCE_IDLE_IN_PERIODIC1)
         {
            //Generate HDLC flag
            uc_octet = (uint8)HDLC_FLAG   ;
            ModulateHdlcOctets(&uc_octet, 1);
         }
         else
         {
            GenerateSynSymLookUpData((int16)(-gs_TxGain));
         }
      }
      else if(gl_TxSymbolCount == 1)
      {
         //If the O-P-Quiet/O-P-Pilot state is the previous state
         if(gul_OperationModeStatus_VDSL2 & V2_LINEPROBE)
         {
            //Mei??? this need to be revisited after it is decided what signal
            //is being sent in R-P-Lineprobe state (for now it is sending silence)
            //queue the TC task to set TX variable gain (it was set to 0 in R-P-PILOT state)
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);
         }
      }

      if(((gus_VdslStatusFlag &BITMAP_DISABLE_TX_CE_VDSL2) != 0) && (gl_TxSymbolCount >= 2))
      {
         gl_TxFixedStateLength = VDSL2_P_PERIODIC1_TX_LENGTH;
         if (!(gul_dbgMiscControl & DISABLE_TX_PERIODIC_TRANSITION))
         {
            //Compute the length of this state, L, such that L*(2N) = K*(2N+CElength)
            //where N is the number of tones, and K is the number of symbols in the periodic state with CE
            //Solve L = K*(1+ m*N/32/2N) = K * (1+m/64) = K + m*(k>>6)
            MULS16(l_temp, gs_m, (int16)(VDSL2_P_PERIODIC1_TX_LENGTH>>6));
            gl_TxFixedStateLength += l_temp;
         }

         gl_TxFixedStateLength += gs_dbgDelayTxSynchro2;

         gs_TxSubState = R_P_PERIODIC_TX_WAIT;
      }

      break;

   case R_P_PERIODIC_TX_WAIT:

      if (gl_TxSymbolCount == gl_TxFixedStateLength-1)
      {
         gs_TxNextState = VDSL2_R_P_SYNCHRO2_TX;
         gpF_TxStateFunc = (PtrToFunc)RPSynchro2TxF_VDSL2;
      }
      break;

   } //switch

}
