/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPQuiet2TxF_VDSL2.c
*
*   This file contains RT function to transmit R-P-QUIET2 state
*
*-------------------------------------------------------------------------
*/
//*****************************************************************************
// RPQuiet2TxF_VDSL2.c
//
// History
//
// 27/11/2012 Ram: Merged IOP fix related to JIRA XDSLRTFW-458
//            XDSLRTFW-458:Loop Reach is limited with different ECI
//            DPBO shapes. This is because link failures at different phases.
//            a) 2nd pilot tone selection failure, because of conditions
//               imposed on pilot selection like limit for Pilot tone selection:
//               ADD_OFFSET_FROM_BANDEDGE. ie., set the start tone index away
//               from the band edge by minimum of predefined value and 1/4 of
//               band size and minimum SNR required 15 dB
//            b) Timing Advance correction applied from O-Update message. If
//               total timing advance value is going above 300 then observed
//               OPTrain1 SNR is completely noisy (because of Echo) hence not
//               able to detect proper band for OPSYNCHRO4 detection.
//               Work around is to limit the Maximum value of Timing Advance
//               from CPE such that Echo effect will not be seen in DS band.
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve
//                signal, Transmit signal, SOC message) to STAT 0
//                Grep for "XDSLRTFW-1901"
//
//*****************************************************************************

#include "gdata.h"
#include "vdsl_state.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "IRI_sync.h"
#include "V_STR_IOf.h"
#include "IRI_Iof.h"
#include "TxPSDControl.h"
#include "RTrainingTxF.h"
#include "TimingAdvanceHandler.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "Cri_iof.h"
#include "V_STR_IIR_IOf.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPQuiet2TxF_VDSL2
 *
 *   This function transmits R-P-QUIET2 symbols in VDSL2
 *
 *  Prototype:  void RPQuiet2TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I) TX substate
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_QUIET_TX_INIT               (0)
#define R_P_QUIET_TX_TIME_ADVANCE         (1)
#define R_P_QUIET_TX_IDLE               (2)

void InitRPQuiet2TxSignal(void)
{

   //Reinitialize CE, CP, CS and beta length for training phase
   InsertTxCE();

   //Reconfigure the IFFT/FFT length
   ConfigTxFrameSize();

   //Set the TX gain to 0 for sending Quiet signal
   ClearTxVarGain();
}

void RPQuiet2TxF_VDSL2(void)
{
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
   if (gft_DSVectoringEnabled == TRUE)
   {
      gsa_IndirectStat0[4]=VDSL2_R_P_QUIET_V1;
   }
   else
   {
      gsa_IndirectStat0[4]=VDSL2_R_P_QUIET2;
   }
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)

   switch (gs_TxSubState)
   {

   case R_P_QUIET_TX_INIT:

      if(gl_TxSymbolCount == 0)
      {
         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timeout from STATE_TIMEOUT_LEN back to VECTORING_STATE_TIMEOUT_LEN.
         // Note: This code is only active for Vectoring!
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_TX)
         {
            gl_TxStateTimeOutCount = VECTORING_STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_TX);
         }
         // XDSLRTFW-3325 (Start)
         // This code is added to send out an autonomous message
         //
         // This is an work around for error code: 586 (E_CODE_ERB_BAR_NOT_CONFIGURED)
         if ((gta_DsBearerChannel[BC0].s_Control & TPS_TC_TYPE_ATM_PTM) == TPS_TC_TYPE_PTM)
         {
            // XDSLRTFW-3711 (Start)
            // The PPE clock frequency needs to be configured based on the profile selected, bonding capability and TC mode.
            // The PPE frequency which needs to be configured is indicated to the PPE driver by configuring the DREG register 0x7DCE (DREG_MISCRAM14_ADDR)
            // before sending out the autonomous message.
            Ppe_clockChange(TPS_TC_TYPE_PTM, gt_ProfileAct.us_ProfileSelected);
            // XDSLRTFW-3711 (End)
            gt_Bonding_TC_Info.s_TC_Type = TPS_TC_TYPE_PTM;
            gft_autonomous_msg_flag = TRUE;
         }
         // XDSLRTFW-3325 (End)


      }
      else if(gl_TxSymbolCount == 1)
      {
         //Reconfig the HW for the first symbol of Training phase
         //(Note: programming the FT and Strymon core has one symbol less delay
         // than programming the QT core. Thus, we start it at gl_TxSymbolCount of 1, rather than 0)
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, InitRPQuiet2TxSignal);
      }
      else if(gl_TxSymbolCount == 2)
      {
         // Apply desired timing advance correction
         // Set timing advanced value for next TimingAdvanceHandler().
         // Note: Positive values shall indicate that the transmitted symbol will be
         //       advanced more with respect to the received symbol.
         gs_TimingAdvance = gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection;

         // Update the timing advance at U2 interface
         // Note: This value is used for R-TA-Update message!
         gs_TargetTimingAdvance += gs_TimingAdvance;

         gs_TimingAdvanceHandlerState = TIMING_ADVANCE_INIT;
         gs_TxSubState = R_P_QUIET_TX_TIME_ADVANCE;
         gs_TxSubStateCnt = 0;

         // Remove TimingAdvance in RP-Quiet2 and the unnecessary delay for Vectoring before OP-Vector1-1.
         // Note: For Vectoring only TimingAdvanceCorrection is allowed to be done, i.e. not a full TA link of ChannelDiscovery!
         if (gft_DSVectoringEnabled == TRUE)
         {
            gs_TxSubState = R_P_QUIET_TX_IDLE;
         }

         //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (start)
         // Restore the original value received
         if(gt_CustomerIopBits.us_ECI & ECI_DPBO_TACORRECTION)
         {
            if (gs_ForceTimingAdvanceCorrection != 0x7fff)
            {
               gt_DecMsg_O_Update_VDSL2.s_TimingAdvanceCorrection = gs_O_UpdateTAC_backup ;
            }
         }
         //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (start)

         //XDSLRTFW-3924 (start)
         // US0 TxFilter loading based on O-UPDTE msg and TxLoaded Filter during CD phase.
         if((gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] & (OPTN_TX_MASK_Filter_Select)) != gs_TxIIRFilterSelect)
         {
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadTxIIR);
         }
         //XDSLRTFW-3924 (end)

      }

      break;

   case R_P_QUIET_TX_TIME_ADVANCE:
      //indicate to the RX that the TX side start sending the signal
      //so the RX side can retrain its PGA with echo
      //go to the next substate
      // signal to TX side to start transmitting RMsg1.
      if (guc_TxRxCommunicator & TX_TIMING_ADVANCE_TRAIN1_START)
      {
         if (gs_TxSubStateCnt == 0)
         {

            if(gus_DebugControlVRX518 & ENA_TA_CONSIDER_FA)
            {
               // Note: The FA is changing the sync point. Reason is so far not understood, but it must be considered in the TimingAdvanced.
               // Note: A negative value is increasing the distance between Tx and Rx FFT buffer-swap.
               if (gft_DSVectoringEnabled == FALSE)
               {
                  int16 s_CumulativeAlignmentOffset;
                  signed int i;

                  i = TX_LOG2_MAX_FFT_LENGTH-gs_RxLog2FftLength;
                  if (i >= 0)
                  {
                     s_CumulativeAlignmentOffset = gs_CumulativeAlignmentOffset << i;
                  }
                  else
                  {
                     s_CumulativeAlignmentOffset = gs_CumulativeAlignmentOffset >> (-i);
                  }
                  gs_TimingAdvance += s_CumulativeAlignmentOffset;
               }
            }
            else
            {
               // Note: The FA is changing the sync point. Reason is so far not understood, but it must be considered in the TimingAdvanced.
               //       gs_TargetTimingAdvance must include the correction as new correct target and gs_TimingAdvance must be set to zero
               //       to consider the delay and the beta/2 TA reference point.
               gs_TimingAdvance = 0;
            }

            gs_TxSubStateCnt++;
         }

         if (gs_TimingAdvanceHandlerState != TIMING_ADVANCE_DONE)
         {
            TimingAdvanceHandler();
         }
         else
         {
            // guc_TxRxCommunicator  flag with TX_TIMING_ADVANCE_TRAIN1_COMPLETED is used in Rx State machine
            // to initiate next Tx state (VDSL2_R_P_TRAIN1_TX)
            guc_TxRxCommunicator |= TX_TIMING_ADVANCE_TRAIN1_COMPLETED;
            // Info: In vectoring mode timing advance correction is done in VDSL2_R_P_VECTOR1_1_TX state

            gs_TxSubState = R_P_QUIET_TX_IDLE;
            gs_TxSubStateCnt = 0;
         }
      }
      break;

   case R_P_QUIET_TX_IDLE:

      break;

   } //switch

   gl_TxRPQuiet2SymbolCount = gl_TxSymbolCount;
}
