/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPSynchro1TxF_VDSL2.c
*
*   This file contains RT function to transmit R-P_SYNCHRO1 symbols
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "fifo.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPSynchro1TxF_VDSL2
 *
 *   This function transmits R-P_SYNCHRO1 symbols in VDSL2
 *
 *  Prototype:  void RPSynchro1TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I) TX substate
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_SYNCHRO1_TX_SYNCH_SYMBOL         (0)

void RPSynchro1TxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_SYNCHRO_1;
   switch (gs_TxSubState)
   {

   case R_P_SYNCHRO1_TX_SYNCH_SYMBOL:

      //For the first 5 and last 5 symbols, set all the tones to (-,-)
      if((gl_TxSymbolCount == 0) || (gl_TxSymbolCount == 10))
      {
         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }
      //For 3 middle symbols, //set all tones to (+,+)
      else if(gl_TxSymbolCount == 5)
      {
         GenerateSynSymLookUpData(gs_TxGain);
      }
      //After sending the 15-th symbol, go to O-P-Quiet/O-P-Pilot state if the lineprobe
      //is requested, go to O-P-Peridic state if the lineprobe is not requested
      else if(gl_TxSymbolCount == 14)
      {
         // log end of R-P-SYNCHRO1 transmission
         gpt_DebugTiming->l_TxRPSynchro1_End = gl_TotalTxSymbolCount;

         if(gul_OperationModeStatus_VDSL2 & V2_LINEPROBE)
         {
            //go to the next TX state O-P-Quiet/O-P-Pilot
            gs_TxNextState = VDSL2_R_P_LINEPROBE_TX;
            gpF_TxStateFunc = (PtrToFunc)RPLineprobeTxF_VDSL2;
         }
         else
         {
            //go to the next TX state O-P-Peridic state
            gs_TxNextState = VDSL2_R_P_PERIODIC1_TX;
            gpF_TxStateFunc = (PtrToFunc)RPPeriodic1TxF_VDSL2;
         }

      }

      break;

   } //switch

}
