/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPSynchro3TxF_VDSL2.c
*
*   This file contains RT function to transmit R-P_SYNCHRO3 symbols
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPSynchro3TxF_VDSL2
 *
 *   This function transmits R-P_SYNCHRO3 symbols in VDSL2
 *
 *  Prototype:  void RPSynchro3TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I) TX substate
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_SYNCHRO_TX_SYNCH_SYMBOL         (0)
#define R_P_SYNCHRO_TX_IDLE               (1)

void RPSynchro3TxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_SYNCHRO_3;
   switch (gs_TxSubState)
   {

   case R_P_SYNCHRO_TX_SYNCH_SYMBOL:

      //For the first 5 and last 5 symbols, set all the tones to (-,-)
      if((gl_TxSymbolCount == 0) || (gl_TxSymbolCount == 10))
      {
         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }
      //For 3 middle symbols, //set all tones to (+,+)
      else if(gl_TxSymbolCount == 5)
      {
         GenerateSynSymLookUpData(gs_TxGain);
      }
      //After sending the 15th symbol, go to O-P-Quiet/O-P-Pilot state if the lineprobe
      //is requested, go to O-P-Periodic state if the lineprobe is not requested
      else if(gl_TxSymbolCount == 14)
      {
         //Transit to the next TX state to send the R-P-Quiet
         gs_TxNextState = VDSL2_R_P_QUIET2_TX;
         gpF_TxStateFunc = (PtrToFunc)RPQuiet2TxF_VDSL2;

         if (gft_DSVectoringEnabled == TRUE)
         {
            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timeout after RP-SYNCHRO3
            // Note:
            //       1) It is not possible to set the value directly if the new
            //          one is lower than the previous one. The timeout check would
            //          directly kick-in in TxForeGround. Since the Vectoring timeout is bigger
            //          it could directly be set. But to be independent of any change the correct
            //          procedure is also used here!
            //       2) guc_SwitchGlobalTimeout must be initialized to zero
            guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_TX;
         }
      }

      break;

   } //switch

}
