/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPSynchro4TxF_VDSL2.c
*
*   This file contains RT function to transmit R-P_SYNCHRO4 symbols
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "vdsl_const.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPSynchro4TxF_VDSL2
 *
 *   This function transmits R-P_SYNCHRO4 symbols in VDSL2
 *
 *  Prototype:  void RPSynchro4TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I) TX substate
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_SYNCHRO_TX_SYNCH_SYMBOL         (0)
#define R_P_SYNCHRO_TX_IDLE               (1)

void RPSynchro4TxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_SYNCHRO_4;
   switch (gs_TxSubState)
   {

   case R_P_SYNCHRO_TX_SYNCH_SYMBOL:

      //For the first 5 and last 5 symbols, set all the tones to (-,-)
      if((gl_TxSymbolCount == 0) || (gl_TxSymbolCount == 10))
      {
         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }
      //For 3 middle symbols, //set all tones to (+,+)
      else if(gl_TxSymbolCount == 5)
      {
         GenerateSynSymLookUpData(gs_TxGain);
      }
      //After sending the 15-th symbol, go to O-P-Quiet/O-P-Pilot state if the lineprobe
      //is requested, go to O-P-Peridic state if the lineprobe is not requested
      else if(gl_TxSymbolCount == 14)
      {
         //Transit to the next TX state to send the R-P-Quiet
         gs_TxNextState = VDSL2_R_P_TEQ_TX;
         NextTxTrainingState();
      }

      break;

   } //switch

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : NextTxTrainingState
 *
 *  Prototype:  void NextTxTrainingState(void)
 *
 *   This function is a generic function called by several state machine function.
 *  It is used to decide which of the next RX state to transfer to based
 *  on the specified length of each state (when the length is empty, it will go to the
 *  next state).
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_TxNextState      -- (I/O) the next TX state to transfer to
 *      gl_TxTeqLength      -- (I) TX TEQ state length
 *      gl_TxQuiet3Length   -- (I) TX QUIET3 state length
 *      gl_TxEctLength      -- (I) TX ECT state length
 *      gl_TxPeriodicLength -- (I) TX Periodic state length
 *      gft_TxStateInitFlag -- (O)
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void NextTxTrainingState(void)
{
   //Transfer to the next TX state
   switch(gs_TxNextState)
   {

   case VDSL2_R_P_TEQ_TX:
      if(gl_TxTeqLength > 0)
      {
         gpF_TxStateFunc = (PtrToFunc)RPTeqTxF_VDSL2;
         break;
      }
      else
      {
         gs_TxNextState = VDSL2_R_P_QUIET3_TX;
      }
      /* no break */

   case VDSL2_R_P_QUIET3_TX:

      if(gl_TxQuiet3Length > 0)
      {
         gpF_TxStateFunc = (PtrToFunc)RPQuiet3TxF_VDSL2;
         break;
      }
      else
      {
         gs_TxNextState = VDSL2_R_P_ECT_TX;
      }
      /* no break */

   case VDSL2_R_P_ECT_TX:

      if(gl_TxEctLength>0)
      {
         gpF_TxStateFunc = (PtrToFunc)RPEctTxF_VDSL2;
         break;
      }
      else
      {
         gs_TxNextState = VDSL2_R_P_PERIODIC2_TX;
      }
      /* no break */

   case VDSL2_R_P_PERIODIC2_TX:

      if(gl_TxPeriodicLength > 0)
      {
         gpF_TxStateFunc = (PtrToFunc)RPPeriodic2TxF_VDSL2;
         break;
      }
      else
      {
         gs_TxNextState = VDSL2_R_P_TRAIN2_TX;
      }
      /* no break */

   case VDSL2_R_P_TRAIN2_TX:

      gpF_TxStateFunc = (PtrToFunc)RPTrain2TxF_VDSL2;
      gft_TxStateInitFlag = TRUE;

      break;
   } //switch ..
}


