/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPSynchro6TxF_VDSL2.c
*
*   This file contains RT function to transmit R-P_SYNCHRO6 symbols
*
*-------------------------------------------------------------------------
*/
#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "fifo.h"
#include "ZPH_Ini.h"
#include "showtime.h"
#include "show_iof.h"
#include "OvhdMsg_IOf.h"
#include "IRI_Iof.h"
#include "vdsl_const.h"
#include "cmv.h"


#include "CustomerTasks.h"
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPSynchro6TxF_VDSL2
 *
 *   This function transmits R-P_SYNCHRO6 symbols in VDSL2
 *
 *  Prototype:  void RPSynchro4TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I) TX substate
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_SYNCHRO_TX_SYNCH_SYMBOL         (0)
#define R_P_SYNCHRO_TX_IDLE               (1)

void RPSynchro6TxF_VDSL2(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_SYNCHRO_6;
   switch (gs_TxSubState)
   {

   case R_P_SYNCHRO_TX_SYNCH_SYMBOL:

      if(gl_TxSymbolCount == gs_dbgDelayRPSynchro6)
      {
         if (!(gul_dbgSocMsgControl & DISABLE_PRBS_RESET_FOR_SYNCHRO6))
         {
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxResetPRBS);
         }
      }

      //For the first 5 and last 5 symbols, set all the tones to (-,-)
      if((gl_TxSymbolCount == gs_dbgDelayRPSynchro6) || (gl_TxSymbolCount == (10+gs_dbgDelayRPSynchro6)))
      {
         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }
      //For 3 middle symbols, //set all tones to (+,+)
      else if(gl_TxSymbolCount == (5+gs_dbgDelayRPSynchro6))
      {
         GenerateSynSymLookUpData(gs_TxGain);
      }


      //After sending the 15-th symbol, go to O-P-Quiet/O-P-Pilot state if the lineprobe
      //is requested, go to O-P-Peridic state if the lineprobe is not requested
      else if(gl_TxSymbolCount == (15+gs_dbgDelayRPSynchro6))
      {
         // enable TX data pump one frame before showtime
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, StartTxDataPath_VDSL2);
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, WriteTxOvhdHwFifo);


      }
      //After sending the 15-th symbol, go to TX showtime
      else if(gl_TxSymbolCount == (16+gs_dbgDelayRPSynchro6))
      {

#ifdef QT_LATCH_LP_BITS
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxQtLpBitsLatch);
#endif

         TxOvhdHandler();

         AddFunctionToFifo(gp_TxLoadingFunctionFifo, DFE_PPE_LinkStatus_TxRxShow);
         // Transition to TX showtime state
         gs_TxNextState = R_SHOWTIME_TX;
         gpF_TxStateFunc = (PtrToFunc)ShowtimeTxF_VDSL2;
         gt_TaskArray[TX_QT_DONE].TimeCriticalTask = ShowtimeTxTC_VDSL2;
      }
      break;

   } //switch
}

