/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   OPSynchro6TxF_VDSL2Diag.c
*
*   This file contains CO function to transmit O-P_SYNCHRO6 symbols
*   for the diagnostic mode.
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "RTrainingTxF.h"
#include "fifo.h"
#include "show_iof.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPSynchro6TxF_VDSL2Diag
 *
 *   This function transmits R-P_SYNCHRO6 symbols in VDSL2 diagnostic mode
 *
 *  Prototype:  void RPSynchro6TxF_VDSL2Diag(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gs_TxSubState -- (I) TX substate
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxGain -- (I) TX output tone gain level
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates                              */
/* =============================================== */
#define R_P_SYNCHRO_TX_SYNCH_SYMBOL         (0)

void RPSynchro6TxF_VDSL2Diag(void)
{

   //ACK message address and control byte is different
   switch (gs_TxSubState)
   {

   case R_P_SYNCHRO_TX_SYNCH_SYMBOL:

      //For the first 5 and last 5 symbols, set all the tones to (-,-)
      if((gl_TxSymbolCount == 0) || (gl_TxSymbolCount == 10))
      {
         if(gl_TxSymbolCount == 0)
         {
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxResetPRBS);
         }

         GenerateSynSymLookUpData((int16)(-gs_TxGain));
      }
      //For 3 middle symbols, //set all tones to (+,+)
      else if(gl_TxSymbolCount == 5)
      {
         GenerateSynSymLookUpData(gs_TxGain);
      }
      else if(gl_TxSymbolCount == 14)
      {
         //Transfer to the next TX state to send O-P-Training
         gs_TxNextState = VDSL2_R_P_TRAIN3_TX;
         gpF_TxStateFunc = (PtrToFunc)RPTrain3TxF_VDSL2Diag;
         gft_TxStateInitFlag = TRUE;
      }

      break;

   } //switch
}
