/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPQuiet2TxF_VDSL2.c
*
*   This file contains RT function to transmit R-P-QUIET2 state
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// hs_resp.c
//
// History
// 29/04/2013 Fuss: Fix for VR9 sending wrong signal at beginning of R-P-VECTOR-1-1, i.e. during first symboles
//                  no quiet is transmitted.
//            Grep for XDSLRTFW-919: BugFix_DS_VECTORING_All_SignalAtBeginOfRPVector11
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//                Grep for XDSLRTFW-1901
//
// ************************************************************************************************************

#include "gdata.h"
#include "vdsl_state.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "RTrainingTxF.h"
#include "PGAHandler.h"
#include "ModulateSocMessages.h"
#include "TxPSDControl.h"
#include "ghs.h"
#include "cmv.h"
#include "vdsl_const.h"

//#ifdef MTK_VECTORING_SUPPORT
#include "V_STR_IOf.h"
#include "qt_memmap.h"
#include "LL_IOf.h"
#include "TimingAdvanceHandler.h"
//#endif

/*^^^
*------------------------------------------------------------------------
*
*  Name : RPTrain1TxF_VDSL2
*
*   This function contains two transmit states
*     i.  VDSL2_R_P_VECTOR1_1_TX    (192)       : R-P Vector1-1/G993.5 State
*    ii. VDSL2_R_P_TRAIN1_TX        (49)        : R-P Training1/G993.2 State
*
*  Prototype:  void RPTrain1TxF_VDSL2(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Return:
*      None
*
*  Global Variables Used:
*      gl_TxSymbolCount -- (I) TX state symbol count
*      gs_TxSubState -- (I) TX substate
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates                              */
/* =============================================== */


//#ifdef MTK_VECTORING_SUPPORT
// Sub state definations of VDSL2_R_P_VECTOR1_1_TX state
#define R_P_VECTOR1_1_TX_SIGNAL_INIT      (0)
#define R_P_VECTOR1_1_TX_LOAD_GAINS       (1)
#define R_P_VECTOR1_1_TX_INIT_TA          (2)
#define R_P_VECTOR1_1_TX_SIGNAL           (3)
//#endif

// Sub state definations of VDSL2_R_P_TRAIN1_TX state
#define R_P_TRAIN_TX_INIT                 (0)
#define R_P_TRAIN_TX_IDLE                 (1)


void RPTrain1TxF_VDSL2(void)
{
   uint8 uc_octet;
   //#ifdef MTK_VECTORING_SUPPORT
   int16 s_RevSeg;
   //#endif //#ifdef MTK_VECTORING_SUPPORT

//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   if(gs_TxState == VDSL2_R_P_VECTOR1_1_TX)
   {
      gsa_IndirectStat0[4]=VDSL2_R_P_VECTOR1_1;
      switch (gs_TxSubState)
      {
// XDSLRTFW-919: BugFix_DS_VECTORING_All_SignalAtBeginOfRPVector11 (start)
      case R_P_VECTOR1_1_TX_SIGNAL_INIT:
         //Clear the bit to indicate that the RX side has not received R-P-Synchro4
         gus_VdslStatusFlag &= ~BITMAP_RX_SYNCHRO_VDSL2;

         // start looking for O-P-SYNCHRO V2 signal
         gs_MsgReceiveOPSYNCHROV1Flag = FALSE;

         //For the diag mode, we modulate each byte in one symbol (instead of 40 symbols)
         //since this is not active SOC message state
         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            gft_DisableTxDiagModulation = TRUE;
         }

         //Start QUITE phase of R-P-Vector1-1
         gus_RefGain = 0x0;                              // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
         gft_IT_MISC_RefGainEna = TRUE;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);

         // Before Sending the R-P Vector1-1 Signal, Timinig advance correction is done.
         //  gs_TimingAdvance = 0;                        // assume reference timining advance value = 0 (?)
         // gs_TimingAdvance value is initialized in RPQuiet2TxF_VDSL2 function at state R_P_QUIET_TX_INIT
         gs_TxSubState = R_P_VECTOR1_1_TX_INIT_TA;
         break;

      case R_P_VECTOR1_1_TX_INIT_TA:
         if (gs_TimingAdvanceHandlerState != TIMING_ADVANCE_DONE)
         {
            TimingAdvanceHandler();
         }
         else
         {
            // Setup for Loading of Transmit Gains
            guc_LoadTransmitGainsState = LTG_LOAD_IRIDIA;
            gs_TxSubState = R_P_VECTOR1_1_TX_LOAD_GAINS;
         }
         break;

      case R_P_VECTOR1_1_TX_LOAD_GAINS:
// XDSLRTFW-919: BugFix_DS_VECTORING_All_SignalAtBeginOfRPVector11 (start)
         //Reconfig the HW to change the Tx Gains,
         if (guc_LoadTransmitGainsState != LTG_LOAD_DONE)
         {
            LoadTransmitGains();
         }
         else
         {
            // Start transmitting R-P-Vector1-1 signal
            gs_TxSubState = R_P_VECTOR1_1_TX_SIGNAL;
         }
         break;

      case R_P_VECTOR1_1_TX_SIGNAL:
         signed int i;
         uint16 us_PilotSeqIndexWithCycShift;
         uint16 us_RefGain;
         int32 l_SocTxDataForPrbs;

         us_RefGain = 0xFFFF;
         if (gs_MsgReceiveOPSYNCHROV1Flag == FALSE)
         {
            // check for Tx Sync frame
            // setup Transmitter to send R-P_Vector1-1 signal
            // transmit every sync frame
            // decide Tx sync frame based on rx Sync frame and offset
            if (gs_TxFrmCnt == TX_DATA_SYMBOLS_PER_SUPERFRAME-1)
            {
               // setup Iridia QT data path to send R-P_Vector1-1 signal at Sync frame
               us_RefGain = 0x2000 ;                       // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain

               // XDSLRTFW-1696 (Start)
               // Get US Sync symbol constellation points using FDPS array and the control parameters and
               // store the result in gl_SocTxDataForPrbs variable
               l_SocTxDataForPrbs = 0;
               gl_SocTxDataForPrbs = 0;

               for (i = 0 ; i < 8; i++)
               {
                  // main array  : gpuca_FDPSActive   size [8][64]
                  // control 1 : gs_VecIndx_PilotSeq
                  // control 2 : guca_IndexIndependentPSActive[8]
                  // control 3 : guca_CyclicalShiftOfSeqActive[8]
                  // control 4 : guc_SignOfSeqActive
                  // modulo parameter : gs_VecNPilotLength_US bit field length

                  //considing Cyclical Shift of the sequence
                  us_PilotSeqIndexWithCycShift  = (uint16)(gs_VecIndx_PilotSeq + guca_CyclicalShiftOfSeqActive[i]*(gs_VecNPilotLength_US >>3));
                  // modulo (s_PilotSeqIndexWithCycShift, gs_VecNPilotLength_US)
                  while (us_PilotSeqIndexWithCycShift > gs_VecNPilotLength_US)
                  {
                     us_PilotSeqIndexWithCycShift -= gs_VecNPilotLength_US;
                  }

                  // get the bit considiring US super frame counter (gs_VecIndx_PilotSeq), cyclical shift and independent pilot sequence
                  s_RevSeg = (*(gpuca_FDPSActive + guca_IndexIndependentPSActive[i]*64  + (us_PilotSeqIndexWithCycShift>>3)) >> (us_PilotSeqIndexWithCycShift & 0x7)) & 0x1; // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start-end)

                  // considereing sign bit
                  if ((guc_SignOfSeqActive >> i) & 0x1)
                  {
                     s_RevSeg = (~s_RevSeg) & 0x1;
                  }
                  // Preparation of constallation points for tones 0,2,3,4,5,6,8 & 9
                  if (s_RevSeg == 1)
                  {
                     l_SocTxDataForPrbs |= (0x3 << 2*i);
                  }
                  else
                  {
                     l_SocTxDataForPrbs |= (0x0 << 2*i);
                  }
               }
               // add flag tones (tone 10n+1 and 10n+7) constallation to zero
               gl_SocTxDataForPrbs = (l_SocTxDataForPrbs & 0x3)| ((l_SocTxDataForPrbs & 0xFFC) << 2) | ((l_SocTxDataForPrbs & 0xF000) << 4);


               // XDSLRTFW-2451 (start)
               // Special treatment for flag tones ( tone 10n+1 & 10n+7)
               if (gus_VectoringOptionsEnabled & VEC_OPTIONS_FDPS_US_MASK ) // FDPS enabled both at CO and CPE
               {
                  gl_SocTxDataForPrbs |= 0xC00C;   // According to Section 6.2.3/G993.5 (During initialization,
                  // the VTU-O(!) may modulate on all flag tones of the downstream sync
                  // symbols either the downstream pilot sequence (the same as modulated on the probe tones),
                  // or an all ONEs sequence).
                  // since in FDPS, it is not posible to modulate flag tones according to pilit sequence bit,
                  // here we modultat 'ONEs' on flag tones
               }
               else // non FDPS
               {
                  // Avinax CO requires zero on flag tones so that we don't need to modify the flag tones
                  if (gul_fe_G994VendorID != IFX_VENDOR_ID)
                  {
                     if (gl_SocTxDataForPrbs != 0)
                     {
                        gl_SocTxDataForPrbs = 0xFFFFF; // modulate flag tones according to pilot sequence bit
                     }
                  }
               }
               // XDSLRTFW-2451 (end)
               // XDSLRTFW-1696 (end)

            }
            else if (gs_TxFrmCnt == TX_DATA_SYMBOLS_PER_SUPERFRAME)
            {
               // Setup QUITE signal on Non Sync Frames at R-P Vector1-1 state
               us_RefGain = 0x0 ;                       // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
            }
         }
         else
         {
            // Setup QUITE signal on Non Sync Frames at R-P Vector1-1 state
            us_RefGain = 0x0 ;                       // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain

//               gs_TxSubState = R_P_TRAIN_TX_INIT;
            gs_TxNextState = VDSL2_R_P_TRAIN1_TX;
            gl_TrainPhaseSymCnt_start = (gl_TotalTxSymbolCount+1);
            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timout after RP-Vector11
            // Note:
            //       1) It is not possible to set the value here directly since
            //          it is lower than the previous one. So the timeout check
            //          in TxForeGround would directly kick in.
            //       2) guc_SwitchGlobalTimeout must be initialized to zero
            guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_TX;
            guc_TxRxCommunicator |= TX_TIMING_ADVANCE_TRAIN1_COMPLETED;
         }

         if (us_RefGain != 0xFFFF)
         {
            // Setup Iridia QT data path to send R-P_Vector1-1 signal at Sync frame or
            // send quiet, i.e. zero gain.
            gus_RefGain = us_RefGain;                    // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
            gft_IT_MISC_RefGainEna = TRUE;
            if (us_RefGain != 0)
            {
               gft_IT_MISC_RefGainEna = FALSE;
            }
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);
         }

         break;
         //#endif // #ifdef MTK_VECTORING_SUPPORT
      } // end switch
   } // end if   of VDSL2_R_P_VECTOR1_1_TX

   else if(gs_TxState == VDSL2_R_P_TRAIN1_TX) //  VDSL2_R_P_TRAIN1_TX state start
   {
      switch (gs_TxSubState)
      {
      case R_P_TRAIN_TX_INIT:

         if(gl_TxSymbolCount == 0)
         {
            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timout from VECTORING_STATE_TIMEOUT_LEN back
            // to normal STATE_TIMEOUT_LEN.
            // Note: This code is only active for Vectoring!
            if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_TX)
            {
               gl_TxStateTimeOutCount = STATE_TIMEOUT_LEN;
               guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_TX);
            }

            //Clear the bit to indicate that the RX side has not received R-P-Synchro4
            gus_VdslStatusFlag &= ~BITMAP_RX_SYNCHRO_VDSL2;

            //For the diag mode, we modulate each byte in one symbol (instead of 40 symbols)
            //since this is not active SOC message state
            if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
            {
               gft_DisableTxDiagModulation = TRUE;
            }

            // Generate 0x7E
            uc_octet = (uint8)HDLC_FLAG   ;
            ModulateHdlcOctets(&uc_octet, 1);

            if (gft_DSVectoringEnabled == FALSE)
            {
               // Setup for Loading of Transmit Gains
               guc_LoadTransmitGainsState = LTG_LOAD_IRIDIA;
            }
            else
            {
               //Coupled Gain Table at Iridia QT at the end of R-P Vector1 State ( default Iridia QT setup)
               gus_RefGain = 0x2000 ; // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
               gft_IT_MISC_RefGainEna = FALSE;
               AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);
            }
         }

         //Reconfig the HW to change the Tx Gains,
         if ((gft_DSVectoringEnabled == FALSE) && (guc_LoadTransmitGainsState != LTG_LOAD_DONE))
         {
            LoadTransmitGains();
         }
         else
         {
            //indicate to the RX that the TX side start sending the signal
            //so the RX side can retrain its PGA with echo
            //go to the next substate
            gs_TxRxMessaging = PGA_RETRAIN_XMITTING;

            //go to the next substate
            gs_TxSubStateCnt = 0;
            gs_TxSubState = R_P_TRAIN_TX_IDLE;
         }
         break;

      case R_P_TRAIN_TX_IDLE:
         //DSM_Vectoring_Debug:
         //if ( gs_PauseControl == 0x17)
         //   Pause(gs_PauseControl);

      #ifdef DEBUG_VRX518_AFE  //0x510C
            if(gs_PauseControl == 0x510C)
            Pause(gs_PauseControl);
      #endif

         break;
      } // end switch
   } // end if   of VDSL2_R_P_TRAIN1_TX

}
