/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPTrain1TxF_VDSL2_Bridge.c
*
*   This file contains RT state function to transmit R-P-TRAIN1 symbol.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "RTrainingTxF.h"
#include "vdsl_state.h"
#include "vdsl_const.h"
#include "cmv.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RPTrain1TxF_VDSL2_Bridge(void)
*
*   This function maintains VDSL2_R_P_TRAIN1_TX state by being cascaded to
*   RPTrain1TxF_VDSL2(). It keeps transmiting R-P-TRAIN1 symbols.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void RPTrain1TxF_VDSL2_Bridge(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_P_TRAINING1;
   // gus_VdslStatusFlag is set in ROPSynchro4RxF_VDSL2() function to indicate
   // that O-P-Synchro4 has been received
   if (gus_VdslStatusFlag & BITMAP_RX_SYNCHRO_VDSL2)
   {
      gs_TxSubStateCnt++;

      // TX side should send R-P-Synchro4 between 48 and 64 symbols upon detecting O-P-Synchro 4
      // (Note: -7 is applied is to consider the TX and RX path delay
      if (gs_TxSubStateCnt == (50 - 7))
      {
         // go to the next TX state to transmit R-P-Synchro4
         gs_TxNextState = VDSL2_R_P_SYNCHRO4_TX;
         gpF_TxStateFunc = (PtrToFunc)RPSynchro4TxF_VDSL2;
      }
   }
   else
   {
      gs_TxSubStateCnt = 0;
   }
}
