/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPTrain2TxF_VDSL2.c
*
*   This file contains the RT state function for transimiting R-P-TRAIN2 messages
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "IRI_Iof.h"
#include "vdsl_xception.h"
#include "V_STR_IOf.h"
#include "PeriodicStateHandler_VDSL2.h"
#include "ghs.h"
#include "mul.h"
#include "TimingAdvanceHandler.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPTrain2TxF_VDSL2
 *
 *   This function transmits R-P-TRAINING 2 symbols in VDSL2
 *
 *  Prototype:  void RPTrain2TxF_VDSL2(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I/O) TX substate
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *      gl_TxTeqLength -- (I) the length of TX TEQ state
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
/* =============================================== */
/* substates                              */
/* =============================================== */

#define R_P_TRAIN_TX_INIT                  (0)
#define R_P_TRAIN_TX_MSG_INIT               (1)
#define R_P_TRAIN_TX_MODULATE_ONE_BYTE         (2)
#define R_P_TRAIN_TX_APPLY_TA               (3)
#define R_P_TRAIN_TX_IDLE                  (4)

void RPTrain2TxF_VDSL2(void)
{

   uint8 uc_octet;
   int32 l_Acc;
   PtrToBkgdFunc ptrToFunction;

   switch (gs_TxSubState)
   {

   case R_P_TRAIN_TX_INIT:

      //Program the HW at the beginning of this state
      if(gs_TxState == VDSL2_R_P_TRAIN2_TX)
      {
         //Handle the TC CE remove at the end of periodic state
         if(gl_TxSymbolCount >= 1)
         {
            HandleTxCE_PeriodicStateEnd();
         }

         if(gft_TxStateInitFlag == TRUE)
         {
            gft_TxStateInitFlag = FALSE;

            gs_TxSubStateCnt = 1;

            gul_TxTimer = 0xFFFFFFFF;

            if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
            {
               //Enable the feature to repetively send HDLC idle flags
               gft_SocRepeatFlag = TRUE;

               //Force the TX state function to run every symbol
               //(rather than every 40 symbols)
               gft_RunTxStateFuncFlag = TRUE;

               //Use the regular initialization modulation method for this state
               //Note this flag must be set before calling ModulateHdlcOctets()
               gft_DisableTxDiagModulation = FALSE;

               //gs_VDSL2_MIN_R_IDLE_TX_TRAIN2 = gus_NumSymbolsPerBit*8*VDSL2_MIN_R_IDLE_TX_TRAIN2
               MULS16(l_Acc, (int16)(8*VDSL2_MIN_R_IDLE_TX_TRAIN2), gus_NumSymbolsPerBit);
               gs_VDSL2_MIN_R_IDLE_TX_TRAIN2 = (int16)l_Acc;
            }

            // Generate HDLC flag
            uc_octet = (uint8)HDLC_FLAG   ;
            ModulateHdlcOctets(&uc_octet, 1);

         }
         else if(gs_TxSubStateCnt == 1)
         {
            gs_TxSubStateCnt++;

            //Restore the TX Var gain in case it is set to 0 in the previous state
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);
         }

         //CPE has to sent at least 128 symbols of R-IDLE before sending the first message
         // and RX side must be ready to decode O_TA_UPDATE
         if ((gl_TxSymbolCount > gs_VDSL2_MIN_R_IDLE_TX_TRAIN2) && (gs_TxRxMessaging == 11))
         {
            //go to the next TX state to transmit R-TA-UPDATE
            gs_TxNextState = VDSL2_R_TA_UPDATE_TX;

            //reset the counts for the next message
            gs_NumRxRepeatRequest = 0;
            gs_NumTxRepeatRequest = 0;

         }
      }
      else
      {
         //go to the next substate
         gs_TxSubStateCnt = 0;
         gs_TxSubState = R_P_TRAIN_TX_MSG_INIT;
      }

      break;

   case R_P_TRAIN_TX_MSG_INIT:

      if(gs_TxSubStateCnt == 0)
      {
         gs_TxSubStateCnt++;

         //Update the count of the number of the same message has been resent
         gs_NumRxRepeatRequest++;

         //If this is not the message to be resent
         if(gs_NumRxRepeatRequest == 1)
         {
            //Start a background process to initialize the TX message payload buffer
            //by the designated message
            switch(gs_TxState)
            {
            case VDSL2_R_TA_UPDATE_TX:

               //Set gs_UpdateTxMsgIdxFlag to TRUE so the message
               //index, guc_TxHDLCMsgIndex, will be increased by one in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = TRUE;

               //In the current implementation, we do not request another timing advance
               gs_TimingAdvance = 0;
               ptrToFunction = (PtrToBkgdFunc)FormRTAUpdateMsg_VDSL2;

               break;

            case VDSL2_R_ACK_TX:

               //Set gs_UpdateTxMsgIdxFlag to TRUE so the message
               //index, guc_TxHDLCMsgIndex, will be increased by one in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = TRUE;
               gs_SendRAckFlag = ACK_MSG;
               ptrToFunction = (PtrToBkgdFunc)FormRAckMsg_VDSL2;

               break;

            case VDSL2_R_REPEAT_REQUEST_TX:

               //Set this flag to FALSE, so guc_TxHDLCMsgIndex will not be changed in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = FALSE;
               ptrToFunction = (PtrToBkgdFunc)FormORRepeatRqstMsg_VDSL2;

               break;

            default:
               ptrToFunction = 0;

               //The message is not expected, go to fail state
               EnterFailStates(E_CODE_UNEXPECTED_TX_TRAIN2_MSG);
               break;
            }

            gs_FormMsgFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo(ptrToFunction);

         }
         else
         {
            //If after two resending of this message, go to fail state
            if(gs_NumRxRepeatRequest > NUM_RESEND_O_UPDATE)
            {
               EnterFailStates(E_CODE_TX_TRAIN2_FAIL);
            }
            else
            {
               //Set gs_UpdateTxMsgIdxFlag to FALSE so the message
               //index will not be increased (since this is a repeated message)
               gs_UpdateTxMsgIdxFlag = FALSE;
               gs_FormMsgFlag = TRAINING_DONE;
            }
         }
      } //if(gs_TxSubStateCnt == 0)

      //If the background process is finished
      if(gs_FormMsgFlag == TRAINING_DONE)
      {
         //Init. HDLC state machine state
         gs_TxHDLCMsgState = HDLC_TX_START_NEW_MSG;

         //go to the next substate
         gs_TxSubState = R_P_TRAIN_TX_MODULATE_ONE_BYTE;

         //Start from the next symbol, the TX state machine function
         //called only at the first symbol of sending each byte
         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            gft_RunTxStateFuncFlag = FALSE;
         }
      }

      break;

   case R_P_TRAIN_TX_MODULATE_ONE_BYTE: // Modulate 1 byte

      //Modulate a byte
      TxHDLCMsgHandler();

      //When the last byte of this message is sent
      if(gs_TxHDLCMsgState == HDLC_TX_CLOSING_FLAG_DONE)
      {
         //For CPE, set up to do the timing advance
         if((gs_TxState == VDSL2_R_ACK_TX) && (gs_EnableTaBugFix == TRUE)
               && (gt_DecMsg_O_TA_Update.s_TimeAdv != 0))
         {
            gs_TimingAdvance = gt_DecMsg_O_TA_Update.s_TimeAdv;
            gs_TimingAdvanceHandlerState = TIMING_ADVANCE_INIT;

            //Update the timing advance at U2 interface
            gs_TargetTimingAdvance += gs_TimingAdvance;

            //Set this flag to TRUE so the TX state function is run every symbol
            if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
            {
               gft_RunTxStateFuncFlag = TRUE;
            }

            //go to the state to apply TA
            gs_TxSubState = R_P_TRAIN_TX_APPLY_TA;
         }
         else
         {
            gs_TxSubState = R_P_TRAIN_TX_IDLE;
         }

         //Set the TX timer
         gul_TxTimer = 0;
         gul_RxTimer = 0;
      }

      break;

   case R_P_TRAIN_TX_APPLY_TA:

      //Perform (but not calculate) timing advance for CPE
      if (gs_TimingAdvanceHandlerState != TIMING_ADVANCE_DONE)
      {
         TimingAdvanceHandler();
      }
      else
      {
         //Set this flag to FALSE so the TX state function is run every 40 symbols
         if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
         {
            gft_RunTxStateFuncFlag = FALSE;
         }

         gs_TxSubState = R_P_TRAIN_TX_IDLE;
      }

      break;

   case R_P_TRAIN_TX_IDLE:

      //go to the next TX state
      if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
      {
         //XDSLRTFW-1621 DeltInVectoring (Start)
         if (gft_DSVectoringEnabled == TRUE)
         {
            if((gs_TxState == VDSL2_R_ACK_TX) && (gs_RxState == VDSL2_R_O_P_SYNCHRO_V3_RX))
            {
               //go to the next TX state to send R-P-Synchro5
               gs_TxNextState = VDSL2_R_P_SYNCHRO5_TX;
               gpF_TxStateFunc = (PtrToFunc)RPSynchro5TxF_VDSL2;

               //disable repeat the HDLC flag
               //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
               gft_SocRepeatFlag = FALSE;
            }
         }//XDSLRTFW-1621 DeltInVectoring (End)
         else
         {
            if((gs_TxState == VDSL2_R_ACK_TX) && (gs_RxState == VDSL2_R_O_P_MEDLEY_RX_BRIDGE))
            {
               //go to the next TX state to send R-P-Synchro5
               gs_TxNextState = VDSL2_R_P_SYNCHRO5_TX;
               gpF_TxStateFunc = (PtrToFunc)RPSynchro5TxF_VDSL2;

               //disable repeat the HDLC flag
               //if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
               gft_SocRepeatFlag = FALSE;
            }
         }
      }

      if(gul_TxTimer != 0xFFFFFFFF)
      {
         gul_TxTimer++;
      }

      break;
   }

}


