/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RPTrain3TxF_VDSL2Diag.c
*
*   This file contains the CO state function for transimiting O-P-TRAIN3 message
*   in the diagnostic mode
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "fifo.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RPTrain3TxF_VDSL2Diag
 *
 *   This function transmits R-P-TRAINING 3 symbols in VDSL2 diagnostic mode.
 *
 *  Prototype:  void RPTrain3TxF_VDSL2Diag(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount -- (I) TX state symbol count
 *      gs_TxSubState -- (I/O) TX substate
 *      gs_TxNextState -- (O) Next TX state
 *      gpF_TxStateFunc -- (O) Next TX state function pointer
 *      gl_TxTeqLength -- (I) the length of TX TEQ state
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
/* =============================================== */
/* substates                              */
/* =============================================== */

#define R_P_TRAIN3_TX_INIT                  (0)
#define R_P_TRAIN3_TX_MSG_INIT               (1)
#define R_P_TRAIN3_TX_MODULATE_ONE_BYTE         (2)
#define R_P_TRAIN3_TX_IDLE                  (3)

//This function is used for the diag. mode only
//if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
void RPTrain3TxF_VDSL2Diag(void)
{

   uint8 uc_octet;

   PtrToBkgdFunc ptrToFunction;

   switch (gs_TxSubState)
   {

   case R_P_TRAIN3_TX_INIT:

      if(gs_TxState == VDSL2_R_P_TRAIN3_TX)
      {
         //if(gl_TxSymbolCount == 0)
         if(gft_TxStateInitFlag == TRUE)
         {
            gft_TxStateInitFlag = FALSE;

            //Enable the feature to repetively send HDLC idle flags
            gft_SocRepeatFlag = TRUE;

            // Generate HDLC flag
            uc_octet = (uint8)HDLC_FLAG   ;
            ModulateHdlcOctets(&uc_octet, 1);

         }

         //Send R-MSG-LD as soon as the O-MSG-LD is received.
         if(gft_RxMsgLdFlag == TRUE)
         {
            gs_TxNextState = VDSL2_R_MSG_LD_TX;
         }
      }
      else
      {
         gs_TxSubStateCnt = 0;
         gs_TxSubState = R_P_TRAIN3_TX_MSG_INIT;
      }

      break;

   case R_P_TRAIN3_TX_MSG_INIT:

      if(gs_TxSubStateCnt == 0)
      {
         gs_TxSubStateCnt++;

         //Update the number of repeated message has been sent
         gs_NumRxRepeatRequest++;

         //If this is not the message to be resent
         if(gs_NumRxRepeatRequest == 1)
         {
            //Start a background process to initialize the TX message payload buffer
            //by the designated message
            switch(gs_TxState)
            {

            case VDSL2_R_MSG_LD_TX:

               //Set gs_UpdateTxMsgIdxFlag to TRUE so the message
               //index, guc_TxHDLCMsgIndex, will be increased by one in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = TRUE;

               ptrToFunction = (PtrToBkgdFunc)FormMsgLD_VDSL2;
               break;

            case VDSL2_R_REPEAT_REQUEST_TX:

               //Set this flag to FALSE, so guc_TxHDLCMsgIndex will not be changed in TxHDLCMsgHandler()
               gs_UpdateTxMsgIdxFlag = FALSE;
               ptrToFunction = (PtrToBkgdFunc)FormORRepeatRqstMsg_VDSL2;

               break;

            default:
               ptrToFunction = 0;

               //The message is not expected, go to fail state
               EnterFailStates(E_CODE_UNEXPECTED_TX_TRAIN3_MSG);
               break;
            }

            gs_FormMsgFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo(ptrToFunction);

         }
         else
         {
            //If after two resending of this message, go to fail state
            if(gs_NumRxRepeatRequest > NUM_RESEND_O_UPDATE)
            {
               EnterFailStates(E_CODE_TX_TRAIN3_FAIL);
            }
            else
            {
               //Set gs_UpdateTxMsgIdxFlag to FALSE so the message
               //index will not be increased (since this is a repeated message)
               gs_UpdateTxMsgIdxFlag = FALSE;
               gs_FormMsgFlag = TRAINING_DONE;
            }
         }
      } //if(gs_TxSubStateCnt == 0)

      //If the background process is finished
      if(gs_FormMsgFlag == TRAINING_DONE)
      {
         //Init. HDLC state machine state
         gs_TxHDLCMsgState = HDLC_TX_START_NEW_MSG;

         //go to the next substate
         gs_TxSubState = R_P_TRAIN3_TX_MODULATE_ONE_BYTE;

         //Start from the next symbol, the TX state machine function
         //called only at the first symbol of sending each byte
         gft_RunTxStateFuncFlag = FALSE;
      }

      break;

   case R_P_TRAIN3_TX_MODULATE_ONE_BYTE: // Modulate 1 byte

      //Modulate a byte
      TxHDLCMsgHandler();

      //When the last byte of this message is sent
      if(gs_TxHDLCMsgState == HDLC_TX_CLOSING_FLAG_DONE)
      {

         //after TX sends out R-MSG-LD,
         //go to the next RX state to receive R-P-Synchro7
         gs_RxNextState = VDSL2_R_O_P_SYNCHRO7_RX;
         gpF_RxStateFunc = (PtrToFunc)ROPSynchro7RxF_VDSL2Diag;

         //Disable demodulate SOC message
         gft_RxSocMsgDemodFlag = DISABLE_LD_DEMOD_SOC_MSG;

         //goto idle state
         gs_TxSubState = R_P_TRAIN3_TX_IDLE;
      }

      break;

   case R_P_TRAIN3_TX_IDLE:

      //After the RX detects O-P-Synchro7,
      //go to the state to send R-P-Synchro7
      if(gs_RxState == VDSL2_R_O_DIAG_DONE_RX)
      {
         //go to the next TX state to send O-P-Synchro5
         gs_TxNextState = VDSL2_R_P_SYNCHRO7_TX;
         gpF_TxStateFunc = (PtrToFunc)RPSynchro7TxF_VDSL2Diag;

         gft_SocRepeatFlag = FALSE;
      }

      break;
   }

}

