/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*
*   RPVector2TxF_VDSL2.c
*
*   This file contains RT function to transmit States R-P_VECTOR 1-2 till R-P SYNCHRO V2
*
*-------------------------------------------------------------------------
*/

//#ifdef MTK_VECTORING_SUPPORT

#include "common.h"
#include "gdata.h"
#include "ModulateSocMessages.h"
#include "vdsl_state.h"
#include "states.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "cmv.h"

#include "V_STR_IOf.h"
#include "qt_memmap.h"
#include "LL_IOf.h"

#include "FormRErrorFeedbackMsg_VDSL2.h"
#include "vdsl_const.h"
#include "IRI_Iof.h"

/*^^^
*------------------------------------------------------------------------
*
*  Name : RPVector2TxF_VDSL2
*
*
*  Prototype:  void RPVector2TxF_VDSL2(void)
*
*  This function contains four Vectoring Tx states
*     i. VDSL2_R_P_VECTOR1_2_TX            (193) : contains R-P Vector1-2 related code
*    ii. VDSL2_R_P_SYNCHRO_V1_TX           (194) : contains R-P Synchro V1 related code
*   iii. VDSL2_R_P_VECTOR2_TX              (195) : contains R-P Vector 2 related code
*    iv. VDSL2_R_P_SYNCHRO_V2_TX           (196) : contains R-P Synchro V2 related code
*
*    Input Arguments:
*
*  Output Arguments:
*
*   Return:
*      None
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

/* =============================================== */
/* substates                              */
/* =============================================== */

// Sub state definations of VDSL2_R_P_VECTOR1_2_TX state
#define R_P_VECTOR1_2_TX_INIT                        (0)
#define R_P_VECTOR1_2_TX_SIGNAL                      (1)

// Sub state definations of VDSL2_R_P_SYNCHRO_V1_TX state
#define R_P_SYNCHRO_V1_TX_SIGNAL                     (0)

// Sub state definations of VDSL2_R_P_VECTOR2_TX state
#define R_P_VECTOR2_TX_INIT                          (0)
#define R_P_VECTOR2_TX_IDLE                          (1)
#define R_P_VECTOR2_TX_ERB                           (2)

// Sub state definations of VDSL2_R_P_SYNCHRO_V2_TX state
#define R_P_SYNCHRO_V2_TX_SIGNAL                     (0)

extern uint16 gus_NextErrorReportSymbolCount;
extern int16 gs_G9935ErbTxCount;
extern int16 gs_G9935ErbTxCountRef;

void SyncFrameHandling(void)
{
   signed int i;
   uint16 us_PilotSeqIndexWithCycShift;
   int32 l_SocTxDataForPrbs;
   int16 s_RevSeg;


   // XDSLRTFW-1696 (Start)
   // Get US Sync symbol constellation points using FDPS array and the control parameters and
   // store the result in gl_SocTxDataForPrbs variable
   l_SocTxDataForPrbs = 0;
   gl_SocTxDataForPrbs = 0;

   for (i = 0 ; i < 8; i++)
   {
      // main array  : gpuca_FDPSActive   size [8][64]
      // control 1 : gs_VecIndx_PilotSeq
      // control 2 : guca_IndexIndependentPSActive[8]
      // control 3 : guca_CyclicalShiftOfSeqActive[8]
      // control 4 : guc_SignOfSeqActive
      // modulo parameter : gs_VecNPilotLength_US bit field length


      //considing Cyclical Shift of the sequence
      us_PilotSeqIndexWithCycShift  = (uint16)(gs_VecIndx_PilotSeq + guca_CyclicalShiftOfSeqActive[i]*(gs_VecNPilotLength_US >>3));
      // modulo (s_PilotSeqIndexWithCycShift, gs_VecNPilotLength_US)
      while (us_PilotSeqIndexWithCycShift > gs_VecNPilotLength_US)
      {
         us_PilotSeqIndexWithCycShift -= gs_VecNPilotLength_US;
      }

      // get the bit considiring US super frame counter (gs_VecIndx_PilotSeq), cyclical shift and independent pilot sequence
      s_RevSeg = (*(gpuca_FDPSActive + guca_IndexIndependentPSActive[i]*64  + (us_PilotSeqIndexWithCycShift>>3)) >> (us_PilotSeqIndexWithCycShift & 0x7)) & 0x1; // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start-end)

      // considereing sign bit
      if ((guc_SignOfSeqActive >> i) & 0x1)
      {
         s_RevSeg = (~s_RevSeg) & 0x1;
      }
      // Preparation of constallation points for tones 0,2,3,4,5,6,8 & 9
      if (s_RevSeg == 1)
      {
         l_SocTxDataForPrbs |= (0x3 << 2*i);
      }
      else
      {
         l_SocTxDataForPrbs |= (0x0 << 2*i);
      }
   }
   // add flag tones (tone 10n+1 and 10n+7) constallation to ZERO
   gl_SocTxDataForPrbs = (l_SocTxDataForPrbs & 0x3)| ((l_SocTxDataForPrbs & 0xFFC) << 2) | ((l_SocTxDataForPrbs & 0xF000) << 4);

   // XDSLRTFW-2451 (start)
   // Special treatment for flag tones ( tone 10n+1 & 10n+7)
   if (gus_VectoringOptionsEnabled & VEC_OPTIONS_FDPS_US_MASK ) // FDPS enabled both at CO and CPE
   {
      gl_SocTxDataForPrbs |= 0xC00C;   // According to Section 6.2.3/G993.5 (During initialization,
      // the VTU-O(!) may modulate on all flag tones of the downstream sync
      // symbols either the downstream pilot sequence (the same as modulated on the probe tones),
      // or an all ONEs sequence).
      // since in FDPS, it is not posible to modulate flag tones according to pilit sequence bit,
      // here we modultat 'ONEs' on flag tones
   }
   else // non FDPS
   {
      // Avinax CO requires zero on flag tones so that we don't need to modify the flag tones
      if (gul_fe_G994VendorID != IFX_VENDOR_ID)
      {
         if (gl_SocTxDataForPrbs != 0)
         {
            gl_SocTxDataForPrbs = 0xFFFFF; // modulate flag tones according to pilot sequence bit
         }
      }
   }
   // XDSLRTFW-2451 (end)

   // Preparation of sending the US sync symbol via extended SOC message
   for(i=0; i<7; i++)
   {
      gl_SocTxDataForPrbs_ext[i] = 0;
   }

   // Register for tone 16-31
   gl_SocTxDataForPrbs_ext[0]   = gl_SocTxDataForPrbs >> 12;     // 0000 0000 0000 0000 0000 0000 xxxx 00xx
   gl_SocTxDataForPrbs_ext[0]  |= gl_SocTxDataForPrbs <<  8;     // 0000 xxxx 00xx xxxx xxxx 00xx
   gl_SocTxDataForPrbs_ext[0]  |= gl_SocTxDataForPrbs << 28;     // 00xx

   // Register for tone 32-47
   gl_SocTxDataForPrbs_ext[1]   = gl_SocTxDataForPrbs >>  4;     // 0000 0000 0000 0000 xxxx 00xx xxxx xxxx
   gl_SocTxDataForPrbs_ext[1]  |= gl_SocTxDataForPrbs << 16;     // 00xx xxxx xxxx 00xx

   // Register for tone 48-63
   gl_SocTxDataForPrbs_ext[2]   = gl_SocTxDataForPrbs >> 16;     // 0000 0000 0000 0000 0000 0000 0000 xxxx
   gl_SocTxDataForPrbs_ext[2]  |= gl_SocTxDataForPrbs <<  4;     // 0000 0000 xxxx 00xx xxxx xxxx 00xx
   gl_SocTxDataForPrbs_ext[2]  |= gl_SocTxDataForPrbs << 24;     // xxxx 00xx

   // Register for tone 64-79
   gl_SocTxDataForPrbs_ext[3]   = gl_SocTxDataForPrbs >>  8;     // 0000 0000 0000 0000 0000 xxxx 00xx xxxx
   gl_SocTxDataForPrbs_ext[3]  |= gl_SocTxDataForPrbs << 12;     // xxxx 00xx xxxx xxxx 00xx

   // Register for tone 80-95
   gl_SocTxDataForPrbs_ext[4]   = gl_SocTxDataForPrbs;           // 0000 0000 0000 xxxx 00xx xxxx xxxx 00xx
   gl_SocTxDataForPrbs_ext[4]  |= gl_SocTxDataForPrbs << 20;     // xxxx xxxx 00xx

   // Register for tone 96-111
   gl_SocTxDataForPrbs_ext[5]   = gl_SocTxDataForPrbs >> 12;     // 0000 0000 0000 0000 0000 0000 xxxx 00xx
   gl_SocTxDataForPrbs_ext[5]  |= gl_SocTxDataForPrbs <<  8;     // 0000 xxxx 00xx xxxx xxxx 00xx
   gl_SocTxDataForPrbs_ext[5]  |= gl_SocTxDataForPrbs << 28;     // 00xx

   // Register for tone 112-120
   gl_SocTxDataForPrbs_ext[6]   = gl_SocTxDataForPrbs >>  4;     // 0000 0000 0000 0000 xxxx 00xx xxxx xxxx

   // Register for tone 0-15
   gl_SocTxDataForPrbs         |= gl_SocTxDataForPrbs << 20;     // xxxx xxxx 00xx | xxxx 00xx xxxx xxxx 00xx

   // XDSLRTFW-1696 (end)
}

void RPVector2TxF_VDSL2(void)
{
   uint8 uca_octet[24];
   uint32 ul_tmpWord;
   uint16 us_G9935TxWindowStart;
   int16 i, s_tmp;


   if ( gs_TxState  == VDSL2_R_P_VECTOR1_2_TX)
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[4]=VDSL2_R_P_VECTOR1_2;
      switch (gs_TxSubState)
      {

      case R_P_VECTOR1_2_TX_INIT:
         // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
         // Switch global state timout from STATE_TIMEOUT_LEN back to VECTORING_STATE_TIMEOUT_LEN.
         if(guc_SwitchGlobalTimeout & SWITCH_GLOBAL_TIMEOUT_TX)
         {
            gl_TxStateTimeOutCount = VECTORING_STATE_TIMEOUT_LEN;
            guc_SwitchGlobalTimeout &= (~SWITCH_GLOBAL_TIMEOUT_TX);
         }

         //Start QUITE phase of R-P-Vector1-2
         gus_RefGain = 0x0 ; // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
         gft_IT_MISC_RefGainEna = TRUE;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);

         gs_TxSubState = R_P_VECTOR1_2_TX_SIGNAL;
         break;


      case R_P_VECTOR1_2_TX_SIGNAL:
         if ((gs_MsgReceiveOPSYNCHROV1Flag != TRUE) ||
               (gs_TxFrmCnt > (TX_DATA_SYMBOLS_PER_SUPERFRAME - 34)) ||
               (gs_TxFrmCnt < 2))
         {
            // check for Tx Sync frame
            // setup Transmitter to send R-P_Vector1-2 signal
            // transmit every sync frame
            // Last symbol of R-P Vector1-2 must not be at sync symbol position!
            // Add a gurad band around the sync symbol for better synchro detection on the CO side!
            if (gs_TxFrmCnt == TX_DATA_SYMBOLS_PER_SUPERFRAME-1)
            {
               int16 s_RevSeg;
               uint16 us_PilotSeqIndexWithCycShift;
               int32 l_SocTxDataForPrbs;

//                  if(gs_PauseControl == 0x61)
//                     Pause(gs_PauseControl);

               // setup Iridia QT data path to send R-P_Vector1-2 signal at Sync frame
               gus_RefGain = 0x2000 ; // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
               gft_IT_MISC_RefGainEna = FALSE;
               AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);

               // XDSLRTFW-1696 (Start)
               // Get US Sync symbol constellation points using FDPS array and the control parameters and
               // store the result in gl_SocTxDataForPrbs variable

               l_SocTxDataForPrbs = 0;
               gl_SocTxDataForPrbs = 0;

               for (i = 0 ; i < 8; i++)
               {
                  // main array  : gpuca_FDPSActive   size [8][64]
                  // control 1 : gs_VecIndx_PilotSeq
                  // control 2 : guca_IndexIndependentPSActive[8]
                  // control 3 : guca_CyclicalShiftOfSeqActive[8]
                  // control 4 : guc_SignOfSeqActive
                  // modulo parameter : gs_VecNPilotLength_US bit field length

                  //considing Cyclical Shift of the sequence
                  us_PilotSeqIndexWithCycShift  = (uint16)(gs_VecIndx_PilotSeq + guca_CyclicalShiftOfSeqActive[i]*(gs_VecNPilotLength_US >>3));
                  // modulo (s_PilotSeqIndexWithCycShift, gs_VecNPilotLength_US)
                  while (us_PilotSeqIndexWithCycShift > gs_VecNPilotLength_US)
                  {
                     us_PilotSeqIndexWithCycShift -= gs_VecNPilotLength_US;
                  }

                  // get the bit considiring US super frame counter (gs_VecIndx_PilotSeq), cyclical shift and independent pilot sequence
                  s_RevSeg = (*(gpuca_FDPSActive + guca_IndexIndependentPSActive[i]*64  + (us_PilotSeqIndexWithCycShift>>3)) >> (us_PilotSeqIndexWithCycShift & 0x7)) & 0x1; // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start-end)

                  // considereing sign bit
                  if ((guc_SignOfSeqActive >> i) & 0x1)
                  {
                     s_RevSeg = (~s_RevSeg) & 0x1;
                  }
                  // Preparation of constallation points for tones 0,2,3,4,5,6,8 & 9
                  if (s_RevSeg == 1)
                  {
                     l_SocTxDataForPrbs |= (0x3 << 2*i);
                  }
                  else
                  {
                     l_SocTxDataForPrbs |= (0x0 << 2*i);
                  }
               }
               // add flag tones (tone 10n+1 and 10n+7) constallation to zero
               gl_SocTxDataForPrbs = (l_SocTxDataForPrbs & 0x3)| ((l_SocTxDataForPrbs & 0xFFC) << 2) | ((l_SocTxDataForPrbs & 0xF000) << 4);


               // XDSLRTFW-2451 (start)
               // Special treatment for flag tones ( tone 10n+1 & 10n+7)
               if (gus_VectoringOptionsEnabled & VEC_OPTIONS_FDPS_US_MASK ) // FDPS enabled both at CO and CPE
               {
                  gl_SocTxDataForPrbs |= 0xC00C;   // According to Section 6.2.3/G993.5 (During initialization,
                  // the VTU-O(!) may modulate on all flag tones of the downstream sync
                  // symbols either the downstream pilot sequence (the same as modulated on the probe tones),
                  // or an all ONEs sequence).
                  // since in FDPS, it is not posible to modulate flag tones according to pilit sequence bit,
                  // here we modultat 'ONEs' on flag tones
               }
               else // non FDPS
               {
                  // Avinax CO requires zero on flag tones so that we don't need to modify the flag tones
                  if (gul_fe_G994VendorID != IFX_VENDOR_ID)
                  {
                     if (gl_SocTxDataForPrbs != 0)
                     {
                        gl_SocTxDataForPrbs = 0xFFFFF; // modulate flag tones according to pilot sequence bit
                     }
                  }
               }
               // XDSLRTFW-2451 (end)
               // XDSLRTFW-1696 (End)
            }
            else if (gs_TxFrmCnt == TX_DATA_SYMBOLS_PER_SUPERFRAME)
            {
//                  if(gs_PauseControl == 0x62)
//                     Pause(gs_PauseControl);

               // Setup QUITE signal on Non Sync Frames at R-P Vector1-2 state
               gus_RefGain = 0x0 ; // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
               gft_IT_MISC_RefGainEna = TRUE;
               AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);
            }
         }
         else
         {
            // move to transmissting R-P-SYNCHRO V1
            gs_MsgReceiveOPSYNCHROV1Flag = FALSE;

            // go to R-P-Synchro V1 Tx State
            gs_TxNextState = VDSL2_R_P_SYNCHRO_V1_TX;
            // During state change sub state will initialize to zero and the code
            // will go to R_P_SYNCHRO_V1_TX_SIGNAL sub state
         }
         break;
      } // end switch
   } // end if of  VDSL2_R_P_VECTOR1_2_TX state
   else if (gs_TxState == VDSL2_R_P_SYNCHRO_V1_TX)
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[4]=VDSL2_R_P_SYNCHRO_V1;
      // We are using this switch funchtion below only to make this state function code similar to other state function code
      switch (gs_TxSubState)
      {
      case R_P_SYNCHRO_V1_TX_SIGNAL:

         if (gl_TxSymbolCount == 0)
         {
            //Coupled Gain Table at Iridia QT at the end of R-P Vector1-2 State ( default Iridia QT setup)
            gus_RefGain = 0x2000 ; // 0x2000 = Unity Gain in 2.13 format, 0 = Zero Gain
            gft_IT_MISC_RefGainEna = FALSE;
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, IridiaTxGainScaleDataPathControl);
         }
         //For the first 5 and last 5 symbols, set all the tones to (-,-)
         if((gl_TxSymbolCount == 0) || (gl_TxSymbolCount == 10))
         {
            gl_SocTxDataForPrbs = 0xFFFFFFFF;
         }

         //For 3 middle symbols, //set all tones to (+,+)
         else if(gl_TxSymbolCount == 5)
         {
            gl_SocTxDataForPrbs = 0x0;
         }
         //After sending the 15-th symbol, go to O-P-Quiet/O-P-Pilot state if the lineprobe
         //is requested, go to O-P-Peridic state if the lineprobe is not requested
         else if(gl_TxSymbolCount == 14)
         {
            // go to R-P Vector2 Tx state
            gs_TxNextState = VDSL2_R_P_VECTOR2_TX ;
            // During state change sub state will initialize to zero and the code
            // will go to R_P_VECTOR2_TX_INIT sub state
         }
         for(i=0; i<7; i++)
         {
            gl_SocTxDataForPrbs_ext[i] =  gl_SocTxDataForPrbs;
         }

         break;
      } // end switch
   } // end if of  VDSL2_R_P_SYNCHRO_V1_TX state
   else if (gs_TxState == VDSL2_R_P_VECTOR2_TX)
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[4]=VDSL2_R_P_VECTOR2;
      switch (gs_TxSubState)
      {
      case R_P_VECTOR2_TX_INIT:

         // introduce extended SOC
         s_tmp = (int16) gt_DecMsg_O_TA_Update.t_G9935_O_TA_Update_Prm.uc_SOCRepetitionFactor;
         gs_TxNumBytesPerSymbol = s_tmp/5;

         // Transmit Idle flag & configure SOC
         for(i=0; i<gs_TxNumBytesPerSymbol; i++)
         {
            uca_octet[i] = (uint8)0x7E;
         }

         ModulateHdlcOctets(uca_octet, gs_TxNumBytesPerSymbol);
         // Prepare SOC repetition according to O-TA_Update (Table 10-10/G.993.5) Field#3
         ReadCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR,&ul_tmpWord);

         gul_QtpTxPrbsMisc_Shadow = ul_tmpWord;  // end of R-P Vector2 this register need to be restored
         ul_tmpWord &= 0xFF01FFFF;
         ul_tmpWord |= ( (s_tmp-1) << 17);
         WriteCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, ul_tmpWord);

         guc_TxHDLCMsgIndexBackup = guc_TxHDLCMsgIndex;     //Store TX Message index of RQ mode to guc_TxHDLCMsgIndexBackup variable
         guc_TxHDLCMsgIndex = 0x01;                   // Prepare Message Index (Table 12-1/G993.2) field for ERB transmission in R-P Vector2 State according to AR mode

         gs_TxSubState = R_P_VECTOR2_TX_IDLE;
         break;

      case R_P_VECTOR2_TX_IDLE:
         // check for Tx Sync frame
         // setup Transmitter to send R-P_Vector2 signal
         // transmit every sync frame

         // check if this needs to be SyncFrm - 1
         if (gs_TxFrmCnt == TX_DATA_SYMBOLS_PER_SUPERFRAME-1)
         {
            SyncFrameHandling();
         }
         else //All other symbols are modulated with IDLE
         {
            if (gs_MsgReceiveOPSYNCHROV1Flag != TRUE)
            {
               //AddFunctionToFifo(gp_TxLoadingFunctionFifo, ClearTxVarGain);
               //Modulate 1 or 2 HDLC flags into one symbol
               //(Note: gs_TxNumBytesPerSymbol is set to be either 1 or 2)
               // Transmit Idle flag
               for(i=0; i<gs_TxNumBytesPerSymbol; i++)
               {
                  uca_octet[i] = (uint8)0x7E;
               }

               // we cannot use this function for modulating the synch symbol because
               // this function fills in 00 constellations every 5th tone
               ModulateHdlcOctets(uca_octet, gs_TxNumBytesPerSymbol);

               //Check if ERB is ready to be transmitted
               if((gs_G9935ErrorFeedbackState == G9935_ERRORFB_FORM_MSG) && (gs_FormMsgFlag == TRAINING_DONE))
               {
                  // Check if We are in the Transmit Window
                  us_G9935TxWindowStart = gus_NextErrorReportSymbolCount + 3;  // minimum t_start = 3 symbol  (Figure 10-9/G993.5)
                  if(us_G9935TxWindowStart>256)
                  {
                     us_G9935TxWindowStart = -256 + us_G9935TxWindowStart;
                  }

                  if(gs_RxFrmCnt>us_G9935TxWindowStart)
                  {
                     gs_FormMsgFlag = TRAINING_IN_PROGRESS;              // Do not enter the above if-case again!

                     //XDSLRTFW-1621 DeltInVectoring (Start/End)
                     if (((gus_VectoringOptionsEnabled & VEC_OPTIONS_FULL_FRIENDLY_MASK) == 0) ||(gft_DeltInVectoringMode ==0))
                     {
                        DSH_SendStream(DSH_R_ERROR_FEEDBACK, (uint16)(3),(void *)gpuca_TxSocMsg);

                       //Init. TxHDLCMsgHandler() to initial state
                       gs_TxHDLCMsgState = HDLC_TX_START_NEW_MSG;
                       //Go to next substate to transmit message
                       gs_TxSubState = R_P_VECTOR2_TX_ERB;
                    }
                    else // G993.2 Annex O Vectoring Friendly mode
                    {
                       //goto idle state
                       //gs_TxSubStateCnt = 0;
                       gs_TxSubState = R_P_VECTOR2_TX_IDLE;
                       gs_G9935ErrorFeedbackState = G9935_ERRORFB_SOCMSG_SENT;
                    }
                 }
              }
           }
           else
           {
              DSH_SendStream(DSH_R_ERROR_FEEDBACK, (uint16)gs_NumOctetsInTxHDLCMsg,(void *)gpuca_TxSocMsg);
              // move to transmit R-P-SYNCHRO V2
              gs_MsgReceiveOPSYNCHROV1Flag = FALSE;
              // Restore QTP_TX_PRBS_MISC (0x252814) register to its original value where
              // the repetition rate is 5 or 10 tones per symbol
              WriteCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, gul_QtpTxPrbsMisc_Shadow);

              gft_TxHDLCSegmentedAutoRepeatMode = 0; // make sure that Segmented AR mode is disabled while finishing R-P Vector-2 State

              guc_TxHDLCMsgIndex = guc_TxHDLCMsgIndexBackup; // restore back Message Index field for RQ mode ( Section 12.2.2.2/G993.2)

              // go to R-P Synchro V2 Tx state
              gs_TxNextState = VDSL2_R_P_SYNCHRO_V2_TX;
              // During state change sub state will initialize to zero and the code
              // will go to R_P_SYNCHRO_V2_TX_SIGNAL sub state
           }
         }
         break;

      case R_P_VECTOR2_TX_ERB:
         //check if this needs to be SyncFrm - 1
         if ( gs_TxFrmCnt == TX_DATA_SYMBOLS_PER_SUPERFRAME-1)  // Transmit Sync Symbol even during ERB transmission
         {
            SyncFrameHandling();
         }
         else   // Transmit ERB
         {
            // Note: The ERB SOC msg is normally not a multiple of 8 (17a) or 16 (35b) bytes.
            //       The missing bytes will be filled with idle "FLAGS" implicitly with aid of state "HDLC_TX_CLOSING_FLAG_DONE".
            TxHDLCMsgHandler();

            if(gs_TxHDLCMsgState == HDLC_TX_CLOSING_FLAG_DONE)
            {
               //Set gs_UpdateTxMsgIdxFlag to TRUE so the message
               //index will be increased for next message
               gs_UpdateTxMsgIdxFlag = TRUE;

               //goto idle state
               gs_TxSubStateCnt = 0;
               gs_TxSubState = R_P_VECTOR2_TX_IDLE;
               gs_G9935ErrorFeedbackState = G9935_ERRORFB_SOCMSG_SENT;

               // gft_TxHDLCSegmentedAutoRepeatMode = 0;
            }

            // XDSLRTFW-3003 : Vectoring - FW always sends the full ERB and is violating the 64 symbol constrain after receiving the O-P-SYNCHRO V4
            // Note: The code was moved at this place so that at least 1 symbol idle "FLAGS" are transmitted.
            //       This is done implicitly with aid of state "HDLC_TX_CLOSING_FLAG_DONE".
            if ((gs_MsgReceiveOPSYNCHROV1Flag == TRUE) && (gs_TxHDLCMsgState != HDLC_TX_CLOSING_FLAG_DONE))
            {
               if ((gs_G9935ErbTxCount + (64 + 2)) < gs_G9935ErbTxCountRef)
               {
                  gs_TxHDLCMsgState = HDLC_TX_CLOSING_FLAG_DONE;
               }
            }
         }
         break;
      } // end switch
   }// end if of   VDSL2_R_P_SYNCHRO_V1_TX state
   else if (gs_TxState == VDSL2_R_P_SYNCHRO_V2_TX)
   {
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[4]=VDSL2_R_P_SYNCHRO_V2;
      // We are using this switch funchtion below only to make this state function code similar to other state function code
      switch (gs_TxSubState)
      {
      case R_P_SYNCHRO_V2_TX_SIGNAL:
         //For the first 5 and last 5 symbols, set all the tones to (-,-)
         if((gl_TxSymbolCount == 0) || (gl_TxSymbolCount == 10))
         {
            GenerateSynSymLookUpData((int16)(-gs_TxGain));
         }
         //For 3 middle symbols, //set all tones to (+,+)
         else if(gl_TxSymbolCount == 5)
         {
            GenerateSynSymLookUpData(gs_TxGain);
         }
         //After sending the 15-th symbol, go to O-P-Quiet/O-P-Pilot state if the lineprobe
         //is requested, go to O-P-Peridic state if the lineprobe is not requested
         else if(gl_TxSymbolCount == 14)
         {
            gs_TxNextState = VDSL2_R_P_MEDLEY_TX_BRIDGE;
            gpF_TxStateFunc = (PtrToFunc)RPMedleyTxF_VDSL2_Bridge;

            // XDSLRTFW-1242: Bugfix_ALL_VDSL2_ALL_CleanupGlobalVectoringTimeouts (Start/End)
            // Switch global state timout after RP-SYNCHROV2
            // Note:
            //       1) It is not possible to set the value here directly since
            //          it is lower than the previous one. So the timeout check
            //          in TxForeGround would directly kick in.
            //       2) guc_SwitchGlobalTimeout must be initialized to zero
            guc_SwitchGlobalTimeout |= SWITCH_GLOBAL_TIMEOUT_TX;
         }

         break;
      } //switch
   } // end if of VDSL2_R_P_SYNCHRO_V2_TX state
}
//#endif
