/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_data.c
 *
 *   This is a file containing global variables used by Handshake files
 *
 *------------------------------------------------------------------------
 */

//************************************************************************************
// hs_data.c
//
// History
//
// 10/07/2013 Sriram Shastry : Bug in check condition for setting up error code to indicate CO perfers ADSL mode
//
// Grep for XDSLRTFW-1005 : BugFix_ALL_ALL_ALL_Hsk_LookforADSLAnnexbits
//************************************************************************************
#include "common.h"
#include "ghs.h"

//****                                   ****
//****  Handshake global variable declarations    ****
//****                                   ****

//---- Handshake carrier sets ----
int16 gs_GhsCarSetCfg;      // E.g. A43, B43, etc., used to index tables below

int16 gs_GhsCarSetCfgInternal; //XDSLRTFW-3515

int16 gs_GhsCarSetActual;      // E.g. A43, B43, etc., used to index tables below

int16 gsa_UpCarSetTable[NUM_CARRIER_SETS][NUM_CARRIER] =
{
   9, 17, 25,         // A43: ADSL(A); ADSL2(A); ADSL2+(A,I); VDSL2 w/US0
   9, 17, 25,         // A43C: ADSL2+(A,I,J,M) Cabinet-Case
   37, 45, 53,         // B43: ADSL(B); ADSL2(B); ADSL2+(B); VDSL2 w/US0
   37, 45, 53,         // B43C: ADSL2+(B)
   7, 9, 9,         // C43: ADSL(C,H,I); ADSL2(C), note only 2 US carriers
   9, 17, 25,         // J43: ADSL2(J,M); ADSL2+(J,M)
   944, 972, 999,       // V43: VDSL2 wo/US0
   9, 17, 25,         // V43P: VDSL1 o POTS
   37, 45, 53         // V43I: VDSL1 o ISDN
};

int16 gsa_DnCarSetTable[NUM_CARRIER_SETS][NUM_CARRIER] =
{
   40, 56, 64,         // A43: ADSL(A); ADSL2(A); ADSL2+(A,I); VDSL2 w/US0
   257, 293, 337,       // A43C: ADSL2+(A,I,J,M) Cabinet-Case
   72, 88, 96,         // B43: ADSL(B); ADSL2(B); ADSL2+(B); VDSL2 w/US0
   257, 293, 337,      // B43C: ADSL2+(B)
   12, 14, 64,         // C43: ADSL(C,H,I); ADSL2(C)
   72, 88, 96,         // J43: ADSL2(J,M); ADSL2+(J,M)
   257, 383, 511,        // V43: VDSL2 wo/US0
   257, 383, 511,      // V43P: VDSL1 o POTS
   257, 383, 511      // V43I: VDSL1 o ISDN
};

// Actual DS and US carrier sets used during GHS
int16 gsa_DnCarSet[NUM_CARRIER];
int16 gsa_UpCarSet[NUM_CARRIER];

int16 gs_numtrials = 0;

int16 *gpsa_TxCarSetTable;
int16 *gpsa_RxCarSet;
int16 gsa_TxGhsToneBuf[2*NUM_CARRIER];      // GHS tone buffer to be loaded to the HW IFFT input buffer

// ---- Message buffer pointers -----------
uint8* gpuca_RxMsgBuf;         //pointer to guca_RxMsgBuf[MESSAGE_BUF_LEN]
uint8* gpuca_DecodeBuf;         //pointer to guca_DecodeBuf[DECODE_BUF_LEN]
uint8* gpuca_TxMsgBuf;         //pointer to guca_TxMsgBuf[MESSAGE_BUF_LEN]
uint8* gpuca_EncodeBuf;         //pointer to guca_EncodeBuf[ENCODE_BUF_LEN]

InfoField_t* gpt_RxInfo;      // pointer to gt_RxInfo
InfoField_t* gpt_RxInfoSave;   // pointer to gt_RxInfoSave
InfoField_t* gpt_TxInfo;      // pointer to gt_TxInfo
InfoField_t* gpt_TxInfoSave;   // pointer to gt_TxInfoSave

//---- global variables and structures for DPSK modulation/demodulation ----
int16 gs_DETECT_SCALE = DETECT_SCALE;   // tone detection threshold
int16 gs_TxAn_Prev;               // last bit symbol for xceiver
uint8 guc_TxOctet;               // Octet buffers for Tx
uint8 guc_RxOctet;               // Octet buffers for Rx
Complex_t gta_RxSymbolBuf[NUM_CARRIER][RX_SYMBOL_BUF_SIZE];   // memory of complex valued DMT symbols for designated carrier bins in Rx
Complex_t gt_RxCurrentSymbol[ NUM_CARRIER ];            // current bit symbol for RX
Complex_t gt_RxLastSymbol[ NUM_CARRIER ];               // last bit symbol for RX

int16 gs_ReAlignSubState;            // substate variable used only in RxSymbolReAlign().
FlagT gft_SymbolReAlignRequired;      // flag indicating symbol re-alignment is required

//---- Symbol and Octet Counters ----
int16 gs_HandShake_Cnt;            // number of times going through GHS

// TX/Encode
uint16 gus_NumberOfMsgOctetsSent;   // Counter for number of octets per transmission. Necessary when doing message segmentation.
uint16 gus_TotalNumberOfMsgOctets;   // Total number of octets in a message to be transmitted.
// If larger than 64 octets, than perform mesage segmentation.
int16 gs_TxMsgBufCnt;             // number of octets in a message to be transmitted
int16 gs_TxOctetCnt;               // counts number of octets in a given TxSubState

// RX/Decode
int16 gs_DecodeBufCnt;             // number of octets in a total message being decoded
int16 gs_RxMsgBufCnt;              // number of octets in a message being received
int16 gs_RxOctetCnt;               // counts number of octets in a given RxSubState

int16 gs_RxGhsSymCnt;            // Rx symbol count used only in C_R_MSG_RX state
uint8 guc_RxGalfCnt;               // counts the number of R_GALF2 octets

//--- global variables used for handling message retransmission
uint8 guc_TxHSMsg_SegmentCnt;      // Tx Msg Segment counter
uint8 guc_RxHSMsg_SegmentCnt;      // Rx Msg Segment counter
uint8 guc_TxHSReqRtx_cnt;         // The transmitted HS REQ_RTX msg counter
uint8 guc_RxHSReqRtx_cnt;         // The received HS REQ_RTX msg counter
uint8 guc_last_rx_msg_type;         // type of last correctly received message segment
uint8 guc_last_tx_msg_type;         // type of last correctly transmitted message segment
int16 gs_LastTxMsgBufCnt;         // number of octets in the last message to be transmitted
int16 gft_RTXCtrlFlag;            // flag to control retransmission operation

// --- variable for link start/cleardown procedure
int16 gs_HostCommand;          // host command. host can start G.hs by setting this variable to START_GHS
int16 gs_GhsTerminateFlag;

// Number of cleardown flags before the GALFs are sent (in the usual RT initiated cleardown)
int16 gs_num_cleardown_flags = NUM_CLEARDOWN_FLAG ;
int16 gs_num_cleardown_flags_short = 5 ;            // triggered against BDCM

//---- global variables used for GHS message state machine ----
HandShakeControl_t gt_hsc;      // handshake control structure
uint8 guc_NotUnderstood;      // flag to indicate message not understood
FlagT gft_Previous_NAK_NS;     // TRUE = NAK_NS message is received by CO for the previous MS message
// FALSE = NAK_NS message is not received by CO for the previous MS message
uint16 gus_ExtraBits;           // represent how many bits are set to 1 in the ignored CL/CLR octets.
int16 gft_WholeTxMsgComplete;   // flag indicate if a whole tx msg is complete (TRUE) or not (FALSE)

//misc
uint8 guc_NewRxMsgType;         // Used in leave state trail function

//---- global variables for power calculation ----
FlagT gft_HsPgaCalcStatus;
int16 gs_HsPgaCalcSymCnt;
int16 gs_PgaCalcDoneCnt;      // substate count on which PGA-1 calc completes
int32 gl_InitRxHsTonesPower;   // the average power of the 3 upstream handshake tones when first detected by the modem.

// Debug code which can be removed later - start
uint16 gs_DnCarSet_ref;
int16 gs_TryNext;
int16 gs_CheckClipping;
// Debug code which can be removed later - end


int32 gl_HsToneSetPower;
int16 gs_HsTonePower_dB;
// XDSLRTFW-3599 : Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile (Start)
int32 gl_RCGalf2HsTonesPower;
int16 gs_RCGalf2HsTonePower_dB;
// XDSLRTFW-3599 : Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile (End)

// function pointer arrays to all HSMsgHandler substate functions
void (*MsgHandler_states [GHS_MAX_MESSAGE_STATES]) (void) = { &R_HS_INITIAL_state,
      &R_HS_SEND_MR_state,
      &R_HS_SEND_MS_state,
      &R_HS_SEND_CLR_state,
      &R_HS_MS_OK_state,
      &R_HS_CL_OK_state,
      &R_HS_PARTIAL_MS_state,
      &R_HS_PARTIAL_CL_state,
      &R_HS_NOT_READY_state,
      &R_HS_NOT_SUPPORTED_state,
      &R_HS_NOT_UNDERSTOOD_state,
      &R_HS_RESTART_state,
      &R_HS_SEND_MP_state,
      &R_HS_RETRANSMIT_state
                                                            };

// Far-end Operating Modes
FE_OperatingModes_t gt_FE_OperatingModes;

// Far-end VDSL2 standard information fields from capabilities list
VDSL2_FE_StdInfo_CL_t gt_VDSL2_FE_StdInfo_CL;
