/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             hs_mesg.c
 *
 * DESCRIPTION:      Message handling functions used in Handshaking.
 *
 **********************************************************************/

// ****************************************************************************************************
// FormRMsg1MSg_VDSL2.c
// History :
//  06/05/2013 Varun : Added code(Debug option) to mark the end of GHs in Debug Buffer and initiate the DMA to
//                external SDRAM
//                   Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//  19/12/2017 Abu Rahman
//  XDSLRTFW-3599: Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile
//  Root cause of this problem was longer Ghs R-FLAG2 transmission due to not detecting end of CO Ghs signal
//  in time. This longer R-FLAG2 transmission destroyed US QLN measurement and receiver training on the CO
//  side which leaded to low us performance.
//  Solution: Enhanced end of C-GALF2 (i.e. no CO Ghs signal on the line) detection logic.
//  Old method looked C-Tones compared to neighboring tones. If C-Tones power is less than 3 dB compared to
//  neighboring tone power it declared end of C-GALF2 state. New implementation computes and compares
//  C-Tone power at each symbol of C-GALF2 state. In this State, if the C-Tone power is at least 6 dB lower than
//  initially measured C-Tone power then silence (end of C-GALF2 signal) is declared. By this new method false
//  detection of C-GALF2 signal can be eliminated.
//  Grep for XDSLRTFW-3599
//
//
//****************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv_Data.h"
#include "ghs.h"
#include "vdsl_xception.h"
#include "cnfg_task.h"
#include "vdsl_state.h"
#include "states.h"
#include "OTrainingTxF.h"
#include "ORTrainingRxF.h"
#include "RTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "ghs_cpe.h"
#include "rx_ops.h"
#include "codeswap.h"
#include "fifo.h"
#include "cmv.h"
#include "V_STR_IOf.h"
#include "DebugBuffer.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "ConvertToDB.h"

extern int32 gl_RxSymbolCount_dbg;
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : FailHandshakeTx
 *
 *  Abstract :
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gs_TxNextState
 *         gpF_TxStateFunc
 *
 *  Notes :
 *
 *-------------------------------------------------------------------
 *^^^
 */
void FailHandshakeTx(uint32 ul_ExceptionCode)
{
//-----------------
// VDSL_BONDING
//-----------------
#ifdef VDSL_BONDING
#endif
//-----------------
   if ((gs_MONI_AutoRestart & MONI_RESTART_AT_FAIL) == 0)
   {
      EnterFailStates(ul_ExceptionCode);
   }
   else
   {

      gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;

      /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
      gs_RxNextState = R_C_SILENT1_RX;
      gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;
   }

}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : FailHandshakeRx
 *
 *  Abstract :
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gs_RxNextState
 *         gpF_RxStateFunc
 *  Notes :
 *
 *-------------------------------------------------------------------
 *^^^
 */
void FailHandshakeRx(uint32 ul_ExceptionCode)
{
//-----------------
// VDSL_BONDING
//-----------------
#ifdef VDSL_BONDING
#endif
//-----------------
   if ((gs_MONI_AutoRestart & MONI_RESTART_AT_FAIL) == 0)
   {
      EnterFailStates(ul_ExceptionCode);
   }
   else
   {
      gs_RxNextState = R_C_SILENT1_RX;
      gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;

      /* ---- if timeout or tone loss in the Rx side, Tx also go back to the beginning ---- */
      gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
   }

}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : PostHandshakeCodeswap
 *
 *  Abstract :
 *
 *  Returns:   FALSE   -- Codeswap Not Done
 *            TRUE   -- Codeswap Done
 *
 *  Global Variables Used:
 *  Notes :
 *
 *-------------------------------------------------------------------
 *^^^
 */
FlagT PostHandshakeCodeswap(int32 l_SymCount, uint8 uc_Page)
{
   if (l_SymCount == 0)
   {
      FreeSwapHandle(&guc_PrimPageHandle);
      guc_RxSwapActivity = CODESWAP_LOAD(uc_Page);
   }

   // Request the next swap page
   if (guc_RxSwapActivity == CODESWAP_LOAD(uc_Page))
   {
      if ((guc_PrimPageHandle = RequestSwap(uc_Page)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
   }
   // Poll for codeswap done
   else if (PollForCodeSwapDone(uc_Page, guc_PrimPageHandle) == SWAP_DONE)
   {
      return (TRUE);
   }

   return (FALSE);
}

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : C_FLAG2_TX
 *
 *  Abstract :
 *
 *  FLAG characters are transmitted continuously until a GALF
 *  character is received.  Exits to selected G.hs mode when a GALF
 *  character is received.

 *  Returns: None
 *
 *  Global Variables Used:
 *      gsa_TxGhsToneBuf[] - (O) the output GHS tones in TxBit()
 *      gs_LoadGhsToneFlag - (O) GHS tone control flag
 *      guc_TxOctet       - (I/O) current octet being transmitted
 *      gs_RxState        - (I) current RX state
 *      gs_TxSubState     - (I/O) current TX substate
 *      gl_TxSymbolCount  - (I) # symbol periods in current TX state
 *      gs_TxOctetCnt     - (O) # octets transmitted in this state
 *      gs_TxNextState    - (O) TX state that will begin next symbol period
 *      gt_hsc            - (I/O)
 *
 *  Notes :
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RFlag2TxF(void)

{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_FLAG2;
   FlagT ft_readyToTerminateGhsTx=FALSE;

   //---- initialize ----
   if ( gl_TxSymbolCount == 0 )
   {

      //Enable loading GHS tone bit, enable register start IFFT bit
      gs_LoadGhsToneFlag = (BITMAP_LOAD_GHS_TONES | BITMAP_REGSTART_IFFT);

      guc_TxOctet = FLAG;
   }


   /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX )
   {
      gs_TxNextState =R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      return;

   }



   //---- Transmit guc_TxOctet bit by bit ----
   TxBit();

   //---- Do post handshake codeswap ----
   if (gt_hsc.l_SelectedMode == NO_COMMON_MODE ||
         gt_hsc.l_SelectedMode == SILENCE ||
         gt_hsc.l_SelectedMode == RESTART_VIA_CLEARDOWN)
   {
      ft_readyToTerminateGhsTx = TRUE;
   }
   else if (gt_hsc.l_SelectedMode == G993_2)
   {
      ft_readyToTerminateGhsTx = PostHandshakeCodeswap(gl_TxSymbolCount, VDSL_CHDIS_1_V2_PM_SWAPPAGE);
   }

   //---- Run State m/c ----
   switch (gs_TxSubState)
   {
      //---- wait till a GALF is received in Rx side ----
   case 0:
      //==== if completing one octet ====
      if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
      {
         // guc_TxOctet is cleared in TxBit() currently, so need to re-initialize it
         guc_TxOctet = FLAG;

         if (gt_hsc.s_RxMsgComplete == TRUE)
         {
            gt_hsc.s_RxMsgComplete = FALSE;  // reset flag
            gs_TxOctetCnt = 0;
            gs_TxSubState = 1;
         }
      }
      break;

      //---- transmit additional FLAGs until ready to terminate GHS Tx ----
   case 1:
      //==== if completing one octet ====
      if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
      {

         // guc_TxOctet is cleared in TxBit() currently, so need to re-initialize it
         guc_TxOctet = FLAG;

         gs_TxOctetCnt++;
         // Terminate Tx handshake if ready
         if (ft_readyToTerminateGhsTx)
         {
            gt_hsc.s_TxMsgComplete = TRUE;
            //Sending silence after flags by disable loading GHS tone bit
            //(but still enable register start IFFT bit)
            gs_LoadGhsToneFlag = (~BITMAP_LOAD_GHS_TONES & BITMAP_REGSTART_IFFT);

            gs_TxOctetCnt = 0;
            gs_TxSubState = 2;

         }
         // Codeswap not done withing max cleardown duration
         else if (gs_TxOctetCnt >= (TIME_500MS / SYMBOLS_PER_OCTET))
         {
            // Goto FAIL state
            EnterFailStates(E_CODE_CODESWAP_ERR);
         }
      }
      break;

      // --- transmit silence to terminate GHS session ---------------------
   case 2:
      gs_TxOctetCnt++;
      if (gs_TxOctetCnt >= NUM_CLEARDOWN_SILENCE)
      {
         TerminateHandshakeTx();
      }

      break;

   } //switch()

}   // CFlag2TxF



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : C_GALF2_TX
 *
 *  Abstract :
 *
 *  FLAG characters are transmitted for a while not exceeding 500ms
 *  followed by 4 GALF characters.  Then, G.HS exits to selected G.hs mode.
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *      gsa_TxGhsToneBuf[] - (O) the output GHS tones in TxBit()
 *      gs_LoadGhsToneFlag - (O) GHS tone control flag
 *      guc_TxOctet       - (I/O) current octet being transmitted
 *      gs_RxState        - (I) current RX state
 *      gs_TxSubState     - (I/O) current TX substate
 *      gl_TxSymbolCount  - (I) # symbol periods in current TX state
 *      gs_TxOctetCnt     - (O) # octets transmitted in this state
 *      gpuca_TxMsgBuf[]   - (I) message octets to be transmitted in this state
 *      gs_TxNextState    - (O) TX state that will begin next symbol period
 *      guc_EscToFR_Flag      - (I/O) flag indicating to exig G.hs to Fast Retrain
 *      gt_hsc            - (I/O)
 *
 *  Notes :
 *
 *  States: C_GALF2
 *
 *-------------------------------------------------------------------
 *^^^
 */

void RGalf2TxF(void)

{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_GALF2;
   FlagT ft_readyToTerminateGhsTx=FALSE;

   //---- initialize ----
   if ( gl_TxSymbolCount == 0 )
   {

      //Enable loading GHS tone bit, enable register start IFFT bit
      gs_LoadGhsToneFlag = (BITMAP_LOAD_GHS_TONES | BITMAP_REGSTART_IFFT);

      gs_TxOctetCnt = 0;
      guc_TxOctet   = FLAG;
   }

   /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX )
   {
      gs_TxNextState =R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      return;

   }

   //---- Transmit guc_TxOctet bit by bit ----
   TxBit();

   //---- Do post handshake codeswap ----
   if (gt_hsc.l_SelectedMode == NO_COMMON_MODE ||
         gt_hsc.l_SelectedMode == SILENCE ||
         gt_hsc.l_SelectedMode == RESTART_VIA_CLEARDOWN)
   {
      ft_readyToTerminateGhsTx = TRUE;
   }
   else if (gt_hsc.l_SelectedMode == G993_2)
   {
      ft_readyToTerminateGhsTx = PostHandshakeCodeswap(gl_TxSymbolCount, VDSL_CHDIS_1_V2_PM_SWAPPAGE);
   }

   //---- Run State m/c ----
   switch(gs_TxSubState)
   {
      //---- transmit FLAGs until ready to terminate GHS Tx ----
   case 0:
      //==== if completing one octet ====
      if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
      {
         // guc_TxOctet is cleared in TxBit() currently, so need to re-initialize it
         guc_TxOctet = FLAG;

         gs_TxOctetCnt++;
         // Terminate Tx handshake if ready
         if (ft_readyToTerminateGhsTx)
         {
            guc_TxOctet   = GALF;
            gs_TxOctetCnt = 0;
            gs_TxSubState = 1;
         }
         // Codeswap not done withing max cleardown duration
         else if (gs_TxOctetCnt >= (TIME_500MS / SYMBOLS_PER_OCTET))
         {
            // Goto FAIL state
            EnterFailStates(E_CODE_CODESWAP_ERR);
         }
      } //if ( (gl_TxSymbolCount & MODULO_BY_64_MASK)

      break;

      //---- transmit NUM_CLEARDOWN_GALF GALFs  ----
   case 1:
      //==== if completing one octet ====
      if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
      {
         // guc_TxOctet is cleared in TxBit() currently, so need to re-initialize it
         guc_TxOctet = GALF;

         gs_TxOctetCnt++;
         if (gs_TxOctetCnt == NUM_CLEARDOWN_GALF)
         {
            gt_hsc.s_TxMsgComplete = TRUE;
            //Sending silence after flags by disable loading GHS tone bit
            //(but still enable register start IFFT bit)
            gs_LoadGhsToneFlag = (~BITMAP_LOAD_GHS_TONES & BITMAP_REGSTART_IFFT);

            gs_TxOctetCnt = 0;
            gs_TxSubState = 2;
         }
      } //if ( (gl_TxSymbolCount & MODULO_BY_64_MASK)
      break;

      // --- transmit silence to terminate GHS session ---------------------
   case 2:
      gs_TxOctetCnt++;
      if(gs_TxOctetCnt >= NUM_CLEARDOWN_SILENCE)
      {
         TerminateHandshakeTx();
      }
      break;

   }  //switch

}   // CGalf2TxF

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : C_R_FLAG2_RX_F
 *
 *  Abstract :
 *
 *  Wait till Tx finishes GALF transmission and move to next state.
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *
 *  Notes :
 *
 *  States: C_R_FLAG2_RX
 *-------------------------------------------------------------------
 *^^^
 */

void RCFlag2RxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_C_FLAG2;
   if ( gl_RxSymbolCount == 0 )
   {
      gs_RxSubStateCnt = 0;
   }


   switch(gs_RxSubState)
   {

   case 0:
      //==== check for end of C_R_Flag2, equivalently look for silence ====
      if ( DetectMultiTones( gpsa_RxCarSet, NUM_CARRIER, gs_DETECT_SCALE) == 0 )
      {
         gs_RxSubStateCnt++;
      }
      else
      {
         gs_RxSubStateCnt = 0;
      }

      if ( gs_RxSubStateCnt >= CLEARDOWN_SILENCE_DETECT_CNT)
      {
         gs_RxSubState = 1;
         gs_RxSubStateCnt = 0;
      }

      break;

   case 1:
      //Terminate GHS RX processing and transit to training state
      TerminateHandshakeRx();
      gs_RxSubStateCnt++;

      break;

   } // switch


   if ( gl_RxSymbolCount > HS_TONE_TIMEOUT)
   {
      // Goto FAIL state
      EnterFailStates(E_CODE_GHS_TIMEOUT);
   }
}    // CRFlag2RxF


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : C_R_GALF2_RX
 *
 *  Abstract :
 *
 *  Wait for a GALF characters.  Exits to selected G.hs mode when
 *  a GALF character is received.
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *      gpsa_FFT_InBuf[]   - input of IFFT
 *      gs_RxToneBuf[]    - frequency domain samples
 *      ( above two are used in RxBit() )
 *      guc_RxOctet       - (I/O) current octet being transmitted
 *      gs_RxState        - (I) current RX state
 *      gs_RxSubState     - (I/O) current RX substate
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *
 *
 *  Notes :
 *
 *-------------------------------------------------------------------
 *^^^
 */

void RCGalf2RxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_C_GALF2;
   int16 s_tx_state;

   s_tx_state = R_FLAG2_TX;

   if ( gl_RxSymbolCount == 0 )
   {
      gs_RxSubStateCnt = 0;
      guc_RxGalfCnt = 0;
   }

   //---- Bit Detection : common for all substates ----
   RxBit(gpsa_RxCarSet, (int16) (gl_RxSymbolCount & MODULO_BY_8_MASK) );

   //==== if one full octet received, check for GALF character ====
   switch (gs_RxSubState)
   {

      //---- wait for a GALF or silence (in case GALFs are not detected by any chance) ----
   case 0:
      // XDSLRTFW-3599 : Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile (Start)
      // gl_RCGalf2HsTonesPower contains Ghs Tone power (linear) at every symbol in C-GALF2 state
      gl_RCGalf2HsTonesPower = RxPowerGHS(gsa_DnCarSet, (int16)(LOG2_NUM_CARRIER + 1));

      // gs_RCGalf2HsTonePower_dB contains C-GALF2 Ghs Tone Power in dB in 8.8 format
      gs_RCGalf2HsTonePower_dB = ConvertToDB(gl_RCGalf2HsTonesPower) - gs_PGA_set_GHS; // XDSLRTFW-3764 (Start_End)

      // Indicate Silence of the line (i.e. CO stop sending C-GALF2 signal) if C-GALF2 Ghs Tone power is at least 6 dB (note1)lower
      // than previously calculated Ghs tone power.
      // note1: 6 dB threshold was taken empirically.
      //        Test result showed that C-Tone power is very stable throughout the Ghs session.
      //        On very long loop where loop attenuation and line noise are dominating factor at least 6 dB GHS SNR is needed to
      //        continue the Ghs Session even though this SNR is not enough for continuing training. That's why 6dB threshold is taken.
      //        We also assumed that Ghs X-talk amplitude will not exceed more than 25% of the active Ghs C-Tones amplitude (i.e Ghs x-talk
      //        power will be at least 6dB lower than active Ghs C-Tone power)

      if (gs_RCGalf2HsTonePower_dB < (gs_HsTonePower_dB - 0x600)) // Ghs tone powers are in 8.8 dB format
      {
         gs_RxSubStateCnt++;
         // After 5th symbol consecutive silence detection rx state machine declares silence( end of C-GALF2) state
      }
      else
      {
         gs_RxSubStateCnt = 0;
      }
      // XDSLRTFW-3599 : Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile (End)

      if ( ( gl_RxSymbolCount & MODULO_BY_64_MASK ) == (SYMBOLS_PER_OCTET - 1) )
      {
         //---- FLAG or any non-GALF octets are ignored ----
         if (guc_RxOctet == GALF)
         {
            guc_RxGalfCnt++;
         }
         else
         {
            guc_RxGalfCnt = 0;
         }
      }

      if (guc_RxGalfCnt == NUM_CLEARDOWN_GALF ||
            (gs_RxSubStateCnt >= CLEARDOWN_SILENCE_DETECT_CNT&& gs_TxState == s_tx_state))   // Wait for Tx transition before declaring silence
      {
         gt_hsc.s_RxMsgComplete = TRUE;
         gs_RxSubState = 1;
         gs_RxSubStateCnt = 0;

      }
      break;

      // --- wait for TX side to finish and then terminate GHS
   case 1:
      //Terminate GHS RX processing and transit to the beginning of training
      TerminateHandshakeRx();
      gs_RxSubStateCnt++;

      break;

   } // switch

   if ( gl_RxSymbolCount > HS_TONE_TIMEOUT)
   {
      // Goto FAIL state
      EnterFailStates(E_CODE_GHS_TIMEOUT);
   }
}   // CRGalf2RxF


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : TerminateHandshakeTx
 *
 *  Abstract : Terminate handshake and jump to next Tx state according to
               handshake result
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gs_TxNextState
 *
 *  Notes : used in CGalf2TxF() and CFlag2TxF()
 *
 *-------------------------------------------------------------------
 *^^^
 */
void TerminateHandshakeTx(void)
{
   //Set the bit to indicate TX side has reached to the GHS termination
   gs_GhsTerminateFlag |= GHS_TX_TERMINATE;

   //If both sides reaches to the termination, set the next TX state to the new state
   if ((gs_GhsTerminateFlag & (GHS_TX_TERMINATE|GHS_RX_TERMINATE) ) == (GHS_TX_TERMINATE|GHS_RX_TERMINATE))
   {
      switch (gt_hsc.l_SelectedMode)
      {

      case NO_COMMON_MODE: // According to G.994.1, if no common mode was selected, both stations shall return to the initial GHS states
         FailHandshakeTx(E_CODE_GHS_NO_COMMON_MODE);
         break;

      case SILENCE:        //silence period requested
         FailHandshakeTx(E_CODE_GHS_SILENT);
         break;

      case RESTART_VIA_CLEARDOWN:
         // gt_hsc.l_SelectedMode is reset in C_R_TONES_REQ_RX state
         // gs_TxNextState = C_SILENT1_TX;
         FailHandshakeTx(E_CODE_GHS_CLEARDOWN);
         break;

         //---- proceed to transceiver training ----
      case T1_MCM_VDSL:
      case G993_2:

         if ((gs_GhsTerminateFlag & GHS_TX_FG_TRANSMIT_SILENT) == 0)
         {
            gs_GhsTerminateFlag |= (GHS_TERMINATE_STATE_BG_INIT | GHS_TX_FG_TRANSMIT_SILENT);

            gs_TxVarGain = 0;
            gs_TxVarGainExp = UNITY_TX_VAR_GAIN_EXP;

            AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);
         }
         else
         {
            if ((gs_GhsTerminateFlag & GHS_TERMINATE_STATE_MASK) == GHS_TERMINATE_STATE_EXIT)
            {
               gs_GhsTerminateFlag |= GHS_TX_GHS_EXIT;

               //Set the initial training state
               gs_TxNextState = R_P_QUITE1_TX;
               gpF_TxStateFunc = (PtrToFunc)RMsg1TxF_VDSL2;

#ifdef DEBUG_TRACES
               // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
               //mark the end of GHS in the debug buffer
               LogMessages(1,DEBUG_BUFFER_DELIMETER_GHS_END);

               if(((gt_DebugBuffControl.us_debugBuffer_StopStartCaptureData) & GHS_TRAINING_CAPTURE_DISABLE_MASK) == 0)
               {
                  if((PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE))
                  {
                     gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_SOURCE_INDEX] = (int32)(gpusa_debugBuff);  // update source address
                     gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_DEST_INDEX] = (int32)gpuca_offChipBuff; // destination;
                  gta_BAR15LookUpTable[OFF_CHIP_DEBUG_BUF][OFF_CHIP_LENGTH_INDEX] = (gt_debugBufStatus.s_debugBufIndex<<1);    // size in bytes; make sure length is multiple of 4-bytes

                     // Free handle for PSD offchip request
                     FreeSwapHandle(&guc_OffChipRequestHandle);
                     guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF, OFF_CHIP_DEBUG_BUF);

                  gpuca_offChipBuff=guca_offChipDebugBuff+(gt_debugBufStatus.s_debugBufIndex<<1); // increment the pointer of guc_offChipDebugBuff to suitable value
                  gt_DebugBufferStatus.s_debugBuffer_GHS_TO_EXCHANGE_length=gt_debugBufStatus.s_debugBufIndex;

                  gt_debugBufStatus.s_debugBufIndex=0; //reset the pointer to the internal debug buffer
                     gul_DMA_Busy_Error=0;
                  }
                  else
                  {
                     gul_DMA_Busy_Error++;
                  }
               }
               // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif //#ifdef DEBUG_TRACES
            }
         }

         break;

      }  // switch
   } //if((gs_GhsTerminateFlag & (GHS_TX_TERMINATE|GHS_RX_TERMINATE) )

} //TerminateHandshakeTx


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : TerminateHandshakeRx
 *
 *  Abstract : Terminate handshake and jump to next Rx state according to
               handshake result
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gt_hsc
 *          gs_RxNextState
 *
 *  Notes : used in CRGalf2RxF() and CRFlag2RxF()
 *
 *-------------------------------------------------------------------
 *^^^
 */
void TerminateHandshakeRx(void)
{
   //Set the bit to indicate RX side has reached to the GHS termination
   gs_GhsTerminateFlag |= GHS_RX_TERMINATE;

   //If both sides reaches to the termination, set the next TX state to the new state
   if ((gs_GhsTerminateFlag & (GHS_TX_TERMINATE|GHS_RX_TERMINATE) ) == (GHS_TX_TERMINATE|GHS_RX_TERMINATE))
   {
      switch (gt_hsc.l_SelectedMode)
      {

      case NO_COMMON_MODE: // According to G.994.1, if no common mode was selected, both stations shall return to the initial GHS states
         FailHandshakeRx(E_CODE_GHS_NO_COMMON_MODE);
         break;

      case SILENCE:        //silence period requested
         FailHandshakeRx(E_CODE_GHS_SILENT);
         break;

      case RESTART_VIA_CLEARDOWN:
         // gt_hsc.l_SelectedMode is reset in C_R_TONES_REQ_RX state
         // gs_TxNextState = C_SILENT1_TX;
         FailHandshakeRx(E_CODE_GHS_CLEARDOWN);
         break;

         //---- proceed to transceiver training ----
      case T1_MCM_VDSL:
      case G993_2:
#ifdef DEBUG_VRX518_AFE  //0x510D
         gula_DebugVarsPalak[11] = gl_RxSymbolCount_dbg;
                        if(gs_PauseControl == 0x510D)
                        Pause(gs_PauseControl);
#endif

         // Init modem variables after GHS will be done by RX side only.
         // TX will wait until init is done before transition to training.
         {
            uint16 us_GhsTerminateState;

            us_GhsTerminateState = (gs_GhsTerminateFlag & GHS_TERMINATE_STATE_MASK);
            switch (us_GhsTerminateState)
            {
            case GHS_TERMINATE_STATE_BG_INIT:
               gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitModem_PostHandshake);

               us_GhsTerminateState = GHS_TERMINATE_STATE_FG_INIT;
               break;

            case GHS_TERMINATE_STATE_FG_INIT:
               if (gs_RxBkgdProcessFlag == TRAINING_DONE)
               {
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo, LinkStart_ForPostGhs);
                  us_GhsTerminateState = GHS_TERMINATE_STATE_INIT_MODEM_DONE;
               }
               break;

            case GHS_TERMINATE_STATE_INIT_MODEM_DONE:
               // signal TX side that postGhs init is done.
               us_GhsTerminateState = GHS_TERMINATE_STATE_EXIT;

               //Set the next RX state to the first training state
               gs_RxNextState = R_O_P_QUITE1_RX;
               gpF_RxStateFunc = (PtrToFunc)ROTrainRxF_VDSL2;

               if((gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) == 0)
               {
                  gsa_IndirectStat0[0] = STAT_FullInitState;
                  gusa_MONI_ModemStat_Status[0] = MONI_STAT_FULL_INIT;
               }
               else
               {
                  gsa_IndirectStat0[0] = STAT_LoopDiagMode;
                  gusa_MONI_ModemStat_Status[0] = MONI_STAT_DIAG_MODE;
               }
               // increment total number of full initializations attempted on the line (successful and failed)
               gt_g997_LineInitPerf_Running.l_FullInitCount += 1;
               gt_g997_LineInitPerf_Current_Previous_TR1.t_Current.l_FullInitCount += 1;
               //XDSLRTFW-2794 (start)
               //Call this function for 35Mode only  once after strymon is taken out of reset and SRC is started running
               //Strymon taken out of reset from the function "LinkStart_ForPostGhs"
               if ( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)||(gft_Debug35bHwConfig17aModeEnable == TRUE) )
               {
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo, CfgSRCCTL);
               }

               //Set the bit "EN_ST_QT_PMS_DONE_STATUS_TIME_SLOT" for not to clear the CRI EVENT & STATUS register.
               //This is required to monitor the QT & PMS done status in Time slotted mode.
               gul_35bLiteConfig |= EN_ST_QT_PMS_DONE_STATUS_TIME_SLOT;

               //XDSLRTFW-2794 (end)
               break;

//               case GHS_TERMINATE_STATE_EXIT:
//               default:
//                  break;
            }

            gs_GhsTerminateFlag &= (~GHS_TERMINATE_STATE_MASK);
            gs_GhsTerminateFlag |= us_GhsTerminateState;
         }
         break;

      }  // switch
   } //if((gs_GhsTerminateFlag & (GHS_TX_TERMINATE|GHS_RX_TERMINATE) )

} // Terminate handshake Rx


void TerminateSnifferGhs(void)
{
   //@todo: to be deleted
}
