/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: hs_init.c
*
*   This file contains handshake functions used in pre/post GHS initialization.
*
*-------------------------------------------------------------------------------
*/

// ****************************************************************************************************
// hs_init.c
// History :
//  06/05/2013 Varun : Added code(Debug option) to initialize the variables related to Debug Buffer(Showtime+
//                   Training) and mark the start of Ghs in Debug Buffer
//                     Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and
//                            "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 28/05/2013 Varun - initialized variable which helps to avoid conflict between DMA of L2 back Channel and DMA of Debug Buffer
//  Search for "XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 24/07/2013 Vinjam: Added new IOP bit to change the GHs Revision between "2" & "3".
//            CMV allotted: CMV INFO 232 2 Bit#2, default set to G.Hs revision as "2".
//            Grep for XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange
//****************************************************************************************************

#include <string.h>                    //for memset and memcpy
#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "DebugBuffer.h"

//Initialize the pointer variables used by the GHS
#define GHS_RXMSGBUF_OFFSET      (0)
#define GHS_TXMSGBUF_OFFSET      (MESSAGE_BUF_LEN)
#define GHS_DECODEBUF_OFFSET   (GHS_TXMSGBUF_OFFSET+MESSAGE_BUF_LEN)
#define GHS_ENCODEBUF_OFFSET   (GHS_DECODEBUF_OFFSET+DECODE_BUF_LEN)
#define GHS_RXINFO_OFFSET      (GHS_ENCODEBUF_OFFSET+ENCODE_BUF_LEN+4)   //add an extra 4 for size conversion

// Note: The parameter for the function "InitGhsPointers", the parameter was of type uint8
//       but to suppress/remove warning, the parameter is changed to type void. Suitable
//       correction are carried out in the function and wherever it is employed.

void InitGhsPointers(uint8 *puca_HndshkBuf)
{
   int16 s_InfoSize;

   gpuca_RxMsgBuf   = &puca_HndshkBuf[GHS_RXMSGBUF_OFFSET];
   gpuca_TxMsgBuf   = &puca_HndshkBuf[GHS_TXMSGBUF_OFFSET];
   gpuca_DecodeBuf = &puca_HndshkBuf[GHS_DECODEBUF_OFFSET];
   gpuca_EncodeBuf = &puca_HndshkBuf[GHS_ENCODEBUF_OFFSET];

   gpt_RxInfo     = (InfoField_t*)(void *)&puca_HndshkBuf[GHS_RXINFO_OFFSET];
   s_InfoSize      = sizeof(InfoField_t) + 4;   //add an extra 4 for size boundary conversion
   gpt_RxInfoSave  = (InfoField_t*)(void *)&puca_HndshkBuf[GHS_RXINFO_OFFSET + s_InfoSize];
   gpt_TxInfo     = (InfoField_t*)(void *)&puca_HndshkBuf[GHS_RXINFO_OFFSET + 2*s_InfoSize];
   gpt_TxInfoSave  = (InfoField_t*)(void *)&puca_HndshkBuf[GHS_RXINFO_OFFSET + 3*s_InfoSize];

   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   // XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //initialize the variables
#ifdef DEBUG_TRACES
// The pragma is ARC only!
#pragma Off(Behaved)
   gpuca_DebugBuff_PingPong=(uint8 *)(void *)&gt_DebugBuff.gusa_DebugBuf;
#pragma Pop(Behaved)
   gt_DebugBufferStatus.s_debugBuffer_Size_of_Per_Symbol_structure_Bytes = sizeof(DebugShowTimeBuffSymbol_t);
   gt_DebugBufferStatus.s_debugBuffer_Size_of_Super_Frame_structure_Bytes = 0;
   gpuca_offChipBuffShowtime=&guca_offChipDebugBuff[SDRAM_RAW_DUMP_SHOWTIME_START_INDEX];
   gus_LenDebugBuff=0;
   guc_StLengthFlag=0;
   gul_LenoffChipBuffShowtime=0;
   guc_ShowtimeEnter=0;

   gt_debugBufStatus.s_debugBufIndex=0;
   gt_DebugBufferStatus.s_debugBuffer_Showtime_length=0;
   gt_DebugBufferStatus.s_debugBuffer_GHS_TO_EXCHANGE_length=0;
   gt_DebugBufferStatus.s_debugBuffer_Showtime_Oldested_data_Start=0;
   // XDSLRTFW-3035 (Start_End)
   gt_DebugBufferStatus.us_debugBuffer_Version = 0x0201;                // 1st VRx518 version: 0x0201

   gul_DMA_Busy_Error=0;
//snv
#ifdef MIPS_PROFILE_USRETX
   gl_mipsdebug1=gl_mipsdebug2=gl_mipsdebug3=0,gl_mipsdebug4=gl_mipsdebug5=gl_mipsdebug6=0;
#endif

   // XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif // #ifdef DEBUG_TRACES

   //XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)

   guc_EVB_DebugBuff_flag=0;
#ifdef DEBUG_TRACES
   // XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
   //mark the start of GHS in the debug buffer
   LogMessages(1,DEBUG_BUFFER_DELIMITER_GHS_START);
#endif //#ifdef DEBUG_TRACES


}

//Initialize the pointer variables used by the GHS
#undef GHS_RXMSGBUF_OFFSET
#undef GHS_TXMSGBUF_OFFSET
#undef GHS_DECODEBUF_OFFSET
#undef GHS_ENCODEBUF_OFFSET
#undef GHS_RXINFO_OFFSET




/*^^^
 *-------------------------------------------------------------------
 *
 *  Name : InitializeParameterInfoField
 *
 *  Abstract :
 *
 *  InitializeInfoField() - Initialize an Information Field structure
 *
 *  Parameters:
 *      InfoField_t *t_Info : information structure to be initialized
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes :
 *
 *-------------------------------------------------------------------
 *^^^
 */

void InitializeParameterInfoField(InfoField_t * t_I)
{

//   int16 i;

   // fill struct with zero
   memset(t_I, 0, sizeof(InfoField_t));

//    t_I->uc_Type           = 0;         // message type field

   //XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange (Start)
   if(gt_CustomerIopBits.us_Generic_IOP_Fixes & GENERIC_GHS_REVISION_CHANGE_IN_GHS_MSGS)
   {
      t_I->uc_Rev            = REVISION3;  // revision number field
   }
   else
   {
      t_I->uc_Rev            = REVISION2;  // revision number field
   }
   //XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange (End)

   //==== Vendor ID field ====
   t_I->us_Country        = ((gt_ne_VendorInformation.uca_CountryCode[0]<<8) |
                             (gt_ne_VendorInformation.uca_CountryCode[1]));      // T.35 country code
   t_I->ul_Provider       = ((gt_ne_VendorInformation.uca_VendorId[0]<<24) |
                             (gt_ne_VendorInformation.uca_VendorId[1]<<16) |
                             (gt_ne_VendorInformation.uca_VendorId[2]<<8) |
                             (gt_ne_VendorInformation.uca_VendorId[3]));         // provider code (Vendor ID, 4 octets)
   t_I->us_VendorInfo     = ((gt_ne_VendorInformation.uca_VendorSpecific[0]<<8) |
                             (gt_ne_VendorInformation.uca_VendorSpecific[1]));   // vendor specific information (2 octets)
}


