/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_rx.c
 *
 *   Receiver state operations for Handshaking.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "mul.h"
#include "dsp_op.h"
#include "cmv.h"
/*
 *------------------------------------------------------------------------
 *
 *  Name : DemodBit
 *
 *  Abstract :
 *
 *  Demodulates one bit of information out of the current and last received bit
 *  symbols.
 *
 *  Parameters:
 *          t_RxCurrentSymbol[]    -   measured tones of current bit symbol
 *          t_RxLastSymbol[]       -   measured tones of the last bit symbol
 *
 *  Returns:
 *          s_bn                   -   determined bit ( 0 or 1 )
 *
 *  Global Variables Used:
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 */

int16 DemodBit( Complex_t t_RxCurrentSymbol[], Complex_t t_RxLastSymbol[] )
{

   int16  i;
   int16 s_Vote;
   int32 l_ProductX, l_Product1, l_Product2;


   s_Vote = 0;

   for ( i = 0; i < NUM_CARRIER; i++ )
   {

      //---- real part of a complex product ( Current_Symbol * Conjugate(Last_Symbol) ) ----
      MULS16(l_Product1, t_RxCurrentSymbol[i].s_X, t_RxLastSymbol[i].s_X);
      MULS16(l_Product2, t_RxCurrentSymbol[i].s_Y, t_RxLastSymbol[i].s_Y);
      l_ProductX = l_Product1 + l_Product2;

      ( l_ProductX >= 0 )?    s_Vote-- : s_Vote++ ; // hard decision and voting (1 for 1, -1 for 0)
   }

   //---- majority vote ----
   return ( ( s_Vote >= 0 ) ?  1 : 0 );

}   // DemodBit


#define BITSPERCYCLE       (11)
#define BITSPERQUARTER     (BITSPERCYCLE-2)
#define A_FIX              (3392)       // (4*C_FIX-512)*16
#define TMP_SCALE          (1<<22)
#define C_FIX              (181)  //C_FIX = round(2^8 * C)
#define PI_FIX             (3217) //pi*2^10
static int16 CosSineFix(int16 s_phase,int16 *ps_sin, int16 *ps_cos)
{
   int32 l_phasein = s_phase; // Phase input
   FlagT ft_flag = 0;
   int16 s_quadrant;
   int32 l_sinout;
   int32 l_cosout;
   int32 l_x1;
   int32 l_temp;

   if(l_phasein < 0)
   {
      l_phasein = l_phasein+PLL_PI_RADIANS;
      ft_flag = 1;
   }
   /**<
      @NOTE: @mahesh: Can we somehow eliminate the below division operation?
   */
   l_phasein = ((l_phasein<<7)/(PI_FIX));

   s_quadrant = l_phasein >> (BITSPERQUARTER);

   if(!s_quadrant)
   {
      l_x1 = l_phasein - 256;
   }
   else
   {
      l_x1 = (256+512) - l_phasein;
   }

   l_temp = -A_FIX * l_x1*l_x1 + C_FIX*TMP_SCALE;

   l_sinout = (l_x1<<21) + l_temp;
   if(!s_quadrant)
   {
      l_cosout = l_temp - (l_x1<<21);
   }
   else
   {
      l_cosout = (l_x1<<21) - l_temp;
   }

   if (ft_flag)
   {
      l_sinout = -l_sinout;
      l_cosout = -l_cosout;
   }

   /**<@NOTE:
   @mahesh: Output is in 1.30 format */

   /**<@NOTE: IF CPE has ARC700 or higher & has an intrinsic sat16 we can replace the Round32to16 by the below lines

      #ifdef _ARC
      // On ARC700 use (custom) intrinsic for DSPS_Sat32To16(), as we have the sat16 extension instruction
         #pragma intrinsic(sature16, name=>"sat16", opcode => 0x05, sub_opcode => 0x02, flags => "znv");
      #endif
   */
   *ps_sin = sature16(l_sinout>>15);
   *ps_cos = sature16(l_cosout>>15);

   return 0;
}

/*
 *------------------------------------------------------------------------
 *
 *  Name : RxBit
 *
 *  Abstract :
 *
 *  RxBit() - Receive a bit and fill up guc_RxOctet from the LSB
 *            Update gs_RxAn_Prev
 *            Right shift guc_RxOctet by one bit to get ready for next bit
 *
 *  Parameters:
 *     int16 sa_CarSet[]    Frequency bins of the carrier set to be used
 *     int16   s_SubBit  -   current subbit index
 *
 *  Returns:     None
 *
 *  Global Variables Used:
 *      guc_RxOctet       - (O)   current octet being transmitted
 *      gs_RxAn_Prev      - (I,O) Last An symbol for DPSK purpose
 *      gsa_RxSubBiBuf    - (O)
 *      gpsa_RxToneBuf   - (I)   frequency domains sampples used in TxTones().
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 */

void RxBit(int16 sa_CarSet[], int16 s_SubBit)
{

   int16  i;
   int16 s_bn;
   uint8 uc_subbit_start = SUBBIT_START;
   uint8 uc_subbit_end = SUBBIT_END;
   uint8 uc_shift = 3;

   if ((TESTArray[TEST_Control3] & TEST_GHS_Fix) == 0)
   {
      uc_subbit_start = SUBBIT_START + 1 ;
      uc_subbit_end = SUBBIT_END - 1;
      uc_shift--;
   }

   //---- reset variables at the beginning of averaging ----
   if ( s_SubBit == uc_subbit_start)
   {
      for ( i = 0; i < NUM_CARRIER; i++ )
      {
         gt_RxCurrentSymbol[i].s_X = 0;
         gt_RxCurrentSymbol[i].s_Y = 0;
      }
   }

   //---- calc vector sum of received tones for four center subbits ----
   if ( (uc_subbit_start <= s_SubBit) && (s_SubBit <= uc_subbit_end) )
   {
      for ( i = 0; i < NUM_CARRIER; i++ )
      {
         int16 s_y,s_x;
         s_x =   gpsa_RxToneBuf[ 2*sa_CarSet[i] ];
         s_y =   gpsa_RxToneBuf[ 2*sa_CarSet[i] + 1];

         if (TESTArray[TEST_Control3] & TEST_GHS_Fix)
         {
            int16 exp_x, exp_y,exp;
            int16 s_angle;

            //Normalize real & imag values before finding the angle
            exp_x = norm_16bit(s_x);
            exp_y = norm_16bit(s_y);
            if (exp_x < exp_y)
            {
               exp = exp_x;
            }
            else
            {
               exp = exp_y;
            }

            s_angle = FastAtan(s_y<<exp, s_x<<exp);// angle of received tone sample
            CosSineFix(s_angle,&s_y,&s_x);
         }
         //NOTE: output of fast cosine is 1.15 & Tone buffer is in 3.13, but for DEMOD by
         // hard decision, it should be ok . Needs to be revisited
         // we add 6 subbits 1-6, so shift is 3

         gt_RxCurrentSymbol[i].s_X += s_x >> uc_shift;
         gt_RxCurrentSymbol[i].s_Y += s_y >> uc_shift;
      }
   }

   //---- one full bit received ----
   if ( s_SubBit == (SYMBOLS_PER_BIT - 1)  )
   {

      //--- demodulate one bit ----
      s_bn = DemodBit( gt_RxCurrentSymbol, gt_RxLastSymbol );

      //---- update guc_RxOctet ----
      guc_RxOctet  >>= 1;
      guc_RxOctet   |= (s_bn == 1)?    0x80 : 0 ;

      //---- update gt_RxLastSymbol ----
      for ( i = 0; i < NUM_CARRIER; i++ )
      {
         gt_RxLastSymbol[i] = gt_RxCurrentSymbol[i];
      }

   }   // if

}   // RxBit
