/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_tx.c
 *
 *   Transmit state operations for Handshaking.
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "ghs.h"

#ifdef VRX518_EMULATION
extern uint8 guc_dbg_TxNumTone;
#endif

/*
 *------------------------------------------------------------------------
 *
 *  Name : TxMultiTones
 *
 *  Abstract :
 *
 *  TxMultiTones() - Fills the gsa_TxGhsToneBuf[NUM_CARRIER] array with the
 *  real/imaginary amplitudes for each carrier in the GHS signal set.
 *   The array gsa_TxGhsToneBuf[NUM_CARRIER] is used to load the IFFT input.
 *
 *  Parameters:
 *     int16 s_NumCar       OBSOLETE. Always assume 3 carriers.
 *     int16 s_TxScale      Scale of tones to be sent
 *
 *  Returns:    None
 *
 *  Global Variables Used:
 *      gsa_TxGhsToneBuf[]   - (O) GHS tone buffer
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 */

void TxMultiTones(int16 s_NumCar, int16 s_TxScale)
{

   // Multiply scale with sqrt(2):
   s_TxScale = (int16) ((23170 * (int32)s_TxScale) >> 14);
#ifdef VRX518_EMULATION
   // Insert tones with phase 90 or 270, depending on the sign of s_TxScale.
   // Each tone is represented by two values in the gsa_TxGhsToneBuf array,
   // corresponding to the real and imaginary values.  This array
   // is used by the LoadGhsTonesToIfftBuf() function to load the HW IFFT
   // input buffer.
   if (guc_dbg_TxNumTone & 0x1)
   {
      gsa_TxGhsToneBuf[0] = 0;
      gsa_TxGhsToneBuf[1] = s_TxScale;
   }
   // Reverse phase for the middle carrier. This reduces the high frequency
   // sidelobes, and therefore echo, considerably. Additionally, it also improves
   // peak-to-average ratio so that the receiver on the other side is less
   // likely to clip even at high PGA setting (on short loops).
   if (guc_dbg_TxNumTone & 0x2)
   {
      gsa_TxGhsToneBuf[2] = 0;
      gsa_TxGhsToneBuf[3] = -s_TxScale;
   }

   if (guc_dbg_TxNumTone & 0x4)
   {
      gsa_TxGhsToneBuf[4] = 0;
      gsa_TxGhsToneBuf[5] = s_TxScale;
   }
#else

   // Insert tones with phase 90 or 270, depending on the sign of s_TxScale.
   // Each tone is represented by two values in the gsa_TxGhsToneBuf array,
   // corresponding to the real and imaginary values.  This array
   // is used by the LoadGhsTonesToIfftBuf() function to load the HW IFFT
   // input buffer.

   gsa_TxGhsToneBuf[0] = 0;
   gsa_TxGhsToneBuf[1] = s_TxScale;

   // Reverse phase for the middle carrier. This reduces the high frequency
   // sidelobes, and therefore echo, considerably. Additionally, it also improves
   // peak-to-average ratio so that the receiver on the other side is less
   // likely to clip even at high PGA setting (on short loops).
   gsa_TxGhsToneBuf[2] = 0;
   gsa_TxGhsToneBuf[3] = -s_TxScale;


   gsa_TxGhsToneBuf[4] = 0;
   gsa_TxGhsToneBuf[5] = s_TxScale;
#endif
}   // TxMultiTones

/*
 *------------------------------------------------------------------------
 *
 *  Name : TxBit
 *
 *  Abstract :
 *
 *  TxBit() - Transmit the LSB of guc_TxOctet
 *            Update gs_TxAn_Prev
 *            Right shift guc_TxOctet by one bit to get ready for next bit transmission
 *
 *  Parameters:  None
 *
 *  Returns:     None
 *
 *  Global Variables Used:
 *      guc_TxOctet[guc_port]       - (I,O) current octet being transmitted
 *      gs_TxAn_Prev[guc_port]      - (I,O) Last An symbol for DPSK purpose
 *      gsa_TxToneBuf[guc_port][]   - (O)   frequency domains samples
 *                          above two are used in TxMultiTones().
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 */
void TxBit(void)
{

   int16 s_bn;
   int16 s_An;
   int16 s_TxGain;

   //==== if beginning one bit transmission ====
   if ( (gl_TxSymbolCount & MODULO_BY_8_MASK) == 0 )
   {
      //---- transmit a subbit symbol ----
      s_bn = (int16) ( guc_TxOctet & LSB_MASK );          // take the bit to be xmitted
      s_An = (s_bn == 0)?  gs_TxAn_Prev : -gs_TxAn_Prev ; // differential encoding
      s_TxGain = (int16) ( s_An * TX_NEG165DBM );
      TxMultiTones(NUM_CARRIER, s_TxGain );     // modulate onto carriers

      gs_TxAn_Prev = s_An; // update for differential encoding
      guc_TxOctet >>= 1;   // update for next bit
   }

}   // TxSubBit

