/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCFlag1RxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "fifo.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "vdsl_xception.h"
#include "cmv.h"
#include "vdsl_const.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCFlag1RxF
 *
 *  Description: R_C_FLAG1_RX detects a FLAG octet.
 *  Upon receiving C_Flag1, Rx gets ready to receive messages.
 *
 *  Prototype: void RCFlag1RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]   - input of IFFT, used in RxBit()
 *      gs_RxToneBuf[]    - frequency domain samples, used in RxBit()
 *      gs_RxAn_Prev      - previous DPSK symbol, used in RxBit()
 *      gsa_RxSubBitBuf[] - 8 DPSK symbols for a bit, used in RxBit()
 *      guc_RxOctet       - (I/O) current octet being transmitted
 *      gs_RxState        - (I) current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *
 *  Notes: implements state R_C_FLAG1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCFlag1RxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_C_FLAG1;
   RxBit(gsa_DnCarSet, (int16) (gl_RxSymbolCount & MODULO_BY_8_MASK) );

   /* ==== if one full octet received, check for FLAG character ==== */
   if ( ( gl_RxSymbolCount & MODULO_BY_64_MASK ) == (SYMBOLS_PER_OCTET - 1) )
   {

#ifdef DEBUG_GHS
      printf( "Rx\t%x\n", guc_RxOctet );
#endif

      /* ---- check for FLAG --- */
      if (guc_RxOctet == FLAG)
      {
         gs_RxNextState = R_C_HS_MSG_RX;
         gpF_RxStateFunc = (PtrToFunc)RCHSMsgRxF;
      }
      /* ---- o.w. check for timeout or unexpected (non-GALF) octet --- */
      else if ( (gl_RxSymbolCount >= HS_TONE_TIMEOUT) || (guc_RxOctet != GALF) )
      {

         HndshkTimeout();

      }

   }   /*  if (complete an octet) */

}   /*  RCFlag1RxF */

