/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCGalf1RxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "fifo.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "vdsl_xception.h"
#include "cmv.h"
#include "vdsl_const.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCGalf1RxF
 *
 *  Description: R_C_GALF1_RX detects a GALF octet.
 *  Upon receiving C_Galf the Rx bit boundaries are aligned.
 *
 *  Prototype: void RCGalf1RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]   - input of IFFT, used in RxSymbolRealign()
 *      gs_RxToneBuf[]    - frequency domain samples, used in RxSymbolRealign()
 *      gs_RxAn_Prev      - previous DPSK symbol, used in RxSymbolRealign()
 *      gsa_RxSubBitBuf[] - 8 DPSK symbols for a bit, used in RxSymbolRealign()
 *      guc_RxOctet       - (I/O) current octet being transmitted,
 *                          used in RxSymbolRealign()
 *      gs_RxState        - (I) current RX state, used in RxSymbolRealign()
 *      gs_RxSubState     - (I/O) current RX substate, used in RxSymbolRealign()
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *      gs_RxSubStateCnt  - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *
 *  Notes: implements state R_C_GALF1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define R_C_GALF1_RX_INITIALIZE         (0)
#define R_C_GALF1_RX_LOCK_PHASE         (1)
#define R_C_GALF1_RX_WAIT_FOR_CODESWAP   (2)
#define R_C_GALF1_RX_SYMBOL_REALIGN      (3)

void RCGalf1RxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_C_GALF1;
   switch (gs_RxSubState)
   {
   case R_C_GALF1_RX_INITIALIZE:

      /* Trigger codeswap */
      if (gs_TxRxMessaging == PRE_GHS_CODESWAP_READY)
      {
         PreHandshakeCodeswap(TRUE);   //Trigger pre-handshake codeswap
      }

      /* Go to next substate. */
      gs_RxSubStateCnt = 0;
      gs_RxSubState = R_C_GALF1_RX_LOCK_PHASE;
      break;

   case R_C_GALF1_RX_LOCK_PHASE:
      /* Update substate count. */
      gs_RxSubStateCnt++;

         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
      if(gs_RxSubStateCnt == 1)
      {
         // Set new Pll Reference for all 3 supported pilot tones.
         ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );

         /* Set PLL loop filter parameters to fast converge. */
         ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);
         ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);
         ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);

         /* Turn on PLL. */
         gft_EnablePLL = TRUE;

         // If clocks are NOT tied
         if (gs_TiedClocks == 0)
         {
            gft_UpdateTimingRecoveryHWEnable = 1;
         }
      }
      /* Reset PLL loop filter parameters to slow converge parameters. */
      else if(gs_RxSubStateCnt == gs_NumFramesPLLRelock)
      {
         ResetPLL(PT_ARRAY_IDX_0, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
         ResetPLL(PT_ARRAY_IDX_1, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
         ResetPLL(PT_ARRAY_IDX_2, (int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
      }
      // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

      /* Achieve phase lock with slow PLL parameters. */
      else if(gs_RxSubStateCnt == gs_NumFramesPLLAcquisition)
      {
         /* Turn off PLL. */
         gft_EnablePLL = FALSE;

         /* Set the flag to inform TX State Machine that handshake PLL is done? */

         /* Initialize RxSymbolReAlign variables. */
         gs_ReAlignSubState = 0;
         /* Go to next substate. */
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_GALF1_RX_WAIT_FOR_CODESWAP;
      }
      break;

   case R_C_GALF1_RX_WAIT_FOR_CODESWAP:
      /* ---- after codeswap done and pll lock --- */
      // Uli: Both flags PRE_GHS_CODESWAP_DONE and PRE_GHS_CODESWAP_RX_DETECT_DONE indicate that pages are already swapped in
      if ((gs_TxRxMessaging == PRE_GHS_CODESWAP_DONE) ||
            (gs_TxRxMessaging == PRE_GHS_CODESWAP_RX_DETECT_DONE))
      {
         // Indicate pages are swapped in, also rx tone detection done.
         gs_TxRxMessaging = PRE_GHS_CODESWAP_RX_DETECT_DONE;

         /* Go to next substate. */
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_GALF1_RX_SYMBOL_REALIGN;
      }
      break;

   case R_C_GALF1_RX_SYMBOL_REALIGN:

      RxSymbolReAlign(); // this function is responsible for changing the Rx State to R_C_FLAG1_RX

      /* ---- if timeout, move to the beginning. ---- */
      if ( gl_RxSymbolCount >= (HS_TONE_TIMEOUT + SYMBOLS_PER_OCTET) )
      {
         HndshkTimeout();
      }

      break;
   }

   if ((gs_TxRxMessaging == PRE_GHS_CODESWAP_READY) &&
         PreHandshakeCodeswap(FALSE))   //Wait for pre-handshake codeswap done
   {
      // Indicate pages are swapped in
      gs_TxRxMessaging = PRE_GHS_CODESWAP_DONE;
   }

}   /*  RCGalf1RxF */


