/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCHSMsgRxF.c
 *
 *
 *------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// RCHSMsgRxF.c
//
// History
// 29/04/2013 Fuss: Fix for Ghs gets not be finished correct in case of a NE NAK-EF
//            Grep for XDSLRTFW-920: BugFix_US_All_All_GhsNakEf
//
// 10/07/2013 Sriram : Endless G.Hs training session in case of missing common mode in CO / CPE capabilities
//            Grep for XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error
// 10/07/2013 Sriram Shastry : Bug in check condition for setting up error code to indicate CO perfers ADSL mode
//            Grep for XDSLRTFW-1005 : BugFix_ALL_ALL_ALL_Hsk_LookforADSLAnnexbits
// 30/04/2014 Fuss: Bonding issues seen NVLT-G and VGV Arcadyan modem, KPN
//            Grep for XDSLRTFW-1695
// 12/05/2014 Fuss: GHS wrong CLR message with no or wrong mode enabled
//            Grep for XDSLRTFW-1729
// 07/07/2014 Fuss: Bonding issues seen NVLT-G and VGV Arcadyan modem, KPN
//            Grep for XDSLRTFW-1883
// ************************************************************************************************************

#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "fifo.h"
#include "vdsl_xception.h"
#include "PrintTrail.h"
#include "stateini.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCHSMsgRxF
 *
 *  Description: R_C_HS_MSG_RX exchanges handshake messages and moves to
 *  selected mode upon completing message exchange and mode selection.
 *
 *  Prototype: void RCHSMsgRxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]          - input of IFFT, used in RxBit()
 *      gs_RxToneBuf[]           - frequency domain samples, used in RxBit()
 *      gpt_RxInfo               - (I) RX message information structure, used in
 *                                 HSMsgHandler()
 *      guc_RxOctet              - (I/O) current octet being transmitted
 *      gs_RxState               - (I) current RX state
 *      gs_RxSubState            - (I/O) current RX substate
 *      gl_RxSymbolCount         - (I) # symbol periods in current RX state
 *      gpuca_RxMsgBuf           - (I) message octets to be transmitted in this state
 *      gs_RxNextState           - (O) RX state that will begin next symbol period
 *      gt_hsc                   - (I) handshake control structure
 *
 *  Substates:
 *      R_C_HS_MSG_RX_IDLE_FLAG  - Get FLAGs until the beginning of a message.
 *      R_C_HS_MSG_RX_COLLECT_MESSAGE    - Gather octets for a whole message and start decode bkgd task.
 *      R_C_HS_MSG_RX_DECODE_MESSAGE     - Continue decode message background task until it finishes
 *      R_C_HS_MSG_RX_START_PROCESSING   - Start HS msg processing, begin HSMsgHandler background task
 *      R_C_HS_MSG_RX_HANDLE_PROCESSING  - Process received message and run the message exchange state machine.
 *
 *  Notes: implements state R_C_HS_MSG_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_HS_MSG_RX_IDLE_FLAG             (0)
#define R_C_HS_MSG_RX_COLLECT_MESSAGE       (1)
#define R_C_HS_MSG_RX_DECODE_MESSAGE        (2)
#define R_C_HS_MSG_RX_START_PROCESSING      (3)
#define R_C_HS_MSG_RX_HANDLE_PROCESSING     (4)


void RCHSMsgRxF(void)
{

   /* ---- initialize ---- */
   if (gl_RxSymbolCount == 0)
   {
      // XDSLRTFW-1695 (start)
      gs_RxSubState    = R_C_HS_MSG_RX_IDLE_FLAG;
      gs_RxGhsSymCnt   = 0;
      gs_RxSubStateCnt = 0;   /*  this is for RxSymbolReAlign() */

      /* default */
      if(gs_HandShake_Cnt == 0)
      {
         // Ignore values from last CL.
         // Note: Between the two session no exception was triggered, i.e. no new FW download took place.
         //       Handshake gets be started directly from the first start-up state "Silent0".
         // XDSLRTFW-1883 (Start_End)
         gt_Bonding_DiscAggr_Status.s_PAF_status = 0;
         gs_NumOfEstRxBands = 0;
         //XDSLRTFW-2425 (Start)
         gs_DecodeBufCnt = 0;
         guc_TxHSMsg_SegmentCnt   = 0;
         guc_RxHSMsg_SegmentCnt   = 0;
         //XDSLRTFW-2425 (End)
         // Delete uc_Type in case we have an M_ACK2 in the receiver and CO drops the link
         gpt_RxInfo->uc_Type = 0;

         InitializeHSC(&gt_hsc);
         InitializeStandardInfoField(gpt_TxInfo);
         CopyInfoField(gpt_TxInfo, gpt_TxInfoSave);
      }

      if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_ST_GHS))
      {
         /* g.hs sample sessions */
         if(gs_HandShake_Cnt != 0)
         {
            gt_hsc.s_State = R_HS_INITIAL;
            gt_hsc.l_SelectedMode = NOT_SELECTED;

            if(gt_hsc.s_CL_Exchanged == TRUE)
            {
               CopyInfoField(gpt_TxInfoSave, gpt_TxInfo);
            }
         }
      }
      // XDSLRTFW-1695 (end)

      /* increment hand shake counter outside of function InitializeHSC() */
      gs_HandShake_Cnt++;
   }

   /*  *************************************************************************** */
   /*  **** Realign symbol boundary right after Tx completes message xmission **** */
   /*  *************************************************************************** */
   /* ---- note that gft_SymbolReAlignmentRequired is set to TRUE at the end of  ---- */
   /* ---- a message transmission.  So, RxSymbolReAlign uses at least the three  ---- */
   /* ---- mandatory FLAGs at the beginning of an incoming message.              ---- */
   if (gft_SymbolReAlignRequired == TRUE)
   {
      RxSymbolReAlign();
      //---- if timeout, move to the beginning ----
      if (gs_RxGhsSymCnt >= HS_MSG_TIMEOUT)
      {
         // XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (Start_End)
         if (gt_hsc.s_NextState == R_HS_CL_OK)
         {
            gft_SymbolReAlignRequired = FALSE;
         }
         else
         {
            gt_hsc.s_TxMsgComplete = FALSE; // reset flag
            gs_HandShake_Cnt = 0;           // Needed to reinitialize HS variables,
            HndshkTimeout();
         }
      }
   }
   else
   {
      /*  ************************************************************************** */
      /*  **** When symbol alignment is done or not required                    **** */
      /*  **** start collecting an incoming message                             **** */
      /*  ************************************************************************** */

      /* ---- Bit Detection : common for all substates ---- */
      RxBit(gsa_DnCarSet, (int16) (gs_RxGhsSymCnt & MODULO_BY_8_MASK));

      /* ---- Silence Detection : used in sniffer mode only ---- */
      if (gul_dbgSnifferControl & SNIFFER_DISABLE_GHSSTATEMACHINE)
      {
         static uint8 uc_dbgSnifferGhsDetectSilenceCnt = 0;

         if ( DetectMultiTones( gpsa_RxCarSet, NUM_CARRIER, gs_DETECT_SCALE) == 0 )
         {
            uc_dbgSnifferGhsDetectSilenceCnt++;
         }
         else
         {
            uc_dbgSnifferGhsDetectSilenceCnt = 0;
         }

         if (uc_dbgSnifferGhsDetectSilenceCnt > CLEARDOWN_SILENCE_DETECT_CNT)
         {
            gs_TxNextState = R_GALF2_TX;
            gpF_TxStateFunc = (PtrToFunc)TerminateSnifferGhs;
            gs_RxNextState = R_C_FLAG2_RX;
            gpF_RxStateFunc = (PtrToFunc)EmptyState;
            return;
         }
      }

      /* ==== if one full octet received, process in different substates ==== */

      if ( (gs_RxGhsSymCnt & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
      {
#ifdef DEBUG_GHS
         printf( "Rx\t%x\n", guc_RxOctet );
#endif /*  DEBUG_GHS */
         switch (gs_RxSubState)
         {
            /* =============================================== */
            /* get FLAGs until the beginning of a message */
            /* =============================================== */
         case R_C_HS_MSG_RX_IDLE_FLAG:

            /* ---- if first non-FLAG octet received ---- */
            // XDSLRTFW-920: BugFix_US_All_All_GhsNakEf (start_end)
            // XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (Start_End)
            if ((guc_RxOctet != FLAG) &&
                  (gt_hsc.s_State != R_HS_RESTART) &&
                  (gt_hsc.s_NextState != R_HS_CL_OK))
            {
               /* ---- fill gua_RxMsgBuf and move to next substate ---- */
               gs_RxOctetCnt      = 1;
               gpuca_RxMsgBuf[0] = guc_RxOctet;
               gs_RxSubState      = R_C_HS_MSG_RX_COLLECT_MESSAGE;
            }

            if (gt_hsc.s_TxMsgComplete == TRUE)
            {
               gt_hsc.s_TxMsgComplete = FALSE;  //reset tx msg complete flag

               switch (gt_hsc.s_State)
               {
                  /* ---- for states that are not receiving any message other than FLAG ---- */
               case R_HS_INITIAL         :
               case R_HS_MS_OK           :
               case R_HS_CL_OK           :
               case R_HS_RESTART         :
               case R_HS_NOT_READY       :
               case R_HS_NOT_SUPPORTED   :
               case R_HS_NOT_UNDERSTOOD  :

                  gs_RxSubState = R_C_HS_MSG_RX_START_PROCESSING;
                  break;

               default:
                  /* ---- if timeout, move to the beginning ---- */
                  if (gs_RxGhsSymCnt >= HS_MSG_TIMEOUT)
                  {
                     gs_HandShake_Cnt = 0; // Needed to reinitialize HS variables,
                     HndshkTimeout();
                  }
                  break;
               }  /*  switch */
            }   /*  if (TxMsgComplete) */

            break;

            /* =============================================== */
            /* gather octets for a whole message and decode it at the end */
            /* =============================================== */
         case R_C_HS_MSG_RX_COLLECT_MESSAGE:

            /* ---- gather octets until it reaches another FLAG ---- */
            gpuca_RxMsgBuf[ gs_RxOctetCnt++ ] = guc_RxOctet;

            /* ---- if end of message or buffer filled up ---- */
            if ( (guc_RxOctet == FLAG) || (gs_RxOctetCnt == MESSAGE_BUF_LEN) )
            {
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDecodeMessage);
               gs_RxBkgdProcessFlag = BG_GHS_TASK_GOING;
               gs_RxSubState = R_C_HS_MSG_RX_DECODE_MESSAGE;
            }
            break;

         case R_C_HS_MSG_RX_DECODE_MESSAGE:
            if(gs_RxBkgdProcessFlag == BG_GHS_TASK_DONE)
            {
               // reset state variable
               /* ---- if invalid message, ignore it ---- */
               if ((gt_hsc.s_DecodeResult == INVALID_MESSAGE) ||
                     (gul_dbgSnifferControl & SNIFFER_DISABLE_GHSSTATEMACHINE))
               {
                  gs_RxSubState = R_C_HS_MSG_RX_IDLE_FLAG;
               }
               /* ---- if not INVALID_MESSAGE ---- */
               else
               {
                  gs_RxSubState = R_C_HS_MSG_RX_START_PROCESSING;
               }
            }  /* if (guc_DecodeMsgState == BG_GHS_TASK_DONE)*/

            break;

            /* =============================================== */
            /* process received message and run message exchange state machine */
            /* =============================================== */
         case R_C_HS_MSG_RX_START_PROCESSING:
            gs_RxBkgdProcessFlag = BG_GHS_TASK_GOING;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)HSMsgHandler);
            gs_RxSubState = R_C_HS_MSG_RX_HANDLE_PROCESSING;
            break;

         case R_C_HS_MSG_RX_HANDLE_PROCESSING:
            if (gs_RxBkgdProcessFlag == BG_GHS_TASK_DONE)
            {
               gt_hsc.s_RxMsgComplete = TRUE;   /*  Let Tx know a message is complete in Rx  */
               gt_hsc.s_TxMsgComplete = FALSE;  /*  reset flag */
#ifdef DEBUG_TRAIL
               LeaveGhsStatesTrail(gt_hsc.s_State, gt_hsc.s_NextState, gs_RxGhsSymCnt, (uint8)RX, guc_NewRxMsgType);
#endif //DEBUG_TRAIL
               if (gt_hsc.s_NextState == R_HS_EXIT)
               {
                  ////XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error(Start)
                  if ( gt_hsc.l_SelectedMode == RESTART_HS_NearEnd )
                  {

                     if (gus_DsmCtrlCmv & (G9935_FULL_VECTORING_SUPPORT | G9932_FULL_VECTORING_FRIENDLY_SUPPORT))
                     {

                        gs_HandShake_Cnt = 0; // Needed to reinitialize HS variables,
                        //gt_hsc.l_SelectedMode = NOT_SELECTED;
                        //InitializeHSC(&gt_hsc);
                        //InitGHSVariables();
                        //InitModemTasks_PreHandshake();
                        gs_RxNextState = R_C_SILENT1_RX;
                        gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;
                        gs_TxNextState = R_SILENT0_TX;
                        gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;

                     }
                     else
                     {

                        EnterFailStates(E_CODE_GHS_M_NAK_EF_NearEnd);
                     }
                  }
                  else if ( gt_hsc.l_SelectedMode == RESTART_HS_FarEnd )
                  {
                     EnterFailStates(E_CODE_GHS_M_NAK_EF_FarEnd);
                  }
                  //XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error(End)
                  else if ( gt_hsc.l_SelectedMode == NOT_SUPPORTED_IN_DUALPORT)
                  {
                     EnterFailStates(E_CODE_GHS_NOT_SUPPORTED_IN_DUALPORT);
                  }
                  else if ( gt_hsc.l_SelectedMode == CO_NOT_BONDABLE)
                  {
                     // If VR9 CPE supports bonding but CO does not bond, then fail with
                     // error code in order to switch to single port mode
                     EnterFailStates(E_CODE_GHS_CO_NOT_BONDABLE);
                  }
                  else if ( gt_hsc.l_SelectedMode == NO_COMMON_MODE )
                  {
                     // XDSLRTFW-1695 (start_end)
                     uint32 ul_ExceptionCode;

                     ul_ExceptionCode = E_CODE_GHS_NO_COMMON_MODE;
#ifdef VDSL_BONDING
                     if (gt_PortModeControl.uc_DualPortModeCurrent == DUAL_PORT_MODE)
                     {
                        // If VR9 CPE supports bonding but CO does not bond, then fail immediately with
                        // error code so API can switch to single port mode in next link
                        if ((gft_SinglePort_if_CO_notBonding) && ((gt_Bonding_DiscAggr_Status.s_PAF_status & 0x1) == 0))
                        {
                           ul_ExceptionCode = E_CODE_GHS_CO_NOT_BONDABLE;
                        }
                     }
#endif //#ifdef VDSL_BONDING
                     EnterFailStates(ul_ExceptionCode);
                  }
                  else if ( gt_hsc.s_State ==  R_HS_MS_OK)
                  {
                     gs_RxNextState = R_C_GALF2_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCGalf2RxF;

                     // we have valid mode, set FLAG to indicate codeswap starts
                     gft_enterTraining = TRUE;
                  }
                  else if ( gt_hsc.s_State == R_HS_SEND_MS )
                  {
                     gs_RxNextState = R_C_FLAG2_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCFlag2RxF;

                     // we have valid mode, set FLAG to indicate codeswap starts
                     gft_enterTraining = TRUE;
                  }
                  else if ( gt_hsc.s_State == R_HS_NOT_UNDERSTOOD )
                  {
                     // since we didn't implemented correctly as indicated in G.HS standard before
                     // we will just forct it to go to FAIL state for debug purpose.
                     // In my opinion, we should have a global control for this. If we want debug
                     // such error state, we can let state to FAIL. Otherwise, we should implement the
                     // code as the standard said.
                     // XDSLRTFW-1695 (start_end)
                     if(gft_CL_CLR_Comparison == 0x8)
                     {
                        uint32 ul_ExceptionCode;

                        ul_ExceptionCode = E_CODE_GHS_NO_COMMON_MODE;

                        if (gt_PortModeControl.uc_DualPortModeCurrent == DUAL_PORT_MODE)
                        {
                           // In this situation there was no binary switch. We had been in VDSL Dual Port mode (Bonding) and
                           // the FW reports an S_XDLS_MODE suberror code (="Retrain required with opposite xDSL flavour
                           // (e.g. VDSL in case of ADSL loaded, and vice versa)"). Different to Single Port mode the
                           // multimode state machine does not immediately swap the flavor but increments the retry counter
                           // only as for any other normal fail case like e.g. a "No common mode"). So retry counter
                           // incrementation is correct.
                           // An immediate exit from dual port mode is only triggered by the S_PORT_MODE (="Retrain
                           // required with opposite port mode ...") suberror.
                           // Moreover the S_XDSL_MODE that is reported in case of an empty MS is misleading, it should
                           // be indicated to the host as "S_MODE" (=No common mode).
                           // In dual port mode it is only misleading ( the behavior is the same as for "S_MODE"). But
                           // an empty MS can also occur in Single Port mode (VDSL or ADSL), and there a wrong S_XDSL_MODE mode
                           // indication would lead to an immediate switching to the opposite flavor and lead to different
                           // behavior than the "S_MODE".
                           if ((gt_Bonding_DiscAggr_Status.s_PAF_status & 0x1) == 0)
                           {
                              // If VR9 CPE supports bonding but CO does not bond,
                              // fail immediately with error code so API can switch to
                              // single port mode in next link
                              ul_ExceptionCode = E_CODE_GHS_CO_NOT_BONDABLE;
                           }
                        }
                        // XDSLRTFW-1005 : BugFix_ALL_ALL_ALL_Hsk_LookforADSLAnnexbits (Start_End)
                        // XDSLRTFW-1729 (Start_End)
                        else
                        {
                           uint8 *puca_RxCLSPar1Octets;
                           uint8 uc_ADSLModes;
                           uint8 uc_G_FastMode;

                           // Initialize local variables
                           puca_RxCLSPar1Octets = &gt_FE_OperatingModes.uca_SupportedModes[0];
                           uc_ADSLModes = ((puca_RxCLSPar1Octets[0] & (ADSL_DMT_MASK)) |
                                           (puca_RxCLSPar1Octets[2] & (ADSL_BIS_MASK)) |
                                           (puca_RxCLSPar1Octets[3] & (ADSL_PLUS_MASK)) |
                                           (puca_RxCLSPar1Octets[4] & G992_5_M));

                           uc_G_FastMode = (puca_RxCLSPar1Octets[4] & G9701);

                           if (uc_ADSLModes)
                           {
                              //set error code to indicate CO perfers ADSL mode
                              ul_ExceptionCode = E_CODE_GHS_S_XDSL_MODE;
                           }
                           else if (uc_G_FastMode)
                           {
                              // Set error code to indicate G.Fast
                              ul_ExceptionCode = E_CODE_G_FAST_SWITCH;
                           }
                        }

                        EnterFailStates(ul_ExceptionCode);
                     }
                     else if (gft_FW_Initiate_Retrain == 0x1)
                     {
                        //Placeholder for RT initiated retrain
                        EnterFailStates(E_CODE_GHS_FWInitiatedRetrain);
                     }
                     else
                     {
                        uint32 ul_ExceptionCode;

                        ul_ExceptionCode = E_CODE_R_HS_NOT_UNDERSTOOD;
                        if((gt_hsc.l_SelectedMode == RESTART_VIA_CLEARDOWN) &&
                              ((gpt_RxInfo->uc_ID_SPar1 & TRANSCEIVER_ID) && (gpt_TxInfoSave->uc_ID_SPar1 & TRANSCEIVER_ID)))
                        {
                           ul_ExceptionCode = E_CODE_GHS_XTALK_LINK;
                        }
                        EnterFailStates(ul_ExceptionCode);
                     }
                  }
                  else
                  {
                     /*  if NAK-CD received */
                     gs_RxNextState = R_C_FLAG2_RX;
                     gpF_RxStateFunc = (PtrToFunc)RCFlag2RxF;
                  }
               }
               else
               {
                  gt_hsc.s_State   = gt_hsc.s_NextState;
                  gs_RxSubState    = R_C_HS_MSG_RX_IDLE_FLAG;
                  gs_RxSubStateCnt = 0;   /*  this is for RxSymbolReAlign */
                  gs_RxGhsSymCnt   = -1;  /*  initialize symbol counter for a new message */
               }
            } /* if (gs_RxBkgdProcessFlag == BG_GHS_TASK_DONE)*/
            break;
         }   /*  switch */
      }   /*  if octet complete */
   }   /*  else (symbol alignment is not require) */

   gs_RxGhsSymCnt++;  /*  increment symbol counter */

}   /*  RCHSMsgRxF */

#undef R_C_HS_MSG_RX_IDLE_FLAG
#undef R_C_HS_MSG_RX_COLLECT_MESSAGE
#undef R_C_HS_MSG_RX_DECODE_MESSAGE
#undef R_C_HS_MSG_RX_START_PROCESSING
#undef R_C_HS_MSG_RX_HANDLE_PROCESSING


