/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCSilent1RxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// RCSilent1RxF.c
//
// History
//
//
// 24/09/2019 Chih-Wen
//            Bug fix for several issues related to V43 and T1413 setup.
//            SEARCH PATTERN: XDSLRTFW-4227
//
// ***********************************************************************************************************
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "afe.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCSilent1RxF
 *
 *  Description: R_C_SILENT1_RX is a beginning state of a handshake session.
 *  It pauses for 500ms and move to next state.
 *
 *  Prototype: void RCSilent1RxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]   - input of IFFT, used in DetectTones()
 *      gs_RxToneBuf[]    - frequency domain samples, used in DetectTones()
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *      gt_hsc            - (I/O) handshake control structure
 *
 *  Notes: implements state R_C_SILENT1_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/******************************************/

#define    R_C_SILENT1_RX_SUBSTATE0     (0)
#define    R_C_SILENT1_RX_SUBSTATE1     (1)
#define    R_C_SILENT1_RX_SUBSTATE2     (2)
#define    R_C_SILENT1_RX_CALIBRATION   (3)
#define    R_C_SILENT1_RX_WAIT         (4)


void RCSilent1RxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)

   gsa_IndirectStat0[3]=VDSL2_R_C_SILENT1;
   switch (gs_RxSubState)
   {
   case R_C_SILENT1_RX_SUBSTATE0:

      if(gl_RxSymbolCount == 0)
      {
         gs_TxRxMessaging = PRE_GHS_CODESWAP_READY;


         // Set RTV flag to read FFT output
         gs_RtvSelect = FFT_OUTPUT;
         
         //XDSLRTFW-4227 (START)  
         //Handle the case when switching from T1413 to GHS V43 carrier set.
         gs_RxToneOffset = 0;
         
         //The "gs_GhsCarSetActual" is the bit index. The format below should be 1 left shifted by "gs_GhsCarSetActual". 
         if ((uint16)(1<<gs_GhsCarSetActual) & (CNFG_GHS_CAR_SET_V43 | CNFG_GHS_CAR_SET_V43P | CNFG_GHS_CAR_SET_V43I) )
         {
            gs_RxToneOffset = FIRST_TONE_RTV_BUFF_FOR_V43_GHS_TONE_DET; //XDSLRTFW-2425 (Start_End)
         }
         //XDSLRTFW-4227 (END)

         // Set offset for loading gpsa_RxToneBuf from RTV buffer 0
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         // Enable GetRxTones in RxProcessTones fcn
         gft_EnableGetRxTones = TRUE;

         //clear the GHS termination flag
         gs_GhsTerminateFlag = 0;
      }
      else
      {
         if ((gul_dbgSnifferControl & SNIFFER_PREPONE_GHSCODESWAP) &&
               gs_TxRxMessaging == PRE_GHS_CODESWAP_READY)
         {
            if (gl_RxSymbolCount == 1)
            {
               PreHandshakeCodeswap(TRUE);         //Trigger pre-handshake codeswap and break out
               return;
            }
            else if (PreHandshakeCodeswap(FALSE))  //Wait for pre-handshake codeswap done
            {
               // Indicate pages are swapped in, do NOT return
               gs_TxRxMessaging = PRE_GHS_CODESWAP_DONE;
            }
            else // else break out
            {
               return;
            }
         }

         gs_PGA_required = gs_PGA_required_In_GHS;

         guc_PgaState = TRAINING_IN_PROGRESS;
         //if(gs_PauseControl == 0x3bed)
         //   Pause(0x3bed);
            AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting);
         gs_RxSubState = R_C_SILENT1_RX_SUBSTATE1;
      }
      break;

   case R_C_SILENT1_RX_SUBSTATE1:
      if (guc_PgaState == TRAINING_DONE)
      {
         gs_RxSubState = R_C_SILENT1_RX_WAIT;
      }
      break;


      //==========================================================
      // wait for end of state
      //==========================================================
   case R_C_SILENT1_RX_WAIT:

      // if(gs_PauseControl == 0x3bee)
      // {
      //    Pause(0x3bee);
      // }
#ifdef VRX518_EMULATION
      if ( gl_RxSymbolCount >= (10) )
#else
      if ( gl_RxSymbolCount >= (4*TIME_500MS) )
#endif
      {
         gs_RxNextState = R_C_TONES_RX;
         gpF_RxStateFunc = (PtrToFunc)RCTonesRxF;
      }
      break;
   }
}   /*  RCSilent1RxF */
