/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCTonesRxF.c
 *
 *
 *
 *------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// RCTonesRxF.c
//
// History
//
//
// 24/09/2019 Chih-Wen
//            Bug fix for several issues related to V43 and T1413 setup.
//            SEARCH PATTERN: XDSLRTFW-4227
//
// ***********************************************************************************************************
#include <string.h>
#include <stdlib.h>
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#include "accum32.h"
#include "IRI_Iof.h"
#include "fifo.h"
#include "PGAHandler.h"
#include "vecpwr.h"
#include "ConvertToDB.h"
#include "cmv.h"
#include "vdsl_const.h"
#include "dsp_op.h"
#include "vdsl_xception.h"
#include "AFED_Functions.h"

int16 gs_PGA_Dbg1 = 0x500;
int16 gs_PGA_Dbg2 = 0x300;
int16 gs_PGA_Dbg3 = 0x100;


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCTonesRxF
 *
 *  Description: R_C_TONES_RX detects the C_Tones from an ATU-C.
 *  Upon detection of C_Tones, Rx enters R_C_GALF state.
 *
 *  Prototype: void RCTonesRxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gsa_FFT_InBuf[]            - input of IFFT, used in DetectTones()
 *      gs_RxToneBuf[]             - frequency domain samples, used in DetectTones()
 *      gs_RxSubState              - (I/O) current RX substate
 *      gs_RxSubStateCnt           - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount           - (I) # symbol periods in current RX state
 *      gs_RxNextState             - (O) RX state that will begin next symbol period
 *      gt_hsc                     - (I/O) handshake control structure
 *
 *  Substates:
 *      R_C_TONES_RX_DETECT_TONES  - Attempt to detect tones.
 *      R_C_TONES_RX_COUNT_SYMBOLS - Count the number of symbols that tones are
 *                                   present, and transition to R_C_GALF1_RX if
 *                                   present for C_TONES_CNT consecutive symbols.
 *
 *  Notes: implements state R_C_TONES_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

// Local function prototypes
void ClearGhsCarSetAccumBuf(void);
static void BgCheckMaxFreqDomain(void)
{
   int16 i;
   int16 *psa_Tone, s_tone_start, s_tone_end;
   int32 l_value, l_MaxFreqDomainValue;

   //Find the last tone to search
   s_tone_end = 512<<1;

   //Find the first tone to search
   //Exclude the DC component
   s_tone_start = 2;

   //gs_MaxFreqDomainValue = 0;
   l_MaxFreqDomainValue = 0;
   gs_MaxFreqDomainValueTone = -1;

   psa_Tone = &(gsa_SnrBuf[0])+s_tone_start;

   //Search for the maximum absolute value of a tone's real or imaginary part
   for (i=s_tone_start; i<s_tone_end; i++)
   {
      l_value = (int32)(*psa_Tone++);
      l_value = abs(l_value);

      if (l_MaxFreqDomainValue < l_value)
      {
         gs_MaxFreqDomainValueTone = i;
         l_MaxFreqDomainValue = l_value;
      }
   }

   if (l_MaxFreqDomainValue >= 0x00008000)
   {
      l_MaxFreqDomainValue = 0x7FFF;
   }
   gs_MaxFreqDomainValue = l_MaxFreqDomainValue;

   gs_MaxFreqDomainValueTone >>= 1;

   guc_PgaState = TRAINING_DONE;
}

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_TONES_RX_CHECK_FOR_CLIPPING (0)
#define R_C_TONES_RX_DYNAMIC_GHS_PGA    (1)
#define R_C_TONES_RX_SET_PGA_WAIT       (2)
#define R_C_TONES_RX_PRE_DETECTION      (3)
#define R_C_TONES_RX_DETECT_TONES       (4)
#define R_C_TONES_RX_WAIT_FOR_HW_READY  (5)

#define R_C_TONES_RX_DETECT_TONES_TIMEOUT               (8192)

#define GHS_MAX_FREQ_DOMAIN_VALUE_REF (0x2000)


//Mei debug
#ifdef VR9_BRINGUP_DBG
extern FlagT gft_EnableGetGhsRxTones;
#endif


void Activation_T1413_StateMachine(void);
void RActReqTxF(void);
void RCActRxF(void);


void RCTonesRxF(void)
{
   FlagT s_TonesDetected=0;
   int16 i,j;
   int16 s_avg_first_channel;
   static int16 s_NoDetectCnt=0;
   static s_Wait2_Cnt;
   int16 s_RCTonesBurstCnt;
#ifdef GHS_TN_DBG
   uint8 *puca_RxTone_Buffer; //XDSLRTFW-2364 (Start_End)
#endif

   // XDSLRTFW-2373
   uint32 ul_Timeout = (2*R_C_TONES_RX_DETECT_TONES_TIMEOUT);

   if (gsa_Cnfg_Misc[0] & CNFG_MISC_NON_STANDARD_HSK_MASK)
   {
      ul_Timeout = 120*TIME_500MS;
   }
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[3]=VDSL2_R_C_TONES;

   int16 s_log2_num_c_tones_avg = LOG2_NUM_CTONES_DETECT_AVG;

   //XDSLRTFW-636
   if (TESTArray[TEST_Control3] & TEST_GHS_Fix)
   {
      //increase avging also helps
      s_log2_num_c_tones_avg++;
   }

   //Mei debug
#ifdef VR9_BRINGUP_DBG
   //staying this state to look the input tones
   if(gft_EnableGetGhsRxTones == 1)
   {
      return;
   }
#endif

   /* Initializations */
   s_RCTonesBurstCnt = (R_C_TONES_BURST_CNT<<gs_frame_rate_is_8khz);

   if ( gl_RxSymbolCount == 0 )
   {
      ClearGhsCarSetAccumBuf();                       // Clear accumulation buffer
      gs_RxSubStateCnt = 0;
// Not needed this is done by the forground!
//      gs_RxSubState = R_C_TONES_RX_CHECK_FOR_CLIPPING;
      gl_InitRxHsTonesPower = 0;

// Debug code which can be removed later - start
      gs_TryNext = 0;
      gs_CheckClipping = 0;
      gl_HsToneSetPower = 0;
// Debug code which can be removed later - end

      //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
      gs_RxIndex = 0; //start of buffer
      gft_Log_Symbol_Count_Start = TRUE;
#endif
      //XDSLRTFW-2288 (End)
      
      // Do not perform detection while accumulating
      return;                    //XDSLRTFW-4227
   }

   //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
   if (TESTArray[TEST_GHS_LOG] & TEST_GHS_AVG_FULL_BAND)
   {
      Accum16to32((int32 *)gpla_RxAccumBuf, 0,   gpsa_RxToneBuf, 0, gs_NumChannelsPerGroup*2);
   }
   else
#endif
   {
      // Accumulate received signal
      for(i=0; i<NUM_CARRIER; i++)
      {
         s_avg_first_channel = gsa_DnCarSet[i] - HALF_DETECT_BAND;
         Accum16to32((int32 *)gpla_RxAccumBuf, (int16) (2*s_avg_first_channel),
                     gpsa_RxToneBuf, (int16) (2*s_avg_first_channel), (int16)(2*FULL_DETECT_BAND));
      }
   }
   //XDSLRTFW-2288 (End)


   // Compute average after accumulation of 8 frames then perform detection
   if ( (gl_RxSymbolCount % (1<<s_log2_num_c_tones_avg)) == 0 )
   {
      //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
      if(gft_TonesDetected > 0)
      {
         gs_RxIndex++;
      }
      else
      {
         gs_RxIndex = 0;
      }

      if (TESTArray[TEST_GHS_LOG] & TEST_GHS_AVG_FULL_BAND)
      {
         RightShiftAndRound32to16(gpsa_RxToneBuf, 0, gpla_RxAccumBuf, 0, gs_NumChannelsPerGroup*2, s_log2_num_c_tones_avg);
      }
      else
#endif
      {
         // Compute average received signal
         for(i=0; i<NUM_CARRIER; i++)
         {
            s_avg_first_channel = gsa_DnCarSet[i] - HALF_DETECT_BAND;
            for (j = (2*s_avg_first_channel); j < (2*(s_avg_first_channel+FULL_DETECT_BAND)); j++)
            {
               gpsa_RxToneBuf[j] = (int16)(gpla_RxAccumBuf[j]>>s_log2_num_c_tones_avg);
            }
         }
      }

#ifdef GHS_TN_DBG
      //XDSLRTFW-2364 (Start)
      if ((gft_Log_Symbol_Count_Start == TRUE) && (TESTArray[TEST_GHS_LOG] & TEST_GHS_LOG_ENABLE))
      {
         puca_RxTone_Buffer = (uint8 *)(void *)gpla_RxTone_Buffer + ((gs_RxIndex*256)*4);
         memcpy(puca_RxTone_Buffer,gpsa_RxToneBuf, 1024);//256tones logging.(1024*2=>512 tones logging)
      }
      //XDSLRTFW-2364 (End)

      if (TESTArray[TEST_GHS_LOG] & TEST_GHS_AVG_FULL_BAND)
      {
         memset(gpla_RxAccumBuf, 0, (int16)(sizeof(int32)*gs_NumChannelsPerGroup*2));
      }
      else
#endif
      {
         // Clear accumulation buffer
         ClearGhsCarSetAccumBuf();
      }
      //XDSLRTFW-2288 (End)

      // XDSLRTFW-1023: Bugfix_DS_All_All_BlackoutTxPhaseReversalGhs (Start)
      // RxToneBuf captured when 2<=TxSymbolCount<=4 are affected by echo due to Tx phase reversal every 69 frames
      // Hence, discard those averaged recieved signals that have been affected by echo due to Tx phase reversal
      if ((gl_TxSymbolCount % TIME_16MS) >= 3 &&
            (gl_TxSymbolCount % TIME_16MS) <= (5+(1<<s_log2_num_c_tones_avg)) &&
            (s_log2_num_c_tones_avg != 0)) // do not discard rx symbols for no averaging case (for testvector tests)
      {
         //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
         if(gs_RxIndex > 0)
         {
            gs_RxIndex--;
         }
#endif
         //XDSLRTFW-2288 (End)
         return;
      }
      // XDSLRTFW-1023: Bugfix_DS_All_All_BlackoutTxPhaseReversalGhs (End)
#ifdef DEBUG_TRAIL
// Debug code for DCT - start
//      if((gs_RxSubState < 4 ))
//      {
//         gsa_StatesTrail[gs_Debug1++] = (gl_TotalTxSymbolCount & 0xFFFF);
//         gsa_StatesTrail[gs_Debug1++] = ((gl_TotalTxSymbolCount >> 16)& 0xFFFF);
//         if(gs_Debug1 >= 512)
//            gs_Debug1 = 0;
//      }
// Debug code for DCT - end
#endif
      // Detect tones
      s_TonesDetected = (FlagT)DetectMultiTones((int16*)gsa_DnCarSet, NUM_CARRIER, gs_DETECT_SCALE);
#ifdef DEBUG_TRAIL
// Debug code for DCT - start
//      if((gs_RxSubState < 4 ))
//      {
//         gsa_StatesTrail[gs_Debug1++] = s_TonesDetected;
//         gsa_StatesTrail[gs_Debug1++] = gs_PGA_set;
//         gsa_StatesTrail[gs_Debug1++] = (gl_TxSymbolCount & 0xFFFF);
//         gsa_StatesTrail[gs_Debug1++] = ((gl_TxSymbolCount >> 16)& 0xFFFF);
//         gs_Debug1 += 4;
//         if(gs_Debug1 >= 512)
//            gs_Debug1 = 0;
//      }
// Debug code for DCT - end
#endif
   }
   else
   {
      // Do not perform detection while accumulating
      return;
   }

   // XDSLRTFW-1035: Bugfix_DS_All_All_GhsPgaAdjustmentShortLoop (start)
   // This place is reached every 8 symbols/frames
   switch ( gs_RxSubState )
   {
   case R_C_TONES_RX_CHECK_FOR_CLIPPING:

      // Only start BG function if the previous one has finished.
      if (guc_PgaState == TRAINING_DONE)
      {
         // Debug code which can be removed later - start
         gs_CheckClipping++;
         // Debug code which can be removed later - end

         // use gsa_SnrBuf to capture a snapshot of RX tone buffer so
         // it can be used in the background function BgCheckMaxFreqDomain()
         memcpy(gsa_SnrBuf, gpsa_RxToneBuf, sizeof(int16)*gs_NumChannelsPerGroup*2);

         // Tone not detected. Try lowering PGA if it is too high.
         guc_PgaState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCheckMaxFreqDomain);

         gs_RxSubState = R_C_TONES_RX_DYNAMIC_GHS_PGA;
      }
      break;

   case R_C_TONES_RX_DYNAMIC_GHS_PGA:

      if (guc_PgaState == TRAINING_DONE)
      {
         if (gs_MaxFreqDomainValue < (3 * GHS_MAX_FREQ_DOMAIN_VALUE_REF))

         {
            gs_RxSubState = R_C_TONES_RX_PRE_DETECTION;
            if(gs_RxSubStateCnt)
            {
               gs_RxSubState = R_C_TONES_RX_DETECT_TONES;
// Debug code for DCT - start
//                     gs_RxSubStateCnt = 0;
// Debug code for DCT - end
            }
         }
         else
         {
            // Lower the PGA requirement by 3 dB
            gs_PGA_required = gs_PGA_set - 0x300;


            if (gs_PGA_required <= MIN_PGA)
            {
               gs_PGA_required = MIN_PGA;
            }

            if (gs_PGA_required != gs_PGA_set)
            {
               guc_PgaState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting);

               gs_RxSubState = R_C_TONES_RX_SET_PGA_WAIT;

               s_Wait2_Cnt = 0;
            }
            else
            {
               gs_RxSubState = R_C_TONES_RX_PRE_DETECTION;
               if(gs_RxSubStateCnt)
               {
                  gs_RxSubState = R_C_TONES_RX_DETECT_TONES;
// Debug code for DCT - start
//                     gs_RxSubStateCnt = 0;
// Debug code for DCT - end
               }
            }
         }
      }
      break;

   case R_C_TONES_RX_SET_PGA_WAIT:

      // Wait for background task to complete and for PGA change to propagate to Rx tone buffer.
      s_Wait2_Cnt++;
      // Wait for background task to complete and
      // for PGA change to propagate to Rx tone buffer.
      if ((guc_PgaState == TRAINING_DONE) && (s_Wait2_Cnt > 2))
// Debug code for DCT - start
//         if ((guc_PgaState == TRAINING_DONE) && (s_Wait2_Cnt > 90))
// Debug code for DCT - end
      {
         gs_RxSubState = R_C_TONES_RX_CHECK_FOR_CLIPPING;
      }
      break;

      /* =============================================== */
      /* initial silence period until a tone is first detected */
      /* =============================================== */
   case R_C_TONES_RX_PRE_DETECTION:

      if (s_TonesDetected)
      {
         gs_RxSubStateCnt++;
         s_NoDetectCnt = 0;
         //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
         gft_Log_Symbol_Count_Start = TRUE;
         gft_TonesDetected++;
#endif
         //XDSLRTFW-2288 (End)
      }
      else
      {
         s_NoDetectCnt++;
         gs_RxSubStateCnt = 0;
         //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
         gft_TonesDetected = 0;
#endif
         //XDSLRTFW-2288 (End)
      }

      // Tones detected for around 30ms.
      if (gs_RxSubStateCnt >= (s_RCTonesBurstCnt>>1))
      {
// Debug code which can be removed later - start
         gl_HsToneSetPower++;
// Debug code which can be removed later - end
         // GHS tones detected, adjust again the PGA.
         gs_RxSubState = R_C_TONES_RX_CHECK_FOR_CLIPPING;

         //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
         gft_Log_Symbol_Count_Start = FALSE;
#endif
         //XDSLRTFW-2288 (End)
#ifdef DEBUG_VRX518_AFE  //0x510a
         if(gs_PauseControl == 0x510a)
         Pause(gs_PauseControl);
#endif

      }
      else if (s_NoDetectCnt == R_C_TONES_DETECTION_FAILURE_CNT)
      {
         s_NoDetectCnt = 0;

// Debug code which can be removed later - start
         gs_TryNext++;
// Debug code which can be removed later - end
         // Try detecting another tone set
#ifdef DEBUG_VRX518_AFE  //0x5109
               if(gs_PauseControl == 0x5109)
               Pause(gs_PauseControl);
#endif
         TryAnotherToneSet();

         //a new gs_RxToneOffset might need to be configured. Wait until HW is ready
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_TONES_RX_WAIT_FOR_HW_READY;

      }
      break;

   case R_C_TONES_RX_DETECT_TONES:

// Debug code for DCT - start
//         if (s_TonesDetected)
//         {
//            gs_RxSubStateCnt++;
//            s_NoDetectCnt = 0;
//         }
//         else
//         {
//            s_NoDetectCnt++;
//            gs_RxSubStateCnt = 0;
//         }
//
//         if (gs_RxSubStateCnt >= 4)
// Debug code for DCT - end
         gl_InitRxHsTonesPower = RxPowerGHS(gsa_DnCarSet, (int16)(LOG2_NUM_CARRIER + 1));

         //Calculate average HSK tone power at the analog front end
         //Taking into account of (1).avergae power calculated from rxtonebuffer, (2).hsk PGA
         //(3).TDQ scaleback with reference to initial gs_pre_tdq_h_exp, which is set to 14, i.e., with 6dB gain
         gs_HsTonePower_dB = ConvertToDB(gl_InitRxHsTonesPower) - gs_PGA_set; // + (gs_pre_tdq_h_exp -14) *6*256 ;
         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         // Choose GHS pilot tone
         gt_PilotConfig.te_UsedPTArrayIdx = PT_ARRAY_IDX_0;
         gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx = (gsa_DnCarSet[2]+gs_RxToneOffset);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxPilotToneIndex);
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

         //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
         if(gs_PauseControl == 0x3bec)
            Pause(0x3bec);
#endif
         //XDSLRTFW-2288 (End)

         /* not excess power - go to next state */
         gs_RxNextState = R_C_GALF1_RX;
         gpF_RxStateFunc = (PtrToFunc)RCGalf1RxF;

      break;

   case R_C_TONES_RX_WAIT_FOR_HW_READY:
      gs_RxSubStateCnt++;
      if (gs_RxSubStateCnt >= gs_RTVxCfgLatency)
      {
         // GHS tones not detected, check for clipping.
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_TONES_RX_CHECK_FOR_CLIPPING;
      }

      break;
   }   /*  switch */

   // XDSLRTFW-2373

   if (gl_RxSymbolCount >= ul_Timeout )
      //if (gl_RxSymbolCount >= (2*R_C_TONES_RX_DETECT_TONES_TIMEOUT))
   {
      // Not detecting tones within timeout period.
      // Go back to initial states to reset the PGA to max, in case it was set
      // really low (and is stuck there) because of some transient strong noise.
      // Tx goes on its own when it sees Rx back to RCSilent1
      if(gsa_Optn0_ModeControl[0] & OPTN_ConfigMode_T1413)
      {
         // Set RTV flag to read FFT output
         gs_RtvSelect = FFT_OUTPUT;

         gs_RxToneOffset = 0; //XDSLRTFW-4227 Reset the capture offset in T1413 mode

         // Set offset for loading gpsa_RxToneBuf from RTV buffer 0
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         // Enable GetRxTones in RxProcessTones fcn
         gft_EnableGetRxTones = TRUE;


         Activation_T1413_StateMachine();
      }
      else
      {

         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
      }
   }

   // XDSLRTFW-1035: Bugfix_DS_All_All_GhsPgaAdjustmentShortLoop (end)
}   /*  RCTonesRxF */

/*========================================================================================*/
/*  Name: Activation_T1413_StateMachine
 *
 *  Abstract:
 *  The following routine is called for T1413 activation purpose.
 *
 * 1) VDSL binary with T1413 support : standard mode:
 *                 |_____4sec_____|_____2sec_____|_____4sec_____|_____2sec_____| Switch to
 *                 |  G.Hs        |  T1.413      |  G.Hs        |  T1.413      | ADSL bin
 *                 | not detected |  detected    | not detected |  detected    | exception code 0x13E
 *
 * 2) VDSL binary with T1413 support : non-standard mode
 *                 |_____60 sec_____|_____60 sec_____| Switch to
 *                 |  G.Hs          |  T1.413        | ADSL bin
 *                 | not detected   |  detected      | exception code 0x13E
 *
 *  Parameters:
 *  Returns:
 *      None                     :
 *  Global Variables Used:
 */
/*========================================================================================*/

void Activation_T1413_StateMachine()
{

   gs_TxNextState = R_ACT_REQ_TX;
   gpF_TxStateFunc = (PtrToFunc) RActReqTxF;

   gs_RxNextState = R_C_ACT_RX;
   gpF_RxStateFunc = (PtrToFunc) RCActRxF;

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RActReqTxF
 *
 *  Description:
 *              R_ACT_REQ is used for ATU-R to initiate a link to the ATU-C.
 *
 *  Prototype: RActReqTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount  - number of symbold in current Tx state
 *      gs_RxState        - Rx state
 *      gs_TxNextState    - next Tx state
 *      gs_TxOutBuf[]     - time domain samples to transmit, used in TxMultiTones()
 *      gs_TxToneBuf[]    - frequency domain samples, used in TxMultiTones()
 *      gsa_IFFT_OutBuf[] - output of IFFT, used in TxMultiTones()
 *      gusa_txgain[]     - (I) used for power cutback
 *
 *  Notes: implements state R_ACT_REQ_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define R_ACT_REQ_TX_LEN                                (1024)
#define R_ACT_REQ_ACT_TX_HALFLEN                (64)
#define R_ACT_REQ_ACT_TX_LEN                    (128)
#define R_ACT_REQ_QUIET_MIN_LEN                 (128)
#define R_QUIET1_TX_LEN                                 (240000)
#define R_QUIET2_MIN_LEN                                (128)
#define R_ACK_TX_HALFLEN                                (64)
#define R_ACK_TX_LEN                                    (128)

// Detection length
#define R_C_ACT_DET_CNT                                 (4)
// TONES FOR RX
#define C_T1413_TONE    72
#define C_ACT1_TONE             48
#define C_ACT2_TONE             44
#define C_ACT3_TONE             52
#define C_ACT4_TONE             60
#define C_REVEILLE_TONE         56

// Tones for TX
#define R_ACT_REQ_TONE  8

#define R_ACK1_TONE             10
#define R_ACK2_TONE             12
#define R_ACK3_TONE             14
#define R_PILOT_TONE    16



#define POWER_LEVEL_HIGH                (0x3CCF)                                  //-1.65dBm
#define POWER_LEVEL_LOW                 (0x615)                                   //0x3CCF*0.1, 20 dB lower

#define C_ACT1          1
#define C_ACT2          2
#define C_ACT3          3
#define C_ACT4          4
#define C_ACT_TONE                              5       // indicate detecting C_T1413_TONE

#define FFT_T1413_SIZE  (512)

void RActReqTxF(void) {

   int16 s_SymCnt;
   int16 s_TxScale;
   /* ---- transmit silence ---- */
   if (gl_TxSymbolCount == 0)
   {
      /* enable IFFT */
      gft_IFFT_On = TRUE;
      gs_LoadGhsToneFlag = (BITMAP_LOAD_T1413_TONE | BITMAP_REGSTART_IFFT);
   }

   /* Start with quiet to simulate 100ms silence in HS/T1 multimode. */
   s_SymCnt = (gl_TxSymbolCount + R_ACT_REQ_ACT_TX_LEN) % R_ACT_REQ_TX_LEN;

   if ( s_SymCnt ==  0 )  {
      // transmit at higher power level   // Multiply scale with sqrt(2):
      s_TxScale = (int16) ((23170 * (int32)POWER_LEVEL_HIGH) >> 14);

      // Insert tones with phase 90 or 270, depending on the sign of s_TxScale.
      // Each tone is represented by two values in the gsa_TxGhsToneBuf array,
      // corresponding to the real and imaginary values.  This array
      // is used by the LoadGhsTonesToIfftBuf() function to load the HW IFFT
      // input buffer.
      gsa_TxGhsToneBuf[0] = 0;
      gsa_TxGhsToneBuf[1] = s_TxScale;
   }
   // transmit at lower POWER_LEVEL_LOW
   else if ( s_SymCnt == R_ACT_REQ_ACT_TX_HALFLEN)
   {
      s_TxScale = (int16) ((23170 * (int32)POWER_LEVEL_LOW) >> 14);
      gsa_TxGhsToneBuf[0] = 0;
      gsa_TxGhsToneBuf[1] = s_TxScale;
   }

   // transmit quiet
   else if ( s_SymCnt == R_ACT_REQ_ACT_TX_LEN)
   {
      gsa_TxGhsToneBuf[0] = 0;
      gsa_TxGhsToneBuf[1] = 0;
   }
}

void BgRightShiftAndRound32to16()
{
   RightShiftAndRound32to16(gpsa_RxRepBuf, 0, gpla_RxAccumBuf, 0,FFT_T1413_SIZE, 3);
   guc_AccumState = TRAINING_DONE;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : R_C_ACT_RX
 *
 *  Abstract :
 *
 *  R_C_ACT_RX detects either C_TONE or C_ACT signal.
 *  Upon the detection of C_TONE or C_ACT
 *  the Rx enters the R_QUIET1_TX or R_ACK_TX state.respectively
 *
 *  Global Variables Used:
 *      gpsa_FFT_InBuf[]   - input of IFFT
 *      gs_RxToneBuf[]    - frequency domain samples
 *      ( above two are used in DetectTones() )
 *      gs_RxSubState     - (I/O) current RX substate
 *      gs_RxSubStateCnt  - (I/O) # symbols in current RX substate
 *      gl_RxSymbolCount  - (I) # symbol periods in current RX state
 *      gs_RxNextState    - (O) RX state that will begin next symbol period
 *
 *  Notes :
 *
 *------------------------------------------------------------------------
 *^^^
 */
#ifndef ISDN   // Only for Anx-A
// R3_P1: AR8_TF: IOP_DS_T1413_ALL_CActCPilot1DetectionProblems

int16 gs_T1413ToneDetectScale = 6;
#else // Anx-B
int16 gs_T1413ToneDetectScale = 60;
#endif // ifndef ISDN

#define CACT_ACCUM              0
#define CACT_DETECT             1

#define CACT_LOG2_NUM_ACCUM_SYMBOLS     (4)
int16 DetectCAct(void)
{
   int16 s_ActType;

   s_ActType = -1;
   switch (gs_DetectCACT_State)
   {
   case CACT_ACCUM:
      /* clear accum buffer before first accumulation */
      if (gs_DetectCACT_AccumCount == 0 )
      {
         memset((int16 *)(void *)gpla_RxAccumBuf, 0, (int16)(sizeof(int32)*FFT_T1413_SIZE));
      }

      /* Accumulate recieved signal for 8 frames */
      Accum16to32((int32 *)gpla_RxAccumBuf, 0, gpsa_RxToneBuf, 0, FFT_T1413_SIZE);
      gs_DetectCACT_AccumCount++;

      /* Accumulation done, goto next state */
      if ((gs_DetectCACT_AccumCount % (1<<CACT_LOG2_NUM_ACCUM_SYMBOLS)) == 0)
      {
         /* Average accumulated signal */
         guc_AccumState = TRAINING_IN_PROGRESS;

         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRightShiftAndRound32to16);

         gs_DetectCACT_State = CACT_DETECT;
      }
      break;

   case CACT_DETECT:
      if(guc_AccumState == TRAINING_DONE)
      {
         //--- Detect either C_T1413_TONE or C_ACT --------
         if (DetectTone(gpsa_RxRepBuf, C_ACT2_TONE, C_ACT2_TONE - HALF_DETECT_BAND,
                        C_ACT2_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale*256)))
            s_ActType = C_ACT2 ;

         // The leakage of the pulsed Tx Tone while using 64 pt IFFT into DS band
         // causes false detection of the T1413 pilot tone. (reference Pui)
         // Hence we do not detect for this tone
         /*
         else if ( s_ToneDetected = DetectTone(gpsa_RxRepBuf, C_T1413_TONE, C_T1413_TONE - HALF_DETECT_BAND,
         C_T1413_TONE + HALF_DETECT_BAND, (int16)(gs_ToneDetectScale*256)) )
         s_ActType = C_ACT_TONE;
         */
         else if (DetectTone(gpsa_RxRepBuf, C_ACT4_TONE, C_ACT4_TONE - HALF_DETECT_BAND,
                             C_ACT4_TONE + HALF_DETECT_BAND, (int16)(gs_T1413ToneDetectScale*256)) )
            s_ActType = C_ACT4;

         else
            s_ActType = 0;

         gs_DetectCACT_State = CACT_ACCUM;
         gs_DetectCACT_AccumCount = 0;
      }
      break;
   }
   return(s_ActType);
}

#define RX_CALCMAXPGA           0
#define RX_SETMAXPGA            1
#define RX_DETECT_ACT           2
#define RX_COUNT_SYMBOLS        3
#define RX_DETECT_C_QUIET2      4

#define SETPGATONES_CHECKLEVEL  (0)
#define SETPGATONES_WAIT1       (1)
#define SETPGATONES_STEPDOWN    (2)
#define SETPGATONES_WAIT2           (3)
#define SETPGATONES_LEVEL_OK    (4)

void SetPgaForToneDetection(void)
{
   static s_Wait3_Cnt;

   switch (guc_PgaToneState)
   {

   case SETPGATONES_CHECKLEVEL:
      memcpy(gsa_SnrBuf, gpsa_RxToneBuf, sizeof(int16)*gs_NumChannelsPerGroup*2);
      guc_PgaState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCheckMaxFreqDomain);
      guc_PgaToneState = SETPGATONES_WAIT1;
      break;

   case SETPGATONES_WAIT1:
      // Wait for background task to complete.
      if (guc_PgaState == TRAINING_DONE)
      {
         // If magnitude is too high, step down the PGA;
         if (gs_MaxFreqDomainValue > GHS_MAX_FREQ_DOMAIN_VALUE_REF)
         {
            if (gs_MaxFreqDomainValue > 30000)
            {  // Danger: hacked in.(TNT)
               // Lower the PGA by 5 dB
               gs_PGA_required = gs_PGA_set  - gs_PGA_Dbg1;
            }
            else if (gs_MaxFreqDomainValue > 2*GHS_MAX_FREQ_DOMAIN_VALUE_REF)
            {
               // Lower the PGA by 3 dB
               gs_PGA_required = gs_PGA_set - gs_PGA_Dbg2;
            }
            else
            {
               // Lower the PGA by 1 dB
               gs_PGA_required = gs_PGA_set - gs_PGA_Dbg3;
            }
            guc_PgaToneState = SETPGATONES_STEPDOWN;
         }
         else
            guc_PgaToneState = SETPGATONES_LEVEL_OK;
      }
      break;

   case SETPGATONES_STEPDOWN:

      // 1. Start background task that decreases the PGA.
      guc_PgaState = TRAINING_IN_PROGRESS;

      if (gs_PGA_required <= MIN_PGA)     //XDSLRTFW-3515
      {
         gs_PGA_required = MIN_PGA;
      }
      AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting);

      //note that the TDQ is disabled and we will not change the digital gain to increase
      // analog gain or correspodingly
      guc_PgaToneState = SETPGATONES_WAIT2;
      s_Wait3_Cnt = 0;
      break;

   case SETPGATONES_WAIT2:
      // Wait for background task to complete and for PGA change to propagate to Rx tone buffer.
      s_Wait3_Cnt++;
      if ((guc_PgaState == TRAINING_DONE) && (s_Wait3_Cnt > 3))
      {
         guc_PgaToneState = SETPGATONES_CHECKLEVEL;

         if ((gs_PauseControl == 0x3bef) && (gs_PGA_required < 0x3600) )
            Pause(0x3bef);
      }
      break;

   case SETPGATONES_LEVEL_OK:
      guc_PgaToneState = SETPGATONES_CHECKLEVEL;
      break;
   }//switch
}



void RCActRxF(void)
{
   int16 s_ActType =-1;
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
   uint32 ul_ActTimeout;
   // XDSLRTFW-2373
   uint8 uc_MinDetects;


   if (gsa_Cnfg_Misc[0] & CNFG_MISC_NON_STANDARD_HSK_MASK)

   {
      ul_ActTimeout = 120*TIME_500MS;
      uc_MinDetects = 1;
   }
   else
   {
      ul_ActTimeout = 4*TIME_500MS;
      uc_MinDetects = 2;
   }


   if (gl_RxSymbolCount == 0)
   {
      gs_DetectCACT_State = CACT_ACCUM;
      gs_DetectCACT_AccumCount = 0;
   }

   /* average recieved signal and perform multi-tone detection */
   /* returns -1 -- no detection performed, 0 -- no tones detected, 2 or 4 -- tones detected */

   if (gs_RxSubState >= RX_DETECT_ACT)
   {
      SetPgaForToneDetection();

      s_ActType = DetectCAct();
   }
   switch (gs_RxSubState)
   {
   case RX_CALCMAXPGA:
      gs_PGA_required = (AFED_AGC1_MAX_PGA << 8); ///* initial PGA */
      guc_PgaState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting);
      gs_RxSubState = RX_SETMAXPGA;
      break;

   case RX_SETMAXPGA:
      if (guc_PgaState == TRAINING_DONE)
      {
         gs_RxSubStateCnt = 0;
         gul_T1413_ACT_TimeOUT_Cnt = 0;
         gs_RxSubState = RX_DETECT_ACT;
      }
      break;

   case RX_DETECT_ACT:
      if ( s_ActType > 0)
      {
         gs_C_ACT_flag = s_ActType;
         gs_RxDetectCnt = 0;
         gs_RxSubState = RX_COUNT_SYMBOLS;
      }
      else
      {

         /* If C-ACT is not detected for 2 seconds and not in T1.413 only mode, switch */
         /* to handshake. */
         //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
         if ((gul_T1413_ACT_TimeOUT_Cnt >= ul_ActTimeout) && (guc_PgaToneState == SETPGATONES_LEVEL_OK))
         {
            if ((gsa_Optn0_ModeControl[0] & ~(OPTN_ConfigMode_T1413))|| gsa_Optn0_ModeControl[1])
            {
               //XDSLRTFW-2389 (Start_End)
               //Switch to G.Hs Handshake mode for both Standard and Non-Standard mode
               //if (gsa_Cnfg_Misc[0] & CNFG_MISC_NON_STANDARD_HSK_MASK)
               {
                  //XDSLRTFW-2373
                  guc_T1413DetectCnt = 0;
                  gs_TxNextState = R_SILENT0_TX;
                  gpF_TxStateFunc = (PtrToFunc) RSilent0TxF;

                  gs_RxNextState = R_C_SILENT1_RX;
                  gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
               }
            }
            else // G.hs not supported.  Jump back to first substate to reset PGA to max.
            {
               gs_RxSubState = RX_CALCMAXPGA;
            }
            //XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start_End)
         }//gul_T1413_ACT_TimeOUT_Cnt
         gs_RxSubStateCnt++;
         gul_T1413_ACT_TimeOUT_Cnt++;
      }
      break;


   case RX_COUNT_SYMBOLS:
      if(s_ActType > 0)
      {
         if (gs_C_ACT_flag == s_ActType)
            gs_RxDetectCnt++;
         else
            gs_RxSubState = RX_DETECT_ACT;
      }
      else if (s_ActType == 0)
         gs_RxSubState = RX_DETECT_ACT;

      if (gs_RxDetectCnt == R_C_ACT_DET_CNT - 1)
      {
         // Detected T1413 once
         //XDSLRTFW-2373
         guc_T1413DetectCnt++;

         STATArray[STAT_Misc] |= STAT_T1413_Signal_Detected;

         if ((gs_C_ACT_flag == C_ACT_TONE) ||
               (gs_C_ACT_flag == C_ACT2) ||
               (gs_C_ACT_flag == C_ACT4))
         {
            // C_T1413_TONE is detected.  This causes CPE to go quiet for a
            // minute, or until C-ACT is detected to initiate the link.
            /*
             * 1) VDSL binary with T1413 support : standard mode:
             *                 |_____4sec_____|_____2sec_____|_____4sec_____|_____2sec_____| Switch to
             *                 |  G.Hs        |  T1.413      |  G.Hs        |  T1.413      | ADSL bin
             *                 | not detected |  detected    | not detected |  detected    | exception code 0x13E
             *
             * 2) VDSL binary with T1413 support : non-standard mode
             *                 |_____60 sec_____|_____60 sec_____| Switch to
             *                 |  G.Hs          |  T1.413        | ADSL bin
             *                 | not detected   |  detected      | exception code 0x13E
             *
             */
            if(guc_T1413DetectCnt >= uc_MinDetects )
            {
               EnterFailStates(E_CODE_GHS_T1413_MODE);
            }
            else
            {
               gs_TxNextState = R_SILENT0_TX;
               gpF_TxStateFunc = (PtrToFunc) RSilent0TxF;

               gs_RxNextState = R_C_SILENT1_RX;
               gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;
            }
         }
         else
         {
            gs_RxSubState = RX_DETECT_C_QUIET2;
            gs_RxSubStateCnt = 0;
         }
      }
      break;
   }//switch


}


void ClearGhsCarSetAccumBuf(void)
{
   int16 i;
   int16 s_avg_first_channel;

   for(i=0; i<NUM_CARRIER; i++)
   {
      s_avg_first_channel = gsa_DnCarSet[i] - HALF_DETECT_BAND;
      memset(&gpla_RxAccumBuf[2*s_avg_first_channel], 0, sizeof(int32)*2*FULL_DETECT_BAND);
   }
}

#undef R_C_TONES_RX_DETECT_TONES
#undef R_C_TONES_RX_COUNT_SYMBOLS
