/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RFlag1TxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "fifo.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#include "vdsl_const.h"
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RFlag1TxF
 *
 *  Description:
 *      FLAG characters are transmitted continuously.
 *      Octet boundary must be maintained, i.e. state transition in the
 *      middle of an octet transmission may not allowed. Upon receiving
 *      C_Flag1, Tx moves to R_HS_MSG_TX.
 *
 *  Prototype: void RFlag1TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]    - frequency domain samples, used in TxBit()
 *      guc_TxOctet       - (I/O) current octet being transmitted
 *      gs_RxState        - (I) current RX state
 *      gl_TxSymbolCount  - (I) # symbol periods in current TX state
 *      gs_TxNextState    - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_FLAG1_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RFlag1TxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_FLAG1;
   /* ---- initialize ---- */
   if ( gl_TxSymbolCount == 0 )
   {
      guc_TxOctet = FLAG;
   }

   /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX )
   {
      gs_TxNextState =R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
   }

   /* ---- transmit a bit ---- */
   TxBit();

   /* ==== if completing one octet transmission ==== */
   if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET-1) )
   {

      /* ---- if Rx received C_Flag1, move to R_HS_MSG_TX ---- */
      if ( gs_RxState == R_C_HS_MSG_RX )
      {
         gs_TxNextState = R_HS_MSG_TX;
         gpF_TxStateFunc = (PtrToFunc)RHSMsgTxF;
      }

      guc_TxOctet = FLAG;
   }

}   /*  RFlag1TxF */

