/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RHSMsgTxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "fcs.h"
#include "PrintTrail.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL

/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RHSMsgTxF
 *
 *  Description:
 *      Handshake messages are transmitted until message exchange is
 *      over and cleardown is requested.  Idle FLAGs are transmitted when there
 *      is no message to transmit.
 *
 *  Prototype: void RHSMsgTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]              - frequency domain samples, used in TxBit()
 *      guc_TxOctet                 - (I/O) current octet being transmitted
 *      gs_RxState                  - (I) current RX state
 *      gs_TxSubState               - (I/O) current TX substate
 *      gl_TxSymbolCount            - (I) # symbol periods in current TX state
 *      gs_TxNextState              - (O) TX state that will begin next symbol period
 *      gpuca_TxMsgBuf              - (I) message octets to be transmitted in
 *                                    this state
 *      gs_TxMsgBufCnt              - (O) # octets in the message buffer to be
 *                                    transmitted in this state
 *      gt_hsc                      - (I/O) handshake control structure
 *      gft_RxSymbolReAlignRequired - (I/O) symbol realign flag
 *
 *  Substates:
 *      R_HS_MSG_TX_PREFIX_FLAG     - Transmits NUM_PREFIX_FLAG mandatory FLAGs
 *                                    at the head of a message.
 *      R_HS_MSG_TX_MESSAGE         - Transmits a message body.
 *      R_HS_MSG_TX_POSTFIX_FLAG    - Transmits NUM_POSTFIX_FLAG mandatory FLAGs
 *                                    at the tail of a message.
 *      R_HS_MSG_TX_IDLE_FLAG       - Transmits FLAGs while waiting for a
 *                                    message in Rx side.
 *
 *  Notes: implements state R_HS_MSG_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_HS_MSG_TX_PREFIX_FLAG     (0)
#define R_HS_MSG_TX_MESSAGE         (1)
#define R_HS_MSG_TX_POSTFIX_FLAG    (2)
#define R_HS_MSG_TX_IDLE_FLAG       (3)



/* =============================================== */
/* macro to prepare for next handshake message exchange */
/* =============================================== */

void TxFlag( int16 s_Num_Flag, int16 s_NextSubState )
{
   gs_TxOctetCnt++;
   if ( gs_TxOctetCnt >= (s_Num_Flag) )
   {
      gs_TxOctetCnt = 0;
      gs_TxSubState = (s_NextSubState);

   }
   guc_TxOctet = FLAG;
}   /*  TxFlag */

/* =============================================== */
/* macro to prepare for next handshake message exchange */
/* =============================================== */
void InitNextMsgExchange()
{
   if ( gs_TxMsgBufCnt > 0 )    /* start from R_HS_MSG_TX_PREFIX_FLAG if there is a message to transmit*/
   {
      gs_TxOctetCnt = 1;
      gs_TxSubState = R_HS_MSG_TX_PREFIX_FLAG;
      gs_LastTxMsgBufCnt = gs_TxMsgBufCnt;
   }
   else                        /* start from R_HS_MSG_TX_IDLE_FLAG if there is nothing to transmit */
   {
      gt_hsc.s_TxMsgComplete = TRUE;
      gs_TxSubState          = R_HS_MSG_TX_IDLE_FLAG;
   }
}

void RHSMsgTxF(void)
{

   /* ---- initialize ---- */
   if ( gl_TxSymbolCount == 0 )
   {
      guc_TxOctet    = FLAG;
      gs_TxMsgBufCnt = 0; // no message to transmit at the beginning of message exchange (HS_INITIAL)
      InitNextMsgExchange();
   }

   /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX )
   {
      gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      return;
   }

   /* ---- Transmit guc_Octet bit by bit ---- */
   TxBit();

   /*  **** if completing an octet **** */
   if ( (gl_TxSymbolCount & MODULO_BY_64_MASK) == (SYMBOLS_PER_OCTET - 1) )
   {

      switch (gs_TxSubState)
      {

         /* ==== transmit NUM_PREFIX_FLAG mandatory FLAGs at the head of a message ==== */
      case R_HS_MSG_TX_PREFIX_FLAG:

         TxFlag( NUM_PREFIX_FLAG, R_HS_MSG_TX_MESSAGE );
         break;

         /* ==== transmit a message body ==== */
      case R_HS_MSG_TX_MESSAGE:
         if (gs_TxOctetCnt < gs_TxMsgBufCnt)
         {
            guc_TxOctet   = gpuca_TxMsgBuf[ gs_TxOctetCnt++ ];
         }
         else
         {

            //Set the message length to 0 after all bytes has been transmitted
            gs_TxMsgBufCnt = 0;
            gs_ReAlignSubState         = 0;  /*  reset */
            // XDSLRTFW-920: BugFix_US_All_All_GhsNakEf (start_end)
            // Note: Must be rethougth for retransmission "gft_RTXCtrlFlag"
            if (gpt_TxInfo->uc_Type != M_NAK_EF)
            {
               gft_SymbolReAlignRequired = TRUE;
            }
            gt_hsc.s_TxMsgComplete    = TRUE;
            gs_TxOctetCnt             = 1;
            guc_TxOctet               = FLAG;
            gs_TxSubState             = R_HS_MSG_TX_POSTFIX_FLAG;
#ifdef DEBUG_TRAIL
            LeaveGhsStatesTrail(gt_hsc.s_State, gt_hsc.s_NextState, gs_RxGhsSymCnt, (uint8)TX, gpt_TxInfo->uc_Type);
#endif //DEBUG_TRAIL
         }

         break;

         /* =============================================== */
         /* transmit NUM_POSTFIX_FLAG mandatory FLAGs at the tail of a message */
         /* =============================================== */
      case R_HS_MSG_TX_POSTFIX_FLAG:
         TxFlag( NUM_POSTFIX_FLAG, R_HS_MSG_TX_IDLE_FLAG );
         break;

         /* =============================================== */
         /* transmit FLAGs while waiting for a message in Rx side */
         /* =============================================== */
      case R_HS_MSG_TX_IDLE_FLAG:

         guc_TxOctet = FLAG;

         /* ---- if a message is completely received and decoded, move to next state ---- */
         if (gt_hsc.s_RxMsgComplete == TRUE)
         {

            gt_hsc.s_RxMsgComplete = FALSE; /* reset flag */

            /* ---- if HS message exchange is done, go to cleardown procedure ---- */
            if (gt_hsc.s_NextState == R_HS_EXIT)
            {

               if ( gt_hsc.s_State == R_HS_MS_OK)
               {
                  gs_TxNextState = R_FLAG2_TX;
                  gpF_TxStateFunc = (PtrToFunc)RFlag2TxF;
               }
               else  /*  if ( gt_hsc.s_State == R_HS_SEND_MS ) */
               {
                  gs_TxNextState = R_GALF2_TX;
                  gpF_TxStateFunc = (PtrToFunc)RGalf2TxF;
               }
            }
            /* ---- else, keep exchanging messages ---- */
            else
            {
               InitNextMsgExchange();
            }

         }   /*  if (message complete) */

         break;

      }   /*  switch */

   }   /*  if (complete an octet) */

}   /*  RHSMsgTxF */

#undef R_HS_MSG_TX_PREFIX_FLAG
#undef R_HS_MSG_TX_MESSAGE
#undef R_HS_MSG_TX_POSTFIX_FLAG
#undef R_HS_MSG_TX_IDLE_FLAG

#undef TxFlag
#undef InitNextMsgExchange

