/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSilent0TxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#include "vdsl_const.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSilent0TxF
 *
 *  Description:
 *      R_SILENT0_TX is a silent state where no signal is transmitted.
 *      A host command moves the Tx state to R_TONES_REQ_TX. C_TONES from an ATU-C
 *      moves the Tx state to R_TONE1_TX.
 *
 *  Prototype: RSilent0TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - number of symbold in current Tx state
 *      gs_RxState       - Rx state
 *      gs_TxNextState   - next Tx state
 *      gs_TxOutBuf[]    - time domain samples to transmit. used in TxQuiet().
 *
 *  Notes: implements state R_SILENT0_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RSilent0TxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_SILENT0;
   /* ---- transmit silence ---- */
   if (gl_TxSymbolCount == 0)
   {
      /* Disable loading GHS tones */
      /* QT is programmed to set all output tones to 0's by setting TX gains to 0  */
      gs_LoadGhsToneFlag = (~BITMAP_LOAD_GHS_TONES & BITMAP_REGSTART_IFFT);

      // Reset of PLL: XDSLRTFW-3115  V+B+35b: Full-Init-drops at beginning of channel discovery (E_CODE_ZERO_TONE_CLUSTERS / E_CODE_RX_LOW_PILOT_TONE_POWER)
      // We need to reset PLL related variables to start with a defined PLL. R_Tones_Request need to be already in the correct frequency range, hence we reset the PLL variables here.
      // Without the PLL reset we started with a random and sometimes incorrect PLL. With an incorrect PLL it was likely that we passed GHS, but were not able to recover the PLL and dropeed then at beginning of
      // channel discovery.
      gl_pll_freq_offset = 0;
      gl_pll_loopfilter_out = 0;
      gs_PhaseError = 0;

      gsa_IndirectStat0[0] = STAT_ReadyState;
      gusa_MONI_ModemStat_Status[0] = MONI_STAT_READY;
   }

   /* ---- proceed to R_TONE_REQ_TX upon host commands CPE to start ---- */
   if (gs_RxState == R_C_TONES_RX)
   {
      gs_TxNextState = R_TONES_REQ_TX;
      gpF_TxStateFunc = (PtrToFunc)RTonesReqTxF;
   }

   /* ---- if C_Tones is received, move to R_TONE1_TX ---- */
   if ( gs_RxState == R_C_GALF1_RX )
   {
      gs_TxNextState = R_TONE1_TX;
      gpF_TxStateFunc = (PtrToFunc)RTone1TxF;
   }

   /* ---- if silence period has been requested by either ATU-R or ATU-C, ---- */
   /* ---- move to next state after about 1 minute of silence             ---- */
   if ( ( gt_hsc.l_SelectedMode == SILENCE ) && ( gl_TxSymbolCount >= REQUESTED_SILENCE ) )
   {
      gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */
      gs_TxNextState        = R_TONES_REQ_TX;
      gpF_TxStateFunc = (PtrToFunc)RTonesReqTxF;
   }

   /* ---- if no common mode can be determined,                     ---- */
   /* ---- do nothing until ATU-C or host command invoke handshking ---- */
   if ( gt_hsc.l_SelectedMode == NO_COMMON_MODE )
   {
      gt_hsc.l_SelectedMode = NOT_SELECTED; /*  reset */
   }

}   /*  RSilent0TxF */

