/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSilent1TxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "vdsl_xception.h"
#include "cmv_data.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSilent1TxF
 *
 *  Description:
 *      Silence for a fixed amount of time.
 *
 *  Prototype: void RSilent1TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - number of symbold in current Tx state
 *      gs_TxNextState   - next Tx state
 *      gs_TxOutBuf[]    - time domain samples to transmit. used in TxQuiet().
 *
 *  Notes: implements state R_SILENT1_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RSilent1TxF(void)
{
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_SILENT1;
   // When C-Tones are detected and the PGA is trained the RX statemachine switches to
   // R_C_GALF1_RX (RCGalf1RxF). After this TX statemachine switches from R_TONES_REQ_TX
   // (RTonesReqTxF) to this state R_SILENT1_TX.

   /* ---- transmit silence ---- */
   if (gl_TxSymbolCount == 0)
   {
      /* Disable loading GHS tones */
      /* QT is programmed to set all output tones to 0's by setting TX gains to 0  */
      gs_LoadGhsToneFlag = (~BITMAP_LOAD_GHS_TONES & BITMAP_REGSTART_IFFT);
   }
   else
   {
      uint16 us_MinSilentFlag;

      // Note: At least R-SILENT1 nust be 50ms. Therefore this additional check should be there.
      //       Used 100ms to be twice as big as the min value.
      us_MinSilentFlag = FALSE;
      if(gl_TxSymbolCount >= (TIME_50MS<<1))
      {
         us_MinSilentFlag = TRUE;
      }

      // We need PLL lock and GHS_2 codeswap to be done.
      // Hence, stay in R-SILENT1 so that CO continues to stay
      // in C-TONES, until Rx gives indication of the same
      // rx detection, pll lock and codeswap done
      if ((gs_TxRxMessaging == PRE_GHS_CODESWAP_RX_DETECT_DONE) &&
            (us_MinSilentFlag))
      {
         // Prevent repeated GHS codeswaps incase of GHS restarts by NOT
         // reseting the TxRxMessaging variable used by pre-ghs codeswap
         // gs_TxRxMessaging = 0;                     //reset tx rx messaging variable
         gs_TxNextState = R_TONE1_TX;
         gpF_TxStateFunc = (PtrToFunc)RTone1TxF;
      }
   }

   // If max R-SILENT1 duration has been elapsed, declare timeout
   {
      int32 l_maxRSilent1Len;

      l_maxRSilent1Len = (TIME_500MS << gs_frame_rate_is_8khz);
      if (gl_TxSymbolCount >= l_maxRSilent1Len)
      {
         EnterFailStates(E_CODE_CODESWAP_ERR);
      }
   }

}   /*  RSilent1TxF */

