/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RTone1TxF.c
 *
 *   Handshaking phase states the Initialization Sequence for both TX and RX.
 *   Complying with ITU-T G.994.1 Draft Recommendation (G.hs).
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "fifo.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#include "vdsl_const.h"

int16 gs_HSAlignment = 2; /* Tx/Rx alignment obtained from lab measurements. */
/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: RTone1TxF
 *
 *  Description:
 *      R_Tone1 is transmitted by the ATU-R.
 *      Upon receiving a GLAF character, the Tx will enter R_FLAG1_TX .
 *
 *  Prototype: void RTone1TxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]    - (I)frequency domain samples, used in TxMultiTones()
 *      gs_TxAnPrev       - (O) DPSK symbol of the last bit
 *      gs_RxState        - (I) current RX state
 *      gl_TxSymbolCount  - (I) # symbol periods in current TX state
 *      gs_TxNextState    - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_TONE1_TX
 *
 *-------------------------------------------------------------------
 *^^^
 */
void RTone1TxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_TONE1;
   /* ---- if timeout or tone loss in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX )
   {
      gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
   }

   /* ---- just write once to TxOutBuf, and leave it being transmitted ---- */
   if ( gl_TxSymbolCount == 0 )
   {
      gs_TxSubStateCnt = 0;
      gs_TxAn_Prev = 1;   /*  initialize gs_TxAn_Prev */

      //Enable loading GHS tone bit, enable register start IFFT bit
      gs_LoadGhsToneFlag = (BITMAP_LOAD_GHS_TONES | BITMAP_REGSTART_IFFT);

      TxMultiTones(NUM_CARRIER, TX_NEG165DBM);
   }

   /* ---- if a GALF is received, move to R_FLAG1_TX ---- */
   if (gs_RxNextState == R_C_FLAG1_RX )
   {
      /* Delay the transmission of the first octet of FLAG in order to
      align the transmitted octets to the received octets. The Tx and
      Rx octets are aligned so that the echo resulting from a TX bit
      transition lies within the two symbols that the receiver
      discards in the neighborhood of each RX bit transition. This way
      the echo will not affect the symbols that are used to
         demodulate the information. */
      if(gs_TxSubStateCnt++ == gs_HSAlignment)
      {
         gs_TxNextState = R_FLAG1_TX;
         gpF_TxStateFunc = (PtrToFunc)RFlag1TxF;
      }
   }

}   /*  RTone1TxF */

