/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RTonesReqTxF.c
 *
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "v_str_Iof.h"
#include "fifo.h"
#include "cmv.h"
#include "vdsl_const.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RTonesReqTxF
 *
 *  Description:
 *      R_Tones_Req is transmitted as an activation request of a
 *      G.hs session. When C_Tones is received in response, the Tx state moves
 *      to R_Silent1_Tx.
 *
 *  Prototype: RTonesReqTxF(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Returns: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount  - number of symbold in current Tx state
 *      gs_TxAn_Prev      - phase of previous DPSK symbol
 *      gs_RxState        - Rx state
 *      gs_TxNextState    - next Tx state
 *      gs_TxToneBuf[]    - frequency domain samples, used in TxMultiToneSetUp()
 *      gusa_txgain[]     - (I) used for power cutback
 *      gus_TxSineGain    - (O) used for powercutback
 *      gTxLoadingFunction - loads TxSineGain
 *
 *  Notes: implements state R_TONES_REQ_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */


//mei debug
#ifdef VR9_BRINGUP_DBG
FlagT gft_DisGhsPhaseRev = 0;
FlagT gft_StayRToneReg = 0;
#endif

//XDSLRTFW-554 : BUG_US_ALL_ALL_GHSPOWER
int16 gs_TxVarGain_In_Ghs_AnnexB = 0x6F00;   //= 16.82 dB if gs_TxVarGainExp = 3-> 20*log((0x6f00*2^3/32768))
//Annex A filter has more US0 only filter gain of 5 dB in US0 abnd compared to Annex B US0 case filter
int16 gs_TxVarGain_In_Ghs = 0x7fff;   // [Vinay]: 20*log((0x7FFF/2^15) * 2^3) = 18.06 dB if gs_TxVarGainExp = 3

void RTonesReqTxF(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[4]=VDSL2_R_TONES_REQ;
   if ( gl_TxSymbolCount == 0 )
   {
      gs_TxAn_Prev = 1;

      //Enable loading GHS tone bit, enable register start IFFT bit
      gs_LoadGhsToneFlag = (BITMAP_LOAD_GHS_TONES | BITMAP_REGSTART_IFFT);

      //XDSLRTFW-554 : BUG_US_ALL_ALL_GHSPOWER
      //If Only A43/A43C are selected. Transmit -38dBm/Hz
      // For BJ Hybrid we have +2dB as L2DGain
      //If Only A43 is set on BJ Hybrid Reduce 2dB
      // so for B43 & B43C we need not have to increase this 2dB of Var Gain
      //If Multi-Mode V43/A43/B43/A43C are selected. Transmit A43 = -38dBm/Hz V43 = -53dBm/Hz
      //=20*log((gs_TxVarGain/0x7FFF) * 2^gs_TxVarGainExp)) = 14 dB
      if(gs_GhsCarSetCfgInternal & (CNFG_GHS_CAR_SET_B43 | CNFG_GHS_CAR_SET_B43C | CNFG_GHS_CAR_SET_V43I))
      {
         gs_TxVarGain_In_Ghs = gs_TxVarGain_In_Ghs_AnnexB;
      }

      gs_TxVarGain = gs_TxVarGain_In_Ghs;

      //XDSLRTFW-554 : BUG_US_ALL_ALL_GHSPOWER

      //XDSLRTFW-2288 (start)
#ifdef GHS_TN_DBG
      if (TESTArray[TEST_GHS_LOG] & TEST_GHS_PWR_6dB_Less)
      {
         gs_TxVarGain = gs_TxVarGain >> 1;// forced to 6dB less;
      }
#endif
      //XDSLRTFW-2288 (end)

      //Increased to 3 below
      gs_TxVarGainExp = 2;


      //now TxVarGain is 4+6 = 10 dB
      gs_TxVarGainExp++;

      if (!(gul_dbgSnifferControl & SNIFFER_TX_DISABLE_VARGAIN))
      {
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);
      }

   }
//Mei debug
#ifdef VR9_BRINGUP_DBG
   if(gft_DisGhsPhaseRev == 1)
   {
      TxMultiTones(NUM_CARRIER, (int16) (TX_NEG165DBM * gs_TxAn_Prev) );
   }
   else
#endif //#ifdef VR9_BRINGUP_DBG
   {
      /* ---- inverting phase every 16ms ---- */
      if ( (gl_TxSymbolCount % TIME_16MS) == 0 )
      {
         gs_TxAn_Prev = -gs_TxAn_Prev;
         TxMultiTones(NUM_CARRIER, (int16) (TX_NEG165DBM * gs_TxAn_Prev) );
      }
   }

//Mei debug
#ifdef VR9_BRINGUP_DBG
   if(gft_StayRToneReg == 1)
   {
      return;
   }
#endif

   /* ---- if timeout in the Rx side, go back to the beginning ---- */
   if ( gs_RxState == R_C_SILENT1_RX )
   {
      gs_TxNextState = R_SILENT0_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
   }

   /* ---- if C_Tones is received, move to R_SILENT1_TX ---- */
   if ( gs_RxState == R_C_GALF1_RX )
   {
      gs_TxNextState = R_SILENT1_TX;
      gpF_TxStateFunc = (PtrToFunc)RSilent1TxF;
   }

}   /*  RTonesReqTxF */

